/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;

public class SearchProfileHandler {
    private static Logger logger = Logger.getLogger(SearchProfileHandler.class.getName());
    private static SearchProfileHandler handler = null;
    public static String[] supportedObjClass = new String[]{"user", "contact", "group"};
    public static String[] supportedObjTxt = new String[]{"adssp.admin.common.text.users", "adssp.admin.common.text.contacts", "adssp.admin.common.text.groups"};
    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SearchProfileHandler getInstance() {
        if (handler != null) return handler;
        Class<SearchProfileHandler> clazz = SearchProfileHandler.class;
        synchronized (SearchProfileHandler.class) {
            if (handler != null) return handler;
            handler = new SearchProfileHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    private SearchProfileHandler() {
    }

    public Boolean isSearchProfileEnabled(Long spId) {
        String isEnabled = "";
        if (LicenseUtil.isDirUpdPurchased()) {
            isEnabled = this.getReqValues("IS_ENABLED", spId);
        }
        return "1".equals(isEnabled);
    }

    public Boolean isOrgChartEnabled(Long spId) {
        String isEnabled = "";
        if (LicenseUtil.isDirUpdPurchased()) {
            isEnabled = this.getReqValues("ENABLE_OU_CHART", spId);
        }
        return "1".equals(isEnabled);
    }

    public String getReqValues(String columnName, Long spId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMSearchProfile", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get("ADSMSearchProfile", c);
            if (!dO.isEmpty()) {
                Row r = dO.getRow("ADSMSearchProfile");
                return (String)r.get(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getPhotoAttrib(Long spId) {
        String disablePhoto = this.getReqValues("DISABLE_PHOTO", spId);
        if ("0".equals(disablePhoto)) {
            String jpegPhoto = this.getReqValues("SHOW_JPEGPHOTO", spId);
            return "1".equals(jpegPhoto) ? "jpegPhoto" : "thumbnailPhoto";
        }
        return null;
    }

    public Hashtable getSearchProfileDetails(Long spId) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSMSearchProfile");
            tablesList.add("SSPSPObjects");
            Criteria spC = new Criteria(Column.getColumn((String)"ADSMSearchProfile", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, spC);
            Criteria colCri = new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            colCri = colCri.and(new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"ATTRIB_LDAP_NAME"), (Object)"msDS-ResultantPSO", 1));
            SelectQueryImpl sq = new SelectQueryImpl(new Table("SSPSPSearchCriteria"));
            sq.addSelectColumn(Column.getColumn((String)"SSPSPSearchCriteria", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SSPSPSearchCriteria", (String)"PRIORITY"), true));
            sq.setCriteria(colCri);
            DataObject sCDObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            colCri = new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            sq = new SelectQueryImpl(new Table("SSPSPDisplayColumn"));
            sq.addSelectColumn(Column.getColumn((String)"SSPSPDisplayColumn", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SSPSPDisplayColumn", (String)"PRIORITY"), true));
            sq.setCriteria(colCri);
            DataObject dCDObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Row row = dataObject.getRow("ADSMSearchProfile");
            hashtable.put("SEARCH_PROFILE_ID", row.get("SEARCH_PROFILE_ID"));
            hashtable.put("SEARCH_PROFILE_NAME", row.get("SEARCH_PROFILE_NAME"));
            hashtable.put("IS_ENABLED", row.get("IS_ENABLED"));
            hashtable.put("SHOW_ON_LOGIN_PAGE", row.get("SHOW_ON_LOGIN_PAGE"));
            if (!this.isSearchProfileEnabled(spId).booleanValue()) {
                hashtable.put("IS_ENABLED", "0");
                hashtable.put("SHOW_ON_LOGIN_PAGE", "0");
            }
            hashtable.put("ENABLE_OU_CHART", row.get("ENABLE_OU_CHART"));
            if (!this.isOrgChartEnabled(spId).booleanValue()) {
                hashtable.put("ENABLE_OU_CHART", "0");
            }
            hashtable.put("DISABLE_PHOTO", row.get("DISABLE_PHOTO"));
            hashtable.put("SHOW_JPEGPHOTO", row.get("SHOW_JPEGPHOTO"));
            hashtable.put("HIDE_DISABLED_USERS", row.get("HIDE_DISABLED_USERS"));
            hashtable.put("HIDE_UNMANAGED_USERS", row.get("HIDE_UNMANAGED_USERS"));
            hashtable.put("SHOW_SAME_FOREST_USERS_ONLY", row.get("SHOW_SAME_FOREST_USERS_ONLY"));
            Iterator iterator = dataObject.getRows("SSPSPObjects");
            while (iterator.hasNext()) {
                Properties objProp = new Properties();
                Row objRow = (Row)iterator.next();
                Long objId = (Long)objRow.get("OBJECT_ID");
                String obj = (String)objRow.get("OBJECT_CLASS");
                String isObjEn = (String)objRow.get("IS_ENABLED");
                ArrayList<String> dCs = new ArrayList<String>();
                ArrayList<Properties> dCDetails = new ArrayList<Properties>();
                Criteria c = new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"OBJECT_ID"), (Object)objId, 0);
                Iterator it = dCDObj.getRows("SSPSPDisplayColumn", c);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String disName = (String)r.get("ATTRIB_DISP_NAME");
                    dCs.add(disName);
                    Properties prop = new Properties();
                    prop.put("ATTRIB_ID", r.get("ATTRIB_ID"));
                    prop.put("ATTRIB_LDAP_NAME", r.get("ATTRIB_LDAP_NAME"));
                    prop.put("ATTRIB_DISP_NAME", disName);
                    prop.put("PRIORITY", r.get("PRIORITY"));
                    dCDetails.add(prop);
                }
                ArrayList<String> sCs = new ArrayList<String>();
                ArrayList<Properties> sCDetails = new ArrayList<Properties>();
                c = new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"OBJECT_ID"), (Object)objId, 0);
                Iterator it2 = sCDObj.getRows("SSPSPSearchCriteria", c);
                while (it2.hasNext()) {
                    Row r = (Row)it2.next();
                    String disName = (String)r.get("ATTRIB_DISP_NAME");
                    sCs.add(disName);
                    Properties prop = new Properties();
                    prop.put("ATTRIB_ID", r.get("ATTRIB_ID"));
                    prop.put("ATTRIB_LDAP_NAME", r.get("ATTRIB_LDAP_NAME"));
                    prop.put("ATTRIB_DISP_NAME", disName);
                    prop.put("LDAP_CRITERIA", r.get("LDAP_CRITERIA"));
                    prop.put("PRIORITY", r.get("PRIORITY"));
                    sCDetails.add(prop);
                }
                objProp.put("OBJECT_LDAP_CRITERIA", objRow.get("LDAP_CRITERIA"));
                objProp.put("IS_OBJECT_ENABLED", isObjEn);
                objProp.put("SEL_DIS_COLS", dCs);
                objProp.put("SEL_SEA_CRIS", sCs);
                objProp.put("SEL_DIS_COLS_DET", dCDetails);
                objProp.put("SEL_SEA_CRIS_DET", sCDetails);
                hashtable.put(obj, objProp);
            }
            hashtable.put("ALL_OBJECT_ATTRIBUTES", this.getAllAttributes(new String[]{"user", "contact", "group"}));
            this.getSearchDomainsAndOus(hashtable, spId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashtable;
    }

    public Hashtable getAllAttributes(String[] objClasses) {
        Hashtable<String, ArrayList> objAttributes = new Hashtable<String, ArrayList>();
        try {
            for (int j = 0; j < objClasses.length; ++j) {
                ObjectClass obj = DirectoryObjectAPI.getInstance().getObjectClass(objClasses[j]);
                Integer startRange = obj.getStartRange();
                Integer endRange = obj.getEndRange();
                objAttributes.put(objClasses[j], this.getReportDisplayNames(startRange, endRange));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getReportDisplayNames(Integer startRange, Integer endRange) {
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<Properties> allAttList = new ArrayList<Properties>();
        ArrayList<String> uniAttName = new ArrayList<String>();
        try {
            Table baseTable = new Table("ADSMAttributeDetails");
            Table joinTable = new Table("ADSMTotalReports");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            Criteria c = new Criteria(Column.getColumn((String)"ADSMTotalReports", (String)"REPORT_ID"), (Object)10001, 4);
            c = c.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)startRange, 4);
            c = c.and(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)endRange, 6);
            sq.setCriteria(c);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String disName = (String)dataSet.getValue("ATTRIB_DISP_NAME");
                String ldapName = (String)dataSet.getValue("ATTRIB_LDAP_NAME");
                if (uniAttName.contains(disName) || ldapName.equalsIgnoreCase("msDS-ResultantPSO")) continue;
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", (Integer)dataSet.getValue("ATTRIB_ID"));
                prop.put("ATTRIB_DISP_NAME", disName);
                prop.put("ATTRIB_LDAP_NAME", (String)dataSet.getValue("ATTRIB_LDAP_NAME"));
                prop.put("ATTRIB_COLUMN_NAME", (String)dataSet.getValue("ATTRIB_COLUMN_NAME"));
                prop.put("TABLE_NAME", (String)dataSet.getValue("TABLE_NAME"));
                prop.put("RELATIONAL_TYPE", (Integer)dataSet.getValue("RELATIONAL_TYPE"));
                allAttList.add(prop);
                uniAttName.add(disName);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return allAttList;
    }

    public void getSearchDomainsAndOus(Hashtable hash, Long spId) {
        try {
            Long loggedOnLoginId;
            String loggedInDomainName;
            ArrayList<String> domainList = new ArrayList<String>();
            ArrayList<String> ouList = new ArrayList<String>();
            Hashtable<String, ArrayList<String>> domainVsOus = new Hashtable<String, ArrayList<String>>();
            ArrayList forestDomains = new ArrayList();
            String showOnlyForestUsers = this.getReqValues("SHOW_SAME_FOREST_USERS_ONLY", spId);
            Credential cred = AuthUtil.getUserCredential();
            if (showOnlyForestUsers.equals("1") && cred != null && (loggedInDomainName = DomainHandler.getDomainName(loggedOnLoginId = cred.getLoginId())) != null) {
                forestDomains = DomainHandler.getForestDomainNames(DomainHandler.getDomainData("DOMAIN_NAME", loggedInDomainName, "ROOT_DOMAIN_NAMING_CONTEXT"), loggedOnLoginId);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSPDomainOUs", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            if (!forestDomains.isEmpty()) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSPDomainOUs", (String)"DOMAIN_NAME"), (Object)forestDomains.toArray(new String[forestDomains.size()]), 8));
            }
            SelectQueryImpl sq = new SelectQueryImpl(new Table("SSPSPDomainOUs"));
            sq.addSelectColumn(Column.getColumn((String)"SSPSPDomainOUs", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SSPSPDomainOUs", (String)"DOMAIN_NAME"), true));
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator iterator = obj.getRows("SSPSPDomainOUs");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    String domainName = (String)r.get("DOMAIN_NAME");
                    String ouDN = (String)r.get("OU_DISTINGUISHED_NAME");
                    if (!domainList.contains(domainName)) {
                        if (ouList.size() > 0) {
                            domainVsOus.put((String)domainList.get(domainList.size() - 1), ouList);
                        }
                        domainList.add(domainName);
                        ouList = new ArrayList();
                    }
                    ouList.add(ouDN);
                }
                if (ouList.size() > 0) {
                    domainVsOus.put((String)domainList.get(domainList.size() - 1), ouList);
                }
                hash.put("DOMAIN_VS_OUS", domainVsOus);
            } else if (showOnlyForestUsers.equals("0")) {
                this.updateDefaultValues(hash, spId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchProfileDetails(HttpServletRequest request) {
        try {
            String showJPEG;
            Long spId = 1L;
            Criteria c = new Criteria(Column.getColumn((String)"ADSMSearchProfile", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            DataObject upDO = CommonUtil.getPersistence(new boolean[0]).get("ADSMSearchProfile", c);
            Row spRow = upDO.getRow("ADSMSearchProfile");
            c = new Criteria(Column.getColumn((String)"SSPSPObjects", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            DataObject oCUDO = CommonUtil.getPersistence(new boolean[0]).get("SSPSPObjects", c);
            Long isEnabled = request.getParameter("ENABLE_EMPLOYEE_SEARCH") != null ? 1L : 0L;
            if (isEnabled.equals(1L)) {
                DataObject addDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (String obj : supportedObjClass) {
                    String isObjEn = request.getParameter(obj + "_search") != null ? "1" : "0";
                    Criteria crit = new Criteria(Column.getColumn((String)"SSPSPObjects", (String)"OBJECT_CLASS"), (Object)obj, 0);
                    Row rObj = oCUDO.getRow("SSPSPObjects", crit);
                    Long objId = (Long)rObj.get("OBJECT_ID");
                    rObj.set("IS_ENABLED", (Object)isObjEn);
                    oCUDO.updateRow(rObj);
                    if (!isObjEn.equals("1")) continue;
                    CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"OBJECT_ID"), (Object)objId, 0));
                    String[] selDisCols = request.getParameter(obj + "_DC_SEL").split(",");
                    int priority = 1;
                    for (String selDC : selDisCols) {
                        selDC = selDC.replaceAll("%2C", ",");
                        String[] vals = selDC.split(";;;");
                        Row rDC = new Row("SSPSPDisplayColumn");
                        rDC.set("SEARCH_PROFILE_ID", (Object)spId);
                        rDC.set("OBJECT_ID", (Object)objId);
                        rDC.set("ATTRIB_ID", (Object)Integer.parseInt(vals[0]));
                        rDC.set("ATTRIB_LDAP_NAME", (Object)vals[1]);
                        rDC.set("ATTRIB_DISP_NAME", (Object)vals[2]);
                        rDC.set("PRIORITY", (Object)priority++);
                        addDO.addRow(rDC);
                    }
                    CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"OBJECT_ID"), (Object)objId, 0));
                    String[] selSeaCri = request.getParameter(obj + "_SC_SEL").split(",");
                    priority = 1;
                    for (String selSC : selSeaCri) {
                        String[] vals = selSC.split(";;;");
                        Row rSC = new Row("SSPSPSearchCriteria");
                        rSC.set("SEARCH_PROFILE_ID", (Object)spId);
                        rSC.set("OBJECT_ID", (Object)objId);
                        rSC.set("ATTRIB_ID", (Object)Integer.parseInt(vals[0]));
                        rSC.set("ATTRIB_LDAP_NAME", (Object)vals[1]);
                        rSC.set("ATTRIB_DISP_NAME", (Object)vals[2]);
                        rSC.set("LDAP_CRITERIA", (Object)("(" + vals[1] + "=%searchString%)"));
                        rSC.set("PRIORITY", (Object)priority++);
                        addDO.addRow(rSC);
                    }
                }
                this.setSearchDomainsAndOus(request, addDO, spId);
                CommonUtil.getPersistence(new boolean[0]).add(addDO);
            }
            String string = showJPEG = request.getParameter("SHOW_JPEGPHOTO") != null ? "1" : "0";
            if (!((String)spRow.get("SHOW_JPEGPHOTO")).equalsIgnoreCase(showJPEG)) {
                try {
                    String productHome = System.getProperty("product.home");
                    if (productHome == null) {
                        productHome = System.getProperty("server.home");
                    }
                    String fileName = productHome + File.separator + "webapps" + File.separator + "adssp" + File.separator + "temp" + File.separator + "photos" + File.separator;
                    FileUtils.deleteDirectory((File)new File(fileName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            spRow.set("SHOW_ON_LOGIN_PAGE", (Object)(request.getParameter("SHOW_ON_LOGIN_PAGE") != null ? "1" : "0"));
            spRow.set("ENABLE_OU_CHART", (Object)(request.getParameter("ENABLE_OU_CHART") != null ? "1" : "0"));
            spRow.set("DISABLE_PHOTO", (Object)(request.getParameter("DISABLE_PHOTO") != null ? "1" : "0"));
            spRow.set("SHOW_JPEGPHOTO", (Object)(request.getParameter("SHOW_JPEGPHOTO") != null ? "1" : "0"));
            spRow.set("HIDE_DISABLED_USERS", (Object)(request.getParameter("HIDE_DISABLED_USERS") != null ? "1" : "0"));
            spRow.set("HIDE_UNMANAGED_USERS", (Object)(request.getParameter("HIDE_UNMANAGED_USERS") != null ? "1" : "0"));
            spRow.set("SHOW_SAME_FOREST_USERS_ONLY", (Object)(request.getParameter("SHOW_SAME_FOREST_USERS_ONLY") != null ? "1" : "0"));
            spRow.set("IS_ENABLED", (Object)isEnabled.toString());
            upDO.updateRow(spRow);
            CommonUtil.getPersistence(new boolean[0]).update(upDO);
            CommonUtil.getPersistence(new boolean[0]).update(oCUDO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchDomainsAndOus(HttpServletRequest request, DataObject obj, Long spId) {
        Hashtable domainAndOusList = new Hashtable();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPSPDomainOUs", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
            String[] domainList = request.getParameterValues("DOMAINS");
            for (int i = 0; i < domainList.length; ++i) {
                String domainName = domainList[i];
                if (request.getParameter(domainName) == null) continue;
                String[] ouList = request.getParameterValues(domainName + "_OULIST");
                if (ouList != null) {
                    for (int j = 0; j < ouList.length; ++j) {
                        Row r = new Row("SSPSPDomainOUs");
                        r.set("SEARCH_PROFILE_ID", (Object)spId);
                        r.set("DOMAIN_NAME", (Object)domainName);
                        r.set("OU_DISTINGUISHED_NAME", (Object)StrUtil.decodeURIComponent(ouList[j]));
                        obj.addRow(r);
                    }
                    continue;
                }
                Row r = new Row("SSPSPDomainOUs");
                r.set("SEARCH_PROFILE_ID", (Object)spId);
                r.set("DOMAIN_NAME", (Object)domainName);
                String domainDN = request.getParameter(domainName + "_DN");
                r.set("OU_DISTINGUISHED_NAME", (Object)domainDN);
                obj.addRow(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDefaultValues(Hashtable hash, Long spId) {
        try {
            Hashtable dns = DomainHandler.getConfiguredDomains();
            Enumeration e = dns.keys();
            while (e.hasMoreElements()) {
                String dn = (String)e.nextElement();
                Properties p = (Properties)dns.get(dn);
                if (!p.getProperty("IS_DEFAULT_DOMAIN").equals("true")) continue;
                String domainName = p.getProperty("DOMAIN_NAME");
                DataObject addDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row("SSPSPDomainOUs");
                r.set("SEARCH_PROFILE_ID", (Object)spId);
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("OU_DISTINGUISHED_NAME", (Object)dn);
                addDO.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(addDO);
                ArrayList<String> dnList = new ArrayList<String>();
                dnList.add(dn);
                Hashtable<String, ArrayList<String>> ret = new Hashtable<String, ArrayList<String>>();
                ret.put(domainName, dnList);
                hash.put("DOMAIN_VS_OUS", ret);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getObjectClassValues(Long searchProfileId) {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSMSearchProfile");
            tablesList.add("SSPSPObjects");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tablesList, new Criteria(Column.getColumn((String)"ADSMSearchProfile", (String)"SEARCH_PROFILE_ID"), (Object)searchProfileId, 0));
            Iterator it = dataObject.getRows("SSPSPObjects");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                list.add(r.get("OBJECT_CLASS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public ObjectClass getObjectClass(String objClass) {
        return DirectoryObjectAPI.getInstance().getObjectClass(objClass);
    }
}

