/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class SecondaryAttributesHandler {
    public static JSONObject getAttributeDetails(String domainName) {
        JSONObject mailMobAttributes = new JSONObject();
        try {
            JSONArray mails = new JSONArray();
            JSONArray mobiles = new JSONArray();
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPSecondaryAttributes"));
            Column column = Column.getColumn((String)"SSPSecondaryAttributes", (String)"ORDER_ID");
            sq.addSelectColumn(Column.getColumn((String)"SSPSecondaryAttributes", (String)"*"));
            sq.setCriteria((Criteria)null);
            if (domainName != null) {
                Criteria criteria = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                sq.setCriteria(criteria);
            }
            SortColumn sortColumn = new SortColumn(column, true);
            sq.addSortColumn(sortColumn);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPSecondaryAttributes");
                while (it.hasNext()) {
                    Object rowValue;
                    String cN;
                    Row r = (Row)it.next();
                    String mailOrMobile = (String)r.get("ATTRIBUTE_TYPE");
                    if (mailOrMobile.equals("MAIL")) {
                        JSONObject mailAttributes = new JSONObject();
                        for (Object object : r.getColumns()) {
                            cN = (String)object;
                            rowValue = r.get(cN);
                            mailAttributes.put(cN, rowValue);
                        }
                        mails.put((Object)mailAttributes);
                        continue;
                    }
                    JSONObject mobAttributes = new JSONObject();
                    for (Object object : r.getColumns()) {
                        cN = (String)object;
                        rowValue = r.get(cN);
                        mobAttributes.put(cN, rowValue);
                    }
                    mobiles.put((Object)mobAttributes);
                }
                mailMobAttributes.put("mail", (Object)mails);
                mailMobAttributes.put("mobile", (Object)mobiles);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mailMobAttributes;
    }

    public static JSONObject getAttributeDetails() {
        return SecondaryAttributesHandler.getAttributeDetails(null);
    }

    public static ArrayList getAttributes(String domainName, String attributeType) {
        ArrayList<String> attributes = new ArrayList<String>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPSecondaryAttributes"));
            Column column = Column.getColumn((String)"SSPSecondaryAttributes", (String)"ORDER_ID");
            sq.addSelectColumn(Column.getColumn((String)"SSPSecondaryAttributes", (String)"*"));
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"IS_ENABLED"), (Object)true, 0);
            if (domainName != null) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                if (attributeType != null) {
                    crit = crit.and(new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_TYPE"), (Object)attributeType, 0));
                }
            }
            sq.setCriteria(crit);
            SortColumn sortColumn = new SortColumn(column, true);
            sq.addSortColumn(sortColumn);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPSecondaryAttributes");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    attributes.add((String)r.get("ATTRIBUTE_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributes;
    }

    public static ArrayList getAttributes(String domainName) {
        return SecondaryAttributesHandler.getAttributes(domainName, null);
    }

    public static ArrayList getAttributes() {
        return SecondaryAttributesHandler.getAttributes(null, null);
    }

    public static void setAttributes(Properties prop) {
        try {
            if (!prop.isEmpty()) {
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row("SSPSecondaryAttributes");
                r.set("ATTRIBUTE_NAME", (Object)((String)prop.get("ATTRIBUTE_NAME")));
                r.set("ORDER_ID", prop.get("ORDER"));
                r.set("DOMAIN_NAME", prop.get("DOMAIN_NAME"));
                r.set("IS_ENABLED", (Object)true);
                r.set("IS_PREDEFINED", (Object)false);
                r.set("ATTRIBUTE_TYPE", (Object)((String)prop.get("ATTRIBUTE_TYPE")));
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getNotificationAttributes(String loginName, String domainName, String attributeType) {
        Properties notifyProps = null;
        try {
            String value;
            int j;
            ArrayList attributeValue;
            String attributeKey;
            int i;
            ArrayList attributes = new ArrayList();
            ArrayList mailAttributes = new ArrayList();
            ArrayList mobileAttributes = new ArrayList();
            if (attributeType == null || "MAIL".equals(attributeType)) {
                mailAttributes = SecondaryAttributesHandler.getAttributes(domainName, "MAIL");
                attributes.addAll(mailAttributes);
            }
            if (attributeType == null || "MOBILE".equals(attributeType)) {
                mobileAttributes = SecondaryAttributesHandler.getAttributes(domainName, "MOBILE");
                if (attributeType == null) {
                    attributes.removeAll(mobileAttributes);
                }
                attributes.addAll(mobileAttributes);
            }
            notifyProps = UserUtil.getObjValList(loginName, DomainHandler.getConfiguredValues(domainName, new Long(1L)), attributes);
            ArrayList<String> mailIds = new ArrayList<String>();
            ArrayList<String> mobileNumbers = new ArrayList<String>();
            for (i = 0; i < mailAttributes.size(); ++i) {
                attributeKey = (String)mailAttributes.get(i);
                attributeValue = (ArrayList)notifyProps.get(attributeKey);
                if (attributeValue == null) continue;
                for (j = 0; j < attributeValue.size(); ++j) {
                    value = (String)attributeValue.get(j);
                    if (!StrUtil.isValidEmailID(value) || mailIds.contains(value)) continue;
                    mailIds.add(value);
                }
            }
            for (i = 0; i < mobileAttributes.size(); ++i) {
                attributeKey = (String)mobileAttributes.get(i);
                attributeValue = (ArrayList)notifyProps.get(attributeKey);
                if (attributeValue == null) continue;
                for (j = 0; j < attributeValue.size(); ++j) {
                    value = (String)attributeValue.get(j);
                    if (mobileNumbers.contains(value) || value.equals("")) continue;
                    mobileNumbers.add(value);
                }
            }
            if (mailIds.size() > 0) {
                notifyProps.put("MAIL_IDS", mailIds);
            }
            if (mobileNumbers.size() > 0) {
                notifyProps.put("MOBILE_NUMBERS", mobileNumbers);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifyProps;
    }

    public static Properties getNotificationAttributes(String loginName, String domainName) {
        return SecondaryAttributesHandler.getNotificationAttributes(loginName, domainName, null);
    }

    public static void setAttributeOrder(HttpServletRequest request) {
        try {
            JSONObject json = new JSONObject(request.getParameter("ATTRIBUTE_ORDER"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPSecondaryAttributes", (Criteria)null);
            for (int i = 1; i <= json.length(); ++i) {
                JSONObject jsonObject = (JSONObject)json.get(String.valueOf(i));
                Long uniqueId = Long.parseLong((String)jsonObject.get("ATTRIBUTE_ID"));
                Criteria cri = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_ID"), (Object)uniqueId, 0);
                Row row = dataObject.getRow("SSPSecondaryAttributes", cri);
                if (row == null) continue;
                row.set("ORDER_ID", (Object)i);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toggleAttributeStatus(HttpServletRequest request) {
        try {
            String mailId = request.getParameter("ID");
            Long id = Long.parseLong(mailId);
            String checked = request.getParameter("CHECK");
            Boolean check = Boolean.parseBoolean(checked);
            Criteria c = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_ID"), (Object)id, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPSecondaryAttributes", c);
            Row r = dataObject.getRow("SSPSecondaryAttributes");
            r.set("IS_ENABLED", (Object)check);
            dataObject.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteAttribute(Long id) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_ID"), (Object)id, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isAttributeAllowedToModify(String domainName, String attributeType, Long attributeId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_ID"), (Object)attributeId, 1);
            Criteria crit = c.and(new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            Criteria criteria = crit.and(new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"ATTRIBUTE_TYPE"), (Object)attributeType, 0));
            c = criteria.and(new Criteria(Column.getColumn((String)"SSPSecondaryAttributes", (String)"IS_ENABLED"), (Object)true, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPSecondaryAttributes", c);
            if (!dataObject.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

