/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.CustomPolicyUtil;
import com.adventnet.sym.adsm.common.server.util.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SelfServiceHandler {
    private static Logger logger = Logger.getLogger(SelfServiceHandler.class.getName());
    private static String resetPassword = "ResetPassword";
    private static String changePassword = "ChangePassword";
    private static String unlockAccount = "UnlockAccount";

    public static void resetPassword(Long adminId, Hashtable userDetails, String updateInAllDCs, Long loginId) throws Exception {
        try {
            DomainHandler.addToSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), resetPassword);
            ADHandler.setPassword(adminId, userDetails, updateInAllDCs);
            Boolean resetWitTempPwd = (Boolean)userDetails.get("RESET_WITH_TEMP_PWD");
            if (resetWitTempPwd != null && resetWitTempPwd.booleanValue()) {
                userDetails.put("RESET_WITH_TEMP_PWD", false);
            }
            Properties p = UserUtil.getUserObjectDetails((String)userDetails.get("USER_NAME"), (String)userDetails.get("DOMAIN_NAME"), new String[]{"pwdLastSet"}, false, "samAccountName", true);
            Hashtable<String, String> pwdDetails = new Hashtable<String, String>();
            pwdDetails.put("PASSWORD_LAST_SET", p.getProperty("pwdLastSet"));
            UserUtil.setUserPersonal(loginId, pwdDetails);
            if (resetWitTempPwd == null || !resetWitTempPwd.booleanValue()) {
                PPEHandler.updatePasswordHistory(loginId, (String)userDetails.get("PASSWORD"), (Long)userDetails.get("POLICY_ID"));
            }
        }
        catch (NativeException ne) {
            DomainHandler.removeFromSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), resetPassword);
            throw new ADSSPException(ne.getExceptionMsg());
        }
        DomainHandler.removeFromSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), resetPassword);
    }

    public static void changePwdAtNextLogon(String domainName, Long loginId, String logonName, String sid, String allDC) throws Exception {
        SelfServiceHandler.updateCPANLogon(domainName, loginId, logonName, sid, allDC, 0);
    }

    public static void updateCPANLogon(String domainName, Long loginId, String logonName, String sid, String allDC, int pwdLastSetValue) throws Exception {
        Boolean chCantCP = ADHandler.checkCantChangePassword(domainName, loginId, logonName);
        Boolean chPwdNevExp = ADHandler.checkPasswordNeverExpires(domainName, loginId, sid);
        if (!chCantCP.booleanValue() && !chPwdNevExp.booleanValue()) {
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("DATA_HANDLER_TYPE", new Long(10L));
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
            p.put("ATTRIB_VALUE", new Long(pwdLastSetValue));
            setAttributeList.add(p);
            ADHandler.modifyUser(domainName, loginId, sid, logonName, setAttributeList, new ArrayList(), null, new ArrayList(), null, allDC);
        }
    }

    public static void changePassword(HttpServletRequest request) throws Exception {
        String domainName = (String)request.getAttribute("domainName");
        String userName = (String)request.getAttribute("loginName");
        try {
            String sid = UserUtil.getSID(domainName, userName);
            if (sid == null) {
                throw new ADSSPException(SelfServiceHandler.getS("adssp.reset_unlock.accounts.rp_ua.error_incomplete_data"));
            }
            DomainHandler.addToSSQueue(domainName, userName, changePassword);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable<String, String> userDetails = new Hashtable<String, String>();
            userDetails.put("USER_NAME", userName);
            String userDN = (String)session.getAttribute("USER_DN");
            if (userDN == null) {
                userDN = UserUtil.getUserDNFrmDB(domainName, userName);
            }
            String oldPassword = request.getParameter("oldPassword");
            String newPassword = request.getParameter("newPassword");
            userDetails.put("USER_DN", userDN);
            userDetails.put("USER_SID", sid);
            userDetails.put("OLD_PASSWORD", oldPassword);
            userDetails.put("NEW_PASSWORD", newPassword);
            userDetails.put("DOMAIN_NAME", domainName);
            ArrayList<String> colNames = new ArrayList<String>();
            colNames.add("UPDATE_ALL_DC");
            Hashtable colValues = APCUtil.getRequiredPCValues((Long)request.getAttribute("policyId"), colNames, "SSPPolicyGeneral");
            String updateInAllDCs = (String)colValues.get("UPDATE_ALL_DC");
            ADHandler.changePassword(loginId, updateInAllDCs, userDetails);
            Properties p = UserUtil.getUserObjectDetails((String)userDetails.get("USER_NAME"), (String)userDetails.get("DOMAIN_NAME"), new String[]{"pwdLastSet"});
            Hashtable<String, String> pwdDetails = new Hashtable<String, String>();
            pwdDetails.put("PASSWORD_LAST_SET", p.getProperty("pwdLastSet"));
            pwdDetails.put("TEMP_PWD", "-");
            UserUtil.setUserPersonal(loginId, pwdDetails);
            PPEHandler.updatePasswordHistory(loginId, (String)userDetails.get("NEW_PASSWORD"), (Long)request.getAttribute("policyId"));
            DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
        }
        catch (NativeException ne) {
            DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
            throw new ADSSPException(ne.getExceptionMsg());
        }
        catch (Exception e) {
            DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
            throw new Exception(e.getMessage());
        }
    }

    public static void userMustChangePassword(HttpServletRequest request) throws Exception {
        String domainName = (String)request.getAttribute("domainName");
        String userName = (String)request.getAttribute("loginName");
        try {
            String sid = UserUtil.getSID(domainName, userName);
            if (sid == null) {
                throw new ADSSPException(SelfServiceHandler.getS("adssp.reset_unlock.accounts.rp_ua.error_incomplete_data"));
            }
            DomainHandler.addToSSQueue(domainName, userName, changePassword);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Hashtable<String, String> userDetails = new Hashtable<String, String>();
            userDetails.put("USER_NAME", userName);
            String userDN = (String)session.getAttribute("USER_DN");
            if (userDN == null) {
                userDN = UserUtil.getUserDNFrmDB(domainName, userName);
            }
            userDetails.put("USER_DN", userDN);
            userDetails.put("USER_SID", sid);
            String oldPassword = request.getParameter("oldPassword");
            String newPassword = request.getParameter("newPassword");
            userDetails.put("OLD_PASSWORD", oldPassword);
            userDetails.put("NEW_PASSWORD", newPassword);
            userDetails.put("DOMAIN_NAME", domainName);
            ArrayList<String> colNames = new ArrayList<String>();
            colNames.add("UPDATE_ALL_DC");
            Hashtable colValues = APCUtil.getRequiredPCValues((Long)request.getAttribute("policyId"), colNames, "SSPPolicyGeneral");
            String updateInAllDCs = (String)colValues.get("UPDATE_ALL_DC");
            ADHandler.userMustChangePassword(loginId, updateInAllDCs, userDetails);
            loginId = ADMPUserHandler.getLoginId(userName, domainName);
            if (loginId != null) {
                Properties p = UserUtil.getUserObjectDetails((String)userDetails.get("USER_NAME"), (String)userDetails.get("DOMAIN_NAME"), new String[]{"pwdLastSet"});
                Hashtable<String, String> pwdDetails = new Hashtable<String, String>();
                pwdDetails.put("PASSWORD_LAST_SET", p.getProperty("pwdLastSet"));
                pwdDetails.put("TEMP_PWD", "-");
                UserUtil.setUserPersonal(loginId, pwdDetails);
                DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
            }
            PPEHandler.updatePasswordHistory(loginId, (String)userDetails.get("NEW_PASSWORD"), (Long)request.getAttribute("policyId"));
        }
        catch (NativeException ne) {
            DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
            throw new ADSSPException(ne.getExceptionMsg());
        }
        catch (Exception e) {
            DomainHandler.removeFromSSQueue(domainName, userName, changePassword);
            throw new Exception(e.getMessage());
        }
    }

    public static void unlockUser(Long loginId, String updateInAllDCs, Hashtable userDetails) throws Exception {
        try {
            DomainHandler.addToSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), unlockAccount);
            if (!SelfServiceHandler.isUserLockedOut((String)userDetails.get("DOMAIN_NAME"), loginId, (String)userDetails.get("USER_DN"))) {
                DomainHandler.removeFromSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), unlockAccount);
                throw new ADSSPException(SelfServiceHandler.getS("adssp.reset_unlock.accounts.unlock_acc.error_not_locked"));
            }
            ADHandler.unlockUser(loginId, updateInAllDCs, userDetails);
            DomainHandler.removeFromSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), unlockAccount);
        }
        catch (NativeException ne) {
            DomainHandler.removeFromSSQueue((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_NAME"), unlockAccount);
            throw new ADSSPException(ne.getExceptionMsg());
        }
    }

    public static boolean isUserLockedOut(String domainName, Long loginId, String userDN) throws Exception {
        boolean lockedOut = false;
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("lockoutTime");
        attributeList.add("lockoutDuration");
        Properties prop = ADHandler.getObjectProperties(domainName, 1L, userDN, attributeList);
        ArrayList list = (ArrayList)prop.get("lockoutTime");
        ArrayList durationList = (ArrayList)prop.get("lockoutDuration");
        long currTime = System.currentTimeMillis();
        long currentTime = CommonUtil.getFileTimeFromSystemTime(new Long(currTime));
        if (list != null && list.size() != 0) {
            long lockOutTime = Long.parseLong((String)list.get(0));
            long duration = 0L;
            logger.log(Level.INFO, "Account Lock Test - lockOutTime : " + lockOutTime);
            if (lockOutTime != 0L) {
                if (durationList != null && durationList.size() != 0) {
                    duration = Long.parseLong((String)durationList.get(0));
                }
                logger.log(Level.INFO, "Account Lock Test - Lock Duration : " + duration + " : current time : " + currentTime);
                if (duration == 0L || currentTime >= lockOutTime && currentTime < lockOutTime + duration) {
                    lockedOut = true;
                }
            }
        }
        return lockedOut;
    }

    public static Boolean isUserAccountDisabled(String loginName, String domainName) {
        Boolean ret = false;
        try {
            Long uAC;
            String[] props = new String[]{"userAccountControl"};
            Properties p = UserUtil.getUserObjectDetails(loginName, domainName, props);
            if (!p.isEmpty() && (uAC = Long.valueOf(Long.parseLong((String)p.get("userAccountControl")) & 2L)) == 2L) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Boolean isUserAccountExpired(String loginName, String domainName) {
        Boolean ret = false;
        try {
            String[] props = new String[]{"accountExpires"};
            Properties p = UserUtil.getUserObjectDetails(loginName, domainName, props);
            if (!p.isEmpty()) {
                Long accExpTime = Long.parseLong((String)p.get("accountExpires"));
                Long curTime = CommonUtil.getFileTimeFromSystemTime(System.currentTimeMillis());
                if (accExpTime != 0L && accExpTime != Long.MAX_VALUE && accExpTime <= curTime) {
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Boolean isUserPasswordExpired(String loginName, String domainName) {
        Boolean ret = false;
        try {
            if (SelfServiceHandler.getPwdExpireDays(loginName, domainName) < 0L) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Boolean isUserLogonPermitted(Properties p) {
        Boolean isPermitted;
        block6: {
            isPermitted = false;
            try {
                Long curTime = System.currentTimeMillis();
                String dateOfWeek = new SimpleDateFormat("E").format(new Date(curTime));
                int hourInDay = Integer.parseInt(new SimpleDateFormat("k").format(new Date(curTime)));
                if (p.isEmpty()) break block6;
                String logonHours = (String)p.get("logonHours");
                if (logonHours.equalsIgnoreCase("-") || logonHours.equalsIgnoreCase("ffffffffffffffffffffffffffffffffffffffffff")) {
                    isPermitted = true;
                    break block6;
                }
                String[] days = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
                int[] hours = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
                int[] dayByte = new int[]{41, 40, 1, 0, 3, 2, 5, 4, 7, 6, 9, 8, 11, 10, 13, 12, 15, 14, 17, 16, 19, 18, 21, 20, 23, 22, 25, 24, 27, 26, 29, 28, 31, 30, 33, 32, 35, 34, 37, 36, 39, 38, 41};
                int bytes = 0;
                int k = 3;
                for (int daysCount = 0; daysCount < days.length; ++daysCount) {
                    for (int hoursCount = 0; hoursCount < hours.length; ++hoursCount) {
                        if (k == 4) {
                            ++bytes;
                            k = 0;
                        }
                        char c = logonHours.charAt(dayByte[bytes]);
                        int t = Character.digit(c, 16);
                        BigDecimal d = new BigDecimal(2);
                        BigDecimal d1 = d.pow(k++);
                        String day = days[daysCount];
                        int hour = hours[hoursCount];
                        if (!day.equals(dateOfWeek) || hour != hourInDay) continue;
                        isPermitted = (t & d1.byteValue()) == d1.byteValue();
                        logger.log(Level.INFO, days[daysCount] + " - " + hours[hoursCount] + " : " + isPermitted);
                        break block6;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isPermitted;
    }

    public static Long getPwdExpireDays(String loginName, String domainName) {
        Long days = 0L;
        try {
            String[] props = new String[]{"pwdLastSet", "msDS-ResultantPSO"};
            Properties p = UserUtil.getUserObjectDetails(loginName, domainName, props);
            if (!p.isEmpty()) {
                String pwdLSStr;
                String resPSO = (String)p.get("msDS-ResultantPSO");
                ArrayList<String> pso = null;
                if (resPSO != null) {
                    pso = new ArrayList<String>();
                    pso.add(resPSO);
                }
                Long pwdLastSet = !(pwdLSStr = (String)p.get("pwdLastSet")).equals("0") ? CommonUtil.getNoOfDays(Long.parseLong(pwdLSStr)) : 0L;
                long maxPwdDays = CustomPolicyUtil.getMaxPwdAge(pso, domainName) / 86400000L;
                if (maxPwdDays != 0L && pwdLastSet != 0L) {
                    days = maxPwdDays - pwdLastSet;
                }
                logger.log(Level.INFO, "pwdLastSet = " + pwdLastSet + ". maxPwdDays = " + maxPwdDays + ". Soon-to-Expire in  = " + days);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return days;
    }

    public static Boolean isUserAccountActive(HttpServletRequest request, Properties p) {
        Boolean ret = true;
        try {
            Long systemTime = System.currentTimeMillis();
            Long previousDay = TimeZoneUtil.getDateInMillis(new Date(systemTime), -1);
            Long curTime = CommonUtil.getFileTimeFromSystemTime(previousDay);
            String lockOutTimeS = (String)p.get("lockoutTime");
            String lockOutDuration = (String)p.get("lockoutDuration");
            Long lockOutTime = lockOutTimeS != null && !lockOutTimeS.equals("") ? Long.parseLong(lockOutTimeS) : 0L;
            Long duration = lockOutDuration != null && !lockOutDuration.equals("") ? Long.parseLong(lockOutDuration) : 0L;
            Long accExpTime = Long.parseLong((String)p.get("accountExpires"));
            Long uAC = Long.parseLong((String)p.get("userAccountControl")) & 2L;
            Long pwdLastSet = Long.parseLong((String)p.get("pwdLastSet"));
            if (lockOutTime != 0L && (duration == 0L || curTime >= lockOutTime && curTime < lockOutTime + duration)) {
                logger.log(Level.INFO, "Account Lock Test - Lock Duration : " + duration + " : current time : " + curTime);
                request.setAttribute("login_status", (Object)"adssp.login.common.error.acc_has_locked");
                ret = false;
            } else if (accExpTime != 0L && accExpTime != Long.MAX_VALUE && accExpTime <= curTime) {
                logger.log(Level.INFO, "Account Expired - accExpTime : " + accExpTime + " : current time : " + curTime);
                request.setAttribute("login_status", (Object)"adssp.login.common.error.acc_has_expired");
                ret = false;
            } else if (uAC == 2L) {
                logger.log(Level.INFO, "Account Expired - uAC : " + uAC);
                request.setAttribute("login_status", (Object)"adssp.login.common.error.acc_has_disabled");
                ret = false;
            } else if (pwdLastSet != 0L && p.get("logonHours") != null && !SelfServiceHandler.isUserLogonPermitted(p).booleanValue()) {
                logger.log(Level.INFO, "The user account is restricted");
                request.setAttribute("login_status", (Object)"adssp.login.common.error.acc_has_restricted");
                ret = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getUserId(Long loginId) throws Exception {
        Criteria crit = new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)loginId, 0, false);
        Long authorizedId = null;
        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
        if (!obj.isEmpty()) {
            Row r = obj.getFirstRow("AaaLogin");
            authorizedId = (Long)r.get("USER_ID");
        }
        return authorizedId;
    }

    public static Long getUserId(String samAccountName, String domainName) throws Exception {
        Long authorizedId = null;
        Criteria crit = new Criteria(new Column("AaaLogin", "NAME"), (Object)samAccountName, 0, false);
        crit = crit.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0));
        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
        if (obj.isEmpty()) {
            ADMPUserHandler.addDomainUser(samAccountName, domainName);
            DataObject accountDO = ADAuthHandler.getAccountDO(samAccountName, domainName, "System");
            Row r = accountDO.getRow("AaaLogin");
            authorizedId = (Long)r.get("USER_ID");
        } else {
            Row r = obj.getFirstRow("AaaLogin");
            authorizedId = (Long)r.get("USER_ID");
        }
        return authorizedId;
    }

    private static String getS(String s) {
        return s;
    }

    public static boolean isPSSLimitExceeded(String samAccountName, String domain, String auditType, Long policyId) {
        long endtime = 0L;
        long startime = 0L;
        long preventRpUaLimit = 0L;
        int preventRpUaDays = 0;
        int preventRpUa = 0;
        boolean ret = false;
        try {
            Calendar cal = Calendar.getInstance();
            Criteria crit = new Criteria(Column.getColumn((String)"SSPBlocking", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject d = DataAccess.get((String)"SSPBlocking", (Criteria)crit);
            if (!d.isEmpty()) {
                Row r = d.getRow("SSPBlocking");
                preventRpUa = Integer.parseInt(r.get("PREVENT_RU").toString());
                if (auditType.equals("reset") && (preventRpUa & 2) == 2) {
                    preventRpUaLimit = Long.parseLong(r.get("PREVENT_RP_LIMIT").toString());
                    preventRpUaDays = Integer.parseInt(r.get("PREVENT_RP_DAYS").toString());
                } else if (auditType.equals("unlock") && (preventRpUa & 4) == 4) {
                    preventRpUaLimit = Long.parseLong(r.get("PREVENT_UA_LIMIT").toString());
                    preventRpUaDays = Integer.parseInt(r.get("PREVENT_UA_DAYS").toString());
                }
                if (preventRpUaLimit > 0L && preventRpUaDays > 0) {
                    endtime = cal.getTimeInMillis();
                    cal.add(5, -preventRpUaDays + 1);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    startime = cal.getTimeInMillis();
                    Long userId = SelfServiceHandler.getUserId(samAccountName, domain);
                    HashMap<String, Object> countQueryMap = new HashMap<String, Object>();
                    countQueryMap.put("domain", domain);
                    countQueryMap.put("startTime", startime);
                    countQueryMap.put("endTime", endtime);
                    countQueryMap.put("userId", userId);
                    new QueryGeneratorFactory();
                    AuditQueryGenerator cntObj = QueryGeneratorFactory.getInstance();
                    long cnt = cntObj.getResetUnlockCount(countQueryMap, auditType);
                    if (cnt >= preventRpUaLimit) {
                        ret = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

