/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;

public class SoonToExpireHandler {
    public static final int DAILY = 1;
    public static final int WEEKLY = 2;
    public static final int ON_SPECIFIC_DAYS = 3;
    public static final int NOTIFY_VIA_MAIL = 1;
    public static final int NOTIFY_VIA_SMS = 2;
    public static final int NOTIFY_VIA_PN = 4;
    public static JSONObject notifyModesObj = null;
    public static final long DEFAULT_NOTIFY_TYPE = 1L;
    public static final long DEFAULT_SCHEDULE_TYPE = 1L;
    public static final long DEFAULT_TIME_HRS = 8L;
    public static final long DEFAULT_TIME_MINS = 0L;
    public static final long DEFAULT_NO_OF_DAYS = 7L;
    private static SoonToExpireHandler instance = null;
    public static ArrayList sTEPropList = new ArrayList();
    private static Logger logger = Logger.getLogger(SoonToExpireHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    private SoonToExpireHandler() {
        try {
            notifyModesObj = new JSONObject("{'1':{'DESC':'MAIL', 'ATTRIB_ID':50001,\t'DISP':'adssp.reports.audit_report.notification_delivery_report.mail',\t'EXPORT_COLUMN':'adssp.admin.policies.scheduler.soon_to_expire_delivery_status_mail'}, '2':{'DESC':'SMS', 'ATTRIB_ID':50002, \t'DISP':'adssp.reports.audit_report.notification_delivery_report.sms',\t'EXPORT_COLUMN':'adssp.admin.policies.scheduler.soon_to_expire_delivery_status_sms'}, '4':{'DESC':'PushNotification',  'ATTRIB_ID':50003,\t'DISP':'adssp.reports.audit_report.notification_delivery_report.pn','EXPORT_COLUMN':'adssp.admin.policies.scheduler.soon_to_expire_delivery_status_pn'}}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SoonToExpireHandler getInstance() {
        if (instance != null) return instance;
        Class<SoonToExpireHandler> clazz = SoonToExpireHandler.class;
        synchronized (SoonToExpireHandler.class) {
            instance = new SoonToExpireHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static ArrayList getSTENotificationProps() {
        ArrayList<Hashtable> overAllDetails = new ArrayList<Hashtable>();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSTENotifications", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator iterator = obj.getRows("SSPSTENotifications");
                while (iterator.hasNext()) {
                    Hashtable props = new Hashtable();
                    Row r = (Row)iterator.next();
                    Long scheduleId = (Long)r.get("SCHEDULE_ID");
                    String notifyAdmin = (String)r.get("NOTIFY_ADMIN");
                    props.put("SCHEDULE_ID", scheduleId);
                    props.put("NOTIFY_ADMIN", notifyAdmin);
                    props.put("NOTIFY_TYPE_ID", (Long)r.get("NOTIFY_TYPE_ID"));
                    props.put("SCHEDULE_TYPE_ID", (Long)r.get("SCHEDULE_TYPE_ID"));
                    props.put("NOTIFY_ENROLLED", (String)r.get("NOTIFY_ENROLLED"));
                    props.put("EXCLUDE_DISABLED_USERS", (String)r.get("EXCLUDE_DISABLED_USERS"));
                    props.put("EXCLUDE_SMARTCARD_USERS", (String)r.get("EXCLUDE_SMARTCARD_USERS"));
                    props.put("RETRY_NOTIFICATION", (String)r.get("RETRY_NOTIFICATION"));
                    props.put("CREATED_TIME", (Long)r.get("CREATED_TIME"));
                    props.put("MODIFIED_TIME", (Long)r.get("MODIFIED_TIME"));
                    props.put("NOTIFY_MANAGER", (String)r.get("NOTIFY_MANAGER"));
                    props.put("NOTIFY_VIA", Integer.parseInt(r.get("NOTIFY_VIA").toString()));
                    props.put("NOTIFY_PWD_EXPIRED_USERS", (String)r.get("NOTIFY_PWD_EXPIRED_USERS"));
                    props.put("SCHEDULER_STATUS", SchedulerHandler.getInstance().isSchedulerRunning(scheduleId.toString(), null));
                    props.put("GROUP_SELECTION", true);
                    SchedulerHandler.getInstance();
                    props = SchedulerHandler.getSchedulerProps(scheduleId, props);
                    SoonToExpireHandler.fillSTEMailDetails(scheduleId, props);
                    overAllDetails.add(props);
                }
            } else {
                Hashtable props = SoonToExpireHandler.defaultSTENotificationProps();
                overAllDetails.add(props);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sTEPropList = overAllDetails;
        return overAllDetails;
    }

    public static void fillSTEMailDetails(Long scheduleId, Hashtable props) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSTEMailDetails", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSTEMailDetails", crit);
            if (!obj.isEmpty()) {
                ArrayList mailDets = new ArrayList();
                Iterator iterator = obj.getRows("SSPSTEMailDetails");
                while (iterator.hasNext()) {
                    String mailPath;
                    Row r = (Row)iterator.next();
                    String string = mailPath = (String)r.get("MAIL_ATT_PATH") != null ? (String)r.get("MAIL_ATT_PATH") : "-";
                    if ((Long)r.get("NO_OF_DAYS") == -1L) {
                        props.put("EXPIRED_MAIL_SUBJECT", (String)r.get("MAIL_SUBJECT"));
                        props.put("EXPIRED_MAIL_CONTENT", (String)r.get("MAIL_CONTENT"));
                        props.put("MAIL_ATT_PATHS", mailPath);
                        props.put("MAIL_PRIORITY", (String)r.get("MAIL_PRIORITY"));
                        props.put("UNIQUE_ID", (Long)r.get("UNIQUE_ID"));
                        SoonToExpireHandler.setMailAttachments(props, mailPath);
                        continue;
                    }
                    Hashtable<String, Object> det = new Hashtable<String, Object>();
                    det.put("NO_OF_DAYS", (Long)r.get("NO_OF_DAYS"));
                    det.put("MAIL_SUBJECT", (String)r.get("MAIL_SUBJECT"));
                    det.put("MAIL_CONTENT", (String)r.get("MAIL_CONTENT"));
                    det.put("MAIL_PRIORITY", (String)r.get("MAIL_PRIORITY"));
                    det.put("UNIQUE_ID", (Long)r.get("UNIQUE_ID"));
                    det.put("MAIL_ATT_PATHS", mailPath);
                    SoonToExpireHandler.setMailAttachments(det, mailPath);
                    mailDets.add(det);
                }
                props.put("MAIL_DETAILS", mailDets);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList setSTENotificationProps(HttpServletRequest request) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("TASK_ID", SchedulerHandler.getTaskID("com.adventnet.sym.adsm.common.server.taskengine.SoonToExpTask"));
            Long scheduleId = Long.parseLong(request.getParameter("SCHEDULE_ID"));
            props.put("SCHEDULE_ID", scheduleId);
            if (scheduleId.equals(0)) {
                props.put("CREATED_TIME", Long.parseLong(request.getParameter("CREATED_TIME")));
            } else {
                props.put("CREATED_TIME", System.currentTimeMillis());
            }
            String nEnroll = "false";
            if (request.getParameter("NOTIFY_ENROLLED") != null) {
                nEnroll = "true";
            }
            String excludeDisabledUsers = request.getParameter("EXCLUDE_DISABLED_USERS") != null ? "true" : "false";
            String excludeSmartcardUsers = request.getParameter("EXCLUDE_SMARTCARD_USERS") != null ? "true" : "false";
            String notifyFailureReattempt = request.getParameter("RETRY_NOTIFICATION") != null ? "true" : "false";
            props.put("NOTIFY_TYPE_ID", Long.parseLong(request.getParameter("NOTIFY_TYPE_ID")));
            props.put("NOTIFY_ENROLLED", nEnroll);
            props.put("EXCLUDE_DISABLED_USERS", excludeDisabledUsers);
            props.put("EXCLUDE_SMARTCARD_USERS", excludeSmartcardUsers);
            props.put("RETRY_NOTIFICATION", notifyFailureReattempt);
            props.put("MAIL_PRIORITY", request.getParameterValues("MAIL_PRIORITY"));
            props.put("SCHEDULE_TYPE_ID", Long.parseLong(request.getParameter("SCHEDULE_TYPE_ID")));
            props.put("USER_MAIL_SUBJECT", request.getParameterValues("USER_MAIL_SUBJECT"));
            props.put("USER_MAIL_CONTENT", request.getParameterValues("USER_MAIL_CONTENT"));
            props.put("MAIL_ATT_PATH", request.getParameterValues("MAIL_ATT_PATH"));
            props.put("NO_OF_DAYS", request.getParameterValues("NO_OF_DAYS"));
            props.put("SCHEDULE_NAME", StrUtil.decodeURIComponent(request.getParameter("SCHEDULE_NAME")));
            props.put("DESCRIPTION", "-");
            props.put("SCHEDULE_TYPE", request.getParameter("SCHEDULE_TYPE"));
            props.put("DAY_OF_WEEK", Integer.parseInt(request.getParameter("DAY_OF_WEEK")));
            props.put("TIME_OF_DAY", Long.parseLong(request.getParameter("TIME_OF_DAY")));
            props.put("MINS_OF_HOUR", Long.parseLong(request.getParameter("MINS_OF_HOUR")));
            props.put("ADMIN_STATUS", Integer.parseInt(request.getParameter("ADMIN_STATUS")));
            String notifyMgr = "false";
            if (request.getParameter("NOTIFY_MANAGER") != null) {
                notifyMgr = "true";
            }
            props.put("NOTIFY_MANAGER", notifyMgr);
            String nAdmin = "false";
            if (request.getParameter("NOTIFY_ADMIN") != null) {
                nAdmin = "true";
            }
            props.put("NOTIFY_ADMIN", nAdmin);
            if (nAdmin.equals("true") || notifyMgr.equals("true")) {
                props.put("EMAIL_ID", request.getParameter("EMAIL_ID"));
                props.put("STORAGE_PATH", request.getParameter("STORAGE_PATH"));
                props.put("FILE_FORMAT", request.getParameter("FILE_FORMAT"));
                props.put("ATTACHMENT_TYPE", request.getParameter("ATTACHMENT_TYPE"));
                props.put("MAIL_SUBJECT", request.getParameter("ADMIN_MAIL_SUBJECT"));
                props.put("MAIL_CONTENT", request.getParameter("ADMIN_MAIL_CONTENT"));
                props.put("ADMIN_MAIL_PRIORITY", request.getParameter("ADMIN_MAIL_PRIORITY"));
            }
            props.put("NOTIFY_VIA", Integer.parseInt(request.getParameter("NOTIFY_VIA")));
            String notifyPwdExpiredUsers = "false";
            if (request.getParameter("NOTIFY_PWD_EXPIRED_USERS") != null) {
                notifyPwdExpiredUsers = "true";
            }
            props.put("NOTIFY_PWD_EXPIRED_USERS", notifyPwdExpiredUsers);
            if (notifyPwdExpiredUsers.equals("true")) {
                props.put("EXPIRED_MAIL_SUBJECT", request.getParameter("EXPIRED_MAIL_SUBJECT"));
                props.put("EXPIRED_MAIL_CONTENT", request.getParameter("EXPIRED_MAIL_CONTENT"));
            }
            String[] attCount = request.getParameterValues("MAIL_ATTACHMENTS");
            String[] userMail = request.getParameterValues("NO_OF_DAYS");
            String[] dirPath = request.getParameterValues("MAIL_ATT_PATH");
            ArrayList<String> tmPath = new ArrayList<String>();
            String[] FileNames = request.getParameterValues("FILE_NAMES");
            int schsize = notifyPwdExpiredUsers.equals("true") ? userMail.length + 1 : userMail.length;
            for (int j = 0; j < schsize; ++j) {
                if (!attCount[j].equals("0")) {
                    String isdirExist = dirPath[j].equals("-") || dirPath[j].equals(null) || dirPath[j].equals("") ? "false" : "true";
                    JSONObject mailattSettings = new JSONObject();
                    mailattSettings.put("SCHEDULE_ID", (Object)scheduleId);
                    mailattSettings.put("TABLE_NAME", (Object)"SSPSTEMailDetails");
                    mailattSettings.put("DIR_EXIST", (Object)isdirExist);
                    String[] filePath = dirPath[j].split("\\\\");
                    String folderName = filePath[filePath.length - 1];
                    mailattSettings.put("FOLDER_NAME", (Object)folderName);
                    mailattSettings.put("DIR_PATH", (Object)dirPath[j]);
                    mailattSettings.put("STORE_FILES", (Object)FileNames[j]);
                    String dir = DirectoryUtil.setAttachments(mailattSettings, request);
                    if (!dir.equalsIgnoreCase("-NA-")) {
                        tmPath.add(dir);
                        continue;
                    }
                    tmPath.add(dirPath[j]);
                    continue;
                }
                if (!(dirPath[j].equals("-") || dirPath[j].equals(null) && dirPath[j].equals(""))) {
                    tmPath.add(dirPath[j]);
                    continue;
                }
                tmPath.add("-");
            }
            String[] mailAttPath = new String[tmPath.size()];
            mailAttPath = tmPath.toArray(mailAttPath);
            props.put("MAIL_ATT_PATH", mailAttPath);
            SchedulerHandler.getInstance();
            Object schId = SchedulerHandler.updateReportScheduler(props, request, false);
            SoonToExpireHandler.setSTENotifications(props, obj, schId);
            SoonToExpireHandler.setSTEMailDetails(props, obj, schId);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
            SoonToExpireHandler.deleteMailAttFolder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SoonToExpireHandler.getSTENotificationProps();
    }

    public static void setSTENotifications(Hashtable props, DataObject obj, Object scheduleId) {
        try {
            Row r = new Row("SSPSTENotifications");
            r.set("SCHEDULE_ID", scheduleId);
            r.set("NOTIFY_ADMIN", props.get("NOTIFY_ADMIN"));
            r.set("NOTIFY_TYPE_ID", props.get("NOTIFY_TYPE_ID"));
            r.set("SCHEDULE_TYPE_ID", props.get("SCHEDULE_TYPE_ID"));
            r.set("NOTIFY_ENROLLED", props.get("NOTIFY_ENROLLED"));
            r.set("EXCLUDE_DISABLED_USERS", props.get("EXCLUDE_DISABLED_USERS"));
            r.set("EXCLUDE_SMARTCARD_USERS", props.get("EXCLUDE_SMARTCARD_USERS"));
            r.set("RETRY_NOTIFICATION", props.get("RETRY_NOTIFICATION"));
            r.set("CREATED_TIME", props.get("CREATED_TIME"));
            r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            r.set("NOTIFY_MANAGER", props.get("NOTIFY_MANAGER"));
            r.set("NOTIFY_VIA", (Object)Integer.parseInt(props.get("NOTIFY_VIA").toString()));
            r.set("NOTIFY_PWD_EXPIRED_USERS", (Object)((String)props.get("NOTIFY_PWD_EXPIRED_USERS")));
            obj.addRow(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSTEMailDetails(Hashtable props, DataObject obj, Object scheduleId) {
        try {
            String[] uSubs = (String[])props.get("USER_MAIL_SUBJECT");
            String[] uMsgs = (String[])props.get("USER_MAIL_CONTENT");
            String[] noOfDays = (String[])props.get("NO_OF_DAYS");
            String[] mailAttachments = (String[])props.get("MAIL_ATT_PATH");
            String[] mailPriority = (String[])props.get("MAIL_PRIORITY");
            Long scheduleTypeId = (Long)props.get("SCHEDULE_TYPE_ID");
            Integer length = scheduleTypeId == 3L ? uSubs.length : 1;
            for (int i = 0; i < length; ++i) {
                Row r = new Row("SSPSTEMailDetails");
                r.set("SCHEDULE_ID", scheduleId);
                r.set("NO_OF_DAYS", (Object)Long.parseLong(noOfDays[i]));
                r.set("MAIL_SUBJECT", (Object)uSubs[i]);
                r.set("MAIL_CONTENT", (Object)uMsgs[i]);
                r.set("MAIL_ATT_PATH", (Object)mailAttachments[i]);
                r.set("MAIL_PRIORITY", (Object)mailPriority[i]);
                obj.addRow(r);
            }
            if ("true".equalsIgnoreCase((String)props.get("NOTIFY_PWD_EXPIRED_USERS"))) {
                String expSub = (String)props.get("EXPIRED_MAIL_SUBJECT");
                String expContent = (String)props.get("EXPIRED_MAIL_CONTENT");
                expContent = expContent.replaceAll("&lt;", "<");
                expContent = expContent.replaceAll("&gt;", ">");
                expContent = expContent.replaceAll("&amp;", "&");
                Row r = new Row("SSPSTEMailDetails");
                r.set("SCHEDULE_ID", scheduleId);
                r.set("NO_OF_DAYS", (Object)-1L);
                r.set("MAIL_SUBJECT", (Object)StrUtil.decodeURIComponent(expSub));
                r.set("MAIL_CONTENT", (Object)StrUtil.decodeURIComponent(expContent));
                r.set("MAIL_ATT_PATH", (Object)mailAttachments[uSubs.length]);
                r.set("MAIL_PRIORITY", (Object)mailPriority[uSubs.length]);
                obj.addRow(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setNotifyMailProps(Long scheduleId, Hashtable notifyMailProps) {
        try {
            Long schTypeId = null;
            Criteria c = new Criteria(Column.getColumn((String)"SSPSTENotifications", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPSTENotifications", c);
            if (!o.isEmpty()) {
                Row r = o.getRow("SSPSTENotifications");
                schTypeId = (Long)r.get("SCHEDULE_TYPE_ID");
                Long nTypeId = (Long)r.get("NOTIFY_TYPE_ID");
                String nAdmin = (String)r.get("NOTIFY_ADMIN");
                notifyMailProps.put("SCHEDULE_TYPE_ID", schTypeId);
                notifyMailProps.put("NOTIFY_TYPE_ID", nTypeId);
                notifyMailProps.put("NOTIFY_ADMIN", nAdmin);
                notifyMailProps.put("NOTIFY_ENROLLED", (String)r.get("NOTIFY_ENROLLED"));
                notifyMailProps.put("EXCLUDE_DISABLED_USERS", (String)r.get("EXCLUDE_DISABLED_USERS"));
                notifyMailProps.put("EXCLUDE_SMARTCARD_USERS", (String)r.get("EXCLUDE_SMARTCARD_USERS"));
                notifyMailProps.put("RETRY_NOTIFICATION", (String)r.get("RETRY_NOTIFICATION"));
                notifyMailProps.put("NOTIFY_MANAGER", (String)r.get("NOTIFY_MANAGER"));
                notifyMailProps.put("NOTIFY_VIA", Integer.parseInt(r.get("NOTIFY_VIA").toString()));
                notifyMailProps.put("NOTIFY_PWD_EXPIRED_USERS", (String)r.get("NOTIFY_PWD_EXPIRED_USERS"));
                Criteria crit = new Criteria(Column.getColumn((String)"SSPSTEMailDetails", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                SelectQueryImpl sq = new SelectQueryImpl(new Table("SSPSTEMailDetails"));
                sq.addSelectColumn(Column.getColumn((String)"SSPSTEMailDetails", (String)"*"));
                sq.addSortColumn(new SortColumn(Column.getColumn((String)"SSPSTEMailDetails", (String)"NO_OF_DAYS"), false));
                sq.setCriteria(crit);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                int count = 0;
                Iterator iterator = obj.getRows("SSPSTEMailDetails");
                while (iterator.hasNext()) {
                    r = (Row)iterator.next();
                    Long noOfDay = (Long)r.get("NO_OF_DAYS");
                    String sub = (String)r.get("MAIL_SUBJECT");
                    String msg = (String)r.get("MAIL_CONTENT");
                    String att = (String)r.get("MAIL_ATT_PATH");
                    att = new File(System.getProperty("server.home")).getAbsolutePath().replaceFirst("\\\\bin\\\\..", "\\\\webapps\\\\adssp\\\\" + att);
                    String prt = (String)r.get("MAIL_PRIORITY");
                    if (noOfDay == -1L) {
                        notifyMailProps.put("EXPIRED_MAIL_SUBJECT", (String)r.get("MAIL_SUBJECT"));
                        notifyMailProps.put("EXPIRED_MAIL_CONTENT", (String)r.get("MAIL_CONTENT"));
                        notifyMailProps.put("EXPIRED_MAIL_ATT_PATH", att);
                        notifyMailProps.put("EXPIRED_MAIL_PRIORITY", (String)r.get("MAIL_PRIORITY"));
                    } else if (schTypeId == 3L) {
                        Hashtable<String, String> p = new Hashtable<String, String>();
                        p.put("USER_MAIL_SUBJECT", sub);
                        p.put("USER_MAIL_CONTENT", msg);
                        p.put("MAIL_ATT_PATH", att);
                        p.put("MAIL_PRIORITY", prt);
                        notifyMailProps.put(noOfDay.toString(), p);
                    } else {
                        notifyMailProps.put("NO_OF_DAYS", noOfDay);
                        notifyMailProps.put("USER_MAIL_SUBJECT", sub);
                        notifyMailProps.put("USER_MAIL_CONTENT", msg);
                        notifyMailProps.put("MAIL_ATT_PATH", att);
                        notifyMailProps.put("MAIL_PRIORITY", prt);
                    }
                    if (count == 0) {
                        if (noOfDay == 0L) {
                            notifyMailProps.put("MAX_CONFIG_DAYS", 1L);
                            notifyMailProps.put("EXPIRES_TODAY_ONLY", "true");
                        } else {
                            notifyMailProps.put("MAX_CONFIG_DAYS", noOfDay + 1L);
                            notifyMailProps.put("EXPIRES_TODAY_ONLY", "false");
                        }
                    }
                    ++count;
                }
                if (nAdmin.equals("true") || "true".equals(notifyMailProps.get("NOTIFY_MANAGER"))) {
                    SchedulerHandler.getInstance();
                    SchedulerHandler.fillSchedulerNotification(scheduleId, notifyMailProps);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addSTEPushNotificationDeliveryReport(Hashtable deliveryProps) {
        try {
            Enumeration e = deliveryProps.keys();
            while (e.hasMoreElements()) {
                Row r;
                String deviceToken = (String)e.nextElement();
                Hashtable pnProps = (Hashtable)deliveryProps.get(deviceToken);
                String domainName = (String)pnProps.get("DOMAIN_NAME");
                String statusMsg = (String)pnProps.get("STATUS");
                Long mailSentTime = (Long)pnProps.get("MAIL_SENT_TIME");
                String actionName = (String)pnProps.get("ACTION_NAME");
                String nType = (String)pnProps.get("NOTIFICATION_TYPE");
                String name = (String)pnProps.get("NAME");
                Long deliveredTime = new Long(-1L);
                if (pnProps.get("DELIVERED_TIME") != null) {
                    deliveredTime = (Long)pnProps.get("DELIVERED_TIME");
                }
                String objectGuid = UserUtil.getUserObjectGUIDFromName(name);
                Object userUniqueId = null;
                if (objectGuid == null) continue;
                Criteria crit = new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"NOTIFICATION_TYPE"), (Object)nType, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"ACTION_NAME"), (Object)actionName, 0));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSTEDeliveryStatus", crit);
                if (obj.isEmpty()) {
                    r = new Row("SSPSTEDeliveryStatus");
                    r.set("OBJECT_GUID", (Object)objectGuid);
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("NOTIFICATION_TYPE", (Object)nType);
                    r.set("ACTION_NAME", (Object)actionName);
                    if (statusMsg.equals("adssp.common.text.success")) {
                        r.set("LAST_DELIVERED_TIME", (Object)deliveredTime);
                    }
                    obj.addRow(r);
                    userUniqueId = r.get("USER_UNIQUE_ID");
                } else {
                    r = obj.getRow("SSPSTEDeliveryStatus");
                    userUniqueId = r.get("USER_UNIQUE_ID");
                    if (!statusMsg.equals("adssp.reports.ste_delivery_rep_mail_already_sent")) {
                        r.set("LAST_DELIVERED_TIME", (Object)deliveredTime);
                        obj.updateRow(r);
                    }
                }
                r = new Row("SSPSTEMailAudit");
                r.set("USER_UNIQUE_ID", userUniqueId);
                r.set("ACTION_NAME", (Object)actionName);
                r.set("NOTIFICATION_TYPE", (Object)nType);
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("OBJECT_GUID", (Object)objectGuid);
                r.set("NAME", (Object)name);
                r.set("TIME", (Object)mailSentTime);
                r.set("DELIVERED_TIME", (Object)deliveredTime);
                if (statusMsg.equals("adssp.common.text.success")) {
                    r.set("STATUS", (Object)1);
                } else {
                    r.set("STATUS", (Object)0);
                }
                r.set("ERROR_MESSAGE", (Object)statusMsg);
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
                AdventNetResourceBundle adminRb = ResourceBundleMgr.getInstance().getBundle();
                JSONObject jsonLog = AuditAPI.getInstance().setNotificationAuditProps(name, domainName, actionName, nType, mailSentTime, deliveredTime, statusMsg, "");
                logger.log(Level.INFO, "calling LogForwarderAPI : " + jsonLog.toString());
                LogForwarderAPI.getInstance().sendMessage(jsonLog);
            }
            AuditReportHandler.checkForBackUp("SSPSTEMailAudit");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addSTEDeliveryReport(Hashtable deliveryProps) {
        try {
            Enumeration e = deliveryProps.keys();
            while (e.hasMoreElements()) {
                Row r;
                String objectGuid = (String)e.nextElement();
                Hashtable mailProps = (Hashtable)deliveryProps.get(objectGuid);
                String domainName = (String)mailProps.get("DOMAIN_NAME");
                String statusMsg = (String)mailProps.get("STATUS");
                Long mailSentTime = (Long)mailProps.get("MAIL_SENT_TIME");
                String actionName = (String)mailProps.get("ACTION_NAME");
                String nType = (String)mailProps.get("NOTIFICATION_TYPE");
                String name = (String)mailProps.get("NAME");
                Long deliveredTime = new Long(-1L);
                if (mailProps.get("DELIVERED_TIME") != null) {
                    deliveredTime = (Long)mailProps.get("DELIVERED_TIME");
                }
                Object userUniqueId = null;
                Criteria crit = new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"OBJECT_GUID"), (Object)objectGuid, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"NOTIFICATION_TYPE"), (Object)nType, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSTEDeliveryStatus", (String)"ACTION_NAME"), (Object)actionName, 0));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSTEDeliveryStatus", crit);
                if (obj.isEmpty()) {
                    r = new Row("SSPSTEDeliveryStatus");
                    r.set("OBJECT_GUID", (Object)objectGuid);
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("NOTIFICATION_TYPE", (Object)nType);
                    r.set("ACTION_NAME", (Object)actionName);
                    if (statusMsg.equals("adssp.common.text.success")) {
                        r.set("LAST_DELIVERED_TIME", (Object)deliveredTime);
                    }
                    obj.addRow(r);
                    userUniqueId = r.get("USER_UNIQUE_ID");
                } else {
                    r = obj.getRow("SSPSTEDeliveryStatus");
                    userUniqueId = r.get("USER_UNIQUE_ID");
                    if (!statusMsg.equals("adssp.reports.ste_delivery_rep_mail_already_sent") && !statusMsg.equals("adssp.reports.ste_delivery_rep_sms_already_sent")) {
                        r.set("LAST_DELIVERED_TIME", (Object)deliveredTime);
                        obj.updateRow(r);
                    }
                }
                r = new Row("SSPSTEMailAudit");
                r.set("USER_UNIQUE_ID", userUniqueId);
                r.set("ACTION_NAME", (Object)actionName);
                r.set("NOTIFICATION_TYPE", (Object)nType);
                r.set("DOMAIN_NAME", (Object)domainName);
                r.set("OBJECT_GUID", (Object)objectGuid);
                r.set("NAME", (Object)name);
                r.set("TIME", (Object)mailSentTime);
                r.set("DELIVERED_TIME", (Object)deliveredTime);
                if (statusMsg.equals("adssp.common.text.success")) {
                    r.set("STATUS", (Object)1);
                } else {
                    r.set("STATUS", (Object)0);
                }
                r.set("ERROR_MESSAGE", (Object)statusMsg);
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
                JSONObject jsonLog = AuditAPI.getInstance().setNotificationAuditProps(name, domainName, actionName, nType, mailSentTime, deliveredTime, statusMsg, "");
                LogForwarderAPI.getInstance().sendMessage(jsonLog);
            }
            AuditReportHandler.checkForBackUp("SSPSTEMailAudit");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean isAlreadyMailSent(String objectGuid, Long maxExpireDay, Long mailSentTime, String actionName) {
        return SoonToExpireHandler.isAlreadyNotificationSent(objectGuid, maxExpireDay, mailSentTime, "adssp.reports.audit_report.notification_delivery_report.mail", actionName);
    }

    public static Boolean isAlreadySMSSent(String objectGuid, Long maxExpireDay, Long mailSentTime, String actionName) {
        return SoonToExpireHandler.isAlreadyNotificationSent(objectGuid, maxExpireDay, mailSentTime, "adssp.reports.audit_report.notification_delivery_report.sms", actionName);
    }

    public static Boolean isAlreadyPNSent(String objectGuid, Long maxExpireDay, Long mailSentTime, String actionName) {
        return SoonToExpireHandler.isAlreadyNotificationSent(objectGuid, maxExpireDay, mailSentTime, "adssp.reports.audit_report.notification_delivery_report.ios.push_notification", actionName) != false || SoonToExpireHandler.isAlreadyNotificationSent(objectGuid, maxExpireDay, mailSentTime, "adssp.reports.audit_report.notification_delivery_report.android.push_notification", actionName) != false;
    }

    public static Boolean isAlreadyNotificationSent(String objectGuid, Long maxExpireDay, Long mailSentTime, String nType, String actionName) {
        try {
            String table = "SSPSTEDeliveryStatus";
            Criteria crit = new Criteria(Column.getColumn((String)table, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)table, (String)"NOTIFICATION_TYPE"), (Object)nType, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)table, (String)"ACTION_NAME"), (Object)actionName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(table, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow(table);
                Long lastDelTime = (Long)r.get("LAST_DELIVERED_TIME");
                HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                Long calculatedTime = lastDelTime + maxExpireDay * 24L * 60L * 60L * 1000L;
                String lastDelDate = TimeZoneUtil.getTimeInCustomFormat(lastDelTime, dateFormatMap, rb);
                if (lastDelTime != -1L && (calculatedTime >= mailSentTime || lastDelDate.toLowerCase().contains("today"))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void deleteScheduler(Long scheduleId) {
        try {
            SchedulerHandler.getInstance();
            SchedulerHandler.deleteScheduler(scheduleId);
            SoonToExpireHandler.deleteMailAttFolder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getselectedNotifyModes(int notifyMode) {
        ArrayList<String> notifyModes = new ArrayList<String>();
        try {
            Iterator it = notifyModesObj.keys();
            while (it.hasNext()) {
                Object key = it.next();
                int notifyId = Integer.parseInt(key.toString());
                if ((notifyId & notifyMode) != notifyId) continue;
                notifyModes.add(notifyModesObj.getJSONObject(key.toString()).getString("DESC"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifyModes;
    }

    public JSONObject getNotifyModesObj(int notifyMode) {
        JSONObject notifyModesObject = new JSONObject();
        try {
            notifyModesObject = new JSONObject(notifyModesObj.toString());
            Iterator it = notifyModesObject.keys();
            while (it.hasNext()) {
                Object key = it.next();
                int notifyId = Integer.parseInt(key.toString());
                JSONObject obj = notifyModesObject.getJSONObject(key.toString());
                obj.put("SELECTED", false);
                if ((notifyId & notifyMode) == notifyId) {
                    obj.put("SELECTED", true);
                }
                notifyModesObject.put(key.toString(), (Object)obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notifyModesObject;
    }

    public static void deleteMailAttFolder() {
        try {
            File cpFile;
            File[] fList;
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSTEMailDetails", (Criteria)null);
            Row r = obj.getRow("SSPSTEMailDetails");
            ArrayList<String> prFolders = new ArrayList<String>();
            Iterator iterator = obj.getRows("SSPSTEMailDetails");
            while (iterator.hasNext()) {
                r = (Row)iterator.next();
                String path = (String)r.get("MAIL_ATT_PATH");
                String[] filePath = path.split("\\\\");
                String folderName = filePath[filePath.length - 1];
                prFolders.add(folderName);
            }
            String resource = new File(System.getProperty("server.home")).getAbsolutePath();
            resource = resource.replaceFirst("\\\\bin\\\\..", "\\\\webapps\\\\adssp\\\\mail_attachments\\\\scheduler\\\\");
            ArrayList<String> tmFiles = new ArrayList<String>();
            if (!resource.equals("-") && (fList = (cpFile = new File(resource)).listFiles()) != null) {
                for (int k = 0; k < fList.length; ++k) {
                    String attachName = fList[k].getName();
                    tmFiles.add(attachName);
                }
            }
            ArrayList destinationList = new ArrayList(tmFiles);
            destinationList.removeAll(prFolders);
            File file = new File(resource);
            File[] fList2 = file.listFiles();
            if (fList2 != null) {
                block4: for (int i = 0; i < destinationList.size(); ++i) {
                    for (int j = 0; j < fList2.length; ++j) {
                        String[] entries;
                        if (!fList2[j].getName().contains((CharSequence)destinationList.get(i))) continue;
                        for (String s : entries = fList2[j].list()) {
                            File currentFile = new File(fList2[j].getPath(), s);
                            currentFile.delete();
                        }
                        fList2[j].delete();
                        continue block4;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setMailAttachments(Hashtable props, String mailPath) {
        ArrayList<String> tmFiles = new ArrayList<String>();
        if (!mailPath.equals("-")) {
            mailPath = new File(System.getProperty("server.home")).getAbsolutePath().replaceFirst("\\\\bin\\\\..", "\\\\webapps\\\\adssp\\\\" + mailPath);
            try {
                long size = FileUtils.sizeOfDirectory((File)new File(mailPath));
                props.put("DIR_SIZE", size);
                File cpFile = new File(mailPath);
                File[] fList = cpFile.listFiles();
                for (int j = 0; j < fList.length; ++j) {
                    String attachName = fList[j].getName();
                    tmFiles.add(attachName);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Invalid mail_attr_path ");
            }
        }
        if (tmFiles.size() != 0) {
            String[] attFiles = new String[tmFiles.size()];
            attFiles = tmFiles.toArray(attFiles);
            props.put("MAIL_ATT_FILES", attFiles);
        } else {
            String[] attFiles = new String[]{"-"};
            props.put("MAIL_ATT_FILES", attFiles);
        }
    }

    public static String deleteAttachedFile(HttpServletRequest request) {
        String status;
        block4: {
            status = "failure";
            try {
                String table = "SSPSTEMailDetails";
                String unqId = request.getParameter("UNIQUE_ID");
                Criteria crit = new Criteria(Column.getColumn((String)table, (String)"UNIQUE_ID"), (Object)unqId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(table, crit);
                if (obj.isEmpty()) break block4;
                Row r = obj.getRow(table);
                String dirPath = (String)r.get("MAIL_ATT_PATH");
                dirPath = new File(System.getProperty("server.home")).getAbsolutePath().replaceFirst("\\\\bin\\\\..", "\\\\webapps\\\\adssp\\\\" + dirPath);
                String fileName = StrUtil.decodeURIComponent(request.getParameter("FILE_NAME"));
                Object delFile = null;
                File file = new File(dirPath);
                File[] fList = file.listFiles();
                for (int j = 0; j < fList.length; ++j) {
                    if (!fList[j].getName().equals(fileName)) continue;
                    fList[j].delete();
                    if (fList.length == 1) {
                        file.delete();
                    }
                    status = "success";
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                status = "failure";
            }
        }
        return status;
    }

    public static Hashtable defaultSTENotificationProps() {
        Hashtable props = new Hashtable();
        try {
            Long scheduleId = 0L;
            props.put("SCHEDULE_ID", scheduleId);
            props.put("SCHEDULE_NAME", "adssp.xml.notification.pwd_acc_expiry_sch_name");
            props.put("DESCRIPTION", "adssp.xml.notification.pwd_acc_expiry_sch_desc");
            props.put("NOTIFY_ADMIN", "false");
            props.put("NOTIFY_TYPE_ID", 1L);
            props.put("SCHEDULE_TYPE_ID", 1L);
            props.put("NOTIFY_ENROLLED", "false");
            props.put("EXCLUDE_DISABLED_USERS", "false");
            props.put("EXCLUDE_SMARTCARD_USERS", "false");
            props.put("RETRY_NOTIFICATION", "true");
            props.put("CREATED_TIME", 0L);
            props.put("MODIFIED_TIME", 0L);
            props.put("NOTIFY_MANAGER", "false");
            props.put("NOTIFY_VIA", 1);
            props.put("NOTIFY_PWD_EXPIRED_USERS", "false");
            props.put("TIME_OF_DAY", 8L);
            props.put("MINS_OF_HOUR", 0L);
            props.put("SCHEDULER_STATUS", false);
            props.put("ADMIN_STATUS", new Integer(4));
            props.put("GROUP_SELECTION", true);
            SchedulerHandler.getInstance();
            props = SchedulerHandler.getSchedulerProps(scheduleId, props);
            ArrayList mailDets = new ArrayList();
            Hashtable<String, Object> det = new Hashtable<String, Object>();
            det.put("NO_OF_DAYS", 7L);
            det.put("MAIL_SUBJECT", "adssp.xml.notification.pwd_expiry_users_sub");
            det.put("MAIL_CONTENT", "adssp.xml.notification.pwd_expiry_users_msg");
            mailDets.add(det);
            props.put("MAIL_DETAILS", mailDets);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }
}

