/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class TechnicianHandler {
    public static final Long SQA_REPORT = new Long(26L);
    public static final Long DISENROLL_USER_ACTION = new Long(40L);
    public static final Long DELETE_USER_ACTION = new Long(41L);
    private static Logger logger = Logger.getLogger(TechnicianHandler.class.getName());
    private static Long[] extendedActionIDs = new Long[]{SQA_REPORT, DISENROLL_USER_ACTION, DELETE_USER_ACTION};

    public static Long createUser(String domainName, String loginName, String password, Long roleId) {
        Long loginId = null;
        try {
            WritableDataObject dobj = new WritableDataObject();
            Properties properties = new Properties();
            properties.put("name", loginName);
            properties.put("displayName", loginName);
            properties.put("mail", "null");
            properties.put("givenName", "null");
            properties.put("initials", "null");
            properties.put("sn", "null");
            properties.put("PASSWORD", password);
            properties.put("ADMP_ROLE_ID", roleId);
            Long mLiteRoleId = AuthUtil.getRoleId((String)"Administrator");
            loginId = ADMPUserHandler.addUserDetailsInAAATable(properties, domainName, mLiteRoleId, loginName);
            logger.log(Level.INFO, "Successfully Created Account for HelpDesk user : " + loginName + " of " + domainName + " domain");
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return loginId;
    }

    public static void changePassword(Long loginId, String password) throws Exception {
        if (TechnicianHandler.isLoggedOnUser(loginId)) {
            throw new ADSSPException("adssp.admin.configuration.technician.cannot_reset_to_loggedonuser");
        }
        try {
            String oldPwd = null;
            String newPwd = password;
            String loginName = (String)AuthDBUtil.getObject((String)"AaaLogin", (String)"NAME", (String)"LOGIN_ID", (Object)loginId);
            String serviceName = ADSMPersUtil.getServiceName(loginName);
            AuthUtil.changePasswordForUser((String)loginName, (String)serviceName, oldPwd, (String)newPwd, (String)"ADSelfService Plus Authentication");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isLoggedOnUser(Long loginId) {
        Credential cred = AuthUtil.getUserCredential();
        return cred.getLoginId().equals(loginId);
    }

    public static boolean changeRoleID(Long loginID, Long roleID, String credential) {
        try {
            Criteria criteria = new Criteria(new Column("ADMPUsersRoleMapping", "LOGIN_ID"), (Object)loginID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersRoleMapping", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADMPUsersRoleMapping");
                row.set("ADMP_ROLE_ID", (Object)roleID);
                row.set("USER_CREDENTIAL", (Object)credential);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in updating user Account");
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTechnicianCount() {
        int i = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Table baseTable = new Table("AaaLogin");
            Table joinTable = new Table("ADMPUsersRoleMapping");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
            query.addJoin(join);
            Criteria criteria = new Criteria(new Column("ADMPUsersRoleMapping", "ADMP_ROLE_ID"), (Object)10000, 1);
            criteria = criteria.and(new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)1, 1));
            Column countColumn = new Column(null, "*");
            query.addSelectColumn(countColumn.count());
            query.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                i = (Integer)dataSet.getValue(1);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting Help desk user count");
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Hashtable> getTechnicianUsers(Long loginID) {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQuery query = TechnicianHandler.getQueryForTechnicians(loginID, false);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            logger.log(Level.INFO, "The selectQuery is " + relationalAPI.getSelectSQL((Query)query));
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            ArrayList<String> keys = new ArrayList<String>();
            while (dataSet.next()) {
                String key = dataSet.getValue("NAME").toString() + dataSet.getValue("DOMAINNAME").toString();
                if (keys.contains(key)) continue;
                keys.add(key);
                String domainName = (String)dataSet.getValue("DOMAINNAME");
                String domainDisplayName = domainName.equalsIgnoreCase("ADSelfService Plus Authentication") ? domainName : (String)dataSet.getValue("DOMAIN_DISPLAY_NAME");
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                hashtable.put("USER_ID", dataSet.getValue("USER_ID"));
                hashtable.put("LOGIN_ID", dataSet.getValue("LOGIN_ID"));
                hashtable.put("ADMP_ROLE_ID", dataSet.getValue("ADMP_ROLE_ID"));
                hashtable.put("NAME", dataSet.getValue("NAME"));
                hashtable.put("ADMP_ROLE_NAME", dataSet.getValue("ADMP_ROLE_NAME"));
                hashtable.put("DOMAINNAME", domainName);
                hashtable.put("DOMAIN_DISPLAY_NAME", domainDisplayName);
                list.add(hashtable);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting Help desk user details");
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRoleName(String loginName, String domainName) {
        Connection connection = null;
        DataSet dataSet = null;
        String roleName = null;
        try {
            Table baseTable = new Table("AaaLogin");
            Table joinTable = new Table("ADMPUsersRoleMapping");
            Criteria crit = new Criteria(new Column("AaaLogin", "NAME"), (Object)loginName, 0);
            crit = crit.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0));
            Join j = new Join(baseTable, joinTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            Join rolesJoin = new Join(joinTable, new Table("ADMPRoles"), new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("AaaLogin"));
            sq.addSelectColumn(new Column("ADMPRoles", "ADMP_ROLE_NAME"));
            sq.addJoin(j);
            sq.addJoin(rolesJoin);
            sq.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                roleName = (String)dataSet.getValue("ADMP_ROLE_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception dsE) {
                    dsE.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception conE) {
                    conE.printStackTrace();
                }
            }
        }
        return roleName;
    }

    public static SelectQuery getQueryForTechnicians(Long loginID, boolean excludeAdminUser) {
        Properties logonUserProps = null;
        SelectQueryImpl query = null;
        try {
            Table baseTable = new Table("AaaLogin");
            Table joinTable = new Table("AaaUser");
            query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2);
            query.addJoin(join);
            query.addSelectColumn(new Column("AaaLogin", "USER_ID"));
            query.addSelectColumn(new Column("AaaLogin", "LOGIN_ID"));
            query.addSelectColumn(new Column("AaaLogin", "NAME"));
            query.addSelectColumn(new Column("AaaLogin", "DOMAINNAME"));
            query.addSelectColumn(new Column("AaaUser", "FULL_NAME"));
            query.addSelectColumn(new Column("ADMPUsersRoleMapping", "ADMP_ROLE_ID"));
            query.addSelectColumn(new Column("ADMPRoles", "ADMP_ROLE_NAME"));
            query.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DISPLAY_NAME"));
            Table accountTable = new Table("AaaAccount");
            Table authTable = new Table("AaaAuthorizedRole");
            Table roleTable = new Table("AaaRole");
            Table admpUserRole = new Table("ADMPUsersRoleMapping");
            Table admpRoles = new Table("ADMPRoles");
            Join join1 = new Join(baseTable, accountTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            Join join2 = new Join(accountTable, authTable, new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 2);
            Join join3 = new Join(authTable, roleTable, new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 2);
            Join join4 = new Join(accountTable, admpUserRole, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            Join join5 = new Join(admpUserRole, admpRoles, new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2);
            Join joinDomainName = new Join(baseTable, Table.getTable((String)"ADSMDomainConfiguration"), new String[]{"DOMAINNAME"}, new String[]{"DOMAIN_NAME"}, 1);
            Criteria criteria = new Criteria(new Column("ADMPUsersRoleMapping", "ADMP_ROLE_ID"), (Object)10000L, 1);
            if (excludeAdminUser) {
                criteria = criteria.and(new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)1L, 1));
            } else if (!ADMPRoleHandler.isADSSPUser(loginID)) {
                logger.log(Level.INFO, "This is domain user...");
                logonUserProps = ADAuthHandler.getLoginUserDetails(loginID);
                String domainName = logonUserProps.getProperty("LOGIN_DOMAIN_NAME");
                logger.log(Level.INFO, "prop ::::: " + logonUserProps);
                criteria = criteria.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0));
            }
            query.addJoin(join1);
            query.addJoin(join2);
            query.addJoin(join3);
            query.addJoin(join4);
            query.addJoin(join5);
            query.addJoin(joinDomainName);
            query.setCriteria(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    public static JSONArray getExtendedActions(AdventNetResourceBundle rb) {
        JSONArray extendedActions = new JSONArray();
        try {
            String baseTable = "ADSSPOperations";
            SelectQueryImpl query = new SelectQueryImpl(new Table(baseTable));
            query.addSelectColumn(Column.getColumn((String)baseTable, (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ADSSPRolePermissions", (String)"*"));
            query.addJoin(new Join(baseTable, "ADSSPRolePermissions", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 1));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSSPOperations", (String)"ACTION_ID"), (Object)extendedActionIDs, 8));
            DataObject operVsPermsDO = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            DataObject roleDO = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", new Criteria(Column.getColumn((String)"ADMPRoles", (String)"ADMP_ROLE_ID"), (Object)10000, 1));
            Iterator roleIt = roleDO.getRows("ADMPRoles");
            while (roleIt.hasNext()) {
                Row roleRow = (Row)roleIt.next();
                Long roleID = (Long)roleRow.get("ADMP_ROLE_ID");
                JSONObject roleObj = new JSONObject();
                roleObj.put("ID", (Object)roleID);
                roleObj.put("NAME", (Object)((String)roleRow.get("ADMP_ROLE_NAME")));
                JSONArray actions = new JSONArray();
                for (Long actionID : extendedActionIDs) {
                    JSONObject actionObj = new JSONObject();
                    actionObj.put("ID", (Object)actionID);
                    Row actionRow = operVsPermsDO.getRow("ADSSPOperations", new Criteria(Column.getColumn((String)"ADSSPOperations", (String)"ACTION_ID"), (Object)actionID, 0));
                    String name = (String)actionRow.get("ACTION_NAME");
                    if (actionID == SQA_REPORT) {
                        name = "adssp.config.admin_tool.technician.permission.view_sqa_report";
                    }
                    actionObj.put("NAME", (Object)rb.getString(name));
                    boolean enabled = false;
                    Criteria permissionCrit = new Criteria(Column.getColumn((String)"ADSSPRolePermissions", (String)"ADMP_ROLE_ID"), (Object)roleID, 0);
                    permissionCrit = permissionCrit.and(new Criteria(Column.getColumn((String)"ADSSPRolePermissions", (String)"ACTION_ID"), (Object)actionID, 0));
                    if (operVsPermsDO.getRow("ADSSPRolePermissions", permissionCrit) != null) {
                        enabled = true;
                    }
                    actionObj.put("ENABLED", enabled);
                    actions.put((Object)actionObj);
                }
                roleObj.put("ACTIONS", (Object)actions);
                extendedActions.put((Object)roleObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return extendedActions;
    }

    public static boolean changePermission(Long roleID, Long actionID, boolean enable) {
        boolean success = false;
        try {
            if (Arrays.asList(extendedActionIDs).contains(actionID) && ADMPRoleHandler.isDefaultAdmin(AuthUtil.getUserCredential().getLoginId()).booleanValue()) {
                if (!enable) {
                    Criteria permissionCrit = new Criteria(Column.getColumn((String)"ADSSPRolePermissions", (String)"ADMP_ROLE_ID"), (Object)roleID, 0);
                    permissionCrit = permissionCrit.and(new Criteria(Column.getColumn((String)"ADSSPRolePermissions", (String)"ACTION_ID"), (Object)actionID, 0));
                    CommonUtil.getPersistence(new boolean[0]).delete(permissionCrit);
                } else {
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    Row r = new Row("ADSSPRolePermissions");
                    r.set("ADMP_ROLE_ID", (Object)roleID);
                    r.set("ACTION_ID", (Object)actionID);
                    obj.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(obj);
                }
                success = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public static void deleteTechnicianProperties(Long loginId) {
        SchedulerHandler.deleteTechnicianSchedulers(loginId);
    }
}

