/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADAuthHandler {
    private static Logger logger = Logger.getLogger(ADAuthHandler.class.getName());

    public static Properties getDomainDetails(String domainName, String columnName) {
        Properties properties = new Properties();
        try {
            Column column = new Column("ADSMDomainConfiguration", columnName);
            Criteria criteria = new Criteria(column, (Object)domainName, 0, false);
            DataObject dataObject = DataAccess.get((String)"ADSMDomainConfiguration", (Criteria)criteria);
            Row row = dataObject.getFirstRow("ADSMDomainConfiguration");
            String domainFlatName = (String)row.get("DOMAIN_FLAT_NAME");
            String domainDispName = (String)row.get("DOMAIN_NAME");
            Long domainControllerId = (Long)row.get("DOMAIN_CONTROLLER_ID");
            Column column2 = new Column("ADSMDCConfiguration", "DOMAIN_CONTROLLER_ID");
            Criteria criteria2 = new Criteria(column2, (Object)domainControllerId, 0);
            DataObject dataObject2 = DataAccess.get((String)"ADSMDCConfiguration", (Criteria)criteria2);
            Row row2 = dataObject2.getFirstRow("ADSMDCConfiguration");
            String serverName = (String)row2.get("DOMAIN_CONTROLLER_NAME");
            properties.setProperty("SERVER_NAME", serverName);
            properties.setProperty("DOMAIN_FLAT_NAME", domainFlatName);
            properties.setProperty("DOMAIN_NAME", domainDispName);
            properties.put("DEFAULT_NAMING_CONTEXT", row.get("DEFAULT_NAMING_CONTEXT"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static Properties getLoginUserDetails(Long loginID) {
        Properties properties = new Properties();
        try {
            Criteria criteria = new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)loginID, 0, false);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AaaLogin");
                properties.setProperty("LOGIN_NAME", row.get("NAME").toString());
                properties.setProperty("LOGIN_DOMAIN_NAME", row.get("DOMAINNAME").toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static DataObject getAccountDO(String loginName, String domainName, String serviceName) throws DataAccessException {
        logger.log(Level.FINEST, "fetching account dataobject for loginname : {0}, service : {1}", new Object[]{loginName, serviceName});
        DataObject accountDobj = null;
        SelectQueryImpl query = new SelectQueryImpl(new Table("AaaLogin"));
        query.addSelectColumn(new Column(null, "*"));
        query.addJoin(new Join("AaaLogin", "AaaUser", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
        query.addJoin(new Join("AaaUser", "AaaUserStatus", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2));
        query.addJoin(new Join("AaaUser", "AaaUserProfile", new String[]{"USER_ID"}, new String[]{"USER_ID"}, 1));
        query.addJoin(new Join("AaaLogin", "AaaAccount", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        query.addJoin(new Join("AaaAccount", "AaaAccountStatus", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
        query.addJoin(new Join("AaaAccount", "AaaAccBadLoginStatus", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
        query.addJoin(new Join("AaaAccount", "AaaAccAdminProfile", new String[]{"ACCOUNTPROFILE_ID"}, new String[]{"ACCOUNTPROFILE_ID"}, 1));
        query.addJoin(new Join("AaaAccount", "AaaService", new String[]{"SERVICE_ID"}, new String[]{"SERVICE_ID"}, 2));
        query.addJoin(new Join("AaaAccount", "AaaAccPassword", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
        query.addJoin(new Join("AaaAccPassword", "AaaPassword", new String[]{"PASSWORD_ID"}, new String[]{"PASSWORD_ID"}, 2));
        query.addJoin(new Join("AaaPassword", "AaaPasswordProfile", new String[]{"PASSWDPROFILE_ID"}, new String[]{"PASSWDPROFILE_ID"}, 1));
        query.addJoin(new Join("AaaPassword", "AaaPasswordStatus", new String[]{"PASSWORD_ID"}, new String[]{"PASSWORD_ID"}, 1));
        query.addJoin(new Join("AaaAccount", "AaaAuthorizedRole", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
        query.addJoin(new Join("AaaAuthorizedRole", "AaaRole", new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 1));
        Criteria criteria = new Criteria(new Column("AaaService", "NAME"), (Object)serviceName, 0, false);
        criteria = criteria.and(new Criteria(new Column("AaaLogin", "NAME"), (Object)loginName, 0, false));
        criteria = criteria.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0, false));
        query.setCriteria(criteria);
        try {
            accountDobj = DataAccess.get((SelectQuery)query);
            logger.log(Level.FINEST, "account data object fetched for login : {0} and service : {1} is : {2}", new Object[]{loginName, serviceName, accountDobj});
            if (!accountDobj.containsTable("AaaAccount")) {
                Criteria criteriaForSys = new Criteria(new Column("AaaService", "NAME"), (Object)"System", 0);
                criteriaForSys = criteriaForSys.and(new Criteria(new Column("AaaLogin", "NAME"), (Object)loginName, 0));
                criteriaForSys = criteriaForSys.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0));
                SelectQuery clonedQuery = (SelectQuery)query.clone();
                clonedQuery.setCriteria(criteriaForSys);
                accountDobj = DataAccess.get((SelectQuery)clonedQuery);
                logger.log(Level.FINEST, "account data object fetched for login : {0} and service : System is : {1}", new Object[]{loginName, accountDobj});
            }
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Exception occured while fetching account dataobject", e);
            throw new DataAccessException("Exception occured while fetching account dataobject", (Throwable)e);
        }
        return accountDobj;
    }

    public static Properties getLoginUserDetails(String upn) {
        Properties properties;
        block8: {
            properties = new Properties();
            String tableName = "ADSMUserGeneralDetails";
            try {
                Table baseTable = new Table(tableName);
                SelectQueryImpl query = new SelectQueryImpl(baseTable);
                Criteria criteria = new Criteria(new Column(tableName, "LOGON_NAME"), (Object)upn, 0);
                query.addSelectColumn(new Column(tableName, "SAM_ACCOUNT_NAME"));
                query.addSelectColumn(new Column(tableName, "OBJECT_GUID"));
                query.addSelectColumn(new Column(tableName, "DOMAIN_NAME"));
                query.setCriteria(criteria);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (!obj.isEmpty() && obj.size(tableName) < 2) {
                    Row r = obj.getFirstRow(tableName);
                    properties.put("DOMAIN_NAME", (String)r.get("DOMAIN_NAME"));
                    properties.put("SAM_ACCOUNT_NAME", (String)r.get("SAM_ACCOUNT_NAME"));
                    System.out.println("Properties(DB):" + properties);
                    break block8;
                }
                ArrayList<String> attributeList = new ArrayList<String>();
                ArrayList domainList = DomainHandler.getDomainList();
                for (Properties domain : domainList) {
                    Row r;
                    attributeList.add("sAMAccountName");
                    attributeList.add("objectGUID");
                    attributeList.add("userPrincipalName");
                    attributeList.add("distinguishedName");
                    attributeList.add("objectSid");
                    String searchString = "(&(objectClass=user)(objectCategory=person)(userPrincipalName=" + StrUtil.ldapEscape(upn) + "))";
                    Properties domainDetails = DomainHandler.getConfiguredValues((String)domain.get("DOMAIN_NAME"), new Long(1L));
                    ArrayList list = new ArrayList();
                    try {
                        list = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
                    }
                    catch (NativeException ne) {
                        ne.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (list.size() <= 0) continue;
                    Properties p = (Properties)list.get(0);
                    properties.put("DOMAIN_NAME", (String)domain.get("DOMAIN_NAME"));
                    properties.put("SAM_ACCOUNT_NAME", StrUtil.getString(p, "sAMAccountName"));
                    System.out.println("Properties(LDAP):" + properties);
                    Criteria crit = new Criteria(new Column(tableName, "OBJECT_GUID"), (Object)StrUtil.getString(p, "objectGUID"), 0);
                    DataObject object = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                    if (object.isEmpty()) {
                        r = new Row(tableName);
                        r.set("OBJECT_GUID", (Object)StrUtil.getString(p, "objectGUID"));
                        r.set("SAM_ACCOUNT_NAME", (Object)StrUtil.getString(p, "sAMAccountName"));
                        r.set("DOMAIN_NAME", (Object)((String)domain.get("DOMAIN_NAME")));
                        r.set("LOGON_NAME", (Object)StrUtil.getString(p, "userPrincipalName"));
                        r.set("SID_STRING", (Object)StrUtil.getString(p, "objectSid"));
                        r.set("DISTINGUISHED_NAME", (Object)StrUtil.getString(p, "distinguishedName"));
                        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                        dataObject.addRow(r);
                        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
                        continue;
                    }
                    r = object.getFirstRow(tableName);
                    r.set("SAM_ACCOUNT_NAME", (Object)StrUtil.getString(p, "sAMAccountName"));
                    r.set("DOMAIN_NAME", (Object)((String)domain.get("DOMAIN_NAME")));
                    r.set("LOGON_NAME", (Object)StrUtil.getString(p, "userPrincipalName"));
                    r.set("SID_STRING", (Object)StrUtil.getString(p, "objectSid"));
                    r.set("DISTINGUISHED_NAME", (Object)StrUtil.getString(p, "distinguishedName"));
                    object.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(object);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return properties;
    }
}

