/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.LicensedUsersHandler;
import com.adventnet.sym.adsm.common.server.util.CaptchaUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.iamapps.handler.sso.SSOSAMLHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import org.json.JSONException;
import org.json.JSONObject;

public class ADMPADAuthenticator
extends Authenticator {
    public static final String ADSSP_AUTHENTICATION = "ADSelfService Plus Authentication";
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public Boolean isSessionNeedToSet = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticate() throws LoginException {
        String loginStatus;
        boolean result;
        block52: {
            result = false;
            boolean isMultipleAccountsMatched = false;
            this.needAudit = true;
            this.auditType = this.session.getAttribute("NTLM") != null ? "adssp.reports.audit_report.user_attempts.type_sso_text" : "adssp.reports.audit_report.user_attempts.type_manual_login_text";
            loginStatus = null;
            this.errMsg = "";
            HttpSession session = this.request.getSession();
            try {
                Hashtable names;
                Boolean isOtherLoginAttrEnabled = false;
                if (ADSMPersUtil.getSyMParameter("otherLoginAttributes").equals("true")) {
                    isOtherLoginAttrEnabled = true;
                }
                String serverName = null;
                if (this.sessionHash == null) {
                    this.sessionHash = new Hashtable();
                }
                this.domainName = this.request.getParameter("domainName");
                if (this.domainName != null && !"".equals(this.domainName) && !this.domainName.equalsIgnoreCase(ADSSP_AUTHENTICATION)) {
                    this.domainName = DomainHandler.getDomainDetails(this.domainName).optString("DOMAIN_NAME", null);
                }
                String sso = ADSMPersUtil.getSyMParameter("SingleSignOn");
                String ajaxLogin = this.request.getParameter("ajaxLogin");
                if ("true".equalsIgnoreCase(ajaxLogin)) {
                    session.setAttribute("ajaxLogin", (Object)ajaxLogin);
                } else {
                    session.removeAttribute("ajaxLogin");
                }
                if ("true".equalsIgnoreCase(sso) && "success".equals(session.getAttribute("NTLM")) && !ADSSP_AUTHENTICATION.equals(this.domainName)) {
                    String ntlmAuthDom = (String)session.getAttribute("NTLM_DOMAIN");
                    this.loginName = (String)session.getAttribute("NTLM_USER");
                    Properties properties = ADAuthHandler.getDomainDetails(ntlmAuthDom, "DOMAIN_FLAT_NAME");
                    serverName = properties.getProperty("SERVER_NAME");
                    this.domainName = properties.getProperty("DOMAIN_NAME");
                }
                Long policyId = new Long(-1L);
                if (this.domainName == null || "".equals(this.domainName) || !this.domainName.equalsIgnoreCase(ADSSP_AUTHENTICATION) && isOtherLoginAttrEnabled.booleanValue()) {
                    names = UserUtil.getUserNameAndDomainName(this.loginName, this.domainName);
                    this.loginName = (String)names.get("userName");
                    this.domainName = (String)names.get("domainName");
                    Properties userProp = (Properties)names.get("userProp");
                    if (userProp != null) {
                        isMultipleAccountsMatched = (Boolean)userProp.get("multipleAccountsMatched");
                    }
                    if (this.domainName == "") throw new LoginException("adssp.login.common.error.no_such_account_for_choosen_domain");
                    if (this.domainName == null) {
                        throw new LoginException("adssp.login.common.error.no_such_account_for_choosen_domain");
                    }
                    if (isMultipleAccountsMatched) {
                        throw new LoginException("adssp.login.common.error.multiple_accounts_matched");
                    }
                }
                if (!"true".equalsIgnoreCase(sso) || !"success".equals(session.getAttribute("NTLM"))) {
                    if (!this.domainName.equals(ADSSP_AUTHENTICATION)) {
                        if ((this.loginName.indexOf("\\") != -1 || this.loginName.indexOf("@") != -1) && (names = UserUtil.getLogonNameFromUPN(this.loginName)).get("userName") != "" && names.get("domainName") != "") {
                            this.loginName = (String)names.get("userName");
                            this.domainName = (String)names.get("domainName");
                        }
                        serverName = ADAuthHandler.getDomainDetails(this.domainName, "DOMAIN_NAME").getProperty("SERVER_NAME");
                    }
                    CaptchaUtil.verifyCaptchaOnLogin(this.loginName, this.domainName, this.request);
                }
                if (this.domainName.equals(ADSSP_AUTHENTICATION)) {
                    logger.log(Level.FINEST, "authenticate invoked with loginName and password");
                    Row passwordRow = null;
                    try {
                        this.accountDO = ADAuthHandler.getAccountDO(this.loginName, ADSSP_AUTHENTICATION, this.serviceName);
                        if (this.accountDO == null) {
                            throw new PAMException("adssp.login.common.error.dataobject_null");
                        }
                        if (!this.accountDO.containsTable("AaaAccount")) {
                            throw new LoginException("adssp.login.common.error.no_such_account_for_choosen_domain");
                        }
                        if (!this.accountDO.containsTable("AaaPassword")) {
                            throw new LoginException("adssp.login.common.error.no_password_configured");
                        }
                        passwordRow = this.accountDO.getFirstRow("AaaPassword");
                    }
                    catch (DataAccessException dae) {
                        throw new PAMException("adssp.login.common.error.dataaccess_exception", (Exception)((Object)dae));
                    }
                    String passwordFromDb = (String)passwordRow.get("PASSWORD");
                    String salt = (String)passwordRow.get("SALT");
                    String algorithm = (String)passwordRow.get("ALGORITHM");
                    if (algorithm == null) throw new PAMException("adssp.login.common.error.unknown_algorithm");
                    if (!algorithm.equals("MD5")) {
                        throw new PAMException("adssp.login.common.error.unknown_algorithm");
                    }
                    String encPassword = AuthUtil.getEncryptedPassword((String)this.password, (String)salt);
                    logger.log(Level.FINEST, "comparing encrypted passwords : {0} , {1}", new Object[]{passwordFromDb, encPassword});
                    result = passwordFromDb.equals(encPassword);
                    if (!result) {
                        loginStatus = "fail";
                        throw new LoginException("adssp.login.common.error.invalid_login");
                    }
                    if (this.request.getSession().getAttribute("SAML_SSO_LOGIN") != null) {
                        this.request.getSession().removeAttribute("SAML_SSO_LOGIN");
                        this.auditType = "adssp.reports.audit_report.user_attempts.type_saml_sso_login";
                        throw new LoginException("adssp.login.common.error.sso_login_permission_denied");
                    }
                    loginStatus = "success";
                    policyId = new Long(1L);
                } else {
                    String isSSLEnabled = ADSMPersUtil.checkLDAPSSL();
                    if ("true".equalsIgnoreCase(sso) && "success".equals(session.getAttribute("NTLM"))) {
                        session.setAttribute("isAuthenticatedViaSSO", (Object)"true");
                        result = true;
                        session.removeAttribute("NTLM");
                    } else {
                        result = "true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter("SINGLE_LOGIN")) ? false : ADHandler.DomainUserSSPLogonAuth(serverName, this.domainName, this.loginName, this.password, isSSLEnabled);
                    }
                    logger.log(Level.INFO, "Authentication Result for User {0} is {1}.", new Object[]{this.loginName, result});
                    String auth = null;
                    String status = null;
                    if (!result) {
                        Properties statusProp = ADHandler.DomainUserADAuth(serverName, this.domainName, this.loginName, this.password, isSSLEnabled);
                        auth = statusProp.getProperty("IsAuthenticated");
                        status = statusProp.getProperty("Status");
                        if (status == null) {
                            status = statusProp.getProperty("Bind_Error");
                        }
                        boolean bl = result = auth != null && !auth.equalsIgnoreCase("false");
                        if (!result) {
                            String string;
                            loginStatus = "fail";
                            if (status == null) {
                                string = "adssp.login.common.error.invalid_login";
                                throw new LoginException(string);
                            }
                            string = ADMPADAuthenticator.getLoginStatusMsg(status);
                            throw new LoginException(string);
                        }
                    }
                    loginStatus = "success";
                    try {
                        Hashtable polPermission = ADMPADAuthenticator.isValidDomainUser(this.loginName, this.domainName);
                        policyId = (Long)polPermission.get("policyId");
                        if (this.request.getSession().getAttribute("SAML_SSO_LOGIN") != null) {
                            String appConfigId = (String)this.request.getSession().getAttribute("APP_CONFIG_ID");
                            Boolean isInvalidPolicy = policyId != null ? !SSOSAMLHandler.isSSOModuleEnabledForPolicy((Long)policyId, (String)appConfigId) : true;
                            if (isInvalidPolicy.booleanValue()) {
                                this.request.getSession().removeAttribute("SAML_SSO_LOGIN");
                                this.auditType = "adssp.reports.audit_report.user_attempts.type_saml_sso_login";
                                throw new LoginException("adssp.login.common.error.sso_login_permission_denied");
                            }
                        }
                        this.loginName = (String)polPermission.get("samAccountName");
                        this.sessionHash.put("USER_DN", (String)polPermission.get("distinguishedName"));
                        this.sessionHash.put("userGroups", polPermission.get("userGroups"));
                        if (!this.isSessionNeedToSet.booleanValue()) {
                            this.request.setAttribute("POLICY_ID", (Object)policyId);
                        }
                    }
                    catch (LoginException e) {
                        throw new LoginException(e.getMessage());
                    }
                    catch (Exception e) {
                        this.errMsg = e.getMessage();
                        this.errMsg = this.errMsg == null ? "adssp.login.common.error.invalid_login" : this.errMsg;
                        throw new LoginException(this.errMsg);
                    }
                    if (result && status != null && (status.equals("adssp.error.native.user_must_change_pwd") || status.equals("adssp.error.native.user_pwd_expired"))) {
                        if (this.domainName.equals(ADSSP_AUTHENTICATION)) throw new LoginException("adssp.login.common.error.must_change_pwd");
                        if ("true".equals(session.getAttribute("isAuthenticatedViaSSO"))) throw new LoginException("adssp.login.common.error.must_change_pwd");
                        Long loginId = ADMPUserHandler.getLoginId(this.loginName, this.domainName);
                        PPEHandler.updatePasswordHistory(loginId, this.password, policyId);
                        throw new LoginException("adssp.login.common.error.must_change_pwd");
                    }
                    this.accountDO = ADAuthHandler.getAccountDO(this.loginName, this.domainName, this.serviceName);
                    if (this.accountDO == null || this.accountDO.isEmpty()) {
                        try {
                            ADMPUserHandler.addDomainUser(this.loginName, this.domainName);
                            this.accountDO = ADAuthHandler.getAccountDO(this.loginName, this.domainName, this.serviceName);
                        }
                        catch (ADSSPException sspEx) {
                            this.errMsg = sspEx.getMessage();
                            throw new LoginException(sspEx.getMessage(this.request));
                        }
                        catch (Exception e) {
                            throw new LoginException(e.getMessage());
                        }
                    }
                }
                if (this.isSessionNeedToSet.booleanValue()) {
                    session.setAttribute("DOMAIN_NAME", (Object)this.domainName);
                    this.setSessionAttributes(this.accountDO, session, rb, this.sessionHash, policyId);
                }
                if (loginStatus == null) break block52;
            }
            catch (LoginException loginException) {
                this.request.setAttribute("LOGIN_NAME", (Object)this.loginName);
                this.request.setAttribute("DOMAIN_NAME", (Object)this.domainName);
                if (this.errMsg != null) {
                    if (!"".equals(this.errMsg)) throw new LoginException(loginException.getMessage());
                }
                this.errMsg = loginException.getMessage();
                throw new LoginException(loginException.getMessage());
                catch (Exception e) {
                    this.errMsg = e.getMessage();
                    e.printStackTrace();
                    return result;
                }
            }
            CaptchaUtil.updateLoginStatus(this.loginName, this.domainName, this.request, loginStatus);
        }
        if (!this.needAudit) return result;
        if (!this.isAPIAuthentication) return result;
        int status = 0;
        if ("".equals(this.errMsg) || Arrays.asList(POST_PROCESS_EXCEPTIONS).contains(this.errMsg)) {
            status = 1;
        }
        AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg, status);
        this.needAudit = false;
        return result;
        finally {
            if (loginStatus != null) {
                CaptchaUtil.updateLoginStatus(this.loginName, this.domainName, this.request, loginStatus);
            }
            if (this.needAudit && this.isAPIAuthentication) {
                status = 0;
                if ("".equals(this.errMsg) || Arrays.asList(POST_PROCESS_EXCEPTIONS).contains(this.errMsg)) {
                    status = 1;
                }
                AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg, status);
                this.needAudit = false;
            }
        }
    }

    private static JSONObject getUserLoginDetails(String loginName, String domainName) throws LoginException {
        boolean isMultipleAccountsMatched = false;
        Boolean isOtherLoginAttrEnabled = false;
        if (ADSMPersUtil.getSyMParameter("otherLoginAttributes").equals("true")) {
            isOtherLoginAttrEnabled = true;
        }
        String serverName = ADAuthHandler.getDomainDetails(domainName, "DOMAIN_NAME").getProperty("SERVER_NAME");
        if (isOtherLoginAttrEnabled.booleanValue()) {
            Properties multiLoginProp = ADMPADAuthenticator.multiLoginProcessor(loginName, domainName, isOtherLoginAttrEnabled);
            loginName = (String)multiLoginProp.get("loginName");
            domainName = (String)multiLoginProp.get("domainName");
            isMultipleAccountsMatched = (Boolean)multiLoginProp.get("isMultipleAccountsMatched");
            serverName = (String)multiLoginProp.get("serverName");
            if (isMultipleAccountsMatched) {
                throw new LoginException("adssp.login.common.error.multiple_accounts_matched");
            }
        }
        JSONObject object = new JSONObject();
        try {
            object.put("loginName", (Object)loginName);
            object.put("domainName", (Object)domainName);
            object.put("serverName", (Object)serverName);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return object;
    }

    public static String getLoginStatusMsg(String key) {
        String val = "";
        if (key.equals("adssp.error.native.invalid_login")) {
            val = "adssp.login.common.error.invalid_login";
        }
        val = key.equals("adssp.error.native.user_account_locked") ? "adssp.login.common.error.acc_has_locked" : (key.equals("adssp.error.native.user_account_expired") ? "adssp.login.common.error.acc_has_expired" : (key.equals("adssp.error.native.user_account_disabled") ? "adssp.login.common.error.acc_has_disabled" : (key.equals("adssp.error.native.user_logon_hrs_restricted") ? "adssp.login.common.error.acc_has_restricted" : (key.equals("adssp.error.native.user_pwd_expired") ? "adssp.login.common.error.pwd_expired" : (key.equals("adssp.login.common.error.multiple_accounts_matched") ? "adssp.login.common.error.multiple_accounts_matched" : (key.equals("adssp.native.err.old_pwd_wrong_or_domainsettings_wrong") ? "adssp.custom.error.text_service_acc_expired" : (key.equals("adssp.error.native.domainutil.servers_not_operational") ? "adssp.custom.error.text.servers_not_operational" : "adssp.login.common.error.invalid_login")))))));
        return val;
    }

    public void setSessionAttributes(DataObject accountDO, HttpSession session, AdventNetResourceBundle rb, Hashtable sessionHash, Long policyId, String domainName) {
        this.domainName = domainName;
        this.setSessionAttributes(accountDO, session, rb, sessionHash, policyId);
    }

    @Override
    public void setSessionAttributes(DataObject accountDO, HttpSession session, AdventNetResourceBundle rb, Hashtable sessionHash, Long policyId) {
        try {
            Row row = accountDO.getRow("AaaLogin");
            Long loginId = (Long)row.get("LOGIN_ID");
            session.setAttribute("ADMP_SESSION_LOGIN_ID", (Object)loginId);
            session.setAttribute("POLICY_ID", (Object)policyId);
            session.setAttribute("licenseMessage", (Object)"false");
            session.setAttribute("CUSTOM_DATE_FORMAT", (Object)TimeZoneUtil.getCustomDateFormat(loginId, this.request));
            Enumeration e = sessionHash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                session.setAttribute(key, sessionHash.get(key));
            }
            session.setAttribute("ADMP_AAA_DETAILS", (Object)ADMPRoleHandler.getAAADetailsForSU(row, rb, policyId, session));
            ADMPUserHandler.validateUserPersonalDetails(loginId);
            if (!ADSSP_AUTHENTICATION.equals(this.domainName) && !"true".equals(session.getAttribute("isAuthenticatedViaSSO"))) {
                session.removeAttribute("isAuthenticatedViaSSO");
                PPEHandler.updatePasswordHistory(loginId, this.password, policyId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable isValidDomainUser(String loginName, String domainName) throws LoginException {
        Hashtable polPermission = null;
        try {
            ArrayList<String> attributes = new ArrayList<String>(Arrays.asList("samAccountName", "distinguishedName", "objectGUID", "memberOf", "primaryGroupID", "objectSID", "displayName", "name"));
            attributes.addAll(SecondaryAttributesHandler.getAttributes(domainName, "MAIL"));
            attributes.addAll(SecondaryAttributesHandler.getAttributes(domainName, "MOBILE"));
            Properties userPro = UserUtil.getUserObjectDetails(loginName, domainName, attributes.toArray(new String[attributes.size()]), true);
            String userDN = ((String)((ArrayList)userPro.get("distinguishedName")).get(0)).toLowerCase();
            String objGUID = (String)((ArrayList)userPro.get("objectGUID")).get(0);
            String samAccountName = (String)((ArrayList)userPro.get("samAccountName")).get(0);
            ArrayList userGroups = (ArrayList)userPro.get("memberOf");
            String primaryGroup = GroupUtil.getPrimaryGroup(domainName, (String)((ArrayList)userPro.get("primaryGroupID")).get(0));
            if (primaryGroup != null) {
                userGroups.add(primaryGroup);
            }
            polPermission = PolicyHandler.checkUserPermission(domainName, userDN, userGroups);
            boolean isUserDNPermitted = (Boolean)polPermission.get("status");
            boolean isUserRestrict = PolicyHandler.isUserRestricted(objGUID);
            boolean isTechUser = LicensedUsersHandler.isTechnicanUser(loginName, domainName) != null;
            logger.log(Level.INFO, "IsUserDNPermittedInPolicy : " + isUserDNPermitted + ", IsUserRestricted : " + isUserRestrict + ", userDN : " + userDN + ", isTechUser : " + isTechUser + ", userGoups : " + userGroups + ", Policy Id for the user  " + polPermission.get("policyId"));
            if (!isUserDNPermitted && !isTechUser) {
                throw new LoginException("adssp.login.common.error.permission_denied");
            }
            if (isUserRestrict) {
                throw new LoginException("adssp.login.common.error.permission_denied_restrict");
            }
            polPermission.put("distinguishedName", userDN);
            polPermission.put("objectGUID", objGUID);
            polPermission.put("samAccountName", samAccountName);
            if (userGroups != null && !userGroups.isEmpty()) {
                polPermission.put("userGroups", userGroups);
            }
        }
        catch (LoginException e) {
            throw new LoginException(e.getMessage());
        }
        return polPermission;
    }

    private static Properties multiLoginProcessor(String loginName, String domainName, Boolean isOtherLoginAttrEnabled) {
        Properties userPro = UserUtil.getUserObjectDetails(loginName, domainName, new String[]{"distinguishedName", "memberOf", "primaryGroupID", "objectSID", "objectGUID", "samAccountName"}, (Boolean)true, isOtherLoginAttrEnabled);
        Boolean isMultipleAccountsMatched = false;
        if (userPro != null && userPro.size() > 0) {
            if (userPro.containsKey("samAccountName")) {
                loginName = (String)((ArrayList)userPro.get("samAccountName")).get(0);
            }
            if (userPro.containsKey("domainName")) {
                domainName = (String)userPro.get("domainName");
            }
            if (userPro.containsKey("multipleAccountsMatched")) {
                isMultipleAccountsMatched = (Boolean)userPro.get("multipleAccountsMatched");
            }
        }
        Properties properties = ADAuthHandler.getDomainDetails(domainName, "DOMAIN_NAME");
        String serverName = properties.getProperty("SERVER_NAME");
        Properties multiLoginProp = new Properties();
        multiLoginProp.put("loginName", loginName);
        multiLoginProp.put("domainName", domainName);
        multiLoginProp.put("isMultipleAccountsMatched", isMultipleAccountsMatched);
        multiLoginProp.put("serverName", serverName);
        return multiLoginProp;
    }
}

