/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.LayoutHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TechnicianUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADMPRoleHandler {
    private static Logger logger = Logger.getLogger(ADMPRoleHandler.class.getName());
    public static DataObject defaultAdminDO = null;
    public static final int SELF_SERVICE_TAB = 27;

    public static boolean isRoleExists(String roleName) {
        boolean isExists = true;
        try {
            Criteria criteria = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_NAME"), (Object)roleName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", criteria);
            if (dataObject.isEmpty()) {
                isExists = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isExists;
    }

    public static void saveADMPRole(String name, String desc, String[] actions, String[] userActions) {
        UniqueValueHolder uniqueValueHolder = null;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("ADMPRoles");
            row.set("ADMP_ROLE_NAME", (Object)name);
            row.set("ADMP_ROLE_DESCRIPTION", (Object)desc);
            row.set("CREATION_TIME", (Object)System.currentTimeMillis());
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            uniqueValueHolder = (UniqueValueHolder)row.get("ADMP_ROLE_ID");
            dataObject.addRow(row);
            ADMPRoleHandler.updateDO(dataObject, (Object)uniqueValueHolder, actions);
            ADMPRoleHandler.updateDO(dataObject, (Object)uniqueValueHolder, userActions);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getADMPRoles() {
        ArrayList arrayList = new ArrayList();
        try {
            Criteria criteria = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_ID"), (Object)10000, 1);
            DataObject rolesDO = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", criteria);
            DataObject loginDO = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", (Row)null);
            Iterator iterator = rolesDO.getRows("ADMPRoles");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                Long roleID = (Long)row.get("ADMP_ROLE_ID");
                hashtable.put("ADMP_ROLE_ID", roleID);
                hashtable.put("ADMP_ROLE_NAME", row.get("ADMP_ROLE_NAME"));
                arrayList.add(hashtable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static boolean checkTerminalService(String[] actionIds) {
        boolean checkTerminal = false;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRolePermissions", new Criteria(new Column("ADMPRolePermissions", "ACTION_ID"), (Object)actionIds, 8));
            if (!dataObject.isEmpty()) {
                checkTerminal = true;
            }
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
        return checkTerminal;
    }

    public static void updateADMPRole(Long roleID, String name, String desc, String[] actions, String[] userActions) {
        try {
            Criteria criteria = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_ID"), (Object)roleID, 0);
            DataObject updateDataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", criteria);
            Row row = updateDataObject.getRow("ADMPRoles");
            row.set("ADMP_ROLE_NAME", (Object)name);
            row.set("ADMP_ROLE_DESCRIPTION", (Object)desc);
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            updateDataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(updateDataObject);
            DataObject addDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria deleteCriteria = new Criteria(new Column("ADMPRolePermissions", "ADMP_ROLE_ID"), (Object)roleID, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(deleteCriteria);
            ADMPRoleHandler.updateDO(addDataObject, (Object)roleID, actions);
            ADMPRoleHandler.updateDO(addDataObject, (Object)roleID, userActions);
            CommonUtil.getPersistence(new boolean[0]).add(addDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void updateDO(DataObject obj, Object roleID, String[] actions) {
        if (actions == null) {
            return;
        }
        for (String str : actions) {
            try {
                Row row2 = new Row("ADMPRolePermissions");
                row2.set("ADMP_ROLE_ID", roleID);
                row2.set("ACTION_ID", (Object)new Long(Long.parseLong(str)));
                obj.addRow(row2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void updateDO(DataObject obj, Object roleID, String moveFolderId) {
        try {
            Row row2 = new Row("ADMPRolePermissions");
            row2.set("ADMP_ROLE_ID", roleID);
            row2.set("ACTION_ID", (Object)new Long(Long.parseLong(moveFolderId)));
            obj.addRow(row2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteADMPRole(Long roleID) {
        try {
            Criteria criteria = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_ID"), (Object)roleID, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getRoleDetails(Long roleID) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            Criteria criteria = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_ID"), (Object)roleID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("ADMPRoles");
                hashtable.put("ADMP_ROLE_ID", row.get("ADMP_ROLE_ID"));
                hashtable.put("ADMP_ROLE_NAME", row.get("ADMP_ROLE_NAME"));
                hashtable.put("ADMP_ROLE_DESCRIPTION", row.get("ADMP_ROLE_DESCRIPTION"));
                hashtable.put("ADMP_ROLE_ACTIONS", ADMPRoleHandler.getRoleActionsObj(roleID));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashtable;
    }

    public static Hashtable getActionID(Long policyId) {
        Hashtable<String, DataObject> hashtable = new Hashtable<String, DataObject>();
        try {
            Criteria criteria = new Criteria(new Column("UpdatePermissions", "POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("UpdatePermissions", criteria);
            if (!dataObject.isEmpty()) {
                hashtable.put("ADMP_ROLE_ACTIONS", dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashtable;
    }

    public static DataObject getRoleActionsObj(Long roleID) {
        DataObject dataObject = null;
        try {
            Criteria criteria = new Criteria(new Column("ADMPRolePermissions", "ADMP_ROLE_ID"), (Object)roleID, 0);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRolePermissions", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    public static ArrayList<Long> getRoleActions(Long roleID) {
        ArrayList<Long> methodsList = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(new Column("ADMPRolePermissions", "ADMP_ROLE_ID"), (Object)roleID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRolePermissions", criteria);
            Iterator iterator = dataObject.getRows("ADMPRolePermissions");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                methodsList.add((Long)row.get("ACTION_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return methodsList;
    }

    public static Long getRoleIdForUser(Long loginId) {
        Long roleId = 1L;
        try {
            Criteria criteria = new Criteria(new Column("ADMPUsersRoleMapping", "LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersRoleMapping", criteria);
            Row row = dataObject.getRow("ADMPUsersRoleMapping");
            roleId = (Long)row.get("ADMP_ROLE_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return roleId;
    }

    public static ArrayList<Properties> getTabsForRole(Long loginId) {
        return ADMPRoleHandler.getTabsForRole(loginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Properties> getTabsForRole(Long loginId, Long policyId) {
        ArrayList tabList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String domainName = DomainHandler.getDomainName(loginId, "LOGIN_ID");
            Table table = new Table("ADMPTotalTabs");
            Table joinTable = new Table("ADSSPRolePermissions");
            Table userRolesTable = new Table("ADMPUsersRoleMapping");
            Join join = new Join(table, joinTable, new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2);
            Join roleJoin = new Join(joinTable, userRolesTable, new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Column idColumn = new Column("ADMPUsersRoleMapping", "LOGIN_ID");
            Column tabsPriorityColumn = new Column("ADMPTotalTabs", "PRIORITY_ID");
            Criteria criteria = new Criteria(idColumn, (Object)loginId, 0);
            if (domainName == null || domainName.equals("ADSelfService Plus Authentication") || policyId == null || policyId == -1L) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADMPTotalTabs", (String)"ACTION_ID"), (Object)27, 1));
            }
            query.setCriteria(criteria);
            query.addJoin(join);
            query.addJoin(roleJoin);
            query.addSelectColumn(idColumn);
            query.addSelectColumn(new Column("ADMPTotalTabs", "TAB_ID"));
            query.addSelectColumn(tabsPriorityColumn);
            query.addSelectColumn(new Column("ADMPTotalTabs", "TAB_DISPLAY_NAME"));
            query.addSelectColumn(new Column("ADMPTotalTabs", "TAB_URL"));
            query.addSortColumn(new SortColumn(tabsPriorityColumn, true));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Properties properties = new Properties();
                properties.setProperty("displayName", dataSet.getValue("TAB_DISPLAY_NAME").toString());
                properties.setProperty("id", dataSet.getValue("TAB_ID").toString());
                properties.setProperty("url", dataSet.getValue("TAB_URL").toString());
                tabList.add(properties);
            }
            tabList = LicenseUtil.arrangeTabs(tabList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return tabList;
    }

    public static boolean isADSSPUser(Long loginId) {
        try {
            logger.log(Level.INFO, "isADSSPUser Called , loginId is " + loginId);
            Criteria criteria = new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)loginId, 0);
            criteria = criteria.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)"ADSelfService Plus Authentication", 0));
            DataObject dbobj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", criteria);
            if (!dbobj.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "It is not adssp user");
        return false;
    }

    public static boolean isAdminUser(Long loginId) {
        ArrayList adsspRoles = TechnicianUtil.getRolesForId(loginId);
        return adsspRoles.contains("Super Admin");
    }

    public static Hashtable getAAADetails(Long loginID) {
        Hashtable hash = null;
        try {
            Criteria criteria = new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)loginID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", criteria);
            Row row = dataObject.getRow("AaaLogin");
            hash = ADMPRoleHandler.getAAADetails(row, new Long(-1L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Hashtable getAAADetails(Row row, Long policyId) {
        Hashtable<String, Object> aaaDetails = new Hashtable<String, Object>();
        try {
            Long loginId = (Long)row.get("LOGIN_ID");
            ArrayList adsspRoles = TechnicianUtil.getRolesForId((Long)row.get("LOGIN_ID"));
            ArrayList<Hashtable> actionList = new ArrayList<Hashtable>();
            ArrayList<Properties> tabList = ADMPRoleHandler.getTabsForRole(loginId, policyId);
            Boolean isDomainUserTechnician = ADMPUserHandler.isDomainUserTechnician(loginId);
            Long[] ids = null;
            if (adsspRoles.contains("SelfService Portal") || isDomainUserTechnician.booleanValue()) {
                ids = ADMPRoleHandler.getActions(policyId, actionList, "UpdatePermissions", "POLICY_ID");
            }
            ArrayList<Long> actionIdsForRole = TechnicianUtil.getRoleMappedActionIDs(loginId);
            aaaDetails.put("AVAILABLE_TABS", tabList);
            aaaDetails.put("AVAILABLE_ACTIONS", actionList);
            aaaDetails.put("ACTION_TEXT", ids);
            aaaDetails.put("ACTION_IDS_OF_USER", actionIdsForRole);
            aaaDetails.put("OUs", new ArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aaaDetails;
    }

    public static Hashtable getAAADetailsForSU(Row row, AdventNetResourceBundle rb, Long policyId, HttpSession session) {
        Hashtable<String, Object> aaaDetails = new Hashtable<String, Object>();
        try {
            Long loginId = (Long)row.get("LOGIN_ID");
            ArrayList adsspRoles = TechnicianUtil.getRolesForId((Long)row.get("LOGIN_ID"));
            ArrayList actionList = new ArrayList();
            ArrayList<Properties> tabList = ADMPRoleHandler.getTabsForRole(loginId, policyId);
            Hashtable layoutDetails = new Hashtable();
            Long[] ids = null;
            Boolean isDomainUserTechnician = ADMPUserHandler.isDomainUserTechnician(loginId);
            ArrayList<String> list = new ArrayList<String>();
            boolean forceUpdate = false;
            if (adsspRoles.contains("SelfService Portal") || isDomainUserTechnician.booleanValue()) {
                Long layoutId = LayoutHandler.getLayoutID(policyId);
                if (layoutId == 0L) {
                    return ADMPRoleHandler.getAAADetails(row, policyId);
                }
                HashMap<String, Object> layoutProps = new HashMap<String, Object>();
                layoutProps.put("LAYOUT_ID", layoutId);
                layoutProps.put("ADMIN_VIEW", false);
                layoutProps.put("RESOURCE_BUNDLE", rb);
                layoutProps.put("DOMAIN_NAME", session.getAttribute("DOMAIN_NAME"));
                layoutProps.put("LOGIN_ID", loginId);
                layoutDetails = LayoutHandler.getLayoutDetails(layoutProps);
                ArrayList acList = (ArrayList)layoutDetails.get("actionList");
                JSONObject json = new JSONObject((String)layoutDetails.get("nonCustomFields"));
                forceUpdate = json.has(Integer.valueOf(1958).toString());
                ids = new Long[acList.size()];
                for (int i = 0; i < acList.size(); ++i) {
                    ids[i] = (Long)acList.get(i);
                }
                aaaDetails.put("ACTION_TEXT", ids);
                ArrayList<Hashtable> attribList = AddUserHandler.getInstance().getAttributeDetailsForActionIds((ArrayList)layoutDetails.get("mandatoryAttribs"));
                for (Hashtable hashtable : attribList) {
                    String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    list.add(ldapName);
                }
            }
            ArrayList<Long> actionIdsForUser = TechnicianUtil.getRoleMappedActionIDs(loginId);
            aaaDetails.put("AVAILABLE_TABS", tabList);
            aaaDetails.put("AVAILABLE_ACTIONS", actionList);
            aaaDetails.put("LAYOUTDETAILS", layoutDetails);
            aaaDetails.put("ACTION_IDS_OF_USER", actionIdsForUser);
            aaaDetails.put("OUs", new ArrayList());
            aaaDetails.put("MANDATORY_FIELDS", list);
            aaaDetails.put("IS_FORCE_UPDATE_ENABLED", forceUpdate);
            if (session != null) {
                String forceSelfUpdate = "false";
                String userDN = (String)session.getAttribute("USER_DN");
                if (forceUpdate) {
                    String domainName = DomainHandler.getDomainName(loginId, "LOGIN_ID");
                    Properties userDetails = ADHandler.getObjectProperties(domainName, 1L, userDN, list);
                    for (Object e : list) {
                        ArrayList vlist = (ArrayList)userDetails.get((String)e);
                        if (vlist != null) continue;
                        forceSelfUpdate = "true";
                        break;
                    }
                }
                session.setAttribute("FORCE_UPDATE", (Object)forceSelfUpdate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aaaDetails;
    }

    public static Long[] getModifyIds(Long roleId, Integer[] bets) {
        Long[] ids = null;
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Criteria criteria = new Criteria(new Column("ADMPRolePermissions", "ADMP_ROLE_ID"), (Object)roleId, 0);
            criteria = criteria.and(new Criteria(new Column("ADMPRolePermissions", "ACTION_ID"), (Object)bets, 14));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPRolePermissions", criteria);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADMPRolePermissions");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long id = (Long)r.get("ACTION_ID");
                    list.add(id);
                }
            }
            ids = list.toArray(new Long[list.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

    public static Long[] getActions(Long policyId, ArrayList<Hashtable> methodDetailsList, String tableName, String columnName) {
        Long[] ret = new Long[]{};
        try {
            Criteria criteria = new Criteria(new Column(tableName, columnName), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (!dataObject.isEmpty()) {
                ArrayList<Object> list = new ArrayList<Object>();
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                    hashtable.put("ACTION_ID", row.get("ACTION_ID"));
                    methodDetailsList.add(hashtable);
                    list.add(row.get("ACTION_ID"));
                }
                ret = new Long[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    ret[i] = (Long)list.get(i);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static int noOfHelpDesk() {
        int count = -1;
        try {
            Criteria criteria = new Criteria(new Column("ADMPUsersRoleMapping", "ADMP_ROLE_ID"), (Object)10000, 1);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersRoleMapping", criteria);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADMPUsersRoleMapping");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long id = (Long)r.get("ADMP_ROLE_ID");
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    public static ArrayList getSelectedParentIds(Long policyId) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(new Column("UpdatePermissions", "ACTION_ID"), (Object)1900, 4);
            crit = crit.and(new Criteria(new Column("UpdatePermissions", "ACTION_ID"), (Object)1920, 6));
            crit = crit.and(new Criteria(new Column("UpdatePermissions", "POLICY_ID"), (Object)policyId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("UpdatePermissions", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("UpdatePermissions");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long actionId = (Long)r.get("ACTION_ID");
                    if (list.contains(actionId)) continue;
                    list.add(actionId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getSubIds(Long parentId) {
        ArrayList<Long> actionList = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(new Column("ADMPActionDetails", "PARENT_ID"), (Object)parentId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPActionDetails", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADMPActionDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long actionId = (Long)r.get("ACTION_ID");
                    actionList.add(actionId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionList;
    }

    public static Boolean isDefaultAdmin(Long loginId) {
        try {
            if (defaultAdminDO == null) {
                Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)"admin", 0, false).and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)"ADSelfService Plus Authentication", 0, false));
                defaultAdminDO = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", c);
            }
            return null != defaultAdminDO.getRow("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

