/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPAuthUtil;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ADMPUserHandler {
    private static Logger logger = Logger.getLogger(ADMPUserHandler.class.getName());

    public static Long addUser(String userDN, String domainName, boolean adminUser, Long roleID, String credential) throws Exception {
        Long loginId = null;
        try {
            Long mLiteRoleId = AuthUtil.getRoleId((String)"Administrator");
            loginId = ADMPUserHandler.addADUser(userDN, domainName, adminUser, mLiteRoleId);
            ADMPUserHandler.setRoleForUser(loginId, roleID, credential);
            ADMPUserHandler.addUserPersonalRow(loginId);
        }
        catch (NativeException ne) {
            ne.printStackTrace();
            throw new ADSSPException(ne.getExceptionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginId;
    }

    public static Long addDomainUser(String loginName, String domainName) throws Exception {
        LicenseUtil.isUserCountExceeded();
        Long loginId = null;
        try {
            String[] props = new String[]{"sAMAccountName", "name", "displayName", "mail", "givenName", "initials", "sn"};
            Properties properties = UserUtil.getUserObjectDetails(loginName, domainName, props);
            loginId = ADMPUserHandler.addDomainUser(properties, domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ADSSPException(e.getMessage());
        }
        return loginId;
    }

    public static Long addDomainUser(Properties properties, String domainName) throws Exception {
        Long loginId = null;
        try {
            if (properties == null || properties.isEmpty()) {
                throw new ADSSPException("adssp.exception.java.userh_user_not_found");
            }
            Long mLiteRoleId = AuthUtil.getRoleId((String)"DomainUser");
            loginId = ADMPUserHandler.addADUser(properties, domainName, false, mLiteRoleId);
            ADMPUserHandler.setRoleForUser(loginId, new Long(10000L), "false");
            ADMPUserHandler.addUserPersonalRow(loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ADSSPException(e.getMessage());
        }
        return loginId;
    }

    public static boolean updateUser(Long loginID, Long roleID, String Credential2) {
        boolean status = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"), (Object)loginID, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersRoleMapping", criteria);
            Row row = dataObject.getRow("ADMPUsersRoleMapping");
            row.set("ADMP_ROLE_ID", (Object)roleID);
            row.set("USER_CREDENTIAL", (Object)Credential2);
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADMPUsersOUMapping", (String)"LOGIN_ID"), (Object)loginID, 0));
            status = true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in updating user Account");
            e.printStackTrace();
        }
        return status;
    }

    public static void updateUserName(Long loginId, String name) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            Row row = dataObject.getRow("AaaLogin");
            row.set("NAME", (Object)name);
            dataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getUser(Long loginId) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            Row userRow = obj.getFirstRow("AaaLogin");
            hash.put("NAME", userRow.get("NAME"));
            hash.put("DOMAIN_NAME", userRow.get("DOMAINNAME"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" GET USER : " + hash);
        return hash;
    }

    private static Long addADUser(String userDN, String domainName, boolean adminUser, Long roleId) throws Exception {
        Properties properties = ADMPUserHandler.getUserDetails(userDN, domainName);
        return ADMPUserHandler.addADUser(properties, domainName, adminUser, roleId);
    }

    public static Long addUserDetailsInAAATable(Properties prop, String domainName, Long roleId, String loginName) {
        logger.log(Level.FINE, "addUserDetailsInAAATable Starting....");
        UniqueValueHolder loginId = null;
        Properties properties = prop;
        try {
            WritableDataObject dobj = new WritableDataObject();
            Row userRow = new Row("AaaUser");
            userRow.set("FULL_NAME", (Object)properties.getProperty("name"));
            userRow.set("DISPLAY_NAME", (Object)properties.getProperty("displayName"));
            userRow.set("EMAIL_ADDRESS", (Object)properties.getProperty("mail"));
            userRow.set("FIRST_NAME", (Object)properties.getProperty("givenName"));
            userRow.set("MIDDLE_NAME", (Object)properties.getProperty("initials"));
            userRow.set("LAST_NAME", (Object)properties.getProperty("sn"));
            dobj.addRow(userRow);
            Row loginRow = new Row("AaaLogin");
            loginRow.set("NAME", (Object)loginName);
            loginRow.set("USER_ID", userRow.get("USER_ID"));
            loginRow.set("DOMAINNAME", (Object)domainName);
            dobj.addRow(loginRow);
            loginId = (UniqueValueHolder)loginRow.get("LOGIN_ID");
            Row accRow = new Row("AaaAccount");
            accRow.set("SERVICE_ID", (Object)AuthUtil.getServiceId((String)"System"));
            accRow.set("ACCOUNTPROFILE_ID", (Object)AuthUtil.getAccountProfileId((String)"Profile 1"));
            accRow.set("LOGIN_ID", loginRow.get("LOGIN_ID"));
            Row passwordRow = new Row("AaaPassword");
            if (properties.getProperty("PASSWORD") != null) {
                passwordRow.set("PASSWORD", (Object)properties.getProperty("PASSWORD"));
            } else {
                passwordRow.set("PASSWORD", (Object)loginName);
            }
            passwordRow.set("PASSWDPROFILE_ID", (Object)AuthUtil.getPasswordProfileId((String)"Profile 1"));
            dobj.addRow(passwordRow);
            Row accPassRow = new Row("AaaAccPassword");
            accPassRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
            accPassRow.set("PASSWORD_ID", passwordRow.get("PASSWORD_ID"));
            dobj.addRow(accPassRow);
            Row accAuthRow = new Row("AaaAuthorizedRole");
            accAuthRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
            accAuthRow.set("ROLE_ID", (Object)roleId);
            dobj.addRow(accAuthRow);
            dobj.addRow(accRow);
            int noOfSubAccounts = -1;
            Row accOwnerProfileRow = new Row("AaaAccOwnerProfile");
            accOwnerProfileRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
            accOwnerProfileRow.set("ALLOWED_SUBACCOUNT", (Object)new Integer(noOfSubAccounts));
            dobj.addRow(accOwnerProfileRow);
            if (properties.get("ADMP_ROLE_ID") != null) {
                Row admpuserrolemapping = new Row("ADMPUsersRoleMapping");
                admpuserrolemapping.set("LOGIN_ID", (Object)loginId);
                admpuserrolemapping.set("ADMP_ROLE_ID", properties.get("ADMP_ROLE_ID"));
                dobj.addRow(admpuserrolemapping);
            }
            AuthUtil.createUserAccount((DataObject)dobj);
            logger.log(Level.INFO, "Successfully Created Account for HelpDesk user : " + loginName + " of " + domainName + " domain");
        }
        catch (Exception ee) {
            logger.log(Level.INFO, "Errror : " + ee);
            logger.log(Level.INFO, "Problem in creating account : " + loginName + " of " + domainName + " domain ");
        }
        logger.log(Level.INFO, "   addUserDetailsInAAATable Ending....");
        return (Long)loginId.getValue();
    }

    private static Long addADUser(Properties properties, String domainName, boolean adminUser, Long roleId) throws Exception {
        Long loginId = null;
        if (properties != null) {
            String loginName = properties.getProperty("sAMAccountName");
            loginId = ADMPUserHandler.addUserDetailsInAAATable(properties, domainName, roleId, loginName);
        }
        return loginId;
    }

    private static Properties getUserDetails(String userDN, String domainName) throws Exception {
        Properties properties = new Properties();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (String string : ADMPAuthUtil.ADMP_USER_LDAP_ATTRIBUTES) {
            attributeList.add(string);
        }
        properties = ADHandler.getObjectProperties(domainName, 1L, userDN, attributeList);
        for (String string : ADMPAuthUtil.ADMP_USER_LDAP_ATTRIBUTES) {
            if (properties.get(string) != null) {
                ArrayList list = (ArrayList)properties.get(string);
                properties.setProperty(string, list.get(0).toString());
                continue;
            }
            properties.setProperty(string, "-");
        }
        return properties;
    }

    private static boolean setRoleForUser(Long loginId, Long roleID, String Credential2) {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("ADMPUsersRoleMapping");
            row.set("LOGIN_ID", (Object)loginId);
            row.set("ADMP_ROLE_ID", (Object)roleID);
            row.set("USER_CREDENTIAL", (Object)Credential2);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in setting role for user");
            e.printStackTrace();
        }
        return true;
    }

    private static void addUserPersonalRow(Long loginId) {
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("ADMPUsersPersonal");
            row.set("LOGIN_ID", (Object)loginId);
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in adding UserPersonalRow");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getADMPUsersCount() {
        int i = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Table baseTable = Table.getTable((String)"AaaLogin");
            Table joinTable = Table.getTable((String)"ADMPUsersRoleMapping");
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
            query.addJoin(join);
            Column countColumn = Column.getColumn(null, (String)"*");
            query.addSelectColumn(countColumn.count());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                i = (Integer)dataSet.getValue(1) - 1;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting Help desk user count");
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return i;
    }

    public static void setUserPersonalDetails(Long loginId, String columnName, String loginPassword) {
        try {
            UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADMPUsersPersonal");
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", criteria);
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn(columnName, (Object)loginPassword);
            CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in setting UserPersonalDetails");
            e.printStackTrace();
        }
    }

    public static String getUserPersonalDetails(Long loginId, String columnName) {
        String columnValue = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", criteria);
            Row row = dataObject.getRow("ADMPUsersPersonal");
            columnValue = row.get(columnName).toString();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting UserPersonalDetails");
            e.printStackTrace();
        }
        return columnValue;
    }

    public static ArrayList getOUList(Long loginId) {
        ArrayList<Object> ouList = new ArrayList<Object>();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
            query.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"*"));
            DataObject roleObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = roleObj.getRows("ADSMOUDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                ouList.add(r.get("DISTINGUISHED_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouList;
    }

    public static String getUserCredential(Long loginId, String columnName) {
        String columnValue = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersRoleMapping", criteria);
            Row row = dataObject.getRow("ADMPUsersRoleMapping");
            if (row != null && row.get(columnName) != null) {
                columnValue = row.get(columnName).toString();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in getting getUserCredential");
            e.printStackTrace();
        }
        return columnValue;
    }

    public static boolean deleteADMPUser(Long loginID) {
        try {
            Criteria selectCriteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginID, 0);
            selectCriteria = selectCriteria.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)1L, 1));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", selectCriteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AaaLogin");
                Long userID = (Long)row.get("USER_ID");
                Criteria criteria = new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userID, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(criteria);
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in deleting helpdesk user");
            e.printStackTrace();
        }
        return false;
    }

    public static void deleteDomainADMPusers(String domainFlatName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainFlatName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", criteria);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows("AaaLogin");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long loginId = (Long)row.get("LOGIN_ID");
                    ADMPUserHandler.deleteADMPUser(loginId);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in deleting helpdesk users of domain : " + domainFlatName);
            e.printStackTrace();
        }
    }

    public static void validateUserPersonalDetails(Long loginId) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", criteria);
            if (obj.isEmpty()) {
                ADMPUserHandler.addUserPersonalRow(loginId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isDomainUserTechnician(Long loginId) {
        boolean status = false;
        try {
            Long roleId;
            String domainName = DomainHandler.getDomainName(loginId, "LOGIN_ID");
            if (domainName != null && !domainName.equals("ADSelfService Plus Authentication") && !(roleId = ADMPRoleHandler.getRoleIdForUser(loginId)).equals(10000L)) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean isDomainUser(Long loginId) {
        boolean status = false;
        try {
            Long roleId = ADMPRoleHandler.getRoleIdForUser(loginId);
            if (roleId.equals(10000L)) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static boolean isValidUser() {
        boolean status = true;
        try {
            int noOfUsers;
            int count = ADMPRoleHandler.noOfHelpDesk();
            String string = CommonUtil.getLicenseProperty("HelpDeskUsers", "NumberOfUsers");
            if (string == null) {
                string = "0";
            }
            if (count > (noOfUsers = Integer.parseInt(string))) {
                status = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static Long getLoginId(String loginName, String domainName) {
        Long loginId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0));
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            if (!o.isEmpty()) {
                Row r = o.getFirstRow("AaaLogin");
                loginId = (Long)r.get("LOGIN_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginId;
    }

    public static Long getUserLoginId(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
    }

    public static ArrayList getRoleActions(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        return aaaDetails != null && aaaDetails.containsKey("ACTION_IDS_OF_USER") ? (ArrayList)aaaDetails.get("ACTION_IDS_OF_USER") : new ArrayList();
    }
}

