/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.manageengine.ads.fw.sso.CustomSSOAuthenticator;
import com.manageengine.ads.fw.sso.cookie.Ticket;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADSSPCustomSSOAuthenticator
implements CustomSSOAuthenticator {
    private static Logger out = Logger.getLogger(ADSSPCustomSSOAuthenticator.class.getName());
    private Ticket ticketObj = null;
    private DataObject accountDO = null;
    private Hashtable policyPermissions = null;
    private String domainName = null;

    public void init(Ticket ticketObj) {
        try {
            if (ticketObj.isDomainAuthentication) {
                JSONObject domainDetails = DomainHandler.getDomainDetails(this.domainName);
                if (domainDetails.length() != 0) {
                    ticketObj.domainName = domainDetails.getString("DOMAIN_NAME");
                }
                this.domainName = ticketObj.domainName;
            } else {
                this.domainName = "ADSelfService Plus Authentication";
                this.accountDO = AuthDBUtil.getAccountDO((String)ticketObj.loginName, (String)ticketObj.serviceName, (String)this.domainName);
            }
            this.ticketObj = ticketObj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValidAccount() throws LoginException {
        boolean isValid = true;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            if (this.ticketObj.isDomainAuthentication) {
                this.domainName = this.ticketObj.domainName;
                Properties properties = ADAuthHandler.getDomainDetails(this.domainName, "DOMAIN_NAME");
                if (properties == null || properties.isEmpty()) {
                    throw new LoginException(rb.getString("adssp.login.common.error.no_such_account"));
                }
                Authenticator auth = new Authenticator();
                if (auth.userLoggedOnCount(this.ticketObj.loginName, this.ticketObj.domainName) > 0) {
                    throw new LoginException("adssp.login.common.error.user_already_loggedin");
                }
                this.policyPermissions = ADMPADAuthenticator.isValidDomainUser(this.ticketObj.loginName, this.ticketObj.domainName);
                this.accountDO = AuthDBUtil.getAccountDO((String)this.ticketObj.loginName, (String)this.ticketObj.serviceName, (String)this.domainName);
            } else {
                if (this.accountDO == null) {
                    throw new PAMException("adssp.login.common.error.dataobject_null");
                }
                if (!this.accountDO.containsTable("AaaAccount")) {
                    throw new LoginException("adssp.login.common.error.no_such_account_for_choosen_domain");
                }
                if (!this.accountDO.containsTable("AaaPassword")) {
                    throw new LoginException("adssp.login.common.error.no_password_configured");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(rb.getString(e.getMessage()));
        }
        return isValid;
    }

    public boolean authenticate() throws LoginException {
        boolean isValid;
        block5: {
            isValid = true;
            try {
                if (!this.ticketObj.isValidTicket) {
                    throw new LoginException("ads.login.authentication_error_invalid_ticket");
                }
                if (!this.ticketObj.isDomainAuthentication || this.accountDO != null && !this.accountDO.isEmpty()) break block5;
                try {
                    out.log(Level.INFO, "New User! Creating the domain user {0} in {1} domain.", new Object[]{this.ticketObj.loginName, this.ticketObj.domainName});
                    ADMPUserHandler.addDomainUser(this.ticketObj.loginName, this.ticketObj.domainName);
                    this.accountDO = AuthDBUtil.getAccountDO((String)this.ticketObj.loginName, (String)this.ticketObj.serviceName, (String)this.domainName);
                }
                catch (Exception e) {
                    throw new LoginException(e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new LoginException(e.getMessage());
            }
        }
        return isValid;
    }

    public void setSessionAttributes(HttpServletRequest request) throws LoginException {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long policyId = 1L;
            Hashtable<String, String> sessionHash = new Hashtable<String, String>();
            if (this.policyPermissions != null) {
                policyId = (Long)this.policyPermissions.get("policyId");
                sessionHash.put("USER_DN", (String)this.policyPermissions.get("distinguishedName"));
                sessionHash.put("userGroups", (String)this.policyPermissions.get("userGroups"));
            }
            new ADMPADAuthenticator().setSessionAttributes(this.accountDO, session, rb, sessionHash, policyId);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public DataObject getDataObject() {
        return this.accountDO;
    }

    public void init(Properties ntlmProperties) {
    }

    public boolean ntlmAuthenticate() throws LoginException {
        return false;
    }
}

