/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.admin.authentication.Authenticator;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.manageengine.ads.fw.authentication.smartcard.SmartCardHandler;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class ADSSPSmartCardAuthenticator
extends Authenticator {
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public boolean authenticate() throws LoginException {
        boolean result = false;
        try {
            this.auditType = "adssp.reports.audit_report.user_attempts.type_smartcard_text";
            if (this.sessionHash == null) {
                this.sessionHash = new Hashtable();
            }
            if (!SmartCardHandler.isSmartCardEnabled()) {
                this.needAudit = false;
                throw new LoginException(rb.getString("ads.login.smartcard_authentication_error.smart_card_login_is_disabled"));
            }
            if (SmartCardHandler.getIsRestartRequired().booleanValue()) {
                this.needAudit = false;
                throw new LoginException(rb.getString("ads.login.smartcard_authentication_error.unable_to_login_using_smart_card_contact_administrator"));
            }
            Hashtable hash = SmartCardHandler.authorizeUsingCertificates((HttpServletRequest)this.request);
            result = (Boolean)hash.get("IS_AUTHORIZED");
            if (!result) {
                String errorMsg;
                if (!hash.contains("LOGIN_NAME")) {
                    this.needAudit = false;
                }
                if ((errorMsg = (String)hash.get("ErrorMessage")).equalsIgnoreCase("")) {
                    throw new LoginException("ads.login.smartcard_authentication_error.unable_to_login_using_smart_card");
                }
                if (errorMsg.contains("ads.login.smartcard_authentication_error")) {
                    throw new LoginException(errorMsg);
                }
                throw new LoginException(errorMsg == null ? "adssp.login.common.error.invalid_login" : ADMPADAuthenticator.getLoginStatusMsg(errorMsg));
            }
            this.loginName = (String)hash.get("LOGIN_NAME");
            String domainDNSName = (String)hash.get("DOMAIN_DNS_NAME");
            this.domainName = DomainHandler.getDomainDetails(domainDNSName).optString("DOMAIN_NAME", null);
            if (this.domainName == null || this.domainName.equalsIgnoreCase("")) {
                throw new LoginException("adssp.login.common.error.invalid_login");
            }
        }
        catch (LoginException loginException) {
            logger.log(Level.INFO, "LoginException with loginName " + this.loginName + " error Message" + loginException.getMessage());
            throw new LoginException(rb.getString(loginException.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

