/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.RolePrincipal;
import com.adventnet.authentication.UserPrincipal;
import com.adventnet.authentication.callback.DomainCallback;
import com.adventnet.authentication.callback.ServiceCallback;
import com.adventnet.authentication.callback.ServletCallback;
import com.adventnet.authentication.callback.SessionIdCallback;
import com.adventnet.authentication.internal.WritableCredential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.SelfServiceHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.tfa.TFAHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.security.Principal;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class Authenticator
extends com.adventnet.authentication.lm.Authenticator {
    public String authRule = null;
    public String errMsg = "";
    public String auditType = "";
    public static final String ADSSP_AUTHENTICATION = "ADSelfService Plus Authentication";
    public static AdventNetResourceBundle rb;
    public static final String AUTH_STATE = "AUTH_STATE";
    public static final int INACTIVE = 1;
    public static final int ACTIVE = 2;
    public static final int COMPLETED = 3;
    public static final String AUTH_STATUS = "AUTH_STATUS";
    public static final String AUTHENTICATORS = "AUTHENTICATORS";
    public static final String CURRENT_AUTHENTICATOR = "CURRENT_AUTHENTICATOR";
    public static final String POST_PROCESS = "POST_PROCESS";
    public static final String POST_PROCESS_AUDIT_TYPES = "POST_PROCESS_AUDIT_TYPES";
    public static final String MFA_AUTH_STATUS = "MFA_AUTH_STATUS";
    public static final String ADMPUSERSROLEMAPPING_TABLE = "ADMPUsersRoleMapping";
    public static final String[] POST_PROCESS_EXCEPTIONS;
    public boolean needAudit = true;
    public boolean isAPIAuthentication = false;
    public JSONObject authStatus = null;
    public HttpSession session = null;
    public Hashtable sessionHash = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        logger.log(Level.FINEST, "intialized with subject : {0}, cbh : {1}, sharedState : {2} & options : {3}", new Object[]{subject, callbackHandler, sharedState, options});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        block50: {
            this.needAudit = true;
            this.isAPIAuthentication = false;
            try {
                Long policyId;
                if (this.callbackHandler == null) {
                    throw new LoginException("No callbackHandler specified");
                }
                Callback[] callbacks = new Callback[]{new NameCallback("Login name : ", "loginname"), new PasswordCallback("Password : ", false), new ServiceCallback(), new ServletCallback(), new DomainCallback()};
                try {
                    this.callbackHandler.handle(callbacks);
                    this.loginName = ((NameCallback)callbacks[0]).getName();
                    this.password = new String(((PasswordCallback)callbacks[1]).getPassword());
                    this.serviceName = ((ServiceCallback)callbacks[2]).getServiceName();
                    this.request = ((ServletCallback)callbacks[3]).getHttpServletRequest();
                    this.domainName = ((DomainCallback)callbacks[4]).getDomainName();
                    logger.log(Level.FINE, "domainName :: [{0}]", this.domainName);
                    this.serverHostName = this.request == null ? AuthUtil.getLocalHostName() : this.request.getServerName();
                    this.hostName = this.request == null ? this.serverHostName : this.request.getRemoteHost();
                    logger.log(Level.FINEST, "loginName obtained via callbacks are : {0}", this.loginName);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error occured while handling callbacks: ", e);
                    throw new LoginException("Error occured while handling callbacks");
                }
                this.errMsg = "";
                this.sessionHash = new Hashtable();
                this.session = this.request.getSession();
                this.authRule = this.request.getParameter("AUTHRULE_NAME");
                if (this.session.getAttribute(AUTH_STATUS) == null) {
                    this.session.setAttribute(AUTH_STATUS, (Object)new JSONObject());
                }
                this.authStatus = (JSONObject)this.session.getAttribute(AUTH_STATUS);
                if (this.authStatus.has(this.authRule)) {
                    JSONObject tfaProviderProp = this.authStatus.getJSONObject(this.authRule);
                    String modeName = tfaProviderProp.getJSONArray("MODE_NAMES").getString(0);
                    JSONObject tfaProviderMode = tfaProviderProp.getJSONObject("MODES").getJSONObject(modeName);
                    this.auditType = tfaProviderMode.getString("AUDIT_TYPE");
                }
                if (this.authStatus.has(this.authRule)) {
                    this.authStatus.put(CURRENT_AUTHENTICATOR, (Object)this.authRule);
                    JSONArray authenticators = new JSONArray();
                    authenticators.put((Object)this.authRule);
                    this.authStatus.put(AUTHENTICATORS, (Object)authenticators);
                }
                if (!this.authStatus.has(POST_PROCESS)) {
                    this.authStatus.put(POST_PROCESS, (Object)new JSONArray());
                }
                if (!this.authStatus.has(POST_PROCESS_AUDIT_TYPES)) {
                    this.authStatus.put(POST_PROCESS_AUDIT_TYPES, (Object)new JSONObject());
                }
                Boolean authResult = false;
                try {
                    if (this.authStatus.has("LOGIN_NAME") && this.authStatus.has("DOMAIN_NAME")) {
                        String authLoginName = this.authStatus.getString("LOGIN_NAME");
                        String authDomainName = this.authStatus.getString("DOMAIN_NAME");
                        if (!this.loginName.equalsIgnoreCase(authLoginName) || !this.domainName.equalsIgnoreCase(authDomainName)) {
                            this.loginName = authLoginName;
                            this.domainName = authDomainName;
                            this.errMsg = "adssp.login.common.error.tfa.session_attrib_differs";
                            this.request.setAttribute("message", (Object)this.errMsg);
                            this.request.setAttribute("messageType", (Object)"error");
                            this.request.setAttribute("showLoginPage", (Object)"true");
                            this.session.invalidate();
                            throw new LoginException("TWO_FACTOR");
                        }
                    }
                    if ((authResult = Boolean.valueOf(this.authenticate())).booleanValue() && this.userLoggedOnCount(this.loginName, this.domainName) > 0 && this.request.getSession().getAttribute("SAML_SSO_LOGIN") == null) {
                        authResult = false;
                        this.session.removeAttribute("ADMP_SESSION_LOGIN_ID");
                        throw new LoginException("adssp.login.common.error.user_already_loggedin");
                    }
                }
                catch (LoginException l) {
                    if (this.authStatus.has(this.authRule)) {
                        JSONObject authRuleJson = this.authStatus.getJSONObject(this.authRule);
                        String retriveTrust = this.request.getParameter("TRUST") != null || authRuleJson.get("TRUST") != null && "checked".equalsIgnoreCase((String)authRuleJson.get("TRUST")) ? "checked" : "";
                        authRuleJson.put("TRUST", (Object)retriveTrust);
                        this.authStatus.put(this.authRule, (Object)authRuleJson);
                    }
                    if (Arrays.asList(POST_PROCESS_EXCEPTIONS).contains(l.getMessage())) {
                        authResult = true;
                        this.authStatus.getJSONArray(POST_PROCESS).put((Object)l.getMessage());
                        this.authStatus.getJSONObject(POST_PROCESS_AUDIT_TYPES).put(l.getMessage(), (Object)this.auditType);
                        this.errMsg = "";
                    }
                    throw l;
                }
                if ("".equals(this.auditType)) {
                    this.auditType = "adssp.reports.audit_report.user_attempts.type_manual_login_text";
                }
                Boolean isCookieValid = false;
                if (authResult.booleanValue()) {
                    if (this.request.getSession().getAttribute("SAML_SSO_LOGIN") != null) {
                        this.auditType = "adssp.reports.audit_report.user_attempts.type_saml_sso_login";
                    }
                    if (this.session.getAttribute("isWinLogTFA") != null) {
                        this.auditType = "adssp.reports.audit_report.user_attempts.type_windows_login_text";
                    }
                } else {
                    logger.log(Level.INFO, "AuthRule [{2}] : authenticate failed for the user [{0}] of domain [{1}], and hence returning return false", new String[]{this.loginName, this.domainName, this.authRule});
                    boolean authRuleJson = false;
                    return authRuleJson;
                }
                AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg);
                if (Boolean.valueOf((String)this.session.getAttribute("isUMCPYetToBeAudited")).booleanValue()) {
                    this.umcpAudit(this.session);
                }
                Long l = policyId = this.session.getAttribute("POLICY_ID") != null ? (Long)this.session.getAttribute("POLICY_ID") : new Long(-1L);
                if (this.request.getParameter("TRUST") != null) {
                    this.session.setAttribute("ADSSPTFACookie", (Object)TFAHandler.createADSSPTFACookie(this.request, this.loginName, this.domainName));
                } else {
                    isCookieValid = TFAHandler.isValidCookiePresent(this.request, this.loginName, this.domainName, policyId);
                }
                if (!(isCookieValid.booleanValue() || this.authStatus.has(AUTHENTICATORS) || ADSSP_AUTHENTICATION.equals(this.domainName))) {
                    JSONArray authenticators = new JSONArray();
                    if (policyId == -1L) {
                        try {
                            Hashtable polPermission = ADMPADAuthenticator.isValidDomainUser(this.loginName, this.domainName);
                            policyId = (Long)polPermission.get("policyId");
                            isCookieValid = TFAHandler.isValidCookiePresent(this.request, this.loginName, this.domainName, policyId);
                            this.sessionHash.put("USER_DN", (String)polPermission.get("distinguishedName"));
                            this.sessionHash.put("userGroups", polPermission.get("userGroups"));
                            this.session.setAttribute("POLICY_ID", (Object)policyId);
                            this.session.setAttribute("USER_DN", (Object)((String)polPermission.get("distinguishedName")));
                            this.session.setAttribute("userGroups", polPermission.get("userGroups"));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (policyId != null) {
                        JSONObject userTFAProps;
                        boolean isSAMLLogin = this.request.getSession().getAttribute("SAML_SSO_LOGIN") != null;
                        boolean tfaExemption = isSAMLLogin && TFAHandler.isTFAExcludedForSAML(policyId) != false;
                        this.session.setAttribute("SAML_TFA_EXEMPT", (Object)tfaExemption);
                        if (!tfaExemption && (userTFAProps = TFAHandler.getUserTFAProps(this.loginName, this.domainName, policyId)).getBoolean("ENABLED")) {
                            JSONArray tfaProviders = userTFAProps.getJSONObject("PROVIDERS").toJSONArray(userTFAProps.getJSONArray("PROVIDER_NAMES"));
                            for (int j = 0; j < tfaProviders.length(); ++j) {
                                JSONObject tfaProviderProps = tfaProviders.getJSONObject(j);
                                tfaProviderProps.put(AUTH_STATE, 1);
                                String providerName = tfaProviderProps.getString("PROVIDER_NAME");
                                this.authStatus.put(providerName, (Object)tfaProviderProps);
                                authenticators.put((Object)providerName);
                            }
                        }
                    }
                    this.authStatus.put(AUTHENTICATORS, (Object)authenticators);
                    this.authStatus.put(CURRENT_AUTHENTICATOR, (Object)this.authRule);
                    this.authStatus.put("TFA_COOKIE_VALIDITY", TFAHandler.getTFACookieValidity());
                } else if (this.authStatus.has(this.authRule)) {
                    this.authStatus.getJSONObject(this.authRule).put(AUTH_STATE, 3);
                }
                Boolean isAuthenticationCompleted = true;
                for (int i = 0; this.authStatus.has(AUTHENTICATORS) && i < this.authStatus.getJSONArray(AUTHENTICATORS).length(); ++i) {
                    String authenticator = this.authStatus.getJSONArray(AUTHENTICATORS).getString(i);
                    if (this.authStatus.has(authenticator) && (!this.authStatus.has(authenticator) || this.authStatus.getJSONObject(authenticator).has(AUTH_STATE) && (!this.authStatus.getJSONObject(authenticator).has(AUTH_STATE) || this.authStatus.getJSONObject(authenticator).getInt(AUTH_STATE) == 3))) continue;
                    this.authStatus.put(CURRENT_AUTHENTICATOR, (Object)authenticator);
                    isAuthenticationCompleted = false;
                    break;
                }
                this.authStatus.put("LOGIN_NAME", (Object)this.loginName);
                this.authStatus.put("DOMAIN_NAME", (Object)this.domainName);
                this.session.setAttribute(AUTH_STATUS, (Object)this.authStatus);
                if (authResult.booleanValue() && (isCookieValid.booleanValue() || isAuthenticationCompleted.booleanValue() || ADSSP_AUTHENTICATION.equals(this.domainName))) {
                    if (this.authStatus.getJSONArray(POST_PROCESS).length() > 0) {
                        String exception = this.authStatus.getJSONArray(POST_PROCESS).getString(0);
                        JSONArray tempJSONArr = new JSONArray();
                        if (this.authStatus.getJSONArray(POST_PROCESS).length() > 1) {
                            for (int i = 1; i < this.authStatus.getJSONArray(POST_PROCESS).length(); ++i) {
                                tempJSONArr.put((Object)this.authStatus.getJSONArray(POST_PROCESS).getString(i));
                            }
                        }
                        this.authStatus.remove(POST_PROCESS);
                        this.authStatus.put(POST_PROCESS, (Object)tempJSONArr);
                        this.auditType = this.authStatus.getJSONObject(POST_PROCESS_AUDIT_TYPES).getString(exception);
                        throw new LoginException(exception);
                    }
                    this.createUserPrincipal();
                    this.principal = new UserPrincipal(this.loginName);
                    this.session.removeAttribute(AUTH_STATUS);
                    logger.log(Level.INFO, "principal object constructed is : {0}", this.principal);
                    break block50;
                }
                throw new Exception("TWO_FACTOR");
            }
            catch (LoginException le) {
                if (this.errMsg == null || "".equals(this.errMsg)) {
                    this.errMsg = le.getMessage();
                } else {
                    le.printStackTrace();
                }
                if (this.needAudit) {
                    int status = 0;
                    if ("".equals(this.errMsg) || Arrays.asList(POST_PROCESS_EXCEPTIONS).contains(this.errMsg)) {
                        status = 1;
                    }
                    if (this.request.getSession().getAttribute("SAML_SSO_LOGIN") != null) {
                        this.auditType = "adssp.reports.audit_report.user_attempts.type_saml_sso_login";
                    }
                    AuditAPI.getInstance().addUserAttemptsAuditLog(this.request, this.loginName, this.domainName, this.auditType, this.errMsg, status);
                }
                throw le;
            }
            catch (Exception e) {
                if ("TWO_FACTOR".equals(e.getMessage())) {
                    throw new LoginException(e.getMessage());
                }
                e.printStackTrace();
            }
            finally {
                this.request.setAttribute("LOGIN_NAME", (Object)this.loginName);
                this.request.setAttribute("DOMAIN_NAME", (Object)this.domainName);
            }
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.principal == null) {
            logger.log(Level.SEVERE, "principal obj is null, commit failed");
            return false;
        }
        if (!this.subject.getPrincipals().contains(this.principal)) {
            this.subject.getPrincipals().add(this.principal);
        }
        this.removeBadLoginStatusIfPresent();
        List roleList = this.getRoles();
        WritableCredential wcr = this.constructWritableCredential();
        wcr.setHostName(this.hostName);
        String roleName = null;
        int noOfRoles = roleList.size();
        for (int i = 0; i < noOfRoles; ++i) {
            roleName = (String)roleList.get(i);
            this.subject.getPrincipals().add((Principal)new RolePrincipal(roleName));
            wcr.addRole(roleName);
        }
        Long sessionId = this.createAccSession();
        wcr.setSessionId(sessionId);
        this.subject.getPublicCredentials().add(wcr);
        logger.log(Level.FINEST, "[{0}] successfully logged in from the host [{1}]", new Object[]{this.principal.getName(), this.hostName});
        this.committed = true;
        return true;
    }

    public boolean logout() throws LoginException {
        logger.log(Level.FINEST, "logout invoked");
        if (this.callbackHandler == null) {
            throw new LoginException("No callbackHandler specified");
        }
        Callback[] callbacks = new Callback[]{new SessionIdCallback()};
        Long sessionId = null;
        try {
            this.callbackHandler.handle(callbacks);
            sessionId = ((SessionIdCallback)callbacks[0]).getSessionId();
            logger.log(Level.FINEST, "sessionId obtained via callback is : {0}", sessionId);
        }
        catch (Exception e) {
            logger.log(Level.FINEST, "Error occured while handling callbacks: ", e);
            throw new LoginException("Error occured while handling callbacks");
        }
        this.closeAccSession(sessionId);
        return true;
    }

    public boolean abort() throws LoginException {
        logger.log(Level.FINEST, "abort invoked");
        this.updateBadLoginCount();
        if (this.committed) {
            this.logout();
        }
        WritableCredential wcr = new WritableCredential();
        wcr.setHostName(this.hostName);
        wcr.setLoginName(this.loginName);
        wcr.setServiceName(this.serviceName);
        wcr.setDomainName(this.domainName);
        this.subject.getPublicCredentials().add(wcr);
        logger.log(Level.FINEST, "Login failed for [{0}] from the host [{1}]", new Object[]{this.loginName, this.hostName});
        this.principal = null;
        return true;
    }

    public void createUserPrincipal() throws LoginException, DataAccessException, Exception {
        this.accountDO = ADAuthHandler.getAccountDO(this.loginName, this.domainName, this.serviceName);
        if (this.accountDO == null || this.accountDO.isEmpty()) {
            try {
                ADMPUserHandler.addDomainUser(this.loginName, this.domainName);
                this.accountDO = ADAuthHandler.getAccountDO(this.loginName, this.domainName, this.serviceName);
            }
            catch (ADSSPException sspEx) {
                throw new LoginException(sspEx.getMessage(this.request));
            }
            catch (Exception e) {
                throw new LoginException(e.getMessage());
            }
        }
        this.setSessionAttributes(this.accountDO, this.session, rb, this.sessionHash);
    }

    public Long createAccSession(HttpServletRequest request) throws PAMException {
        this.serverHostName = request == null ? AuthUtil.getLocalHostName() : request.getServerName();
        this.hostName = request == null ? this.serverHostName : request.getRemoteHost();
        return super.createAccSession();
    }

    public void closeAccSession(Long sessionId) throws PAMException {
        logger.log(Level.FINEST, "");
        super.closeAccSession(sessionId);
    }

    public void setSessionAttributes(DataObject accountDO, HttpSession session, AdventNetResourceBundle rb, Hashtable sessionHash, Long policyId) {
        if (policyId != null) {
            sessionHash.put("POLICY_ID", policyId);
        }
        this.setSessionAttributes(accountDO, session, rb, sessionHash);
    }

    public void setSessionAttributes(DataObject accountDO, HttpSession session, AdventNetResourceBundle rb, Hashtable sessionHash) {
        try {
            Row row = accountDO.getRow("AaaLogin");
            Long loginId = (Long)row.get("LOGIN_ID");
            session.setAttribute("ADMP_SESSION_LOGIN_ID", (Object)loginId);
            session.setAttribute("licenseMessage", (Object)"false");
            session.setAttribute("CUSTOM_DATE_FORMAT", (Object)TimeZoneUtil.getCustomDateFormat(loginId, this.request));
            Enumeration e = sessionHash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                session.setAttribute(key, sessionHash.get(key));
            }
            Long policyId = session.getAttribute("POLICY_ID") != null ? (Long)session.getAttribute("POLICY_ID") : new Long(-1L);
            session.setAttribute("ADMP_AAA_DETAILS", (Object)ADMPRoleHandler.getAAADetailsForSU(row, rb, policyId, session));
            ADMPUserHandler.validateUserPersonalDetails(loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int userLoggedOnCount(String loginName, String domainName) {
        if (!"true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter("DENY_CONCURRENT_LOGIN"))) {
            return 0;
        }
        DataObject accountDobj = null;
        SelectQueryImpl query = new SelectQueryImpl(new Table("AaaLogin"));
        query.addSelectColumn(new Column(null, "*"));
        query.addJoin(new Join("AaaLogin", "AaaAccount", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        query.addJoin(new Join("AaaAccount", "AaaAccSession", new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1));
        query.addJoin(new Join("AaaLogin", ADMPUSERSROLEMAPPING_TABLE, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        Criteria criteria = new Criteria(new Column("AaaLogin", "NAME"), (Object)loginName, 0, false);
        criteria = criteria.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)domainName, 0, false));
        criteria = criteria.and(new Criteria(new Column("AaaAccSession", "STATUS"), (Object)"Active", 0, false));
        criteria = criteria.and(new Criteria(new Column("AaaLogin", "LOGIN_ID"), (Object)1L, 1, false));
        if ("true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter("ALLOW_TECHNICIAN_CONCURRENT_LOGIN"))) {
            criteria = criteria.and(new Criteria(new Column(ADMPUSERSROLEMAPPING_TABLE, "ADMP_ROLE_ID"), (Object)10000L, 0));
        }
        query.setCriteria(criteria);
        try {
            accountDobj = DataAccess.get((SelectQuery)query);
            return accountDobj.size("AaaAccSession");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void umcpAudit(HttpSession session) {
        try {
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long userId = SelfServiceHandler.getUserId(loginId);
            AuditAPI.getInstance().addAuditLog(loginId, userId, "adssp.audit.change_pwd.umcp", System.currentTimeMillis(), this.request.getRemoteHost(), CommonUtil.getIPAddress(this.request), new Hashtable(), new Integer(1), "adssp.common.text.success", ReportsUtil.getSSPAccessMode(this.request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            System.loadLibrary("ADAuth");
            System.loadLibrary("ADAuthWmi");
        }
        rb = ResourceBundleMgr.getInstance().getBundle();
        POST_PROCESS_EXCEPTIONS = new String[]{"adssp.error.native.user_must_change_pwd", "adssp.error.native.user_pwd_expired", "adssp.login.common.error.must_change_pwd"};
    }
}

