/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADQuestionsHandler {
    public static JSONArray getADQuestions() {
        JSONArray questions = new JSONArray();
        try {
            SelectQuery query = QueryConstructor.get((String)"SSPADQuestions", (Criteria)null);
            query.addSortColumn(new SortColumn(Column.getColumn((String)"SSPADQuestions", (String)"QUESTION_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(query);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("SSPADQuestions");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    JSONObject question = new JSONObject();
                    for (String column : r.getColumns()) {
                        question.put(column, r.get(column));
                    }
                    questions.put((Object)question);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return questions;
    }

    public static void updateADQuestion(String qId, String qText, String ldapName) throws Exception {
        try {
            DataObject dataObject = null;
            Boolean update = true;
            Row r = null;
            if (qId == null) {
                update = false;
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                r = new Row("SSPADQuestions");
            } else {
                Criteria c = new Criteria(Column.getColumn((String)"SSPADQuestions", (String)"QUESTION_ID"), (Object)Long.parseLong(qId), 0);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPADQuestions", c);
                r = dataObject.getFirstRow("SSPADQuestions");
            }
            r.set("QUESTION_TEXT", (Object)qText);
            if (ldapName != null) {
                r.set("ATTRIB_LDAP_NAME", (Object)ldapName);
            }
            if (update.booleanValue()) {
                dataObject.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            } else {
                r.set("IS_SELECTED", (Object)true);
                dataObject.addRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            }
        }
        catch (Exception e) {
            throw new Exception("adssp.config.admin_tools.helpdesk.duplicate_attribute");
        }
    }

    public static void deleteADQuestion(String qId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"SSPADQuestions", (String)"QUESTION_ID"), (Object)Long.parseLong(qId), 0);
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPADQuestions", criteria);
        dataObject.deleteRows("SSPADQuestions", criteria);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
    }

    public static void selectADQuestion(String qId, String status) throws Exception {
        Criteria c = new Criteria(Column.getColumn((String)"SSPADQuestions", (String)"QUESTION_ID"), (Object)Long.parseLong(qId), 0);
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPADQuestions", c);
        Row r = dataObject.getFirstRow("SSPADQuestions");
        r.set("IS_SELECTED", (Object)Boolean.valueOf(status));
        dataObject.updateRow(r);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
    }

    public static void changeAttribute(String qId, String ldapName) throws Exception {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPADQuestions", (String)"QUESTION_ID"), (Object)Long.parseLong(qId), 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPADQuestions", c);
            Row r = dataObject.getFirstRow("SSPADQuestions");
            r.set("ATTRIB_LDAP_NAME", (Object)ldapName);
            dataObject.updateRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            throw new Exception("adssp.config.admin_tools.helpdesk.duplicate_attribute");
        }
    }
}

