/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class APCModuleHandler {
    public static final String SSPPCPOLICYVSMODULES = "SSPPCPOLICYVSMODULES";
    public static final String SSPPCMODULEFLAGS = "SSPPCMODULEFLAGS";
    public static final String SSPPCMODULES = "SSPPCMODULES";
    public static final String FLAG_BIT_VAL = "FLAG_BIT_VAL";
    public static final String FLAG_NAME = "FLAG_NAME";
    public static final String PC_MODULE_ID = "PC_MODULE_ID";
    public static final String PC_MODULE_NAME = "PC_MODULE_NAME";
    public static final String POLICY_ID = "POLICY_ID";
    public static final String FLAG_BIT_VALS = "FLAG_BIT_VALS";
    public static final String IS_ENABLED = "IS_ENABLED";
    public static final String VERIFICATION_CODE = "VERIFICATION_CODE";
    public static final String ENROLLMENT = "ENROLLMENT";
    public static final String ID_VERIFICATIONS = "ID_VERIFICATIONS";

    public static JSONObject getAPCValues(HttpServletRequest request) {
        JSONObject APCValues = new JSONObject();
        Long policyId = Long.parseLong(request.getParameter("policyId"));
        JSONArray allModuleIds = APCModuleHandler.getAllModuleIds(policyId);
        try {
            for (int i = 0; i < allModuleIds.length(); ++i) {
                JSONObject module = allModuleIds.getJSONObject(i);
                Long moduleId = module.getLong(PC_MODULE_ID);
                JSONArray flagNames = APCModuleHandler.getModuleFlagNames(moduleId, policyId);
                Long bitValue = APCModuleHandler.getModuleBitValue(moduleId, policyId);
                for (int j = 0; j < flagNames.length(); ++j) {
                    JSONObject flag = flagNames.getJSONObject(j);
                    String flagName = flag.getString(FLAG_NAME);
                    Long flagBitVal = flag.getLong(FLAG_BIT_VAL);
                    Long flagPos = APCModuleHandler.getFlagPos(flagBitVal);
                    APCValues.put(flagName, (Object)APCModuleHandler.getBitValue(flagPos, bitValue));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return APCValues;
    }

    public static String getBitValue(long flagPos, long bitValue) {
        if ((bitValue >> (int)flagPos & 1L) == 0L) {
            return "0";
        }
        return "1";
    }

    public static void setModuleValues(HttpServletRequest request, String moduleName) {
        try {
            Long policyId = Long.parseLong(request.getParameter("policyId"));
            Long moduleId = APCModuleHandler.getModuleId(moduleName);
            Long bitVal = 0L;
            JSONArray flagNames = APCModuleHandler.getModuleFlagNames(moduleId, policyId);
            Long prevValue = APCModuleHandler.getModuleBitValue(moduleId, policyId);
            for (int j = 0; j < flagNames.length(); ++j) {
                String flagVal;
                JSONObject flag = flagNames.getJSONObject(j);
                String flagName = flag.getString(FLAG_NAME);
                Long flagBitVal = flag.getLong(FLAG_BIT_VAL);
                Long flagPos = APCModuleHandler.getFlagPos(flagBitVal);
                String string = request.getParameter(flagName) != null ? (!request.getParameter(flagName).equals("0") ? "1" : "0") : (flagVal = APCModuleHandler.getBitValue(flagPos, prevValue));
                if (!flagVal.equals("1")) continue;
                bitVal = bitVal | (long)(1 << (int)flagPos.longValue());
            }
            APCModuleHandler.setModule(moduleId, policyId, bitVal);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setAPCValues(HttpServletRequest request) {
        Long policyId = Long.parseLong(request.getParameter("policyId"));
        JSONArray allModuleIds = APCModuleHandler.getAllModuleIds(policyId);
        try {
            for (int i = 0; i < allModuleIds.length(); ++i) {
                JSONObject module = allModuleIds.getJSONObject(i);
                Long moduleId = module.getLong(PC_MODULE_ID);
                Long bitVal = 0L;
                JSONArray flagNames = APCModuleHandler.getModuleFlagNames(moduleId, policyId);
                for (int j = 0; j < flagNames.length(); ++j) {
                    JSONObject flag = flagNames.getJSONObject(j);
                    String flagName = flag.getString(FLAG_NAME);
                    Long flagBitVal = flag.getLong(FLAG_BIT_VAL);
                    Long flagPos = APCModuleHandler.getFlagPos(flagBitVal);
                    if (!request.getParameter(flagName).equals("1")) continue;
                    bitVal = bitVal | (long)(1 << (int)flagPos.longValue());
                }
                APCModuleHandler.setModule(moduleId, policyId, bitVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isPowerOfTwo(long number) {
        if (number == 0L) {
            return true;
        }
        if ((number & -number) == number) {
            return true;
        }
        if (number < 0L) {
            return false;
        }
        return false;
    }

    public static long getFlagPos(long flagBitVal) {
        if (APCModuleHandler.isPowerOfTwo(flagBitVal)) {
            return Long.toBinaryString(flagBitVal).length() - 1;
        }
        return 0L;
    }

    public static JSONArray getAllModuleIds(Long policyId) {
        JSONArray flagList = new JSONArray();
        try {
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCPOLICYVSMODULES, c);
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows(SSPPCPOLICYVSMODULES);
                while (it.hasNext()) {
                    JSONObject flag = new JSONObject();
                    Row r = (Row)it.next();
                    flag.put(PC_MODULE_ID, r.get(PC_MODULE_ID));
                    flagList.put((Object)flag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flagList;
    }

    public static JSONArray getModuleFlagNames(Long moduleId) {
        JSONArray flagList = new JSONArray();
        try {
            Criteria c = new Criteria(Column.getColumn((String)SSPPCMODULEFLAGS, (String)PC_MODULE_ID), (Object)moduleId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSPPCMODULEFLAGS, c);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows(SSPPCMODULEFLAGS);
                while (it.hasNext()) {
                    JSONObject flag = new JSONObject();
                    Row r = (Row)it.next();
                    flag.put(FLAG_BIT_VAL, r.get(FLAG_BIT_VAL));
                    flag.put(FLAG_NAME, r.get(FLAG_NAME));
                    flagList.put((Object)flag);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return flagList;
    }

    public static JSONArray getModuleFlagNames(Long moduleId, Long policyId) {
        JSONArray flagList = new JSONArray();
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add(SSPPCPOLICYVSMODULES);
            tablesList.add(SSPPCMODULES);
            tablesList.add(SSPPCMODULEFLAGS);
            boolean[] isLeftJoins = new boolean[tablesList.size()];
            Arrays.fill(isLeftJoins, true);
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)PC_MODULE_ID), (Object)moduleId, 0));
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            JSONObject module = new JSONObject();
            JSONArray moduleList = new JSONArray();
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows(SSPPCMODULEFLAGS);
                while (it.hasNext()) {
                    JSONObject flag = new JSONObject();
                    Row r = (Row)it.next();
                    flag.put(FLAG_BIT_VAL, r.get(FLAG_BIT_VAL));
                    flag.put(FLAG_NAME, r.get(FLAG_NAME));
                    flagList.put((Object)flag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flagList;
    }

    public static long getModuleBitValue(long moduleId, Long policyId) {
        try {
            Iterator it;
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)PC_MODULE_ID), (Object)moduleId, 0));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCPOLICYVSMODULES, c);
            if (!dataobject.isEmpty() && (it = dataobject.getRows(SSPPCPOLICYVSMODULES)).hasNext()) {
                Row r = (Row)it.next();
                return (Long)r.get(FLAG_BIT_VALS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static Long getModuleId(String moduleName) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)SSPPCMODULES, (String)PC_MODULE_NAME), (Object)moduleName, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCMODULES, c);
            if (!dataobject.isEmpty()) {
                Row r = dataobject.getFirstRow(SSPPCMODULES);
                return (Long)r.get(PC_MODULE_ID);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return 0L;
    }

    public static JSONObject getModuleFlagValues(Long policyId, String moduleName) {
        JSONObject moduleValues = new JSONObject();
        try {
            Long moduleId = APCModuleHandler.getModuleId(moduleName);
            JSONArray flagNames = APCModuleHandler.getModuleFlagNames(moduleId, policyId);
            Long bitValue = APCModuleHandler.getModuleBitValue(moduleId, policyId);
            for (int j = 0; j < flagNames.length(); ++j) {
                JSONObject flag = flagNames.getJSONObject(j);
                String flagName = flag.getString(FLAG_NAME);
                Long flagBitVal = flag.getLong(FLAG_BIT_VAL);
                Long flagPos = APCModuleHandler.getFlagPos(flagBitVal);
                moduleValues.put(flagName, (Object)APCModuleHandler.getBitValue(flagPos, bitValue));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return moduleValues;
    }

    public static JSONArray getModule(Long moduleId, Long policyId) {
        JSONArray flagList = new JSONArray();
        try {
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            c.and(new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)PC_MODULE_ID), (Object)moduleId, 0));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCPOLICYVSMODULES, c);
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows(SSPPCMODULEFLAGS);
                while (it.hasNext()) {
                    JSONObject flag = new JSONObject();
                    Row r = (Row)it.next();
                    flag.put(FLAG_BIT_VAL, r.get(FLAG_BIT_VAL));
                    flag.put(FLAG_NAME, r.get(FLAG_NAME));
                    flag.put(PC_MODULE_ID, r.get(PC_MODULE_ID));
                    flagList.put((Object)flag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flagList;
    }

    public static void setModule(Long moduleId, Long policyId, Long bitVals) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)PC_MODULE_ID), (Object)moduleId, 0));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCPOLICYVSMODULES, c);
            if (!dataobject.isEmpty()) {
                Row r = new Row(SSPPCPOLICYVSMODULES);
                r.set(POLICY_ID, (Object)policyId);
                r.set(PC_MODULE_ID, (Object)moduleId);
                r.set(FLAG_BIT_VALS, (Object)bitVals);
                dataobject.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(dataobject);
            } else {
                dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row(SSPPCPOLICYVSMODULES);
                r.set(POLICY_ID, (Object)policyId);
                r.set(PC_MODULE_ID, (Object)moduleId);
                r.set(FLAG_BIT_VALS, (Object)bitVals);
                dataobject.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dataobject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addRows(long policyId) {
        try {
            Criteria c = null;
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCMODULES, c);
            Iterator it = dataobject.getRows(SSPPCMODULES);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long pcModuleId = (Long)r.get(PC_MODULE_ID);
                c = new Criteria(Column.getColumn((String)SSPPCMODULEFLAGS, (String)PC_MODULE_ID), (Object)pcModuleId, 0);
                DataObject dObject = CommonUtil.getPersistence(new boolean[0]).get(SSPPCMODULEFLAGS, c);
                Iterator it1 = dObject.getRows(SSPPCMODULEFLAGS);
                long flagBitVals = 0L;
                while (it1.hasNext()) {
                    Row r1 = (Row)it1.next();
                    boolean isDefault = (Boolean)r1.get(IS_ENABLED);
                    if (!isDefault) continue;
                    Long flagBitVal = (Long)r1.get(FLAG_BIT_VAL);
                    flagBitVals += flagBitVal.longValue();
                }
                DataObject dObject1 = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r2 = new Row(SSPPCPOLICYVSMODULES);
                r2.set(POLICY_ID, (Object)policyId);
                r2.set(PC_MODULE_ID, (Object)pcModuleId);
                r2.set(FLAG_BIT_VALS, (Object)flagBitVals);
                dObject1.addRow(r2);
                CommonUtil.getPersistence(new boolean[0]).add(dObject1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getAllModulesFlagNames(Long policyId) {
        JSONArray flagList = new JSONArray();
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add(SSPPCPOLICYVSMODULES);
            tablesList.add(SSPPCMODULES);
            tablesList.add(SSPPCMODULEFLAGS);
            boolean[] isLeftJoins = new boolean[tablesList.size()];
            Arrays.fill(isLeftJoins, true);
            Criteria c = new Criteria(Column.getColumn((String)SSPPCPOLICYVSMODULES, (String)POLICY_ID), (Object)policyId, 0);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            JSONObject module = new JSONObject();
            JSONArray moduleList = new JSONArray();
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows(SSPPCMODULEFLAGS);
                while (it.hasNext()) {
                    JSONObject flag = new JSONObject();
                    Row r = (Row)it.next();
                    flag.put(FLAG_BIT_VAL, r.get(FLAG_BIT_VAL));
                    flag.put(FLAG_NAME, r.get(FLAG_NAME));
                    flag.put(PC_MODULE_ID, r.get(PC_MODULE_ID));
                    flagList.put((Object)flag);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flagList;
    }
}

