/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.SoonToExpireHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollHandler;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.EnrollmentNotificationUtil;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.mobile.pushnotification.PNEnrollmentHandler;
import com.manageengine.ads.fw.mobile.pushnotification.PushNotificationConstants;
import com.manageengine.ads.fw.mobile.pushnotification.SendPushNotification;
import com.manageengine.ads.fw.util.CommonUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EnrollmentNotifyHandler
implements PushNotificationConstants {
    private static Logger enrollmentNotifyHandlerLogger = Logger.getLogger("EnrollmentNotifyHandlerLogger");
    public static final int MAIL_NOTIFICATION = 0;
    public static final int PUSH_NOTIFICATION = 1;

    public static JSONObject sendEnrollmentMailReq(String domainName, Properties mailConfig, String subject, String mailText, String toAddress, String mailList, ArrayList ouList, ArrayList policyIds) {
        return EnrollmentNotifyHandler.sendEnrollmentMailReq(domainName, mailConfig, subject, mailText, toAddress, mailList, ouList, policyIds, false);
    }

    public static JSONObject sendEnrollmentMailReq(String domainName, Properties mailConfig, String subject, String mailText, String toAddress, String mailList, ArrayList ouList, ArrayList policyIds, Boolean isScheduler) {
        String message = "adssp.common.text.mail_sent_success_check_notification";
        String statusType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject responseJSON = new JSONObject();
        try {
            if (domainName != null && EnrollmentNotifyHandler.isZohoCorpDomain(domainName)) {
                responseJSON.put("MESSAGE", (Object)"adssp.common.text.zoho_corp_domain.restriction");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
                return responseJSON;
            }
            Hashtable hTable = new Hashtable();
            ArrayList userList = new ArrayList();
            ArrayList noMailId = new ArrayList();
            ArrayList noMailIdProp = new ArrayList();
            String[] props = new String[]{"mail", "name", "objectGUID"};
            String mailRegex = "^[a-zA-Z0-9]([\\w\\-\\.\\+\\']*)@([\\w\\-\\.]*)(\\.[a-zA-Z]{2,8}(\\.[a-zA-Z]{2}){0,2})$";
            String mobRegex = "[0-9+\\(\\) ]+";
            if (toAddress.equals("users") || toAddress.equals("domains")) {
                if (toAddress.equals("users")) {
                    StringTokenizer stToken = new StringTokenizer(mailList, ",");
                    while (stToken.hasMoreTokens()) {
                        String mailId = stToken.nextToken();
                        if (mailId.matches(mailRegex)) {
                            Properties p = new Properties();
                            ArrayList<String> mail = new ArrayList<String>();
                            mail.add(mailId);
                            p.put(props[0], mail);
                            p.put(props[1], mailId.substring(0, mailId.indexOf("@")));
                            p.put(props[2], "");
                            p.put("nType", "adssp.reports.audit_report.notification_delivery_report.mail");
                            p.put("actionName", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton");
                            userList.add(p);
                            noMailId = new ArrayList();
                            noMailIdProp = new ArrayList();
                            continue;
                        }
                        message = "adssp.reports.delivery_rep_invalid_email_id";
                        statusType = "failure";
                    }
                } else {
                    hTable = EnrollmentNotifyHandler.getUsersList(domainName, ouList, policyIds);
                    userList = (ArrayList)hTable.get("userList");
                    noMailId = (ArrayList)hTable.get("noMailId");
                    noMailIdProp = (ArrayList)hTable.get("noMailIdProp");
                    Boolean status = (Boolean)hTable.get("statusMessage");
                    if (userList.size() == 0 && noMailId.size() == 0 && status != null && !status.booleanValue()) {
                        message = "adssp.admin.policies.send_enroll_notif_user_not_permitted";
                        statusType = "failure";
                    } else if (userList.size() == 0 && noMailId.size() == 0) {
                        message = "adssp.admin.policies.import_ans.sel_container_empty";
                        statusType = "failure";
                    }
                }
            } else {
                Hashtable hash = new Hashtable();
                ArrayList domainNames = new ArrayList();
                if (!policyIds.isEmpty()) {
                    hTable = EnrollmentNotifyHandler.getUsersList(domainName, ouList, policyIds);
                    userList.addAll((ArrayList)hTable.get("userList"));
                    noMailId.addAll((ArrayList)hTable.get("noMailId"));
                    noMailIdProp.addAll((ArrayList)hTable.get("noMailIdProp"));
                }
                if (userList.size() == 0 && noMailId.size() == 0) {
                    message = "adssp.admin.policies.import_ans.no_users_found";
                    statusType = "failure";
                }
            }
            if (noMailId.size() != 0 && noMailId.size() != noMailId.size() + userList.size()) {
                message = MessageFormat.format(rb.getString("adssp.admin.policies.import_ans.resultant_emails_sent"), noMailId.size(), noMailId.size() + userList.size());
                if (!toAddress.equals("users")) {
                    String reportLink = MessageFormat.format(rb.getString("adssp.configuration.admin_tool.quick_enroll.enrollment_notification_sent"), "4413477363710");
                    message = message + "||" + reportLink;
                }
            } else if (noMailId.size() != 0 && noMailId.size() == noMailId.size() + userList.size()) {
                message = "adssp.admin.policies.import_ans.sel_cont_empty";
                statusType = "failure";
            }
            if (userList.size() != 0) {
                SendMailAPI.getInstance().sendNotification(domainName, mailConfig, subject, mailText, userList);
                EnrollmentNotificationUtil.addToEnrollDeliveryStatus(userList, domainName);
            }
            if (!statusType.equalsIgnoreCase("failure") || isScheduler.booleanValue()) {
                for (int k = 0; k < noMailIdProp.size(); ++k) {
                    Properties p = (Properties)noMailIdProp.get(k);
                    String objectGUID = (String)p.get("objectGUID");
                    Hashtable<String, Properties> auditLogs = new Hashtable<String, Properties>();
                    Properties auditProps = new Properties();
                    auditProps.put("ACTION_NAME", (String)p.get("actionName"));
                    auditProps.put("DOMAIN_NAME", domainName);
                    auditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                    auditProps.put("MAIL_SENT_TIME", (Object)System.currentTimeMillis());
                    auditProps.put("STATUS", "adssp.reports.delivery_rep_invalid_email_id");
                    auditProps.put("NAME", p.get("samAccountName"));
                    auditLogs.put(objectGUID, auditProps);
                    AuditAPI.getInstance();
                    AuditAPI.addAuditLogs(auditLogs);
                }
            }
            responseJSON.put("MESSAGE", (Object)message);
            responseJSON.put("STATUS_TYPE", (Object)statusType);
        }
        catch (Exception e) {
            try {
                responseJSON.put("MESSAGE", (Object)"adssp.common.text.failure");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
            }
            catch (JSONException j) {
                j.printStackTrace();
            }
            e.printStackTrace();
            return responseJSON;
        }
        return responseJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable getUsersList(String domainName, ArrayList ouList, ArrayList policyIds) {
        String[] attribList = new String[]{"OBJECT_GUID", "NAME", "E_MAIL", "MAIL_NICK_NAME", "SAM_ACCOUNT_NAME", "DN_STRING", "PRIMARY_GROUP_ID"};
        Hashtable<String, Serializable> hash = new Hashtable<String, Serializable>();
        ArrayList<Properties> list = new ArrayList<Properties>();
        ArrayList<String> noMailId = new ArrayList<String>();
        ArrayList<Properties> noMailIdProp = new ArrayList<Properties>();
        ArrayList groupList = null;
        Connection connection = null;
        DataSet dataSet = null;
        Boolean inheritChildOUs = true;
        ArrayList<String> objGUIDLists = new ArrayList<String>();
        if (policyIds != null) {
            ouList = null;
            for (int j = 0; j < policyIds.size(); ++j) {
                Long policyId = (Long)policyIds.get(j);
                Hashtable policyDet = PolicyHandler.getPolicyCriteria(policyId, domainName);
                ArrayList tempOUList = (ArrayList)policyDet.get("OU");
                ArrayList tempGroupList = (ArrayList)policyDet.get("GROUP");
                if (ouList == null) {
                    ouList = tempOUList;
                } else {
                    ouList.addAll(tempOUList);
                }
                if (groupList == null) {
                    groupList = tempGroupList;
                    continue;
                }
                groupList.addAll(tempGroupList);
            }
        }
        try {
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollHandler.getDSForNonEnrolled(connection, domainName, ouList, inheritChildOUs, groupList, attribList);
            Boolean notifyAll = "true".equals(ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY"));
            Boolean message = null;
            while (dataSet.next()) {
                String objGUID = dataSet.getString("OBJECT_GUID");
                if (objGUIDLists.contains(objGUID)) continue;
                objGUIDLists.add(objGUID);
                message = false;
                ArrayList groupsDN = GroupUtil.getAllGroupsOfUser(domainName, dataSet.getString("OBJECT_GUID"), dataSet.getString("PRIMARY_GROUP_ID"));
                Hashtable userHash = PolicyHandler.checkUserPermission(domainName, dataSet.getString("DN_STRING").toLowerCase(), groupsDN);
                if (policyIds == null && ((Boolean)userHash.get("status")).booleanValue() || policyIds != null && !policyIds.isEmpty() && ((Boolean)userHash.get("status")).booleanValue() && policyIds.contains((Long)userHash.get("policyId"))) {
                    Properties p = new Properties();
                    String samAccName = dataSet.getString("SAM_ACCOUNT_NAME");
                    p.put("name", dataSet.getString("NAME"));
                    p.put("samAccountName", samAccName);
                    p.put("objectGUID", dataSet.getString("OBJECT_GUID"));
                    p.put("nType", "adssp.reports.audit_report.notification_delivery_report.mail");
                    p.put("actionName", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton");
                    Properties properties = SecondaryAttributesHandler.getNotificationAttributes(dataSet.getString("SAM_ACCOUNT_NAME"), domainName, "MAIL");
                    ArrayList mail = (ArrayList)properties.get("MAIL_IDS");
                    ArrayList secMailIds = UserUtil.getUserSecondaryMailIds(samAccName, domainName);
                    Boolean isMailIdsAbsent = true;
                    if (mail != null && mail.size() != 0) {
                        isMailIdsAbsent = false;
                        p.put("mail", mail);
                    }
                    if (notifyAll.booleanValue() && secMailIds != null && secMailIds.size() != 0) {
                        isMailIdsAbsent = false;
                        p.put("secMail", secMailIds);
                    }
                    if (isMailIdsAbsent.booleanValue()) {
                        noMailId.add(dataSet.getString("NAME"));
                        noMailIdProp.add(p);
                    } else {
                        list.add(p);
                    }
                }
                if (!((Boolean)userHash.get("status")).booleanValue()) continue;
                message = true;
            }
            hash.put("userList", list);
            hash.put("noMailId", noMailId);
            hash.put("noMailIdProp", noMailIdProp);
            hash.put("statusMessage", message);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return hash;
    }

    public static JSONObject sendEnrollmentPNReq(String domainName, String subject, String pushText, String toAddress, ArrayList ouList, ArrayList policyIds) {
        String message = "adssp.common.text.mail_sent_success";
        String statusType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject responseJSON = new JSONObject();
        try {
            pushText = StrUtil.decodeURIComponent(pushText);
            if (domainName != null && EnrollmentNotifyHandler.isZohoCorpDomain(domainName)) {
                responseJSON.put("MESSAGE", (Object)"adssp.common.text.zoho_corp_domain.restriction");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
                return responseJSON;
            }
            ArrayList userList = new ArrayList();
            if (toAddress.equals("domains")) {
                userList = EnrollmentNotifyHandler.getMobPNUsersList(domainName, ouList, policyIds);
                if (userList.size() == 0) {
                    message = "adssp.admin.policies.import_ans.sel_container_empty_for_pn_config_users";
                    statusType = "failure";
                }
            } else {
                Hashtable hash = new Hashtable();
                ArrayList domainNames = new ArrayList();
                if (!policyIds.isEmpty()) {
                    userList = EnrollmentNotifyHandler.getMobPNUsersList(domainName, ouList, policyIds);
                }
                if (userList.size() == 0) {
                    message = "adssp.admin.policies.import_ans.pn_config_no_users_found";
                    statusType = "failure";
                }
            }
            enrollmentNotifyHandlerLogger.log(Level.INFO, "User List Size : " + userList.size() + " : OU List : " + ouList);
            responseJSON.put("MESSAGE", (Object)message);
            responseJSON.put("STATUS_TYPE", (Object)statusType);
            ArrayList<Long> mobUserList = new ArrayList<Long>();
            for (int i = 0; i < userList.size(); ++i) {
                Properties p = (Properties)userList.get(i);
                Long loginId = (Long)p.get("LOGIN_ID");
                if (loginId == null) continue;
                mobUserList.add(loginId);
            }
            JSONObject customAttribs = new JSONObject();
            customAttribs.put("NA", 1);
            JSONObject pushResponse = new JSONObject();
            try {
                message = toAddress.equals("domains") ? "adssp.admin.policies.import_ans.sel_container_empty_for_pn_config_users" : "adssp.admin.policies.import_ans.pn_config_no_users_found";
                String messageType = "failure";
                if (mobUserList.size() > 0) {
                    int noOfNonEnrolledPNuser = PNEnrollmentHandler.getUniqueLoginIdCount(mobUserList);
                    enrollmentNotifyHandlerLogger.log(Level.INFO, "No. of Users to be notified : " + noOfNonEnrolledPNuser);
                    Long sentTime = System.currentTimeMillis();
                    JSONObject returnValueJSON = SendPushNotification.getInstance().sendBulkNotification(subject, pushText, customAttribs, mobUserList, EnrollmentNotifyHandler.getMachineDomainNames());
                    Hashtable<String, String> notificationProps = new Hashtable<String, String>();
                    notificationProps.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton");
                    notificationProps.put("NOTIFICATION_FROM", "QUICK_ENROLLMENT");
                    enrollmentNotifyHandlerLogger.log(Level.INFO, "Push Notification : response -" + returnValueJSON);
                    int mobileDataLength = returnValueJSON.getInt("PN_SENT_DEVICE_COUNT");
                    returnValueJSON.remove("PN_SENT_DEVICE_COUNT");
                    String returnValue = returnValueJSON.get("STATUS") + "";
                    returnValueJSON.remove("STATUS");
                    message = MessageFormat.format(rb.getString("adssp.configuration.admin_tool.quick_enroll.enrollment_notification.push_notification.text.result_push_sent"), mobileDataLength, noOfNonEnrolledPNuser);
                    if (returnValue.equals("success")) {
                        JSONArray notifiedUserList = returnValueJSON.getJSONArray("DELIVERY_DETAILS");
                        EnrollmentNotifyHandler.auditProcess(notifiedUserList, notificationProps);
                        returnValueJSON.remove("DELIVERY_DETAILS");
                        messageType = "success";
                        String reportLink = MessageFormat.format(rb.getString("adssp.configuration.admin_tool.quick_enroll.enrollment_notification_sent"), "4413477363710");
                        message = message + "||" + reportLink;
                        Iterator it = returnValueJSON.keys();
                        String statusKey = "";
                        while (it.hasNext()) {
                            statusKey = (String)it.next();
                            message = message + "||" + returnValueJSON.get(statusKey);
                            if (!statusKey.contains("_AUTHENTICATION_FAILURE")) continue;
                            messageType = "failure";
                        }
                        enrollmentNotifyHandlerLogger.log(Level.INFO, "Push Notification : message -" + message);
                    } else {
                        message = returnValue;
                        messageType = "failure";
                        enrollmentNotifyHandlerLogger.log(Level.INFO, "Push Notification : message -" + message);
                    }
                    enrollmentNotifyHandlerLogger.log(Level.INFO, "Push Notification : Total Users - " + noOfNonEnrolledPNuser + " & Push Configured - " + mobileDataLength);
                }
                responseJSON.put("MESSAGE", (Object)message);
                responseJSON.put("STATUS_TYPE", (Object)messageType);
            }
            catch (Exception e) {
                responseJSON.put("MESSAGE", (Object)"adssp.login.common.error.exception_occured");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
                e.printStackTrace();
            }
            if (userList.size() != 0 && mobUserList.size() != 0) {
                EnrollmentNotificationUtil.addToEnrollDeliveryStatus(EnrollmentNotifyHandler.getUniqueUserObjectGUID(userList), domainName);
            }
        }
        catch (Exception e) {
            try {
                responseJSON.put("MESSAGE", (Object)"adssp.common.text.failure");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
            }
            catch (JSONException j) {
                j.printStackTrace();
            }
            e.printStackTrace();
            return responseJSON;
        }
        return responseJSON;
    }

    public static void sendEnrollmentPNReqPerDevice(String domainName, String subject, String mailText, String toAddress, ArrayList ouList, ArrayList policyIds, int notificationAction) {
        String message = "adssp.common.text.mail_sent_success";
        String statusType = "success";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject responseJSON = new JSONObject();
        try {
            String[] userLoginIds;
            mailText = StrUtil.decodeURIComponent(mailText);
            if (domainName != null && EnrollmentNotifyHandler.isZohoCorpDomain(domainName)) {
                responseJSON.put("MESSAGE", (Object)"adssp.common.text.zoho_corp_domain.restriction");
                responseJSON.put("STATUS_TYPE", (Object)"failure");
                enrollmentNotifyHandlerLogger.log(Level.INFO, responseJSON.toString());
            }
            ArrayList<Long> mobUserList = new ArrayList<Long>();
            ArrayList userList = new ArrayList();
            if (toAddress.equals("domains")) {
                userList = EnrollmentNotifyHandler.getMobPNUsersList(domainName, ouList, policyIds);
                if (userList.size() == 0) {
                    message = "adssp.admin.policies.import_ans.sel_container_empty";
                    statusType = "failure";
                }
            } else {
                ArrayList domainNames = new ArrayList();
                if (!policyIds.isEmpty()) {
                    userList = EnrollmentNotifyHandler.getMobPNUsersList(domainName, ouList, policyIds);
                }
                if (userList.size() == 0) {
                    message = "adssp.admin.policies.import_ans.no_users_found";
                    statusType = "failure";
                }
            }
            enrollmentNotifyHandlerLogger.log(Level.INFO, "User List Size : " + userList.size() + " : OU List : " + ouList);
            responseJSON.put("MESSAGE", (Object)message);
            responseJSON.put("STATUS_TYPE", (Object)statusType);
            for (int i = 0; i < userList.size(); ++i) {
                Properties p = (Properties)userList.get(i);
                Long loginId = (Long)p.get("LOGIN_ID");
                if (loginId == null) continue;
                mobUserList.add(loginId);
            }
            JSONObject pnUserProps = new JSONObject();
            if (userList.size() > 0) {
                EnrollmentNotifyHandler.formatMessage(userList, domainName, mailText, subject, notificationAction, pnUserProps);
            }
            if ((userLoginIds = JSONObject.getNames((JSONObject)pnUserProps)) != null) {
                Long[] loginIds = new Long[userLoginIds.length];
                for (int i = 0; i < userLoginIds.length; ++i) {
                    loginIds[i] = Long.valueOf(userLoginIds[i]);
                }
                enrollmentNotifyHandlerLogger.log(Level.INFO, "No. of Users to be notified : " + loginIds.length);
                if (loginIds.length > 0) {
                    Long sentTime = System.currentTimeMillis();
                    JSONObject returnValueJSON = SendPushNotification.getInstance().sendNotification(loginIds, pnUserProps, mobUserList, EnrollmentNotifyHandler.getMachineDomainNames());
                    Hashtable<String, String> notificationProps = new Hashtable<String, String>();
                    notificationProps.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton");
                    notificationProps.put("NOTIFICATION_FROM", "QUICK_ENROLLMENT");
                    enrollmentNotifyHandlerLogger.log(Level.INFO, responseJSON.toString());
                    String returnValue = returnValueJSON.get("STATUS") + "";
                    returnValueJSON.remove("STATUS");
                    if (returnValue.equals("success")) {
                        JSONArray notifiedUserList = returnValueJSON.getJSONArray("DELIVERY_DETAILS");
                        EnrollmentNotifyHandler.auditProcess(notifiedUserList, notificationProps);
                    }
                }
            }
            if (userList.size() != 0) {
                EnrollmentNotificationUtil.addToEnrollDeliveryStatus(EnrollmentNotifyHandler.getUniqueUserObjectGUID(userList), domainName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getMobPNUsersList(String domainName, ArrayList ouList, ArrayList policyIds) {
        String[] attribList = new String[]{"NAME", "SAM_ACCOUNT_NAME", "PRIMARY_GROUP_ID"};
        ArrayList<Properties> pnConfiglist = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollUtil.getDSNonEnrolledPNConfigUsers(connection, domainName, ouList, false, true, attribList);
            while (dataSet.next()) {
                ArrayList groupsDN = GroupUtil.getAllGroupsOfUser(domainName, dataSet.getString("OBJECT_GUID"), dataSet.getString("PRIMARY_GROUP_ID"));
                Hashtable userHash = PolicyHandler.checkUserPermission(domainName, dataSet.getString("DN_STRING").toLowerCase(), groupsDN);
                if ((policyIds != null || !((Boolean)userHash.get("status")).booleanValue()) && (policyIds == null || policyIds.isEmpty() || !((Boolean)userHash.get("status")).booleanValue() || !policyIds.contains((Long)userHash.get("policyId")))) continue;
                Properties p = new Properties();
                p.put("name", dataSet.getString("NAME"));
                p.put("LOGIN_ID", (Object)dataSet.getLong("LOGIN_ID"));
                p.put("samAccountName", dataSet.getString("SAM_ACCOUNT_NAME"));
                p.put("objectGUID", dataSet.getString("OBJECT_GUID"));
                pnConfiglist.add(p);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return pnConfiglist;
    }

    private static void formatMessage(ArrayList list, String domainName, String message, String subject, int notificationAction, JSONObject pnUserProps) throws Exception {
        int len = list.size();
        String formatedMessage = "";
        String formatedSubject = "";
        for (int i = 0; i < len; ++i) {
            Properties p = (Properties)list.get(i);
            Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
            String name = (String)p.get("name");
            keyPairValue.put("userName", name);
            keyPairValue.put("accessURL", AdminHandler.getAccessURL());
            String objectGUID = (String)p.get("objectGUID");
            if (!objectGUID.equals("")) {
                formatedMessage = FormatUtil.getNameFormats(domainName, message, objectGUID, "objectGUID", keyPairValue);
                formatedSubject = FormatUtil.getNameFormats(domainName, subject, objectGUID, "objectGUID", keyPairValue);
            } else {
                formatedMessage = FormatUtil.getNameFormats(domainName, message, keyPairValue);
                formatedSubject = FormatUtil.getNameFormats(domainName, subject, keyPairValue);
            }
            JSONObject customAttribs = new JSONObject();
            customAttribs.put("NA", notificationAction);
            JSONObject messageBody = PNEnrollmentHandler.getMessageBody((String)formatedSubject, (String)formatedMessage, (JSONObject)customAttribs);
            pnUserProps.put(p.get("LOGIN_ID") + "", (Object)messageBody);
        }
    }

    public static boolean isZohoCorpDomain(String domainName) {
        boolean isDevMode;
        boolean isZohoCorp;
        boolean bl = isZohoCorp = domainName.equalsIgnoreCase("zohocorp") || domainName.equalsIgnoreCase("csez.zohocorpin.com");
        if (isZohoCorp && (isDevMode = Boolean.valueOf(ADSMPersUtil.getSyMParameter("DEVELOPMENT_MODE")).booleanValue())) {
            enrollmentNotifyHandlerLogger.log(Level.INFO, "Scheduler is restricted for Zohocorp domain");
            return true;
        }
        return false;
    }

    public static ArrayList getUniqueUserObjectGUID(ArrayList userList) {
        ArrayList<Properties> uniqueUserList = new ArrayList<Properties>();
        for (int i = 0; i < userList.size(); ++i) {
            Properties subP;
            String tempObjectGuid;
            String objectGUID = "";
            Properties p = null;
            try {
                p = (Properties)userList.get(i);
                objectGUID = (String)p.get("objectGUID");
                if (objectGUID == null) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int flag = 0;
            for (int j = 0; j < uniqueUserList.size() && !objectGUID.equals(tempObjectGuid = (String)(subP = (Properties)uniqueUserList.get(j)).get("objectGUID")); ++j) {
                ++flag;
            }
            if (flag != uniqueUserList.size()) continue;
            uniqueUserList.add(p);
        }
        return uniqueUserList;
    }

    public static void auditProcess(JSONArray notifiedUserList, Hashtable notificationProps) throws Exception {
        Hashtable<String, Properties> auditProps = new Hashtable<String, Properties>();
        int length = notifiedUserList.length();
        for (int i = 0; i < length; ++i) {
            Properties p = new Properties();
            JSONObject userProp = notifiedUserList.getJSONObject(i);
            String mDeviceToken = userProp.getString("DEVICE_TOKEN");
            p.put("NAME", userProp.getString("NAME"));
            p.put("DOMAIN_NAME", userProp.getString("DOMAIN_NAME"));
            p.put("STATUS", userProp.getString("STATUS"));
            p.put("MAIL_SENT_TIME", (Object)userProp.getLong("SENT_TIME"));
            p.put("DELIVERED_TIME", (Object)userProp.getLong("DELIVERED_TIME"));
            p.put("ACTION_NAME", notificationProps.get("ACTION_NAME").toString());
            p.put("NOTIFICATION_TYPE", EnrollmentNotifyHandler.getNotifyType(userProp.getString("PROVIDER_NAME")));
            auditProps.put(mDeviceToken, p);
        }
        if (!auditProps.isEmpty()) {
            if (notificationProps.get("NOTIFICATION_FROM").toString().equals("QUICK_ENROLLMENT") || notificationProps.get("NOTIFICATION_FROM").toString().equals("MFA_NOTIFICATION")) {
                AuditAPI.addAuditLogs(auditProps);
            } else {
                SoonToExpireHandler.addSTEPushNotificationDeliveryReport(auditProps);
            }
        }
    }

    public static String getNotifyType(String providerName) {
        String notificationtype = "";
        try {
            notificationtype = providerName.equalsIgnoreCase("ANDROID") ? "adssp.reports.audit_report.notification_delivery_report.android.push_notification" : "adssp.reports.audit_report.notification_delivery_report.ios.push_notification";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return notificationtype;
    }

    public static String getMachineDomainNames() {
        String ADSM_DOMAIN_CONFIGURATION = "ADSMDomainConfiguration";
        String domainNames = "";
        try {
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMDomainConfiguration", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainNames = domainNames + r.get("DOMAIN_NAME") + " ";
                }
            }
        }
        catch (Exception e) {
            enrollmentNotifyHandlerLogger.log(Level.INFO, " ", e);
        }
        return domainNames;
    }
}

