/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.tfa.TFAHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.zoho.framework.utils.crypto.CryptoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class IdentityVerifyHandler {
    public static final Long SQA_VERIFICATION_ID = 1L;
    public static final Long CODE_VERIFICATION_ID = 2L;
    public static final Long AUTHENTICATOR_VERIFICATION_ID = 3L;
    public static final Long DUO_VERIFICATION_ID = 4L;
    public static final Long RSA_VERIFICATION_ID = 5L;
    public static final Long RADIUS_VERIFICATION_ID = 6L;
    public static final Long PN_VERIFICATION_ID = 7L;
    public static final Long FINGER_PRINT_VERIFICATION_ID = 8L;
    public static final Long QR_CODE_VERIFICATION_ID = 9L;
    public static final Long TOTP_VERIFICATION_ID = 10L;
    public static final Long ONE_AUTH_VERIFICATION_ID = 17L;
    public static final int VERIFICATION_CODE_LENGTH = 8;
    public static final Long[] UNSUPPORTED_MFA_METHODS = new Long[]{DUO_VERIFICATION_ID, RSA_VERIFICATION_ID, RADIUS_VERIFICATION_ID};

    public static JSONObject getIdentityDetails(Long policyId, HttpServletRequest request, boolean checkNonSup) {
        JSONObject identDetails = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Criteria cri = new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPVerificationsSettings", cri);
            if (dataObject.isEmpty()) {
                return IdentityVerifyHandler.getDUIdentities(false, rb);
            }
            Iterator iterator = dataObject.getRows("SSPVerificationsSettings");
            Boolean isNativeApp = MobileUtil.isNativeApp(request);
            List<String> nonSupList = MobileUtil.getNonSupportedList(request);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long identId = (Long)row.get("VERIFICATION_ID");
                Long priority = (Long)row.get("PRIORITY");
                JSONObject json = new JSONObject();
                json.put("VERIFICATION_ID", (Object)identId);
                Boolean isMandatory = checkNonSup && nonSupList.contains(String.valueOf(identId)) ? false : (Boolean)row.get("IS_MANDATORY");
                json.put("IS_MANDATORY", (Object)isMandatory);
                json.put("PRIORITY", (Object)priority);
                json.put("VERIFICATION_DISPLAY_NAME", (Object)rb.getString((String)row.get("VERIFICATION_DISPLAY_NAME")));
                identDetails.put(Long.toString(priority), (Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return identDetails;
    }

    public static JSONObject getIdentityDetails(Long policyId, HttpServletRequest request) {
        return IdentityVerifyHandler.getIdentityDetails(policyId, request, true);
    }

    public static JSONObject getQASettings(Long policyId) {
        JSONObject qaSettings = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPQASettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPQASettings", crit);
            Row row = dataObject.getFirstRow("SSPQASettings");
            if (row != null) {
                List columnList = row.getColumns();
                for (int j = 0; j < columnList.size(); ++j) {
                    String column = (String)columnList.get(j);
                    qaSettings.put(column, row.get(column));
                }
                Long totalQe = new Long((Integer)row.get("PRE_DEFINED_QUESTIONS") + (Integer)row.get("USER_DEFINED_QUESTIONS"));
                qaSettings.put("NO_OF_QUES", (Object)totalQe);
            }
            crit = new Criteria(Column.getColumn((String)"SSPSecurity", (String)"POLICY_ID"), (Object)policyId, 0);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPSecurity", crit);
            row = dataObject.getFirstRow("SSPSecurity");
            if (row != null) {
                qaSettings.put("HIDE_ANSWER", row.get("HIDE_ANSWER"));
                qaSettings.put("ENCRYPT_TWO_WAY", row.get("ENCRYPT_TWO_WAY"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return qaSettings;
    }

    public static void setQASettings(HttpServletRequest request) {
        try {
            Long policyId = Long.parseLong(request.getParameter("policyId"));
            Criteria crit = new Criteria(Column.getColumn((String)"SSPQASettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPQASettings", crit);
            Row r = dataObject.getFirstRow("SSPQASettings");
            if (r != null) {
                List columnList = r.getColumns();
                for (int j = 1; j < columnList.size(); ++j) {
                    String value;
                    String column = (String)columnList.get(j);
                    String string = value = request.getParameter(column) != null ? request.getParameter(column) : "-2";
                    if (value == null || value.equals("-2")) continue;
                    String columnType = r.getColumnType(column);
                    Object columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                    r.set(column, columnValue);
                }
                r.set("POLICY_ID", (Object)policyId);
                dataObject.updateRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            crit = new Criteria(Column.getColumn((String)"SSPSecurity", (String)"POLICY_ID"), (Object)policyId, 0);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPSecurity", crit);
            Row row = dataObject.getFirstRow("SSPSecurity");
            if (row != null) {
                Object columnValue;
                String columnType;
                String value;
                String string = value = request.getParameter("HIDE_ANSWER") != null ? request.getParameter("HIDE_ANSWER") : "0";
                if (value != null) {
                    columnType = row.getColumnType("HIDE_ANSWER");
                    columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                    row.set("HIDE_ANSWER", columnValue);
                }
                String string2 = value = request.getParameter("ENCRYPT_TWO_WAY") != null ? request.getParameter("ENCRYPT_TWO_WAY") : "0";
                if (value != null) {
                    columnType = row.getColumnType("ENCRYPT_TWO_WAY");
                    columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                    row.set("ENCRYPT_TWO_WAY", columnValue);
                }
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ArrayList getMandatoryVerifyList(Long policyId) {
        return IdentityVerifyHandler.getMandatoryVerifyList(policyId, null);
    }

    public static ArrayList getMandatoryVerifyList(Long policyId, HttpServletRequest request) {
        return IdentityVerifyHandler.getMandatoryVerifyList(policyId, request, true);
    }

    public static ArrayList getMandatoryVerifyList(Long policyId, HttpServletRequest request, boolean checkNonSupList) {
        ArrayList<Long> identityId = new ArrayList<Long>();
        try {
            List<String> nonSupportedMFAApps = request != null ? MobileUtil.getNonSupportedList(request) : null;
            JSONObject json = APCModuleHandler.getModuleFlagValues(policyId, "ID_VERIFICATIONS");
            String[] ids = new String[]{"SECURITY_QA_AUTH", "VERIFICATION_CODE", "ENABLE_MOBILE_AUTH", "DUO_WEB", "RSA", "RADIUS", "PUSH_NOTIFICATION_AUTH", "FINGER_PRINT_AUTH", "QR_CODE_AUTH", "TOTP_AUTH"};
            Criteria crit = new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"IS_MANDATORY"), (Object)true, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPVerificationsSettings", crit);
            Iterator iterator = dataObject.getRows("SSPVerificationsSettings");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long id = (Long)row.get("VERIFICATION_ID");
                String mfaAppId = ids[(int)(id - 1L)];
                Boolean removeNonSupportedApp = nonSupportedMFAApps != null && checkNonSupList && nonSupportedMFAApps.contains(String.valueOf(id));
                if (!json.get(mfaAppId).equals("1") || removeNonSupportedApp.booleanValue()) continue;
                identityId.add(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return identityId;
    }

    public static void addIDRows(Long policyId) {
        JSONObject identities = new JSONObject();
        try {
            identities = IdentityVerifyHandler.getDUIdentities(true, null);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Long priority = 1L;
            for (int i = 1; i <= identities.length(); ++i) {
                JSONObject json = (JSONObject)identities.get(Integer.toString(i));
                Row row = new Row("SSPVerificationsSettings");
                row.set("POLICY_ID", (Object)policyId);
                row.set("VERIFICATION_ID", json.get("VERIFICATION_ID"));
                row.set("PRIORITY", json.get("PRIORITY"));
                row.set("IS_MANDATORY", (Object)false);
                row.set("VERIFICATION_DISPLAY_NAME", json.get("VERIFICATION_DISPLAY_NAME"));
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getIdentityName(Long identityId) {
        JSONObject identityDetails = new JSONObject();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPIDVerifications", (Criteria)null);
            Iterator iterator = obj.getRows("SSPIDVerifications");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (!identityId.equals((Long)row.get("VERIFICATION_ID"))) continue;
                return (String)row.get("VERIFICATION_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject getDUIdentities(Boolean isKeyNeeded, AdventNetResourceBundle rb) {
        JSONObject identityDetails = new JSONObject();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPIDVerifications", (Criteria)null);
            Iterator iterator = obj.getRows("SSPIDVerifications");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject json = new JSONObject();
                json.put("VERIFICATION_ID", (Object)((Long)row.get("VERIFICATION_ID")));
                json.put("VERIFICATION_DISPLAY_NAME", (Object)((String)row.get("VERIFICATION_DISPLAY_NAME")));
                if (!isKeyNeeded.booleanValue() && rb != null) {
                    json.put("VERIFICATION_DISPLAY_NAME", (Object)rb.getString((String)row.get("VERIFICATION_DISPLAY_NAME")));
                }
                Long priority = (Long)row.get("PRIORITY");
                json.put("PRIORITY", (Object)priority);
                identityDetails.put(Long.toString(priority), (Object)json);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return identityDetails;
    }

    public static void setMandatory(Long policyId, Long verifyId, boolean mandatory) {
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"POLICY_ID"), (Object)policyId, 0);
            cri = cri.and(new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"VERIFICATION_ID"), (Object)verifyId, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPVerificationsSettings", cri);
            Iterator iterator = dataObject.getRows("SSPVerificationsSettings");
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                row.set("IS_MANDATORY", (Object)mandatory);
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setIdentityDetails(Long policyId, JSONObject json) {
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"SSPVerificationsSettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPVerificationsSettings", cri);
            if (dataObject.isEmpty()) {
                IdentityVerifyHandler.addIDRows(policyId);
            }
            Iterator iterator = dataObject.getRows("SSPVerificationsSettings");
            Long priority = (long)json.length() + 1L;
            while (iterator.hasNext()) {
                int i;
                Row row = (Row)iterator.next();
                Long identityId = (Long)row.get("VERIFICATION_ID");
                for (i = 1; i <= json.length(); ++i) {
                    JSONObject jsonObject = (JSONObject)json.get(String.valueOf(i));
                    Long identId = Long.parseLong((String)jsonObject.get("VERIFICATION_ID"));
                    if (!identityId.equals(identId)) continue;
                    Long isMandatory = Long.parseLong((String)jsonObject.get("IS_MANDATORY"));
                    row.set("PRIORITY", (Object)new Long(i));
                    row.set("IS_MANDATORY", (Object)isMandatory);
                    break;
                }
                if (i > json.length()) {
                    row.set("PRIORITY", (Object)priority);
                    row.set("IS_MANDATORY", (Object)false);
                    Long l = priority;
                    Long l2 = priority = Long.valueOf(priority + 1L);
                }
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getVerificationCodeLength() {
        int vcLength = 8;
        try {
            String vcLengthStr = ADSMPersUtil.getSyMParameter("VERIFICATION_CODE_LENGTH");
            if (vcLengthStr != null && !vcLengthStr.equals("")) {
                vcLength = Integer.parseInt(vcLengthStr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return vcLength;
    }

    public static String generateVerificationCode(HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        return StrUtil.generateUniqueCode(IdentityVerifyHandler.getVerificationCodeLength(), rb.getString("adssp.common.verification.code"));
    }

    public static Boolean setMFAProviderServerSettings(HttpServletRequest request, ArrayList modifiedModes) {
        Boolean result = false;
        try {
            ArrayList<Long> modeIds = new ArrayList<Long>();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Criteria c = new Criteria(Column.getColumn((String)"SSPTFAProviderModes", (String)"MODE_NAME"), (Object)modifiedModes.toArray(new String[modifiedModes.size()]), 8);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get(Arrays.asList("SSPTFAProviderModes", "SSPTFAModeParams"), Arrays.asList("SSPTFAModeParams"), (Criteria)null);
            Iterator it = dobj.getRows("SSPTFAProviderModes", c);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                modeIds.add((Long)r.get("MODE_ID"));
                String modeName = (String)r.get("MODE_NAME");
                if ("DUOWEB".equals(modeName)) {
                    try {
                        TFAHandler.isValidDuoWebKey(request.getParameter("I_KEY"), request.getParameter("S_KEY"), request.getParameter("API_HOST_NAME"));
                    }
                    catch (Exception e) {
                        request.setAttribute("statusMessage", (Object)rb.getString(e.getMessage()));
                        request.setAttribute("messageType", (Object)"error");
                        return false;
                    }
                }
                if (!"RADIUS".equals(modeName)) continue;
                try {
                    Boolean radiusStatus = TFAHandler.isValidRadiusServer(request.getParameter("SERVER_NAME"), request.getParameter("SERVER_PORT"), request.getParameter("SERVER_SECRET"), request.getParameter("SERVER_PROTOCOL"), request.getParameter("TIME_OUT"));
                    if (radiusStatus.booleanValue()) continue;
                    request.setAttribute("statusMessage", (Object)rb.getString("adssp.admin.tfa.radius_server_invalid"));
                    request.setAttribute("messageType", (Object)"error");
                    return false;
                }
                catch (Exception e) {
                    request.setAttribute("statusMessage", (Object)rb.getString(e.getMessage()));
                    request.setAttribute("messageType", (Object)"error");
                    return false;
                }
            }
            Criteria modeCriteria = new Criteria(Column.getColumn((String)"SSPTFAModeParams", (String)"MODE_ID"), (Object)modeIds.toArray(new Long[modeIds.size()]), 8);
            Iterator paramIterator = dobj.getRows("SSPTFAModeParams", modeCriteria);
            while (paramIterator.hasNext()) {
                Row paramRow = (Row)paramIterator.next();
                String paramName = (String)paramRow.get("PARAM_NAME");
                if (request.getParameter(paramName) == null) continue;
                String paramValue = request.getParameter(paramName);
                if ("S_KEY".equals(paramName)) {
                    paramValue = CryptoUtil.encrypt((String)paramValue);
                }
                paramRow.set("PARAM_VALUE", (Object)paramValue);
                dobj.updateRow(paramRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dobj);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

