/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class PPEHandler {
    private static Logger logger = Logger.getLogger(PPEHandler.class.getName());
    private static final String ENCRYPT_TYPE = "SHA-512";
    public static final int MAX_PASSWORDS = 24;

    public static String getPwdPolicyForAgent(Long policyId) {
        try {
            String[] forceLevel = new String[]{"2", "3", "6", "7"};
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)forceLevel, 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", criteria);
            if (obj.isEmpty()) {
                return null;
            }
            if (!PPEHandler.isRPOrCPPermitted(policyId)) {
                return null;
            }
            Row r = obj.getFirstRow("SSPPasswordPolicy");
            StringBuilder sb = new StringBuilder();
            List columnList = r.getColumns();
            for (int j = 0; j < columnList.size(); ++j) {
                String column = (String)columnList.get(j);
                String value = r.get(column) != null ? r.get(column).toString() : "";
                sb.append(column);
                sb.append("=");
                sb.append(value);
                sb.append("||");
            }
            String str = PPEHandler.addDictFileLastModified(sb);
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getPwdPolicy(Long policyId, String requestFrom) {
        try {
            String[] forceLevel = requestFrom.equals("GinaOrAgent") ? new String[]{"2", "3", "6", "7"} : (requestFrom.equals("Mobile") ? new String[]{"1", "3", "5", "7"} : new String[]{"4", "5", "6", "7"});
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)forceLevel, 8);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", criteria);
            if (obj.isEmpty()) {
                return null;
            }
            Row r = obj.getFirstRow("SSPPasswordPolicy");
            JSONObject json = new JSONObject();
            List columnList = r.getColumns();
            for (int j = 0; j < columnList.size(); ++j) {
                String column = (String)columnList.get(j);
                String value = r.get(column) != null ? r.get(column).toString() : "";
                json.put(column, (Object)value);
            }
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject savePPEValues(Hashtable ppeValues) {
        JSONObject resultJSON = new JSONObject();
        try {
            String min = (String)ppeValues.get("min");
            String max = (String)ppeValues.get("max");
            String spl = (String)ppeValues.get("spl");
            String alpha = (String)ppeValues.get("alpha");
            String mixed = (String)ppeValues.get("mixed");
            String num = (String)ppeValues.get("num");
            String pal = (String)ppeValues.get("pal");
            String rep_char = (String)ppeValues.get("rep_char");
            String char_from_name = (String)ppeValues.get("char_from_name");
            String excluded = (String)ppeValues.get("excluded");
            String ginaEnforce = (String)ppeValues.get("ginaEnforce");
            String webEnforce = (String)ppeValues.get("webEnforce");
            String mobileEnforce = (String)ppeValues.get("mobileEnforce");
            String pLevel = (String)ppeValues.get("pLevel");
            String policyId = (String)ppeValues.get("policyId");
            String showOrHide = (String)ppeValues.get("showOrHide");
            String minNoOfCond = (String)ppeValues.get("minNoOfCond");
            String passPhMin = (String)ppeValues.get("passPhMin");
            String unicodeChars = (String)ppeValues.get("unicodeChars");
            String incremental = (String)ppeValues.get("incremental");
            String dict = (String)ppeValues.get("dict");
            String dictCheckType = (String)ppeValues.get("dictCheckType");
            String pwdHistory = (String)ppeValues.get("pwdHistory");
            Criteria c = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0);
            c = c.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)"0", 1));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", c);
            if (!dataobject.isEmpty()) {
                Row row = dataobject.getFirstRow("SSPPasswordPolicy");
                row.set("FORCE_LEVEL", (Object)"0");
                dataobject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataobject);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"LEVEL_NAME"), (Object)pLevel, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", crit);
            Row r = obj.getFirstRow("SSPPasswordPolicy");
            if (pLevel.equals("Custom")) {
                r.set("MIN_LEN", (Object)Long.parseLong(min));
                r.set("MAX_LEN", (Object)Long.parseLong(max));
                r.set("NO_OF_SPL_CHARS", (Object)Long.parseLong(spl));
                r.set("START_WITH_ALPHA", (Object)alpha);
                r.set("MIXED_CASE", (Object)mixed);
                r.set("NUMERAL_REQ", (Object)Long.parseLong(num));
                r.set("PALINDROME_REQ", (Object)pal);
                r.set("PREVENT_REPEATED_CHARS", (Object)rep_char);
                r.set("PREVENT_CHARS_FRM_NAME", (Object)char_from_name);
                r.set("EXCLUDED_WORDS", (Object)excluded);
                r.set("SHOW_POLICY_REQUIREMENTS", (Object)Long.valueOf(showOrHide));
                r.set("MIN_REQUIREMENTS", (Object)Long.valueOf(minNoOfCond));
                r.set("PASS_PHRASE_LENGTH", (Object)Long.valueOf(passPhMin));
                r.set("UNICODE_CHARS", (Object)Long.valueOf(unicodeChars));
                r.set("INCREMENTAL_PWD", (Object)Long.valueOf(incremental));
                r.set("DICTIONARY", (Object)dict);
                r.set("DICT_WORDS_CONTAINS", (Object)dictCheckType);
                r.set("PASSWORD_HISTORY", (Object)pwdHistory);
            }
            r.set("FORCE_LEVEL", (Object)(webEnforce + ginaEnforce + mobileEnforce));
            String s = webEnforce + ginaEnforce + mobileEnforce;
            int force = Integer.parseInt(s, 2);
            r.set("FORCE_LEVEL", (Object)Integer.toString(force));
            obj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            resultJSON.put("result", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultJSON;
    }

    public static JSONObject savePPECustomMsg(Hashtable customMsg, JSONObject priority) {
        JSONObject resultJSON = new JSONObject();
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"SSPPPECustomizedRules", (String)"POLICY_ID"), (Object)Long.parseLong(priority.getString("pID")), 0);
            DataObject dataobj = CommonUtil.getPersistence(new boolean[0]).get("SSPPPECustomizedRules", cri);
            DataObject data_object = CommonUtil.getPersistence(new boolean[0]).get("SSPPPECustomizedRules", cri);
            String[] platforms = new String[]{"WEB", "MOB", "GINA"};
            String[] ruleNames = new String[]{"MIN_LEN", "MAX_LEN", "NO_OF_SPL_CHARS", "START_WITH_ALPHA", "MIXED_CASE", "NUMERAL_REQ", "PALINDROME_REQ", "PREVENT_REPEATED_CHARS", "PREVENT_CHARS_FRM_NAME", "EXCLUDED_WORDS", "INCREMENTAL_PWD", "UNICODE_CHARS", "DICTIONARY", "PASS_PHRASE_LENGTH"};
            String[][] priorityNames = new String[][]{{"minW", "maxW", "splW", "startWithAlphaW", "mixedCaseW", "numW", "palW", "repCharW", "charFrmNameW", "excWordsW", "incW", "unicW", "dictW", "passPhW"}, {"minM", "maxM", "splM", "startWithAlphaM", "mixedCaseM", "numM", "palM", "repCharM", "charFrmNameM", "excWordsM", "incM", "unicM", "dictM", "passPhM"}, {"minG", "maxG", "splG", "startWithAlphaG", "mixedCaseG", "numG", "palG", "repCharG", "charFrmNameG", "excWordsG", "incG", "unicG", "dictG", "passPhG"}};
            String[][] custMsgNames = new String[][]{{"minWeb", "maxWeb", "splWeb", "alphaWeb", "mixedWeb", "numWeb", "palWeb", "rep_charWeb", "char_from_nameWeb", "excludedWeb", "incWeb", "unicWeb", "dictWeb", "passPhWeb"}, {"minMob", "maxMob", "splMob", "alphaMob", "mixedMob", "numMob", "palMob", "rep_charMob", "char_from_nameMob", "excludedMob", "incMob", "unicMob", "dictMob", "passPhMob"}, {"minGina", "maxGina", "splGina", "alphaGina", "mixedGina", "numGina", "palGina", "rep_charGina", "char_from_nameGina", "excludedGina", "incGina", "unicGina", "dictGina", "passPhGina"}};
            boolean flag = false;
            for (int i = 0; i < platforms.length; ++i) {
                for (int j = 0; j < ruleNames.length; ++j) {
                    Criteria criteria = new Criteria(Column.getColumn((String)"SSPPPECustomizedRules", (String)"POLICY_ID"), (Object)Long.parseLong(priority.getString("pID")), 0);
                    criteria = criteria.and(Column.getColumn((String)"SSPPPECustomizedRules", (String)"PLATFORM"), (Object)platforms[i], 0);
                    Row row = dataobj.getRow("SSPPPECustomizedRules", criteria = criteria.and(Column.getColumn((String)"SSPPPECustomizedRules", (String)"RULE_NAME"), (Object)ruleNames[j], 0));
                    if (row == null) {
                        row = new Row("SSPPPECustomizedRules");
                        flag = true;
                    }
                    row.set("PLATFORM", (Object)platforms[i]);
                    row.set("RULE_NAME", (Object)ruleNames[j]);
                    row.set("POLICY_ID", (Object)Long.parseLong(priority.getString("pID")));
                    if ("" != customMsg.get(custMsgNames[i][j]) && customMsg.get(custMsgNames[i][j]) != null) {
                        row.set("RULE_VALUE", customMsg.get(custMsgNames[i][j]));
                    }
                    row.set("PRIORITY", (Object)priority.getString(priorityNames[i][j]));
                    if (flag) {
                        flag = false;
                        data_object.addRow(row);
                        continue;
                    }
                    data_object.updateRow(row);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).update(data_object);
            resultJSON.put("result", (Object)"success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultJSON;
    }

    public static int getEnforcedPolicyCount() {
        try {
            Criteria ct = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)new String[]{"0", "1"}, 9);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", ct);
            return dObj.size("SSPPasswordPolicy");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static Hashtable getPwdPolCustomText(Long policyId, String platform) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Hashtable<String, String> h = new Hashtable<String, String>();
        try {
            String[] platforms = new String[]{};
            if (platform.equals("ALL")) {
                platforms = new String[]{"WEB", "MOB", "GINA"};
            } else if (platform.equals("GINA")) {
                platforms = new String[]{"GINA"};
            } else if (platform.equals("WEB")) {
                platforms = new String[]{"WEB"};
            } else if (platform.equals("MOB")) {
                platforms = new String[]{"MOB"};
            }
            String[] ruleNames = new String[]{"MIN_LEN", "MAX_LEN", "NO_OF_SPL_CHARS", "START_WITH_ALPHA", "MIXED_CASE", "NUMERAL_REQ", "PALINDROME_REQ", "PREVENT_REPEATED_CHARS", "PREVENT_CHARS_FRM_NAME", "EXCLUDED_WORDS", "INCREMENTAL_PWD", "DICTIONARY", "UNICODE_CHARS", "PASS_PHRASE_LENGTH"};
            Criteria cri = new Criteria(Column.getColumn((String)"SSPPPECustomizedRules", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataobj = CommonUtil.getPersistence(new boolean[0]).get("SSPPPECustomizedRules", cri);
            DataObject data_object = CommonUtil.getPersistence(new boolean[0]).get("SSPPPEDefaultRules", (Criteria)null);
            for (int k = 0; k < platforms.length; ++k) {
                for (int l = 0; l < ruleNames.length; ++l) {
                    Row row;
                    Criteria criteria;
                    if (!dataobj.isEmpty()) {
                        String pri;
                        String ruleValue;
                        criteria = new Criteria(Column.getColumn((String)"SSPPPECustomizedRules", (String)"POLICY_ID"), (Object)policyId, 0);
                        criteria = criteria.and(Column.getColumn((String)"SSPPPECustomizedRules", (String)"PLATFORM"), (Object)platforms[k], 0);
                        row = dataobj.getRow("SSPPPECustomizedRules", criteria = criteria.and(Column.getColumn((String)"SSPPPECustomizedRules", (String)"RULE_NAME"), (Object)ruleNames[l], 0));
                        if (row != null && row.get("RULE_VALUE") != null) {
                            ruleValue = (String)row.get("RULE_VALUE");
                            pri = (String)row.get("PRIORITY");
                        } else {
                            Criteria criteria1 = new Criteria(Column.getColumn((String)"SSPPPEDefaultRules", (String)"PLATFORM"), (Object)platforms[k], 0);
                            criteria1 = criteria1.and(Column.getColumn((String)"SSPPPEDefaultRules", (String)"RULE_NAME"), (Object)ruleNames[l], 0);
                            Row row1 = data_object.getRow("SSPPPEDefaultRules", criteria1);
                            ruleValue = rb.getString((String)row1.get("RULE_VALUE"));
                            pri = "-1";
                        }
                        h.put(ruleNames[l] + "_" + platforms[k], ruleValue);
                        h.put(ruleNames[l] + "_POS_" + platforms[k].substring(0, 1), pri);
                        continue;
                    }
                    criteria = new Criteria(Column.getColumn((String)"SSPPPEDefaultRules", (String)"PLATFORM"), (Object)platforms[k], 0);
                    criteria = criteria.and(Column.getColumn((String)"SSPPPEDefaultRules", (String)"RULE_NAME"), (Object)ruleNames[l], 0);
                    row = data_object.getRow("SSPPPEDefaultRules", criteria);
                    h.put(ruleNames[l] + "_" + platforms[k], rb.getString((String)row.get("RULE_VALUE")));
                    h.put(ruleNames[l] + "_POS_" + platforms[k].substring(0, 1), (String)row.get("PRIORITY"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }

    public static boolean isPwdPolicyEnabled(String domainDnsName) {
        try {
            String domainName = DomainHandler.getDomainDetails(domainDnsName).getString("DOMAIN_NAME");
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            if (!dObj.isEmpty()) {
                ArrayList<Long> policyIds = new ArrayList<Long>();
                Iterator it = dObj.getRows("PolicyConfiguration");
                while (it.hasNext()) {
                    policyIds.add((Long)((Row)it.next()).get("POLICY_ID"));
                }
                Long[] arr = new Long[policyIds.size()];
                policyIds.toArray(arr);
                crit = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)arr, 8);
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"LEVEL_NAME"), (Object)"Custom", 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)"7", 0));
                dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", crit);
                if (!dObj.isEmpty()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ArrayList getDictFiles() {
        ArrayList<String> dictFiles = new ArrayList<String>();
        String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
        File folder = new File(dictDir);
        File[] listOfFiles = folder.listFiles();
        for (int i = 0; i < listOfFiles.length; ++i) {
            dictFiles.add(listOfFiles[i].getName());
        }
        return dictFiles;
    }

    public static String getDictFilesForSyncAgent(String domainName, String dictNeeded) {
        String dictonaries = "";
        ArrayList dictFiles = new ArrayList();
        String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
        ArrayList policyIds = PolicyHandler.getAllPolicyIdsForDomain(domainName);
        try {
            File folder = new File(dictDir);
            File[] listOfFiles = folder.listFiles();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < listOfFiles.length; ++i) {
                String[] temp = listOfFiles[i].toString().split("\\\\");
                String dictFileName = temp[temp.length - 1];
                String dic = dictFileName.substring(0, dictFileName.length() - 4);
                dic = dic.substring(dic.lastIndexOf("_") + 1);
                if ((!dictNeeded.equals("-1") || !dictFileName.equals("defaultDictionary.txt") && !policyIds.contains(Long.parseLong(dic))) && (dictNeeded == "-1" || !dictFileName.equals(dictNeeded))) continue;
                BufferedReader br = new BufferedReader(new FileReader(listOfFiles[i]));
                sb.append("***START_OF_DICTIONARY***\n");
                sb.append(dictFileName);
                sb.append("===");
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                sb.append("***END_OF_DICTIONARY***\n");
                br.close();
            }
            dictonaries = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dictonaries;
    }

    public static String getDictWords(JSONObject fields) {
        StringBuilder sb = new StringBuilder();
        String words = "";
        try {
            String[] dictFilesArray;
            String dictFiles = fields.getString("DICTIONARY_Custom");
            if (dictFiles.equals("-1")) {
                return "";
            }
            for (String dictFile : dictFilesArray = dictFiles.split(",")) {
                String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
                String fileName = dictDir + dictFile;
                BufferedReader br = new BufferedReader(new FileReader(fileName));
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("||");
                    line = br.readLine();
                }
                br.close();
            }
            words = sb.toString();
            words = words.replaceAll("\\\\", "\\\\\\\\");
            words = words.replaceAll("\\\"", "\\\\\\\"");
            words = words.replaceAll(",$", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return words;
    }

    public static String getDictWordsFor(String dictName) {
        JSONObject dict = new JSONObject();
        String words = "";
        try {
            dict.put("DICTIONARY_Custom", (Object)dictName);
            words = PPEHandler.getDictWords(dict);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return words;
    }

    public static void deleteDict(String dictToDelete) {
        try {
            String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
            File file = new File(dictDir + dictToDelete);
            file.delete();
            Criteria criteria = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"DICTIONARY"), (Object)dictToDelete, 12);
            String dict = null;
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", criteria);
            Iterator it = dObj.getRows("SSPPasswordPolicy");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                dict = (String)row.get("DICTIONARY");
                if (dict.equals(dictToDelete)) {
                    row.set("DICTIONARY", (Object)"-1");
                } else if (dict.contains("," + dictToDelete + ",")) {
                    row.set("DICTIONARY", (Object)dict.replaceAll("," + dictToDelete + ",", ","));
                } else if (dict.startsWith(dictToDelete + ",")) {
                    row.set("DICTIONARY", (Object)dict.replaceAll(dictToDelete + ",", ""));
                } else if (dict.endsWith("," + dictToDelete)) {
                    row.set("DICTIONARY", (Object)dict.substring(0, dict.length() - (dictToDelete.length() + 1)));
                }
                dObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String addDictFileLastModified(StringBuilder sb) {
        String str = sb.toString();
        String dictName = str.substring(str.indexOf("DICTIONARY="));
        dictName = dictName.substring(str.indexOf("=") + 2);
        if ((dictName = dictName.substring(0, dictName.indexOf("||"))).equals("-1")) {
            return str;
        }
        String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
        File file = new File(dictDir + "\\" + dictName);
        Long lastUpdatedTimeLong = file.lastModified();
        String lastUpdatedTime = Long.toString(lastUpdatedTimeLong);
        str = str + "DICTIONARY_UPDATED_TIME=" + lastUpdatedTime + "||";
        return str;
    }

    public static void deleteAllDictsForPolicy(Long policyId) {
        String dictDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator + "resources" + File.separator + "dictionaries" + File.separator;
        try {
            File folder = new File(dictDir);
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                String[] temp = listOfFiles[i].toString().split("\\\\");
                String dictFileName = temp[temp.length - 1];
                String dic = dictFileName.substring(0, dictFileName.length() - 4);
                if (!(dic = dic.substring(dic.lastIndexOf("_") + 1)).equals(Long.toString(policyId))) continue;
                listOfFiles[i].delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteAllDictsForDomain(String domainName) {
        try {
            ArrayList dictFiles = new ArrayList();
            ArrayList policyIds = PolicyHandler.getAllPolicyIdsForDomain(domainName);
            for (int i = 0; i < policyIds.size(); ++i) {
                PPEHandler.deleteAllDictsForPolicy((Long)policyIds.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRPOrCPPermitted(Long policyId) {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("RESET_PASSWORD");
        columnNames.add("CHANGE_PASSWORD");
        Hashtable result = APCUtil.getRequiredPCValues(policyId, columnNames, "PolicyConfiguration");
        return ((String)result.get("RESET_PASSWORD")).equals("true") || ((String)result.get("CHANGE_PASSWORD")).equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePasswordHistory(Long loginId, String password, Long policyId) {
        Connection connection = null;
        try {
            Row row;
            boolean isPasswordAvailable = false;
            Long addedTime = System.currentTimeMillis();
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"LEVEL_NAME"), (Object)"Custom", 0));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", crit);
            Long isPHEnabled = 0L;
            if (!dObj.isEmpty() && (isPHEnabled = (Long)(row = dObj.getFirstRow("SSPPasswordPolicy")).get("PASSWORD_HISTORY")) != 0L) {
                String encPassword;
                int rowsCount = 0;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPUserCredentials"));
                crit = new Criteria(Column.getColumn((String)"SSPUserCredentials", (String)"LOGIN_ID"), (Object)loginId, 0);
                sq.setCriteria(crit);
                Column col = new Column("SSPUserCredentials", "UNIQUE_ID").count();
                sq.addSelectColumn(col);
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
                while (dataSet.next()) {
                    rowsCount = (Integer)dataSet.getValue(1);
                }
                dataSet.close();
                dObj = PPEHandler.getPasswordList(loginId, false);
                if (!dObj.isEmpty() && (encPassword = AuthUtil.getEncryptedPassword((String)password, (String)String.valueOf((row = dObj.getFirstRow("SSPUserCredentials")).get("ADDED_TIME")), (String)ENCRYPT_TYPE)).equals((String)row.get("CRYPTED_PASSWORD"))) {
                    isPasswordAvailable = true;
                }
                if (!isPasswordAvailable) {
                    if (rowsCount >= 24) {
                        dObj = PPEHandler.getPasswordList(loginId, true);
                        row = dObj.getFirstRow("SSPUserCredentials");
                        Long oldValue = (Long)row.get("UNIQUE_ID");
                        crit = new Criteria(Column.getColumn((String)"SSPUserCredentials", (String)"UNIQUE_ID"), (Object)oldValue, 0);
                        CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    }
                    row = new Row("SSPUserCredentials");
                    row.set("LOGIN_ID", (Object)loginId);
                    row.set("CRYPTED_PASSWORD", (Object)AuthUtil.getEncryptedPassword((String)password, (String)String.valueOf(addedTime), (String)ENCRYPT_TYPE));
                    row.set("ADDED_TIME", (Object)addedTime);
                    dObj.addRow(row);
                    logger.log(Level.INFO, "Password updated for checking history requirements for loginId-" + loginId);
                    CommonUtil.getPersistenceLite().update(dObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static DataObject getPasswordList(Long loginId, boolean sortOrder) {
        DataObject dObj = null;
        try {
            Criteria cri = new Criteria(Column.getColumn((String)"SSPUserCredentials", (String)"LOGIN_ID"), (Object)loginId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPUserCredentials"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserCredentials", (String)"UNIQUE_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserCredentials", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserCredentials", (String)"CRYPTED_PASSWORD"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserCredentials", (String)"ADDED_TIME"));
            sq.setCriteria(cri);
            sq.addSortColumn(new SortColumn("SSPUserCredentials", "ADDED_TIME", sortOrder));
            dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dObj;
    }

    public static boolean isPHSatisfied(Long policyId, Long loginId, String password) {
        logger.log(Level.INFO, "Password Reset history checking for loginId-" + loginId);
        try {
            DataObject obj;
            Row r;
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"LEVEL_NAME"), (Object)"Custom", 0));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", crit);
            Long isPHEnabled = 0L;
            if (!dObj.isEmpty() && (isPHEnabled = (Long)(r = dObj.getFirstRow("SSPPasswordPolicy")).get("PASSWORD_HISTORY")) > 0L && !(obj = PPEHandler.getPasswordList(loginId, false)).isEmpty()) {
                Iterator it = obj.getRows("SSPUserCredentials");
                int i = 0;
                while ((long)i < isPHEnabled && it.hasNext()) {
                    Row row = (Row)it.next();
                    String encPassword = AuthUtil.getEncryptedPassword((String)password, (String)String.valueOf(row.get("ADDED_TIME")), (String)ENCRYPT_TYPE);
                    if (encPassword.equals((String)row.get("CRYPTED_PASSWORD"))) {
                        logger.log(Level.INFO, "Password Reset failed. Password history requirements does not match for loginId-" + loginId);
                        return false;
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static int getEnforcedInGinaPolicyCount() {
        try {
            Criteria ct = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"FORCE_LEVEL"), (Object)"7", 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", ct);
            return dObj.size("SSPPasswordPolicy");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getShowPolicyEnabledCount() {
        try {
            Criteria ct = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"SHOW_POLICY_REQUIREMENTS"), (Object)"1", 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", ct);
            return dObj.size("SSPPasswordPolicy");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getPasswordHistoryEnabledCount() {
        try {
            Criteria ct = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"PASSWORD_HISTORY"), (Object)"0", 1);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPasswordPolicy", ct);
            return dObj.size("SSPPasswordPolicy");
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getRating(String userName, String pwd, String oldPwd, JSONObject fields) throws Exception {
        if (PPEHandler.isStrongPwd(userName, pwd, oldPwd, fields)) {
            return 3;
        }
        if (PPEHandler.isSatisfied(userName, pwd, oldPwd, "Good", fields)) {
            return 2;
        }
        return 1;
    }

    public static boolean isStrongPwd(String userName, String pwd, String oldPwd, JSONObject fields) throws Exception {
        String finalLevel = "Strong";
        String isCusSel = (String)fields.get("FORCE_LEVEL_Custom");
        if (!isCusSel.equals("0")) {
            finalLevel = "Custom";
        }
        return PPEHandler.isSatisfied(userName, pwd, oldPwd, finalLevel, fields);
    }

    public static boolean isSatisfied(String userName, String pwd, String oldPwd, String level, JSONObject fields) throws Exception {
        String[] pPAs = new String[]{"MIN_LEN", "MAX_LEN", "NO_OF_SPL_CHARS", "EXCLUDED_WORDS", "START_WITH_ALPHA", "MIXED_CASE", "NUMERAL_REQ", "PALINDROME_REQ", "PREVENT_REPEATED_CHARS", "PREVENT_CHARS_FRM_NAME", "DICTIONARY", "UNICODE_CHARS", "INCREMENTAL_PWD", "PASSWORD_HISTORY"};
        long lower = 0L;
        long upper = 0L;
        long num = 0L;
        long spl = 0L;
        long unic = 0L;
        JSONObject charCount = PPEHandler.setCNSCount(pwd);
        lower = (Long)charCount.get("lower");
        upper = (Long)charCount.get("upper");
        num = (Long)charCount.get("numbers");
        unic = (Long)charCount.get("unicode");
        spl = (Long)charCount.get("specialchars");
        level = "_" + level;
        int ind = 0;
        long minLen = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long maxLen = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long noOfSplCh = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        String exWords = (String)fields.get(pPAs[ind++] + level);
        long isStWAlpha = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long isMixedCase = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long isNumReq = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long isPalAva = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long isPreRepCh = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long isPreChFName = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long passPhMinLen = Long.parseLong((String)fields.get("PASS_PHRASE_LENGTH" + level));
        String dict = (String)fields.get(pPAs[ind++] + level);
        long unicodeChars = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long incremental = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long pwdHistory = Long.parseLong((String)fields.get(pPAs[ind++] + level));
        long noOfCond = Long.parseLong((String)fields.get("MIN_REQUIREMENTS_Custom"));
        if (passPhMinLen <= (long)pwd.length() && passPhMinLen != 0L) {
            return true;
        }
        return !((long)pwd.length() < minLen || maxLen != -1L && (long)pwd.length() > maxLen || spl < noOfSplCh || !exWords.equals("") && PPEHandler.isExWordsAva(pwd, exWords) || isStWAlpha == 1L && !PPEHandler.isPwdStWAlpha(pwd) || isMixedCase == 1L && !PPEHandler.isConMixedCase(pwd, lower, upper) || isNumReq != 0L && num < isNumReq || isPalAva == 1L && PPEHandler.isPalindrome(pwd) || isPreRepCh == 1L && PPEHandler.isCharsRepeated(pwd) || isPreChFName == 1L && PPEHandler.isCharsAvaFrmUN(userName, pwd) || unicodeChars != 0L && unic <= 0L) && (incremental == 0L || !PPEHandler.isCharsAvaFrmUN(oldPwd, pwd));
    }

    public static JSONObject validatePasswordPolicy(long policyId, String pwd, String oldPwd, String loginName) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject condresult = new JSONObject();
        try {
            boolean passPhMinLenFlag = false;
            boolean isForcedFlag = false;
            int rating = 1;
            String[] pPAs = new String[]{"MIN_LEN", "MAX_LEN", "NO_OF_SPL_CHARS", "EXCLUDED_WORDS", "START_WITH_ALPHA", "MIXED_CASE", "NUMERAL_REQ", "PALINDROME_REQ", "PREVENT_REPEATED_CHARS", "PREVENT_CHARS_FRM_NAME", "DICTIONARY", "UNICODE_CHARS", "INCREMENTAL_PWD", "PASSWORD_HISTORY"};
            JSONObject fields = new JSONObject();
            String forcedLevel = AdvancedPolicyHandler.getPasswordPolicy(policyId, fields);
            String[] conditionsForced = new String[]{"(minLen!=0)", "(maxLen !=-1)", "(noOfSplCh!=0)", "(exWords !='')", "(isStWAlpha == '1')", "(isMixedCase == '1')", "(isNumReq != 0)", "(isPalAva == '1' )", "(isPreRepCh == '1')", "(isPreChFName == '1' )", "(dict!='-1')", "(unicodeChars!='0')", "(incremental!='0')", "pwdHistory!='0'"};
            String[] conditions = new String[]{"(pwd.length < minLen)", "(maxLen !=-1 && pwd.length > maxLen)", "(spl < noOfSplCh)", "(exWords !='' && isExWordsAva(pwd, exWords))", "(isStWAlpha == '1' && !isPwdStWAlpha(pwd))", "(isMixedCase == '1' && !isConMixedCase(pwd,lower,upper))", "(isNumReq != 0 && num < isNumReq)", "(isPalAva == '1' && isPalindrome(pwd))", "(isPreRepCh == '1' && isCharsRepeated(pwd))", "(isPreChFName == '1' && isCharsAvaFrmUN(userName, pwd))", "(dict!='-1' && dictCheck(pwd,fields))", "(unicodeChars!='0' && unic<=0)", "(incremental != '0' && isCharsAvaFrmUN(oldPwd, pwd))", "false"};
            long lower = 0L;
            long upper = 0L;
            long num = 0L;
            long spl = 0L;
            long unic = 0L;
            JSONObject charCount = PPEHandler.setCNSCount(pwd);
            lower = (Long)charCount.get("lower");
            upper = (Long)charCount.get("upper");
            num = (Long)charCount.get("numbers");
            unic = (Long)charCount.get("unicode");
            spl = (Long)charCount.get("specialchars");
            boolean isFailed = false;
            String[] levels = new String[]{"Custom", "Strong", "Good", "Weak", "Too Short"};
            for (int l = 0; l < levels.length; ++l) {
                String level = levels[l];
                long isForced = Long.parseLong((String)fields.get("FORCE_LEVEL_" + level));
                if (isForced == 0L) continue;
                isForcedFlag = true;
                level = "_" + level;
                int ind = 0;
                long minLen = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long maxLen = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long noOfSplCh = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                String exWords = (String)fields.get(pPAs[ind++] + level);
                long isStWAlpha = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long isMixedCase = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long isNumReq = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long isPalAva = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long isPreRepCh = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long isPreChFName = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long passPhMinLen = Long.parseLong((String)fields.get("PASS_PHRASE_LENGTH_Custom"));
                String dict = (String)fields.get(pPAs[ind++] + level);
                long unicodeChars = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long incremental = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long pwdHistory = Long.parseLong((String)fields.get(pPAs[ind++] + level));
                long noOfCond = Long.parseLong((String)fields.get("MIN_REQUIREMENTS_Custom"));
                long condCount = 0L;
                long flag = 0L;
                long splflag = 0L;
                boolean splRule = false;
                if (passPhMinLen <= (long)pwd.length() && passPhMinLen != 0L) {
                    condresult.put("passPhMinLen", 1);
                    passPhMinLenFlag = true;
                } else {
                    condresult.put("passPhMinLen", 0);
                }
                if (minLen != 0L) {
                    if ((long)pwd.length() >= minLen) {
                        ++condCount;
                        condresult.put("minLen", 1);
                    } else {
                        ++flag;
                        condresult.put("minLen", 0);
                    }
                }
                if (maxLen != -1L) {
                    if (maxLen != -1L && (long)pwd.length() <= maxLen) {
                        ++condCount;
                        condresult.put("maxLen", 1);
                    } else {
                        ++flag;
                        condresult.put("maxLen", 0);
                    }
                }
                if (noOfSplCh != 0L) {
                    if (spl >= noOfSplCh) {
                        ++condCount;
                        condresult.put("noOfSplCh", 1);
                    } else {
                        ++flag;
                        condresult.put("noOfSplCh", 0);
                    }
                }
                if (!exWords.equals("")) {
                    if (!exWords.equals("") && !PPEHandler.isExWordsAva(pwd, exWords)) {
                        condresult.put("exWords", 1);
                    } else {
                        splRule = true;
                        condresult.put("exWords", 0);
                    }
                }
                if (isStWAlpha == 1L) {
                    if (isStWAlpha == 1L && PPEHandler.isPwdStWAlpha(pwd)) {
                        ++condCount;
                        condresult.put("isStWAlpha", 1);
                    } else {
                        ++flag;
                        condresult.put("isStWAlpha", 0);
                    }
                }
                if (isMixedCase == 1L) {
                    if (isMixedCase == 1L && PPEHandler.isConMixedCase(pwd, lower, upper)) {
                        ++condCount;
                        condresult.put("isMixedCase", 1);
                    } else {
                        ++flag;
                        condresult.put("isMixedCase", 0);
                    }
                }
                if (isNumReq != 0L) {
                    if (isNumReq != 0L && num >= isNumReq) {
                        ++condCount;
                        condresult.put("isNumReq", 1);
                    } else {
                        ++flag;
                        condresult.put("isNumReq", 0);
                    }
                }
                if (isPalAva == 1L) {
                    if (isPalAva == 1L && !PPEHandler.isPalindrome(pwd)) {
                        ++condCount;
                        condresult.put("isPalAva", 1);
                    } else {
                        ++flag;
                        condresult.put("isPalAva", 0);
                    }
                }
                if (isPreRepCh == 1L) {
                    if (isPreRepCh == 1L && !PPEHandler.isCharsRepeated(pwd)) {
                        ++condCount;
                        condresult.put("isPreRepCh", 1);
                    } else {
                        ++flag;
                        condresult.put("isPreRepCh", 0);
                    }
                }
                if (isPreChFName == 1L) {
                    if (isPreChFName == 1L && !PPEHandler.isCharsAvaFrmUN(loginName, pwd)) {
                        ++condCount;
                        condresult.put("isPreChFName", 1);
                    } else {
                        ++flag;
                        condresult.put("isPreChFName", 0);
                    }
                }
                if (!dict.equals("-1")) {
                    if (!dict.equals("-1") && !PPEHandler.dictCheck(pwd, fields)) {
                        condresult.put("dict", 1);
                    } else {
                        splRule = true;
                        condresult.put("dict", 0);
                        String matchedDicWord = "";
                        if (fields.get("matchedDicWord") != null) {
                            matchedDicWord = (String)fields.get("matchedDicWord");
                        }
                        condresult.put("matchedDicWord", (Object)matchedDicWord);
                    }
                }
                if (unicodeChars != 0L) {
                    if (unicodeChars != 0L && unic > 0L) {
                        ++condCount;
                        condresult.put("unicodeChars", 1);
                    } else {
                        ++flag;
                        condresult.put("unicodeChars", 0);
                    }
                }
                if (incremental != 0L) {
                    if (incremental != 0L && !PPEHandler.isCharsAvaFrmUN(oldPwd, pwd)) {
                        ++condCount;
                        condresult.put("incremental", 1);
                    } else {
                        ++flag;
                        condresult.put("incremental", 0);
                    }
                }
                if (noOfCond != -1L) {
                    if (condCount < noOfCond || splRule) {
                        result.put("isFailed", 1);
                        isFailed = true;
                        break;
                    }
                    result.put("isFailed", 0);
                    break;
                }
                if (splRule || flag > 0L) {
                    result.put("isFailed", 1);
                    isFailed = true;
                    break;
                }
                result.put("isFailed", 0);
                break;
            }
            rating = PPEHandler.getRating(loginName, pwd, oldPwd, fields);
            if (passPhMinLenFlag) {
                result.put("isFailed", 0);
            }
            if (!isForcedFlag) {
                result.put("isFailed", 0);
            }
            result.put("condresult", (Object)condresult);
            result.put("rating", rating);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("isFailed", 1);
            result.put("condresult", (Object)condresult);
            result.put("rating", 1);
            return result;
        }
    }

    public static boolean validatePasswordPolicy(HttpServletRequest request, String ssAction, long policyId, String loginName) throws Exception {
        try {
            String pwd = "";
            String oldPwd = "";
            if (ssAction.equals("resetPassword")) {
                pwd = request.getParameter("password");
            } else if (ssAction.equals("changePassword")) {
                pwd = request.getParameter("newPassword");
                oldPwd = request.getParameter("oldPassword");
            }
            return PPEHandler.validatePasswordPolicy(pwd, oldPwd, policyId, loginName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static boolean validatePasswordPolicy(String pwd, String oldPwd, long policyId, String loginName) throws Exception {
        try {
            int isFailed = 1;
            JSONObject result = PPEHandler.validatePasswordPolicy(policyId, pwd, oldPwd, loginName);
            isFailed = (Integer)result.get("isFailed");
            if (isFailed == 0) {
                return true;
            }
            if (isFailed == 1) {
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static JSONObject setCNSCount(String pwd) throws Exception {
        JSONObject charCount = new JSONObject();
        long lower = 0L;
        long upper = 0L;
        long num = 0L;
        long unic = 0L;
        long spl = 0L;
        for (int i = 0; i < pwd.length(); ++i) {
            if (pwd.charAt(i) <= 'z' && pwd.charAt(i) >= 'a') {
                ++lower;
                continue;
            }
            if (pwd.charAt(i) <= 'Z' && pwd.charAt(i) >= 'A') {
                ++upper;
                continue;
            }
            if (pwd.charAt(i) <= '9' && pwd.charAt(i) >= '0') {
                ++num;
                continue;
            }
            if (pwd.charAt(i) <= '/' && pwd.charAt(i) >= ' ' || pwd.charAt(i) <= '@' && pwd.charAt(i) >= ':' || pwd.charAt(i) <= '`' && pwd.charAt(i) >= '[' || pwd.charAt(i) <= '~' && pwd.charAt(i) >= '{') {
                ++spl;
                continue;
            }
            if (pwd.charAt(i) <= '\u007f') continue;
            ++unic;
        }
        charCount.put("lower", lower);
        charCount.put("upper", upper);
        charCount.put("numbers", num);
        charCount.put("unicode", unic);
        charCount.put("specialchars", spl);
        return charCount;
    }

    public static boolean isCharsAvaFrmUN(String userName, String pwd) {
        try {
            boolean rep = false;
            boolean isMoreThan3CharsRep = false;
            String lowerPwd = pwd.toLowerCase();
            String uName = userName.toLowerCase();
            for (int i = 0; i < uName.length(); ++i) {
                String check;
                if (i + 5 > uName.length() || lowerPwd.indexOf(check = uName.substring(i, i + 5)) == -1) continue;
                rep = true;
                if (i + 4 > uName.length() || lowerPwd.indexOf(check = uName.substring(i, i + 3)) == -1) break;
                isMoreThan3CharsRep = true;
                break;
            }
            return rep;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCharsRepeated(String pwd) {
        pwd = pwd.toLowerCase();
        boolean same = false;
        if (pwd.length() < 3) {
            return false;
        }
        for (int i = 0; i < pwd.length() - 2; ++i) {
            if (pwd.charAt(i) != pwd.charAt(i + 1) || pwd.charAt(i + 1) != pwd.charAt(i + 2)) continue;
            same = true;
        }
        return same;
    }

    public static boolean isPalindrome(String pwd) {
        pwd = pwd.toLowerCase();
        int n = pwd.length();
        for (int i = 0; i < n / 2; ++i) {
            if (pwd.charAt(i) == pwd.charAt(n - i - 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean isExWordsAva(String pwd, String exWords) {
        String[] arr = exWords.split(",");
        for (int i = 0; i < arr.length; ++i) {
            if (pwd.toLowerCase().indexOf(arr[i].toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean isPwdStWAlpha(String pwd) {
        return pwd.charAt(0) <= 'Z' && pwd.charAt(0) >= 'A' || pwd.charAt(0) <= 'z' && pwd.charAt(0) >= 'a';
    }

    public static boolean isConMixedCase(String pwd, long lower, long upper) {
        return upper > 0L && lower > 0L;
    }

    public static boolean dictCheck(String pwd, JSONObject fields) throws Exception {
        String dictWords = PPEHandler.getDictWords(fields);
        String[] arr = dictWords.split(Pattern.quote("||"));
        fields.put("matchedDicWord", (Object)"");
        if (((String)fields.get("DICT_WORDS_CONTAINS_Custom")).equals("true")) {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].length() <= 0 || pwd.toLowerCase().indexOf(arr[i].toLowerCase()) == -1) continue;
                fields.put("matchedDicWord", (Object)arr[i]);
                return true;
            }
        } else {
            for (int i = 0; i < arr.length; ++i) {
                if (arr[i].length() <= 0 || !pwd.toLowerCase().equals(arr[i].toLowerCase())) continue;
                fields.put("matchedDicWord", (Object)arr[i]);
                return true;
            }
        }
        return false;
    }
}

