/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSyncConstants;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.manageengine.ads.fw.iamapps.handler.IAMAccountHandler;
import com.manageengine.ads.fw.iamapps.handler.IAMAppHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class PasswordSyncHandler
extends PasswordSyncConstants {
    public static final int CLOUD_PROVIDER = 1;
    public static final int HOST_PROVIDER = 2;

    public static JSONArray getProviders() {
        JSONArray providers = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("ADSIAMApplications");
        tablesList.add("ADSIAMAppConfig");
        boolean[] isLeftJoins = new boolean[tablesList.size()];
        Arrays.fill(isLeftJoins, true);
        try {
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)null);
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSIAMApplications", (String)"APP_ID"), true));
            RelationalAPI rapi = RelationalAPI.getInstance();
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            if (!dataobject.isEmpty()) {
                providers = new JSONArray();
                Iterator it = dataobject.getRows("ADSIAMApplications");
                while (it.hasNext()) {
                    JSONObject provider = new JSONObject();
                    Row r = (Row)it.next();
                    String pName = (String)r.get("APP_NAME");
                    Long provId = (Long)r.get("APP_ID");
                    provider.put("APP_ID", (Object)provId);
                    provider.put("PROVIDER_NAME", (Object)pName);
                    provider.put("ICON_STYLE", r.get("ICON_STYLE"));
                    provider.put("DISPLAY_NAME", r.get("DISPLAY_NAME"));
                    provider.put("CATEGORY", r.get("CATEGORY_ID"));
                    provider.put("PRIORITY", r.get("PRIORITY"));
                    Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_ID"), (Object)((Long)r.get("APP_ID")), 0);
                    int count = 0;
                    Iterator host = dataobject.getRows("ADSIAMAppConfig", c);
                    while (host.hasNext()) {
                        host.next();
                        ++count;
                    }
                    if (count > 0) {
                        provider.put("COUNT", count);
                    }
                    providers.put((Object)provider);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providers;
    }

    public static JSONObject getHosts(long providerId) {
        JSONObject hosts = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("ADSIAMAppConfig");
        tablesList.add("ADSIAMAppConfigParams");
        tablesList.add("SSPPSPolicies");
        tablesList.add("PolicyConfiguration");
        tablesList.add("SSPPSConfPolicy");
        boolean[] isLeftJoins = new boolean[tablesList.size()];
        Arrays.fill(isLeftJoins, true);
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_ID"), (Object)providerId, 0);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            if (!dataobject.isEmpty()) {
                hosts = new JSONObject();
                Iterator config = dataobject.getRows("ADSIAMAppConfig");
                while (config.hasNext()) {
                    Iterator params;
                    Row r = (Row)config.next();
                    JSONObject host = new JSONObject();
                    String cId = r.get("APP_CONFIG_ID").toString();
                    host.put("HOST_NAME", r.get("HOST_NAME"));
                    host.put("DESCRIPTION", r.get("DESCRIPTION"));
                    host.put("USER_NAME", r.get("USER_NAME"));
                    host.put("IS_ENABLED", r.get("IS_ENABLED"));
                    host.put("AUTH_TOKEN", r.get("AUTH_TOKEN"));
                    if (dataobject.containsTable("SSPPSConfPolicy")) {
                        params = dataobject.getRows("SSPPSConfPolicy", new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)cId, 0));
                        while (params.hasNext()) {
                            r = (Row)params.next();
                            host.put("ASSIGN_ALL_POLICIES", r.get("ASSIGN_ALL_POLICIES"));
                            host.put("AUTO_LINK_USER", (Object)IAMAccountHandler.isAutoLinked((Long)Long.parseLong(cId)));
                        }
                    }
                    if (dataobject.containsTable("ADSIAMAppConfigParams")) {
                        params = dataobject.getRows("ADSIAMAppConfigParams", new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)cId, 0));
                        while (params.hasNext()) {
                            r = (Row)params.next();
                            host.put((String)r.get("PARAM_NAME"), r.get("PARAM_VALUE"));
                        }
                    }
                    if (dataobject.containsTable("SSPPSPolicies")) {
                        JSONArray policy = new JSONArray();
                        Iterator policyiterator = dataobject.getRows("SSPPSPolicies", new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)cId, 0));
                        while (policyiterator.hasNext()) {
                            r = (Row)policyiterator.next();
                            r = dataobject.getRow("PolicyConfiguration", new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), r.get("POLICY_ID"), 0));
                            policy.put(r.get("POLICY_NAME"));
                        }
                        if (policy.length() > 0) {
                            host.put("POLICY", (Object)policy);
                        }
                    }
                    hosts.put(cId, (Object)host);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hosts;
    }

    public static String getDisplayName(long appId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMApplications", (String)"APP_ID"), (Object)appId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMApplications", c);
            Row r = dataObject.getFirstRow("ADSIAMApplications");
            return (String)r.get("DISPLAY_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static JSONObject getHosts(JSONArray cId) {
        JSONObject hosts = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("ADSIAMApplications");
        tablesList.add("ADSIAMAppConfig");
        tablesList.add("SSPPSConfPolicy");
        tablesList.add("ADSIAMAppConfigParams");
        tablesList.add("ADSIAMAppAPIs");
        String hostDisplayName = "";
        boolean[] isLeftJoins = new boolean[tablesList.size()];
        Arrays.fill(isLeftJoins, true);
        try {
            long[] acId = new long[cId.length()];
            for (int i = 0; i < cId.length(); ++i) {
                acId[i] = Long.valueOf(cId.get(i).toString());
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)acId, 8);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            if (!dataobject.isEmpty()) {
                hosts = new JSONObject();
                Iterator config = dataobject.getRows("ADSIAMAppConfig");
                while (config.hasNext()) {
                    Iterator params;
                    Row r = (Row)config.next();
                    JSONObject host = new JSONObject();
                    String configId = r.get("APP_CONFIG_ID").toString();
                    host.put("APP_CONFIG_ID", Long.parseLong(configId));
                    host.put("DISPLAY_NAME", (Object)PasswordSyncHandler.getDisplayName((Long)r.get("APP_ID")));
                    host.put("HOST_NAME", r.get("HOST_NAME"));
                    hostDisplayName = (String)r.get("HOST_DISPLAY_NAME");
                    if (r.get("HOST_DISPLAY_NAME") != null && !hostDisplayName.equals("")) {
                        host.put("HOST_DISPLAY_NAME", r.get("HOST_DISPLAY_NAME"));
                    } else {
                        host.put("HOST_DISPLAY_NAME", r.get("HOST_NAME"));
                    }
                    host.put("AUTH_TOKEN", r.get("AUTH_TOKEN"));
                    host.put("USER_NAME", r.get("USER_NAME"));
                    host.put("PASSWORD", r.get("PASSWORD"));
                    Criteria a = new Criteria(Column.getColumn((String)"ADSIAMAppAPIs", (String)"APP_ID"), r.get("APP_ID"), 0, false);
                    Criteria b = a.and(new Criteria(Column.getColumn((String)"ADSIAMAppAPIs", (String)"API_NAME"), (Object)"PASSWORD_SYNC", 0, false));
                    DataObject dO = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppAPIs", b);
                    if (!dO.isEmpty()) {
                        Row apiMatchedRow = dO.getFirstRow("ADSIAMAppAPIs");
                        host.put("PROVIDER_CLASS", apiMatchedRow.get("API_CLASS_NAME"));
                    }
                    if (dataobject.containsTable("ADSIAMAppConfigParams")) {
                        params = dataobject.getRows("ADSIAMAppConfigParams", new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)configId, 0));
                        while (params.hasNext()) {
                            r = (Row)params.next();
                            host.put((String)r.get("PARAM_NAME"), r.get("PARAM_VALUE"));
                        }
                    }
                    if (dataobject.containsTable("SSPPSConfPolicy")) {
                        params = dataobject.getRows("SSPPSConfPolicy", new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)configId, 0));
                        while (params.hasNext()) {
                            r = (Row)params.next();
                            host.put("AUTO_LINK_USER", (Object)IAMAccountHandler.isAutoLinked((Long)Long.parseLong(configId)));
                        }
                    }
                    hosts.put(configId, (Object)host);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hosts;
    }

    public static JSONObject getHostDetails(long cId) {
        JSONObject host = null;
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("ADSIAMAppConfig");
        tablesList.add("ADSIAMAppConfigParams");
        tablesList.add("SSPPSPolicies");
        tablesList.add("PolicyConfiguration");
        tablesList.add("SSPPSConfPolicy");
        boolean[] isLeftJoins = new boolean[tablesList.size()];
        Arrays.fill(isLeftJoins, true);
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)cId, 0);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            if (!dataobject.isEmpty()) {
                Iterator params;
                host = new JSONObject();
                Row r = dataobject.getFirstRow("ADSIAMAppConfig");
                host.put("APP_ID", (Object)r.get("APP_ID").toString());
                host.put("APP_CONFIG_ID", (Object)r.get("APP_CONFIG_ID").toString());
                host.put("HOST_NAME", r.get("HOST_NAME"));
                host.put("DESCRIPTION", r.get("DESCRIPTION"));
                host.put("USER_NAME", r.get("USER_NAME"));
                host.put("AUTH_TOKEN", r.get("AUTH_TOKEN"));
                host.put("IS_ENABLED", r.get("IS_ENABLED"));
                if (dataobject.containsTable("SSPPSConfPolicy")) {
                    params = dataobject.getRows("SSPPSConfPolicy", new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)cId, 0));
                    while (params.hasNext()) {
                        r = (Row)params.next();
                        host.put("ASSIGN_ALL_POLICIES", r.get("ASSIGN_ALL_POLICIES"));
                        host.put("AUTO_LINK_USER", (Object)IAMAccountHandler.isAutoLinked((Long)cId));
                    }
                }
                if (dataobject.containsTable("ADSIAMAppConfigParams")) {
                    params = dataobject.getRows("ADSIAMAppConfigParams");
                    while (params.hasNext()) {
                        r = (Row)params.next();
                        host.put((String)r.get("PARAM_NAME"), r.get("PARAM_VALUE"));
                    }
                }
                if (dataobject.containsTable("SSPPSPolicies")) {
                    JSONArray policy = new JSONArray();
                    Iterator policyiterator = dataobject.getRows("SSPPSPolicies", new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)cId, 0));
                    while (policyiterator.hasNext()) {
                        r = (Row)policyiterator.next();
                        policy.put(r.get("POLICY_ID"));
                    }
                    if (policy.length() > 0) {
                        host.put("POLICY", (Object)policy);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return host;
    }

    public static void addHostDetails(JSONObject host) throws Exception {
        Row r;
        DataObject dataobject;
        Criteria c;
        long cId = 0L;
        boolean isUpdate = false;
        if (host.has("APP_CONFIG_ID")) {
            isUpdate = true;
            cId = Long.valueOf(host.get("APP_CONFIG_ID").toString());
            c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)cId, 0, false);
            dataobject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfig", c);
            r = dataobject.getFirstRow("ADSIAMAppConfig");
        } else {
            dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            r = new Row("ADSIAMAppConfig");
        }
        r.set("APP_ID", (Object)new Long((String)host.get("APP_ID")));
        r.set("HOST_NAME", (Object)((String)host.get("HOST_NAME")));
        r.set("DESCRIPTION", (Object)((String)host.get("DESCRIPTION")));
        r.set("USER_NAME", (Object)((String)host.get("USER_NAME")));
        r.set("PASSWORD", (Object)((String)host.get("PASSWORD")));
        r.set("AUTH_TOKEN", (Object)((String)host.get("AUTH_TOKEN")));
        r.set("IS_ENABLED", (Object)true);
        try {
            if (isUpdate) {
                dataobject.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(dataobject);
                c = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)cId, 0, false);
                CommonUtil.getPersistence(new boolean[0]).delete(c);
                ArrayList policyIds = APCUtil.getAllDomainPolicyIds();
                Long[] policies = policyIds.toArray(new Long[policyIds.size()]);
                c = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)cId, 0, false);
                c = c.and(new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)policies, 8, false));
                CommonUtil.getPersistence(new boolean[0]).delete(c);
                c = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)cId, 0, false);
                CommonUtil.getPersistence(new boolean[0]).delete(c);
            } else {
                dataobject.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dataobject);
                cId = (Long)r.get("APP_CONFIG_ID");
            }
        }
        catch (DataAccessException e) {
            throw new Exception("ads.config.admin_tools.pwd_sync.duplicate_host_name");
        }
        dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row r2 = new Row("SSPPSConfPolicy");
        r2.set("ASSIGN_ALL_POLICIES", (Object)((Boolean)host.get("ASSIGN_ALL_POLICIES")));
        r2.set("APP_CONFIG_ID", (Object)cId);
        IAMAccountHandler.setAutoLink((String)((String)host.get("AUTO_LINK_USER")), (Long)cId);
        dataobject.addRow(r2);
        if (host.has("PARAMS")) {
            JSONObject parameter = host.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                r = new Row("ADSIAMAppConfigParams");
                r.set("APP_CONFIG_ID", (Object)cId);
                r.set("PARAM_NAME", (Object)pName);
                r.set("PARAM_VALUE", (Object)((String)parameter.get(pName)));
                dataobject.addRow(r);
            }
        }
        if (host.has("POLICY")) {
            JSONArray policies = host.getJSONArray("POLICY");
            for (int i = 0; i < policies.length(); ++i) {
                r = new Row("SSPPSPolicies");
                r.set("APP_CONFIG_ID", (Object)cId);
                r.set("POLICY_ID", (Object)Long.valueOf(policies.get(i).toString()));
                dataobject.addRow(r);
            }
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataobject);
        if (host.has("P12_KEY")) {
            String newpath = System.getProperty("user.dir") + File.separator + "GoogleApps" + File.separator + cId + ".p12";
            String oldpath = System.getProperty("user.dir") + File.separator + "GoogleApps" + File.separator + "gappskey.p12";
            File file = new File(newpath);
            if (file.exists()) {
                file.delete();
            }
            File ofile = new File(oldpath);
            ofile.renameTo(new File(newpath));
        }
    }

    public static void updateAssignedPolicies(JSONArray cId, JSONArray pId) throws Exception {
        int i;
        long[] acId = new long[cId.length()];
        for (i = 0; i < cId.length(); ++i) {
            acId[i] = Long.valueOf(cId.get(i).toString());
        }
        Criteria c = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)acId, 8, false);
        CommonUtil.getPersistence(new boolean[0]).delete(c);
        DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        for (i = 0; i < acId.length; ++i) {
            for (int j = 0; j < pId.length(); ++j) {
                Row r = new Row("SSPPSPolicies");
                r.set("APP_CONFIG_ID", (Object)acId[i]);
                r.set("POLICY_ID", (Object)Long.valueOf(pId.get(j).toString()));
                dataobject.addRow(r);
            }
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataobject);
        Criteria c1 = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)acId, 8, false);
        dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSConfPolicy", c1);
        Iterator hosts = dataobject.getRows("SSPPSConfPolicy");
        while (hosts.hasNext()) {
            Row r = (Row)hosts.next();
            r.set("ASSIGN_ALL_POLICIES", (Object)false);
            dataobject.updateRow(r);
        }
        CommonUtil.getPersistence(new boolean[0]).update(dataobject);
    }

    public static boolean setHostStatus(JSONArray cId, boolean status) {
        boolean ret = true;
        long[] acId = new long[cId.length()];
        try {
            for (int i = 0; i < cId.length(); ++i) {
                acId[i] = Long.valueOf(cId.get(i).toString());
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)acId, 8, false);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfig", c);
            Iterator config = dataobject.getRows("ADSIAMAppConfig");
            while (config.hasNext()) {
                Row r = (Row)config.next();
                r.set("IS_ENABLED", (Object)status);
                dataobject.updateRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataobject);
        }
        catch (Exception e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    public static String getClassName(long pId) throws Exception {
        Criteria c2 = new Criteria(Column.getColumn((String)"ADSIAMAppAPIs", (String)"APP_ID"), (Object)pId, 0, false);
        Criteria c = c2.and(new Criteria(Column.getColumn((String)"ADSIAMAppAPIs", (String)"API_NAME"), (Object)"PASSWORD_SYNC", 0, false));
        DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppAPIs", c);
        Row r = dataobject.getFirstRow("ADSIAMAppAPIs");
        return (String)r.get("API_CLASS_NAME");
    }

    public static JSONArray getHostList(long pId) {
        JSONArray hostList = new JSONArray();
        ArrayList<String> tablesList = new ArrayList<String>();
        tablesList.add("ADSIAMAppConfig");
        tablesList.add("SSPPSPolicies");
        tablesList.add("SSPPSConfPolicy");
        boolean[] isLeftJoins = new boolean[tablesList.size()];
        Arrays.fill(isLeftJoins, true);
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"IS_ENABLED"), (Object)true, 0, false);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            c = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"ASSIGN_ALL_POLICIES"), (Object)true, 0, false);
            if (!dataobject.isEmpty()) {
                Row r;
                Iterator iterator = dataobject.getRows("ADSIAMAppConfig", c);
                while (iterator.hasNext()) {
                    r = (Row)iterator.next();
                    if ((Long)r.get("APP_ID") == 13L) {
                        String hostname = (String)r.get("HOST_NAME");
                        Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)pId, 0, false);
                        DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
                        String domainName = (String)obj.getFirstValue("PolicyConfiguration", "DOMAIN_NAME");
                        if (hostname.equalsIgnoreCase(domainName)) continue;
                        hostList.put((Object)((Long)r.get("APP_CONFIG_ID")));
                        continue;
                    }
                    hostList.put((Object)((Long)r.get("APP_CONFIG_ID")));
                }
                if (dataobject.containsTable("SSPPSPolicies")) {
                    c = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)pId, 0, false);
                    iterator = dataobject.getRows("SSPPSPolicies", c);
                    while (iterator.hasNext()) {
                        r = (Row)iterator.next();
                        hostList.put((Object)((Long)r.get("APP_CONFIG_ID")));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hostList;
    }

    public static boolean deleteHost(JSONArray cId) {
        boolean ret = true;
        long[] acId = new long[cId.length()];
        try {
            for (int i = 0; i < cId.length(); ++i) {
                acId[i] = Long.valueOf(cId.get(i).toString());
                File file = new File(System.getProperty("user.dir") + File.separator + "GoogleApps" + File.separator + acId[i] + ".p12");
                if (!file.exists()) continue;
                file.delete();
            }
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)acId, 8, false);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
        }
        catch (Exception e) {
            ret = false;
            e.printStackTrace();
        }
        return ret;
    }

    public static String getOtherAccountUserName(long loginId, long pSConfigId) {
        String username = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
            c = c.and(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSLinkedAccounts", c);
            Row r = dataObject.getFirstRow("SSPPSLinkedAccounts");
            username = (String)r.get("USER_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return username;
    }

    public static boolean isDomainExists(long pId, String hostName) {
        IAMAppHandler aHandler = new IAMAppHandler();
        return IAMAppHandler.isDomainExists((long)pId, (String)hostName);
    }
}

