/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.configuration;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.configuration.ADQuestionsHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorkflowConfigHandler {
    private static Logger logger = Logger.getLogger("ADSLogger");

    public static JSONObject getAllProviderActions() {
        JSONObject providerActions = new JSONObject();
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("SSPWFProviders");
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("ADSProducts");
            tableList.add("ADSProductDetails");
            ArrayList<String> optionalTableList = new ArrayList<String>();
            optionalTableList.add("ADSProductDetails");
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, optionalTableList, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Iterator providerActionIt = dataObj.getRows("SSPWFProviderVsActions");
                while (providerActionIt.hasNext()) {
                    Row providerActionRow = (Row)providerActionIt.next();
                    Iterator providerIt = dataObj.getRows("SSPWFProviders");
                    while (providerIt.hasNext()) {
                        Row providerRow = (Row)providerIt.next();
                        Iterator actionIt = dataObj.getRows("SSPWFRequestActions");
                        while (actionIt.hasNext()) {
                            Row actionRow = (Row)actionIt.next();
                            if (!actionRow.get("WF_ACTION_ID").equals(providerActionRow.get("WF_ACTION_ID")) || !providerActionRow.get("WF_PROVIDER_ID").equals(providerRow.get("WF_PROVIDER_ID"))) continue;
                            boolean isIntegrated = false;
                            JSONObject providers = new JSONObject();
                            JSONArray actions = new JSONArray();
                            if (providerActions.has(providerRow.get("WF_PROVIDER_ID").toString())) {
                                providers = providerActions.getJSONObject(providerRow.get("WF_PROVIDER_ID").toString());
                                if (providers.has("actions")) {
                                    actions = providers.getJSONArray("actions");
                                }
                            } else {
                                providers.put("providerId", providerRow.get("WF_PROVIDER_ID"));
                                providers.put("providerClass", providerRow.get("WF_PROVIDER_CLASS"));
                                if (dataObj.containsTable("ADSProductDetails")) {
                                    isIntegrated = true;
                                }
                                providers.put("isIntegrated", isIntegrated);
                                providers.put("providerName", providerRow.get("WF_PROVIDER_NAME"));
                            }
                            JSONObject reqActions = new JSONObject();
                            reqActions.put("actionId", actionRow.get("WF_ACTION_ID"));
                            reqActions.put("priority", actionRow.get("PRIORITY"));
                            reqActions.put("action", actionRow.get("WF_ACTION"));
                            reqActions.put("actionName", actionRow.get("WF_ACTION_NAME"));
                            reqActions.put("iconStyle", actionRow.get("ICON_STYLE"));
                            reqActions.put("description", actionRow.get("DESCRIPTION"));
                            reqActions.put("config_url", actionRow.get("CONFIG_URL"));
                            reqActions.put("criteria", actionRow.get("CRITERIA"));
                            reqActions.put("providerActionId", providerActionRow.get("WF_PROVIDER_ACTION_ID"));
                            reqActions.put("providerActionClass", providerActionRow.get("WF_PROVIDER_ACTION_CLASS"));
                            actions.put((Object)reqActions);
                            providers.put("actions", (Object)actions);
                            providerActions.put(providerActionRow.get("WF_PROVIDER_ID").toString(), (Object)providers);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return providerActions;
    }

    public static JSONObject getWorkflowConfiguration() {
        JSONObject workflowConfig = new JSONObject();
        try {
            workflowConfig = WorkflowConfigHandler.getAllWorkflowConfiguration(null, null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return workflowConfig;
    }

    public static JSONObject getWorkflowConfiguration(Long policyId, String actionName) {
        JSONObject workflowConfig = new JSONObject();
        try {
            workflowConfig = WorkflowConfigHandler.getAllWorkflowConfiguration(policyId, actionName).getJSONObject(policyId.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return workflowConfig;
    }

    private static JSONObject getAllWorkflowConfiguration(Long policyId, String actionName) {
        JSONObject workflowConfig = new JSONObject();
        try {
            Long loggedOnLoginId;
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("PolicyConfiguration");
            tableList.add("SSPWFProviders");
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("SSPWFConfiguration");
            ArrayList<String> optionalTableList = new ArrayList<String>();
            optionalTableList.add("SSPWFProviders");
            optionalTableList.add("SSPWFProviderVsActions");
            optionalTableList.add("SSPWFRequestActions");
            optionalTableList.add("SSPWFConfiguration");
            Criteria domainCriteria = null;
            Credential cred = AuthUtil.getUserCredential();
            if (cred != null && !ADMPRoleHandler.isADSSPUser(loggedOnLoginId = cred.getLoginId())) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                domainCriteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            Criteria checkCr = policyId == null ? domainCriteria : new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, optionalTableList, checkCr);
            Iterator it = dO.getRows("PolicyConfiguration");
            while (it.hasNext()) {
                JSONObject providers = new JSONObject();
                Row row = (Row)it.next();
                providers.put("policyId", row.get("POLICY_ID"));
                providers.put("policyName", row.get("POLICY_NAME"));
                Criteria policyCr = new Criteria(Column.getColumn((String)"SSPWFConfiguration", (String)"POLICY_ID"), row.get("POLICY_ID"), 0);
                Iterator policyIt = dO.getRows("SSPWFConfiguration", policyCr);
                while (policyIt.hasNext()) {
                    JSONArray configs = new JSONArray();
                    if (providers.has("configurations")) {
                        configs = providers.getJSONArray("configurations");
                    }
                    Row policyRow = (Row)policyIt.next();
                    Criteria providerActionCr = new Criteria(Column.getColumn((String)"SSPWFProviderVsActions", (String)"WF_PROVIDER_ACTION_ID"), policyRow.get("WF_PROVIDER_ACTION_ID"), 0);
                    Row providerActionRow = null;
                    Row actionRow = null;
                    providerActionRow = dO.getRow("SSPWFProviderVsActions", providerActionCr);
                    if (providerActionRow == null) continue;
                    Criteria actionCr = new Criteria(Column.getColumn((String)"SSPWFRequestActions", (String)"WF_ACTION_ID"), providerActionRow.get("WF_ACTION_ID"), 0);
                    if (actionName != null) {
                        actionCr = actionCr.and(new Criteria(Column.getColumn((String)"SSPWFRequestActions", (String)"WF_ACTION_NAME"), (Object)actionName, 0));
                    }
                    if ((actionRow = dO.getRow("SSPWFRequestActions", actionCr)) == null) continue;
                    Criteria providerCr = new Criteria(Column.getColumn((String)"SSPWFProviders", (String)"WF_PROVIDER_ID"), providerActionRow.get("WF_PROVIDER_ID"), 0);
                    Row providerRow = dO.getRow("SSPWFProviders", providerCr);
                    JSONObject prov = new JSONObject();
                    prov.put("providerId", providerRow.get("WF_PROVIDER_ID"));
                    prov.put("providerName", providerRow.get("WF_PROVIDER_NAME"));
                    prov.put("providerClass", providerRow.get("WF_PROVIDER_CLASS"));
                    prov.put("providerActionId", providerActionRow.get("WF_PROVIDER_ACTION_ID"));
                    prov.put("providerActionClass", providerActionRow.get("WF_PROVIDER_ACTION_CLASS"));
                    prov.put("actionId", actionRow.get("WF_ACTION_ID"));
                    prov.put("priority", actionRow.get("PRIORITY"));
                    prov.put("action", actionRow.get("WF_ACTION"));
                    prov.put("actionName", actionRow.get("WF_ACTION_NAME"));
                    prov.put("iconStyle", actionRow.get("ICON_STYLE"));
                    prov.put("description", actionRow.get("DESCRIPTION"));
                    prov.put("config_url", actionRow.get("CONFIG_URL"));
                    prov.put("criteria", actionRow.get("CRITERIA"));
                    configs.put((Object)prov);
                    providers.put("configurations", (Object)configs);
                }
                workflowConfig.put(row.get("POLICY_ID").toString(), (Object)providers);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return workflowConfig;
    }

    public static void updateWorkflowConfiguration(JSONObject configuration) throws Exception {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("SSPWFConfiguration");
            tableList.add("SSPWFProviders");
            ArrayList<String> optionalTableList = new ArrayList<String>();
            optionalTableList.add("SSPWFConfiguration");
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, optionalTableList, (Criteria)null);
            Iterator it = configuration.keys();
            while (it.hasNext()) {
                String providerId = (String)it.next();
                JSONObject providerObj = configuration.getJSONObject(providerId);
                JSONArray providerArray = providerObj.getJSONArray("policies");
                for (int policyItem = 0; policyItem < providerArray.length(); ++policyItem) {
                    JSONObject policies = providerArray.getJSONObject(policyItem);
                    Long policyId = policies.getLong("policyId");
                    JSONArray polConfiguration = policies.getJSONArray("configurations");
                    Criteria policyCr = new Criteria(Column.getColumn((String)"SSPWFConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
                    Criteria providerActionCr = new Criteria(Column.getColumn((String)"SSPWFProviderVsActions", (String)"WF_PROVIDER_ID"), (Object)Long.parseLong(providerId), 0);
                    Iterator providerActionIt = dataObj.getRows("SSPWFProviderVsActions", providerActionCr);
                    while (providerActionIt.hasNext()) {
                        Row providerActionRow = (Row)providerActionIt.next();
                        Criteria actionCr = new Criteria(Column.getColumn((String)"SSPWFProviderVsActions", (String)"WF_ACTION_ID"), providerActionRow.get("WF_ACTION_ID"), 0);
                        if (polConfiguration.length() > 0) {
                            Iterator actionIt = dataObj.getRows("SSPWFProviderVsActions", actionCr);
                            while (actionIt.hasNext()) {
                                Row actionRow = (Row)actionIt.next();
                                Criteria actionPolCr = policyCr.and(new Criteria(Column.getColumn((String)"SSPWFConfiguration", (String)"WF_PROVIDER_ACTION_ID"), actionRow.get("WF_PROVIDER_ACTION_ID"), 0));
                                dataObj.deleteRows("SSPWFConfiguration", actionPolCr);
                            }
                        }
                        Criteria providerCr = policyCr.and(new Criteria(Column.getColumn((String)"SSPWFConfiguration", (String)"WF_PROVIDER_ACTION_ID"), providerActionRow.get("WF_PROVIDER_ACTION_ID"), 0));
                        dataObj.deleteRows("SSPWFConfiguration", providerCr);
                    }
                    for (int configItem = 0; configItem < polConfiguration.length(); ++configItem) {
                        Long providerActionId = polConfiguration.getLong(configItem);
                        Row row = new Row("SSPWFConfiguration");
                        row.set("POLICY_ID", (Object)policyId);
                        row.set("WF_PROVIDER_ACTION_ID", (Object)providerActionId);
                        dataObj.addRow(row);
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage());
        }
    }

    public static JSONObject getProviderDetail(String providerActionId) {
        JSONObject productDetail = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPWFProviderVsActions", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("SSPWFProviders");
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("ADSProducts");
            tableList.add("ADSProductDetails");
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, c);
            if (!dO.isEmpty()) {
                productDetail = new JSONObject();
                Row productRow = dO.getRow("ADSProductDetails");
                List columns = productRow.getColumns();
                for (String column : columns) {
                    productDetail.put(column, productRow.get(column));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
        return productDetail;
    }

    public static JSONObject getProviderActionDetails(String providerActionId) {
        JSONObject providerActionDetail = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPWFProviderVsActions", (String)"WF_PROVIDER_ACTION_ID"), (Object)providerActionId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPWFProviderVsActions", c);
            if (!dO.isEmpty()) {
                providerActionDetail = new JSONObject();
                Row productRow = dO.getRow("SSPWFProviderVsActions");
                List columns = productRow.getColumns();
                for (String column : columns) {
                    providerActionDetail.put(column, productRow.get(column));
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
        return providerActionDetail;
    }

    public static Long getProviderActionId(Long providerId, String requestActionName) {
        Long result = null;
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("SSPWFProviderVsActions");
            tableList.add("SSPWFRequestActions");
            tableList.add("SSPWFProviders");
            Criteria c = new Criteria(Column.getColumn((String)"SSPWFProviders", (String)"WF_PROVIDER_ID"), (Object)providerId, 0);
            c = c.and(Column.getColumn((String)"SSPWFRequestActions", (String)"WF_ACTION_NAME"), (Object)requestActionName, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, c);
            if (!dO.isEmpty()) {
                result = (Long)dO.getFirstValue("SSPWFProviderVsActions", "WF_PROVIDER_ACTION_ID");
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
        return result;
    }

    public static boolean isRPUAWorkflowEnabled(Long policyId) {
        return WorkflowConfigHandler.isWorkflowConfigured(policyId, "adssp.config.admin_tools.helpdesk.action_reset_pwd_unlock_account");
    }

    public static boolean isWorkflowConfigured(Long policyId) {
        return WorkflowConfigHandler.isWorkflowConfigured(policyId, null);
    }

    public static boolean isWorkflowConfigured(Long policyId, String requestActionName) {
        JSONObject workflowConfiguration = WorkflowConfigHandler.getWorkflowConfiguration(policyId, requestActionName);
        return workflowConfiguration != null && workflowConfiguration.length() > 0 && workflowConfiguration.has("configurations");
    }

    public static JSONObject getAllRequestActionPermissions() {
        JSONObject permissions = new JSONObject();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPWFRequestActions", (Criteria)null);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("SSPWFRequestActions");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    permissions.put(row.get("WF_ACTION_ID").toString(), row.get("WF_ACTION"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permissions;
    }

    public static JSONObject getResetUnlockConfigurationDetails() {
        JSONObject details = new JSONObject();
        try {
            Hashtable allAttributes = SearchProfileHandler.getInstance().getAllAttributes(new String[]{"user"});
            ArrayList userAttributes = (ArrayList)allAttributes.get("user");
            JSONObject attributes = new JSONObject();
            for (Properties attribute : userAttributes) {
                Integer aId = (Integer)attribute.get("ATTRIB_ID");
                String disName = (String)attribute.get("ATTRIB_DISP_NAME");
                String ldapName = (String)attribute.get("ATTRIB_LDAP_NAME");
                if (attributes.has(ldapName)) continue;
                attributes.put(ldapName, (Object)new Object[]{aId, disName});
            }
            details.put("ALL_USER_LDAP_ATTRIBUTES", (Object)attributes);
            details.put("ALL_QUESTIONS", (Object)ADQuestionsHandler.getADQuestions());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return details;
    }

    public static void removeWorkflowConfigurations() {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPWFConfiguration", (Criteria)null);
            dataObj.deleteRows("SSPWFConfiguration", (Criteria)null);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

