/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.dbsync;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.manageengine.ads.fw.dbsync.ExecutorImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SSPExecutorImpl
extends ExecutorImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");

    public String execute(JSONObject jsonRow) {
        String result;
        block19: {
            result = "success";
            try {
                String moduleName = jsonRow.getString("MODULE_NAME");
                if (moduleName.equals("DomainConfiguration")) {
                    int operation;
                    Properties domainProperties = this.getDomainDetails(jsonRow);
                    String domainName = domainProperties.getProperty("DomainName");
                    String userName = domainProperties.getProperty("UserName");
                    String password = domainProperties.getProperty("Password");
                    JSONObject domainDetails = DomainHandler.getDomainDetails(domainName);
                    if (domainDetails.length() != 0) {
                        String oldUserName;
                        domainName = domainDetails.getString("DOMAIN_NAME");
                        String string = oldUserName = domainDetails.has("USER_NAME") ? domainDetails.getString("USER_NAME") : null;
                        if (userName == null || oldUserName != null && !oldUserName.equals("") && !userName.equalsIgnoreCase(oldUserName)) {
                            userName = domainDetails.getString("USER_NAME");
                            password = domainDetails.getString("PASSWORD");
                        }
                    }
                    if ((operation = jsonRow.getInt("OPERATION")) == 1 || operation == 2) {
                        String authenticationRequired = domainProperties.getProperty("IsAuthRequired");
                        String isDefaultDomain = domainProperties.getProperty("IsDefaultDomain");
                        String[] dcs = domainProperties.getProperty("DCList").split(",");
                        ArrayList<String> dcList = new ArrayList<String>(Arrays.asList(dcs));
                        Properties prop = new Properties();
                        prop.put("IS_AUTHENTICATION_REQUIRED", "false");
                        prop.put("DOMAIN_NAME", domainName);
                        if (domainDetails.has("DOMAIN_DISPLAY_NAME")) {
                            prop.put("DOMAIN_DISPLAY_NAME", domainDetails.getString("DOMAIN_DISPLAY_NAME"));
                        }
                        if (authenticationRequired != null && authenticationRequired.equalsIgnoreCase("true")) {
                            prop.put("USER_DISTINGUISHED_NAME", userName);
                            prop.put("PASSWORD", password);
                            prop.put("IS_AUTHENTICATION_REQUIRED", authenticationRequired);
                        }
                        prop.put("DOMAIN_CONTROLLER_LIST", dcList);
                        if (isDefaultDomain != null && isDefaultDomain.equalsIgnoreCase("true")) {
                            prop.put("IS_DEFAULT_DOMAIN", "true");
                        } else {
                            String defaultDomain = DomainHandler.getDefaultDomain();
                            if (defaultDomain.equalsIgnoreCase("") || defaultDomain.equalsIgnoreCase(domainName)) {
                                prop.put("IS_DEFAULT_DOMAIN", "true");
                            } else {
                                prop.put("IS_DEFAULT_DOMAIN", "false");
                            }
                        }
                        if (operation == 1) {
                            if (!DomainHandler.isDomainExists()) {
                                prop.put("IS_DEFAULT_DOMAIN", "true");
                            } else {
                                prop.put("IS_DEFAULT_DOMAIN", "false");
                            }
                            DomainHandler.addDomainDetails(prop, true);
                        } else if (authenticationRequired == null && prop.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("true")) {
                            DomainHandler.setDefaultDomain(domainName, true);
                        } else if (authenticationRequired != null) {
                            DomainHandler.updateDomainDetails(prop, true);
                        }
                    }
                    break block19;
                }
                return super.execute(jsonRow);
            }
            catch (Exception e) {
                result = e.getMessage() != null ? e.getMessage() : e.toString();
                out.log(Level.INFO, "Unable to Execute Row - Reason : " + result);
            }
        }
        return result;
    }

    private Properties getDomainDetails(JSONObject row) throws Exception {
        Properties properties = new Properties();
        JSONArray columns = row.getJSONArray("COLUMNS");
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.getJSONObject(i);
            properties.put(column.getString("NAME"), column.getString("VALUE"));
        }
        return properties;
    }
}

