/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.dbsync;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.manageengine.ads.fw.dbsync.DBSyncModulesContainer;
import com.manageengine.ads.fw.dbsync.PublisherImpl;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONObject;

public class SSPPublisherImpl
extends PublisherImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static Map<String, String> tableModuleMap = DBSyncModulesContainer.getTableModuleMap();

    public void addRow(Row row) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        if (tableName.equalsIgnoreCase("AaaLogin")) {
            if (!CommonUtil.getApplicationDomainName().equalsIgnoreCase((String)row.get("DOMAINNAME"))) {
                super.addRow(row);
            }
        } else if (tableName.equalsIgnoreCase("ADSMDomainConfiguration")) {
            if (operation == 1) {
                String moduleName = tableModuleMap.get(tableName);
                List columnList = row.getColumns();
                this.createRow(moduleName, operation);
                for (Object columnName : columnList) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                }
                this.addColumn("DCList", SSPPublisherImpl.getDCList(row.get("DOMAIN_NAME").toString()), null);
                this.addRowtoEvent();
            }
        } else {
            super.addRow(row);
        }
    }

    public void addRow(Row row, List<String> columnList) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        if (!tableName.equalsIgnoreCase("ADSMDomainConfiguration")) {
            super.addRow(row, columnList);
        } else {
            String moduleName = tableModuleMap.get(tableName);
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            for (String uniqueColumn : uniqueColumns) {
                if (columnList.contains(uniqueColumn)) continue;
                columnList.add(uniqueColumn);
            }
            String[] authColumns = new String[]{"IS_AUTHENTICATION_REQUIRED", "USER_DISTINGUISHED_NAME", "PASSWORD"};
            boolean containsAuthChanges = false;
            for (String authColumn : authColumns) {
                if (!columnList.contains(authColumn)) continue;
                containsAuthChanges = true;
                break;
            }
            if (containsAuthChanges) {
                for (String authColumn : authColumns) {
                    if (columnList.contains(authColumn)) continue;
                    columnList.add(authColumn);
                }
            }
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName);
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addColumn("DCList", SSPPublisherImpl.getDCList(row.get("DOMAIN_NAME").toString()), null);
            this.addRowtoEvent();
        }
    }

    private JSONObject constructColumn(Row row, JSONObject columnSyncDetails) throws Exception {
        JSONObject result = new JSONObject();
        Object value = null;
        Object originalValue = row.getOriginalValue(columnSyncDetails.getString("COLUMN_NAME"));
        if (columnSyncDetails != null) {
            value = row.get(columnSyncDetails.getString("COLUMN_NAME"));
            String stringValue = value == null ? null : value.toString();
            value = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
            stringValue = originalValue == null ? null : originalValue.toString();
            originalValue = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
        }
        result.put("NAME", (Object)columnSyncDetails.getString("MODULE_COLUMN_NAME"));
        if (value != null) {
            result.put("VALUE", (Object)value.toString());
        } else {
            result.put("VALUE", JSONObject.NULL);
        }
        if (originalValue != null) {
            result.put("ORIGINAL_VALUE", (Object)originalValue.toString());
        } else {
            result.put("ORIGINAL_VALUE", JSONObject.NULL);
        }
        return result;
    }

    private static String getDCList(String domainName) {
        String result = null;
        try {
            Properties domainProperties = DomainHandler.getConfiguredValuesForModify(domainName);
            List dcList = (List)domainProperties.get("DOMAIN_CONTROLLER_LIST");
            for (String dc : dcList) {
                if (result == null) {
                    result = dc;
                    continue;
                }
                result = result + "," + dc;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

