/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class AdventNetResourceBundle
extends ResourceBundle {
    private Properties resBund = null;
    private Locale locale = null;

    public AdventNetResourceBundle(Locale locale) {
        try {
            this.locale = locale;
            String location = System.getProperty("server.home") + File.separator + "resources" + File.separator + "adssp";
            final String localeFile = this.getLocaleFile("ApplicationResources");
            File dir = new File(location);
            String[] filesList = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equalsIgnoreCase(localeFile);
                }
            });
            String resourceFileName = location + File.separator + localeFile;
            resourceFileName = filesList != null && filesList.length != 0 ? location + File.separator + filesList[filesList.length - 1] : location + File.separator + "ApplicationResources_" + locale.getLanguage() + ".properties";
            File propFile = new File(resourceFileName);
            if (!propFile.exists()) {
                this.locale = ResourceBundleMgr.getInstance().getDefaultLocale();
                resourceFileName = location + File.separator + this.getLocaleFile("ApplicationResources");
            }
            FileInputStream stream = new FileInputStream(resourceFileName);
            this.resBund = new Properties();
            this.resBund.load(stream);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object handleGetObject(String key) {
        if (this.resBund == null) {
            return key;
        }
        if (this.resBund.get(key) == null || "".equals(this.resBund.get(key))) {
            return key;
        }
        return this.resBund.get(key);
    }

    public Enumeration getKeys() {
        return this.resBund.keys();
    }

    public String getLocaleFile(String fName) {
        String file = fName;
        try {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            file = country != null && !country.equals("") ? fName + "_" + language + "_" + country : fName + "_" + language;
            file = file + ".properties";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }
}

