/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;

public class JsMessage {
    private Properties jsProps = null;
    private Locale locale = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsMessage(Locale locale) {
        this.locale = locale;
        FileInputStream stream = null;
        try {
            File propFile;
            String location = System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adssp" + File.separator + "jsMessage";
            final String localeFile = this.getLocaleFile("ApplicationResources_script");
            File dir = new File(location);
            String[] filesList = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(localeFile);
                }
            });
            String resourceFileName = localeFile;
            if (filesList.length != 0) {
                resourceFileName = location + File.separator + filesList[filesList.length - 1];
            }
            if (!(propFile = new File(resourceFileName)).exists()) {
                resourceFileName = System.getProperty("server.dir") + File.separator + "resources" + File.separator + "adssp" + File.separator + "jsMessage" + File.separator + "ApplicationResources_script_en_US.properties";
            }
            stream = new FileInputStream(resourceFileName);
            this.jsProps = new Properties();
            this.jsProps.load(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        try {
            Enumeration<Object> keys = this.jsProps.keys();
            buff.append("({");
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                buff.append(key + ": \"" + this.jsProps.getProperty(key) + "\"");
                if (!keys.hasMoreElements()) continue;
                buff.append(", ");
            }
            buff.append("})");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buff.toString();
    }

    public String getLocaleFile(String fName) {
        String fileName = fName;
        try {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            fileName = country != null && !country.equals("") ? fileName + "_" + language + "_" + country : fileName + "_" + language;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileName;
    }
}

