/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.JsMessage;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.json.JSONObject;

public class ResourceBundleMgr {
    private static ResourceBundleMgr instance = null;
    private HashMap rbLocaleMap = new HashMap();
    private HashMap jsLocaleMap = new HashMap();

    private ResourceBundleMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceBundleMgr getInstance() {
        if (instance != null) return instance;
        Class<ResourceBundleMgr> clazz = ResourceBundleMgr.class;
        synchronized (ResourceBundleMgr.class) {
            if (instance != null) return instance;
            instance = new ResourceBundleMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AdventNetResourceBundle getBundle() {
        return this.getBundle(this.getServerLocale());
    }

    public AdventNetResourceBundle getBundle(Locale locale) {
        AdventNetResourceBundle rb = null;
        try {
            rb = (AdventNetResourceBundle)this.rbLocaleMap.get(locale);
            if (rb == null) {
                Locale supportedLocale = this.getSupportedLocale(locale);
                rb = (AdventNetResourceBundle)this.rbLocaleMap.get(supportedLocale);
                if (rb == null) {
                    rb = new AdventNetResourceBundle(supportedLocale);
                }
                this.rbLocaleMap.put(locale, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb;
    }

    public AdventNetResourceBundle getBundle(HttpServletRequest request) {
        Locale locale = null;
        try {
            HttpSession session = request.getSession();
            Object loginId = session.getAttribute("ADMP_SESSION_LOGIN_ID");
            locale = session.getAttribute("USER_LOCALE") != null ? (Locale)session.getAttribute("USER_LOCALE") : (loginId != null ? this.getClientLocale((Long)loginId, request) : this.getUserLocale(request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getBundle(locale);
    }

    public void setUserLocale(Long loginId, Long localeId, HttpServletRequest request) {
        try {
            Criteria crit = new Criteria(new Column("User_Locale", "LOGIN_ID"), (Object)loginId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("User_Locale", crit);
            if (!dObj.isEmpty()) {
                dObj.deleteRows("User_Locale", crit);
            }
            Row r = new Row("User_Locale");
            r.set("LOGIN_ID", (Object)loginId);
            r.set("LOCALE_ID", (Object)localeId);
            dObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
            Locale locale = this.getLocale(localeId);
            request.getSession().setAttribute("USER_LOCALE", (Object)locale);
            JSONObject systemSettings = new JSONObject();
            systemSettings.put("USER_LOCALE", (Object)locale);
            request.getSession().setAttribute("AAA_SYSTEM_SETTINGS", (Object)systemSettings);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getJsMessage(Locale locale) {
        String jsMessage = "";
        try {
            JsMessage jsBundleObj = (JsMessage)this.jsLocaleMap.get(locale);
            if (jsBundleObj == null) {
                jsBundleObj = new JsMessage(locale);
                this.jsLocaleMap.put(locale, jsBundleObj);
            }
            jsMessage = jsBundleObj.getString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsMessage;
    }

    public void updateLocaleDetails(Long localeId, String language, String country) {
        try {
            Criteria crit = new Criteria(new Column("LocaleDetails", "LOCALE_ID"), (Object)localeId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("LocaleDetails");
                r.set("LOCALE_LANGUAGE", (Object)language);
                r.set("LOCALE_COUNTRY", (Object)country);
                dObj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Locale getServerLocale() {
        Locale locale = null;
        Long localeId = this.getUserLocaleId(1L);
        locale = localeId == 0L || localeId == -1L ? Locale.getDefault() : this.getLocale(localeId);
        return locale;
    }

    public Locale getClientLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("USER_LOCALE");
        if (locale == null) {
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            return this.getClientLocale(loginId, request);
        }
        return locale;
    }

    public Locale getClientLocale(Long loginId, HttpServletRequest request) {
        Locale locale = null;
        try {
            Long localeId = this.getClientLocaleId(loginId, request);
            locale = localeId == 0L || localeId == -1L || loginId != null && loginId == 1L && this.allowMobLocalLang(request) ? request.getLocale() : this.getLocale(localeId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return locale;
    }

    public Long getUserLocaleId(Long loginId) {
        Long localeId = -1L;
        try {
            Criteria crit = new Criteria(new Column("User_Locale", "LOGIN_ID"), (Object)loginId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("User_Locale", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("User_Locale");
                localeId = (Long)r.get("LOCALE_ID");
            } else {
                if (loginId != null && loginId == 1L && (localeId = this.getLocaleId(this.getDefaultLocale().toString())) != 1L) {
                    return localeId;
                }
                localeId = -1L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localeId;
    }

    public Long getLocaleId(String localeStr) {
        Long localeId = -1L;
        try {
            String[] splits = localeStr.split("_");
            if (splits.length == 2) {
                Criteria crit = new Criteria(new Column("LocaleDetails", "LOCALE_LANGUAGE"), (Object)splits[0], 0);
                crit = crit.and(new Criteria(new Column("LocaleDetails", "LOCALE_COUNTRY"), (Object)splits[1], 0));
                DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
                if (!dObj.isEmpty()) {
                    Row r = dObj.getFirstRow("LocaleDetails");
                    localeId = (Long)r.get("LOCALE_ID");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localeId;
    }

    public Locale getLocale(String langCountry, HttpServletRequest request) {
        Locale locale = this.getDefaultLocale();
        try {
            String[] splits = langCountry.split("_");
            if ("--_--".equalsIgnoreCase(langCountry)) {
                locale = request.getLocale();
            } else if (splits.length > 1) {
                locale = new Locale(splits[0], splits[1]);
            } else if (splits.length == 1) {
                locale = new Locale(splits[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }

    public Locale getUserLocale(HttpServletRequest request) {
        return this.getUserLocale(request, null);
    }

    public Locale getUserLocale(HttpServletRequest request, HttpServletResponse servletresponse) {
        Locale locale = null;
        try {
            String paramLocale = request.getParameter("paramLocale");
            String adsspLocale = UserUtil.getCookieValue(request, "adssplocale");
            if (paramLocale != null) {
                locale = this.getLocale(paramLocale, request);
                if (servletresponse != null) {
                    Cookie cookie = new Cookie("adssplocale", paramLocale);
                    cookie.setPath("/");
                    if (request.isSecure()) {
                        cookie.setSecure(true);
                    }
                    cookie.setMaxAge(63072000);
                    servletresponse.addCookie(cookie);
                }
            } else {
                locale = !"".equals(adsspLocale) ? this.getLocale(adsspLocale, request) : this.getClientLocale(1L, request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return locale;
    }

    public Locale getLocale(Long localeId) {
        Locale locale = this.getDefaultLocale();
        try {
            Criteria crit = new Criteria(new Column("LocaleDetails", "LOCALE_ID"), (Object)localeId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("LocaleDetails");
                String language = (String)r.get("LOCALE_LANGUAGE");
                String country = (String)r.get("LOCALE_COUNTRY");
                locale = country != null && !country.equals("") ? new Locale(language, country) : new Locale(language);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }

    private boolean allowMobLocalLang(HttpServletRequest request) {
        Locale locale = request.getLocale();
        if (!MobileUtil.isNativeApp(request)) {
            return false;
        }
        Locale supLocale = this.getSupportedLocale(locale);
        boolean isSupportedLocale = locale.equals(supLocale);
        return isSupportedLocale;
    }

    public Long getClientLocaleId(Long loginId, HttpServletRequest request) {
        Long localeId = this.getUserLocaleId(loginId);
        if (!(localeId != -1L || loginId != null && loginId == 1L || this.allowMobLocalLang(request))) {
            localeId = this.getUserLocaleId(1L);
        }
        return localeId;
    }

    public Long getClientLocaleId(Long loginId) {
        Long localeId = this.getUserLocaleId(loginId);
        if (localeId == -1L && (loginId == null || loginId != 1L)) {
            localeId = this.getUserLocaleId(1L);
        }
        return localeId;
    }

    public Locale getSupportedLocale(Locale locale) {
        try {
            Criteria crit = new Criteria(new Column("LocaleDetails", "LOCALE_LANGUAGE"), (Object)locale.getLanguage(), 0);
            crit = crit.and(new Criteria(new Column("LocaleDetails", "LOCALE_ID"), (Object)0, 5));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty()) {
                Row r = null;
                if (!"".equals(locale.getCountry())) {
                    r = dObj.getRow("LocaleDetails", new Criteria(Column.getColumn((String)"LocaleDetails", (String)"LOCALE_COUNTRY"), (Object)locale.getCountry(), 0, false));
                }
                if (r == null) {
                    r = dObj.getFirstRow("LocaleDetails");
                }
                String language = (String)r.get("LOCALE_LANGUAGE");
                String country = (String)r.get("LOCALE_COUNTRY");
                locale = country != null && !country.equals("") ? new Locale(language, country) : new Locale(language);
            } else {
                locale = this.getDefaultLocale();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Locale locale = (Locale)session.getAttribute("USER_LOCALE");
            if (locale == null) {
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                if (loginId == null) {
                    locale = ResourceBundleMgr.getInstance().getUserLocale(request, response);
                } else {
                    locale = ResourceBundleMgr.getInstance().getClientLocale(loginId, request);
                    session.setAttribute("USER_LOCALE", (Object)locale);
                    JSONObject systemSettings = new JSONObject();
                    systemSettings.put("USER_LOCALE", (Object)locale);
                    session.setAttribute("AAA_SYSTEM_SETTINGS", (Object)systemSettings);
                }
            }
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            LocalizationContext lContext = null;
            lContext = new LocalizationContext((ResourceBundle)rb, locale);
            Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)lContext);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Locale getDefaultLocale() {
        Locale locale = new Locale("en", "US");
        try {
            Criteria crit = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"BASE_BUILD_LANGUAGE", 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("SystemParams");
                String localeStr = (String)r.get("PARAM_VALUE");
                String[] splits = localeStr.split("_");
                locale = new Locale(splits[0], splits[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }
}

