/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class SystemResourceBundle
extends ResourceBundle {
    private Properties resBund = null;
    private Locale locale = null;

    public SystemResourceBundle(Locale locale) {
        try {
            File propFile;
            this.locale = locale;
            String location = System.getProperty("SERVER_HOME") + File.separator + "resources" + File.separator + "adssp" + File.separator + "system";
            File dir = new File(location);
            final String localeFile = this.getLocaleFile("SystemResources");
            String[] filesList = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(localeFile);
                }
            });
            String resourceFileName = location + File.separator + localeFile;
            if (filesList.length != 0) {
                resourceFileName = location + File.separator + filesList[filesList.length - 1];
            }
            if (!(propFile = new File(resourceFileName)).exists()) {
                resourceFileName = location + File.separator + "SystemResources_en_US.properties";
            }
            FileInputStream stream = new FileInputStream(resourceFileName);
            this.resBund = new Properties();
            this.resBund.load(stream);
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object handleGetObject(String key) {
        if (this.resBund == null) {
            return key;
        }
        if (this.resBund.get(key) == null || "".equals(this.resBund.get(key))) {
            return key;
        }
        return this.resBund.get(key);
    }

    public Enumeration getKeys() {
        return this.resBund.keys();
    }

    public String getLocaleFile(String fName) {
        String file = fName;
        try {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            file = country != null && !country.equals("") ? fName + "_" + language + "_" + country : fName + "_" + language;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }
}

