/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import com.adventnet.sym.adsm.common.server.i18n.SystemResourceBundle;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemResourceBundleHandler {
    private HashMap rbLocaleMap = new HashMap();
    private HashMap jsLocaleMap = new HashMap();

    public SystemResourceBundle getBundle() {
        return this.getBundle(this.getServerLocale());
    }

    public SystemResourceBundle getLocalizedBuildBundle() {
        return this.getBundle(this.getLocalizedBuildLocale());
    }

    public SystemResourceBundle getBundle(Locale locale) {
        SystemResourceBundle rb = null;
        try {
            rb = (SystemResourceBundle)this.rbLocaleMap.get(locale);
            if (rb == null) {
                rb = new SystemResourceBundle(locale);
                this.rbLocaleMap.put(locale, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb;
    }

    public Locale getLocalizedBuildLocale() {
        Locale locale = new Locale("en", "US");
        try {
            File sysParamFile = new File("../conf/adssp/system-params.xml");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(sysParamFile);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("SystemParams");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                Element eElement = (Element)nNode;
                String paramName = eElement.getAttribute("param_name");
                if (paramName == null || !paramName.equalsIgnoreCase("BASE_BUILD_LANGUAGE")) continue;
                String localeStr = eElement.getAttribute("param_value");
                String[] splits = localeStr.split("_");
                locale = new Locale(splits[0], splits[1]);
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }

    public Locale getServerLocale() {
        Locale locale = Locale.getDefault();
        return locale;
    }
}

