/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mail;

import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SendMailAPI {
    private static SendMailAPI handle;
    private static Logger sendMailAPILogger;
    private static Hashtable auditProps;
    public static final String PRIORITY_HIGH = "High";
    public static final String PRIORITY_LOW = "Low";

    public static SendMailAPI getInstance() {
        if (handle == null) {
            handle = new SendMailAPI();
        }
        return handle;
    }

    public String sendMail(HashMap map, Hashtable updateStatus, Properties mailServerProp) throws Exception {
        auditProps = new Hashtable();
        String objectGuid = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        String status = "adssp.common.text.mail_sent_success";
        try {
            String priority;
            File[] fList;
            File cpFile;
            int i;
            String messageInHtml;
            String mailServer = (String)mailServerProp.get("MAIL_SERVER");
            String mailPort = (String)mailServerProp.get("SMTP_PORT");
            String fromAddress = (String)mailServerProp.get("FROM_ADDRESS");
            String mailAuthenUser = (String)mailServerProp.get("MAIL_SERVER_USER");
            String mailAuthenPwd = (String)mailServerProp.get("MAIL_SERVER_PWD");
            String securityType = (String)mailServerProp.get("USE_SECURE_CONNECTION");
            String isHtmlFormat = (String)mailServerProp.get("HTML_FORMAT");
            String attType = (String)map.get("ATTACHMENT_TYPE");
            objectGuid = (String)map.get("OBJECT_GUID");
            String domainName = (String)map.get("DOMAIN_NAME");
            if (domainName != null && SendMailAPI.isZohoCorpDomain(domainName)) {
                status = "adssp.common.text.failure";
                return status;
            }
            if (domainName != null) {
                auditProps.put("DOMAIN_NAME", domainName);
                auditProps.put("MAIL_SENT_TIME", (Long)map.get("MAIL_SENT_TIME"));
            }
            if (map.containsKey("DOMAIN_LIST")) {
                auditProps.put("DOMAIN_LIST", (String)map.get("DOMAIN_LIST"));
            } else {
                auditProps.put("DOMAIN_LIST", "");
            }
            if ((String)map.get("NOTIFICATION_TYPE") != null && (String)map.get("ACTION_NAME") != null && (String)map.get("NAME") != null) {
                auditProps.put("NOTIFICATION_TYPE", (String)map.get("NOTIFICATION_TYPE"));
                auditProps.put("ACTION_NAME", (String)map.get("ACTION_NAME"));
                if (((String)map.get("ACTION_NAME")).equalsIgnoreCase("adssp.reports.audit_report.notification_delivery_report.mail_to_admin")) {
                    auditProps.put("MAIL_SUBJECT", rb.getString((String)map.get("MAIL_SUBJECT")));
                    auditProps.put("MAIL_CONTENT", rb.getString((String)map.get("MAIL_CONTENT")));
                }
                auditProps.put("NAME", (String)map.get("NAME"));
            }
            String subject = rb.getString((String)map.get("MAIL_SUBJECT"));
            String message = rb.getString((String)map.get("MAIL_CONTENT"));
            if (!message.equals((String)map.get("MAIL_CONTENT")) && isHtmlFormat.equals("true") && !(messageInHtml = rb.getString((String)map.get("MAIL_CONTENT") + "_html")).equals((String)map.get("MAIL_CONTENT") + "_html")) {
                message = messageInHtml;
            }
            Properties systemProps = System.getProperties();
            Properties properties = (Properties)systemProps.clone();
            properties.put("mail.smtp.host", mailServer);
            properties.put("mail.smtp.port", mailPort);
            properties.put("mail.smtp.sendpartial", "true");
            Session session = null;
            boolean authRequired = false;
            properties.put("mail.smtp.auth", "false");
            if (!(mailAuthenUser == null || mailAuthenPwd == null || mailAuthenUser.equals("") && mailAuthenPwd.equals(""))) {
                properties.put("mail.smtp.auth", "true");
                authRequired = true;
            }
            if ("SSL".equalsIgnoreCase(securityType)) {
                properties.put("mail.smtp.socketFactory.port", mailPort);
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.put("mail.smtp.socketFactory.fallback", "false");
            } else if ("TLS".equalsIgnoreCase(securityType)) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.smtp.starttls.required", "true");
            }
            if (authRequired) {
                SMTPAuthenticator auth = new SMTPAuthenticator(mailAuthenUser, mailAuthenPwd);
                session = Session.getInstance((Properties)properties, (Authenticator)auth);
            } else {
                session = Session.getInstance((Properties)properties);
            }
            session.setDebug(false);
            MimeMessage mess = new MimeMessage(session);
            if (map.get("MAIL_IDS") != null) {
                String[] to = (String[])map.get("MAIL_IDS");
                InternetAddress[] toInternetAddress = new InternetAddress[to.length];
                for (i = 0; i < to.length; ++i) {
                    toInternetAddress[i] = new InternetAddress(to[i].trim());
                }
                mess.setRecipients(Message.RecipientType.TO, (Address[])toInternetAddress);
            }
            if (fromAddress != null && !fromAddress.equals("")) {
                InternetAddress address = new InternetAddress(fromAddress);
                String personal = address.getPersonal();
                if (personal != null) {
                    address.setPersonal(personal, "utf-8");
                }
                mess.setFrom((Address)address);
            }
            mess.setSentDate(new Date());
            if (map.get("CC_ADDRESS") != null) {
                String[] cc = (String[])map.get("CC_ADDRESS");
                InternetAddress[] ccInternetAddress = new InternetAddress[cc.length];
                for (i = 0; i < cc.length; ++i) {
                    ccInternetAddress[i] = new InternetAddress(cc[i].trim());
                }
                mess.setRecipients(Message.RecipientType.CC, (Address[])ccInternetAddress);
            }
            mess.setSubject(subject);
            String type = "text/html;charset=UTF-8";
            if (!"true".equalsIgnoreCase(isHtmlFormat)) {
                type = "text/plain;charset=UTF-8";
            }
            mess.setContent((Object)message, type);
            if (message.contains("<br><table border='1'>") && "false".equalsIgnoreCase(isHtmlFormat)) {
                MimeMultipart newMessage = new MimeMultipart("mixed");
                MimeMultipart messageBody = new MimeMultipart();
                Integer updatedAttrStart = message.indexOf("<br><table border='1'>");
                Integer updatedAttrEnd = message.indexOf("</table>") + 8;
                String textMessage = message.substring(0, updatedAttrStart);
                String htmlMessage = message.substring(updatedAttrStart, updatedAttrEnd);
                String textMessage2 = message.substring(updatedAttrEnd);
                MimeBodyPart plainTextPart = new MimeBodyPart();
                plainTextPart.setText(textMessage, "utf-8");
                MimeBodyPart htmlTextPart = new MimeBodyPart();
                htmlTextPart.setContent((Object)htmlMessage, "text/html;charset=UTF-8");
                MimeBodyPart plainTextPart2 = new MimeBodyPart();
                plainTextPart2.setText(textMessage2, "utf-8");
                messageBody.addBodyPart((BodyPart)plainTextPart);
                messageBody.addBodyPart((BodyPart)htmlTextPart);
                messageBody.addBodyPart((BodyPart)plainTextPart2);
                MimeBodyPart alternativeBodyPart = new MimeBodyPart();
                alternativeBodyPart.setContent((Multipart)messageBody);
                newMessage.addBodyPart((BodyPart)alternativeBodyPart);
                mess.setContent((Multipart)newMessage);
            }
            if (attType != null && !attType.equals("")) {
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)message, type);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                String dir = (String)map.get("DIRECTORY_PATH");
                if (attType.equalsIgnoreCase("FILE")) {
                    cpFile = new File(dir);
                    fList = cpFile.listFiles();
                    AdventNetResourceBundle rbEng = ResourceBundleMgr.getInstance().getBundle(Locale.ENGLISH);
                    for (int i2 = 0; i2 < fList.length; ++i2) {
                        Boolean attachFile = false;
                        String attachName = fList[i2].getName();
                        if (map.containsKey("EXPORT_REPORT_NAMES") && map.get("EXPORT_REPORT_NAMES") != null) {
                            ArrayList repNames = (ArrayList)map.get("EXPORT_REPORT_NAMES");
                            for (int k = 0; k < repNames.size(); ++k) {
                                String repFile = rbEng.getString((String)repNames.get(k));
                                sendMailAPILogger.log(Level.INFO, "repFile::" + repFile);
                                if (!attachName.contains(repFile)) continue;
                                attachFile = true;
                            }
                        } else {
                            attachFile = true;
                        }
                        if (attachName.equalsIgnoreCase("adssp-reports.zip") || !attachFile.booleanValue()) continue;
                        messageBodyPart = new MimeBodyPart();
                        FileDataSource source = new FileDataSource(fList[i2]);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                        messageBodyPart.setFileName(attachName);
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                } else if (attType.equalsIgnoreCase("ZIP")) {
                    String localfile = dir + File.separator + "adssp-reports.zip";
                    messageBodyPart = new MimeBodyPart();
                    FileDataSource source = new FileDataSource(localfile);
                    messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                    messageBodyPart.setFileName("REPORTS.zip");
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                }
                mess.setContent((Multipart)multipart);
            }
            if (map.get("MAIL_PRIORITY") != null && ((priority = (String)map.get("MAIL_PRIORITY")).equalsIgnoreCase(PRIORITY_HIGH) || priority.equalsIgnoreCase(PRIORITY_LOW))) {
                mess.setHeader("Importance", priority);
                mess.setHeader("X-Priority", priority);
            }
            if (map.get("MAIL_ATT_PATH") != null) {
                String attDir = (String)map.get("MAIL_ATT_PATH");
                MimeBodyPart messageBodyPart = new MimeBodyPart();
                messageBodyPart.setContent((Object)message, type);
                MimeMultipart multipart = new MimeMultipart();
                multipart.addBodyPart((BodyPart)messageBodyPart);
                if (!attDir.equals("-") && (fList = (cpFile = new File(attDir)).listFiles()) != null) {
                    for (int j = 0; j < fList.length; ++j) {
                        String attachName = fList[j].getName();
                        attachName = MimeUtility.encodeText((String)attachName, (String)"UTF-8", (String)"B");
                        messageBodyPart = new MimeBodyPart();
                        FileDataSource source = new FileDataSource(fList[j]);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
                        messageBodyPart.setFileName(attachName);
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                }
                mess.setContent((Multipart)multipart);
            }
            Transport.send((Message)mess);
            if (domainName != null) {
                auditProps.put("STATUS", "adssp.common.text.success");
                auditProps.put("DELIVERED_TIME", System.currentTimeMillis());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleSendFailedException(e, map, auditProps);
            status = (String)auditProps.get("STATUS");
        }
        if (objectGuid != null) {
            updateStatus.put(objectGuid, auditProps);
        }
        return status;
    }

    private void handleSendFailedException(Exception mex, HashMap map, Hashtable auditProps) {
        sendMailAPILogger.log(Level.INFO, "The Error occurs in the SendFailedException.");
        Exception ex = mex;
        boolean resend = false;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        do {
            if (ex instanceof SendFailedException) {
                Address[] validSent;
                StringBuffer error = new StringBuffer();
                SendFailedException sfex = (SendFailedException)ex;
                Address[] invalid = sfex.getInvalidAddresses();
                if (invalid != null) {
                    auditProps.put("STATUS", rb.getString("adssp.reports.ste_delivery_rep_invalid_email_id"));
                    sendMailAPILogger.log(Level.INFO, "InvalidAddresses :: " + invalid);
                    break;
                }
                Address[] validUnsent = sfex.getValidUnsentAddresses();
                if (validUnsent != null) {
                    sendMailAPILogger.log(Level.INFO, "ValidUnsentAddresses :: " + validUnsent);
                    if (!resend && validUnsent.length > 0) {
                        sendMailAPILogger.log(Level.INFO, "Resending in Valid Unsent Address");
                        resend = true;
                    }
                }
                if ((validSent = sfex.getValidSentAddresses()) != null) {
                    sendMailAPILogger.log(Level.INFO, "ValidSentAddresses :: " + validSent);
                }
                if (validUnsent == null && validSent == null && invalid == null && sfex.getMessage().indexOf("Could not connect to SMTP host") != -1) {
                    auditProps.put("STATUS", rb.getString("adssp.reports.ste_delivery_rep_could_not_connect_smtp_host"));
                    if (!resend) {
                        sendMailAPILogger.log(Level.INFO, "Resending in Could not connect to SMTP host ");
                        resend = true;
                    }
                    sendMailAPILogger.log(Level.INFO, "Could not connect to SMTP host error occurs");
                    break;
                }
                if (ex.getMessage().contains("Unknown SMTP host")) {
                    auditProps.put("STATUS", rb.getString("adssp.reports.ste_delivery_rep_network_failure"));
                    sendMailAPILogger.log(Level.INFO, "Network Failure or Mail Server Down " + ex.getMessage());
                    if (resend) break;
                    sendMailAPILogger.log(Level.INFO, "Resending in Network Failure ");
                    resend = true;
                    break;
                }
                if (ex.getMessage().contains("AuthenticationFailedException")) {
                    auditProps.put("STATUS", rb.getString("adssp.admin.productsettings.serversettings.wrong_authentication"));
                    sendMailAPILogger.log(Level.INFO, "Authentication given is mismatch with mail server " + ex.getMessage());
                    break;
                }
                if (ex.getMessage().contains("Unrecognized SSL message")) {
                    auditProps.put("STATUS", rb.getString("adssp.admin.productsettings.serversettings.secure_connection"));
                    sendMailAPILogger.log(Level.INFO, "Secure Connection enabled" + ex.getMessage());
                    break;
                }
                if (ex.getMessage().contains("Invalid domain name")) {
                    auditProps.put("STATUS", rb.getString("adssp.reports.ste_delivery_rep_invalid_domain_name"));
                    sendMailAPILogger.log(Level.INFO, "Sending mail failed : " + ex.getMessage());
                    break;
                }
                if (ex.getMessage().contains("Must issue a STARTTLS command first")) {
                    auditProps.put("STATUS", rb.getString("adssp.admin.server_settings.mail.start_tls"));
                    sendMailAPILogger.log(Level.INFO, "Must issue a STARTTLS command first : " + ex.getMessage());
                    break;
                }
                if (ex.getMessage() == null) continue;
                auditProps.put("STATUS", ex.getMessage());
                sendMailAPILogger.log(Level.INFO, "Unknown exception occured : " + ex.getMessage());
                break;
            }
            if (ex instanceof IOException) {
                auditProps.put("STATUS", rb.getString("adssp.reports.ste_delivery_rep_network_failure") + " : [" + ex.getMessage() + "]");
                sendMailAPILogger.log(Level.INFO, "Network Failure or Mail Server Down " + ex.getMessage());
                if (resend) break;
                sendMailAPILogger.log(Level.INFO, "Resending in Network Failure ");
                resend = true;
                break;
            }
            if (ex instanceof AuthenticationFailedException) {
                auditProps.put("STATUS", rb.getString("adssp.admin.server_settings.mail.username_pwd"));
                sendMailAPILogger.log(Level.INFO, "Username and Password not accepted : " + ex.getMessage());
                break;
            }
            if (ex instanceof MessagingException) {
                Throwable cause = ex.getCause();
                if (cause != null && cause.getMessage() != null && cause.getMessage().contains("sun.security.provider.certpath.SunCertPathBuilderException: unable to find valid certification path to requested target")) {
                    auditProps.put("STATUS", rb.getString("adssp.admin.server_settings.not_trusted_smtp_cert"));
                    break;
                }
                auditProps.put("STATUS", ex.getMessage());
                sendMailAPILogger.log(Level.INFO, "The exception is :" + ex.getMessage());
                break;
            }
            auditProps.put("STATUS", ex.getMessage());
            sendMailAPILogger.log(Level.INFO, "The exception is :" + ex.getMessage());
            break;
        } while (ex != null);
    }

    public String sendNotification(String domainName, Properties mailConfig, String subject, String mailText, ArrayList mailID) {
        String message = "Successfully mail sent !";
        try {
            MailAction mail = new MailAction(mailID, mailConfig, subject, mailText, domainName, message);
            mail.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        return message;
    }

    public static String getFormatValue(String message, String name) {
        int lastIndex1;
        int prevIndex = 0;
        int index = message.indexOf("%");
        int length = message.length();
        StringBuffer value = new StringBuffer();
        while (index != -1) {
            int nextIndex = message.indexOf("%", index + 1);
            String prevStr = message.substring(prevIndex, index);
            prevStr = prevStr.replaceAll("\"", "");
            value.append(prevStr);
            if (nextIndex != -1) {
                String noOfLetters = "";
                if (length > nextIndex + 1 && Character.isDigit(message.charAt(nextIndex + 1))) {
                    noOfLetters = new Character(message.charAt(nextIndex + 1)).toString();
                    if (length > nextIndex + 2 && Character.isDigit(message.charAt(nextIndex + 2))) {
                        noOfLetters = noOfLetters + new Character(message.charAt(nextIndex + 2)).toString();
                    }
                }
                String toBeReplaced = message.substring(index + 1, nextIndex);
                String str = null;
                if (str != null) {
                    if (!noOfLetters.equals("")) {
                        int letters = Integer.parseInt(noOfLetters);
                        if (str.length() >= letters) {
                            value.append(str.substring(0, letters));
                        } else {
                            value.append(str);
                        }
                    } else {
                        value.append(str);
                    }
                    nextIndex += noOfLetters.length();
                } else if (toBeReplaced.equals("user")) {
                    value.append(name);
                } else {
                    value.append(message.substring(index, nextIndex + 1));
                }
                prevIndex = nextIndex + 1;
                index = message.indexOf("%", nextIndex + 1);
                continue;
            }
            prevIndex = index;
            index = nextIndex;
        }
        String lastStr = message.substring(prevIndex).replaceAll("\"", "");
        value.append(lastStr);
        String s = value.toString();
        int index1 = s.indexOf("%");
        if (index1 > 0 && (lastIndex1 = s.lastIndexOf("%", index1 + 1)) > 0) {
            s = SendMailAPI.getFormatValue(s, name);
        }
        return s;
    }

    public static boolean isZohoCorpDomain(String domainName) {
        boolean isDevMode;
        boolean isZohoCorp;
        boolean bl = isZohoCorp = domainName.equalsIgnoreCase("zohocorp") || domainName.equalsIgnoreCase("csez.zohocorpin.com");
        if (isZohoCorp && (isDevMode = Boolean.valueOf(ADSMPersUtil.getSyMParameter("DEVELOPMENT_MODE")).booleanValue())) {
            sendMailAPILogger.log(Level.INFO, "Scheduler is restricted for Zohocorp domain");
            return true;
        }
        return false;
    }

    static {
        sendMailAPILogger = Logger.getLogger("sendMailAPILogger");
        auditProps = new Hashtable();
    }

    public class MailAction
    extends Thread {
        private ArrayList mailList = null;
        private Properties mailConfig = null;
        private String subject = null;
        private String messageText = null;
        private String domainName = null;
        private String message = "";
        private String subj = "";

        public MailAction(ArrayList list, Properties mailConfig, String subj, String body, String domainName, String message) {
            this.mailList = list;
            this.mailConfig = mailConfig;
            this.subject = subj;
            this.subj = subj;
            this.messageText = body;
            this.message = body;
            this.domainName = domainName;
        }

        @Override
        public void run() {
            Hashtable<String, Hashtable> updateStatus = new Hashtable<String, Hashtable>();
            int idsLen = this.mailList.size();
            Properties mailServerProp = ADSMPersUtil.getMailServerSettings();
            for (int i = 0; i < idsLen; ++i) {
                try {
                    String[] toAddr;
                    String email;
                    int j;
                    this.messageText = this.message;
                    this.subject = this.subj;
                    Properties p = (Properties)this.mailList.get(i);
                    ArrayList mailIds = (ArrayList)p.get("mail") != null ? (ArrayList)p.get("mail") : new ArrayList();
                    ArrayList secMailIds = (ArrayList)p.get("secMail") != null ? (ArrayList)p.get("secMail") : new ArrayList();
                    String name = (String)p.get("name");
                    String samAccountName = (String)p.get("samAccountName");
                    String objectGUID = (String)p.get("objectGUID");
                    String nType = (String)p.get("nType");
                    String actionName = (String)p.get("actionName");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    Boolean notifyAll = "true".equals(ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY"));
                    Boolean isEnrollmentNoti = "adssp.reports.audit_report.notification_delivery_report.mail".equalsIgnoreCase(nType);
                    String tempStatus = "";
                    Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
                    keyPairValue.put("userName", (String)p.get("name"));
                    keyPairValue.put("accessURL", AdminHandler.getAccessURL());
                    if (!objectGUID.equals("")) {
                        this.messageText = FormatUtil.getNameFormats(this.domainName, this.messageText, objectGUID, "objectGUID", keyPairValue);
                        this.subject = FormatUtil.getNameFormats(this.domainName, this.subject, objectGUID, "objectGUID", keyPairValue);
                    } else {
                        objectGUID = name;
                        this.messageText = FormatUtil.getNameFormats(this.domainName, this.messageText, keyPairValue);
                        this.subject = FormatUtil.getNameFormats(this.domainName, this.subject, keyPairValue);
                    }
                    map.put("MAIL_SERVER", (String)this.mailConfig.get("MAIL_SERVER"));
                    map.put("FROM_ADDRESS", (String)this.mailConfig.get("FROM_ADDRESS"));
                    map.put("MAIL_SUBJECT", this.subject);
                    map.put("MAIL_CONTENT", this.messageText);
                    map.put("SMTP_PORT", (String)this.mailConfig.get("SMTP_PORT"));
                    map.put("MAIL_SERVER_USER", (String)this.mailConfig.get("MAIL_SERVER_USER"));
                    map.put("MAIL_SERVER_PWD", (String)this.mailConfig.get("MAIL_SERVER_PWD"));
                    map.put("DOMAIN_NAME", this.domainName);
                    map.put("OBJECT_GUID", objectGUID);
                    map.put("NAME", samAccountName);
                    if (samAccountName == null) {
                        map.put("NAME", name);
                    }
                    map.put("MAIL_SENT_TIME", System.currentTimeMillis());
                    map.put("NOTIFICATION_TYPE", nType);
                    map.put("ACTION_NAME", actionName);
                    for (j = 0; j < mailIds.size(); ++j) {
                        email = (String)mailIds.get(j);
                        toAddr = new String[]{email};
                        map.put("MAIL_IDS", toAddr);
                        if (!SendMailAPI.this.sendMail(map, updateStatus, mailServerProp).equals("adssp.common.text.mail_sent_success")) continue;
                        tempStatus = "adssp.common.text.success";
                        if (!notifyAll.booleanValue() || !isEnrollmentNoti.booleanValue()) break;
                    }
                    for (j = 0; j < secMailIds.size() && notifyAll.booleanValue() && isEnrollmentNoti.booleanValue(); ++j) {
                        email = (String)secMailIds.get(j);
                        if ("".equals(email)) continue;
                        toAddr = new String[]{email};
                        map.put("MAIL_IDS", toAddr);
                        if (!SendMailAPI.this.sendMail(map, updateStatus, mailServerProp).equals("adssp.common.text.mail_sent_success")) continue;
                        tempStatus = "adssp.common.text.success";
                    }
                    if (tempStatus == "") continue;
                    Hashtable mailAuditProps = (Hashtable)updateStatus.get(objectGUID);
                    mailAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                    mailAuditProps.put("STATUS", tempStatus);
                    updateStatus.put(objectGUID, mailAuditProps);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            AuditAPI.getInstance();
            AuditAPI.addAuditLogs(updateStatus);
        }
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String userName = null;
        private String password = null;

        public SMTPAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (this.userName != null && this.password != null) {
                return new PasswordAuthentication(this.userName, this.password);
            }
            return null;
        }
    }
}

