/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mailalias;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UnionQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class GSConfigHandler {
    public static final String GRP_SUBCRIPT_TABLE = "SSPGroupSubscriptions";
    public static final String GS_GROUPS_TABLE = "SSPGSGroups";
    public static final String GS_USERS_TABLE = "SSPGSUsers";
    public static final String GS_OUS_TABLE = "SSPGSOUs";
    public static final int TRUE = 1;
    public static final int FALSE = 0;

    public static JSONObject getSubscriptionsList() {
        JSONObject retJson = null;
        try {
            DataObject obj;
            Criteria crit = null;
            Credential cred = AuthUtil.getUserCredential();
            Long loginId = cred.getLoginId();
            if (!ADMPRoleHandler.isADSSPUser(loginId)) {
                crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"DOMAIN_NAME"), (Object)DomainHandler.getDomainName(loginId), 0, false);
            }
            if (!(obj = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, crit)).isEmpty()) {
                retJson = new JSONObject();
                int i = 0;
                Iterator subscriptionIterator = obj.getRows(GRP_SUBCRIPT_TABLE);
                while (subscriptionIterator.hasNext()) {
                    Row r = (Row)subscriptionIterator.next();
                    JSONObject subJson = new JSONObject();
                    Long subId = (Long)r.get("SUB_ID");
                    String domainName = r.get("DOMAIN_NAME").toString();
                    subJson.put("SUB_ID", (Object)subId);
                    subJson.put("NAME", (Object)r.get("NAME").toString());
                    subJson.put("DESCRIPTION", (Object)r.get("DESCRIPTION").toString());
                    subJson.put("DOMAIN_NAME", (Object)domainName);
                    subJson.put("STATUS", (Object)((Boolean)r.get("STATUS")));
                    subJson.put("VIEW_MEMBERS", (Integer)r.get("VIEW_MEMBERS") == 1);
                    subJson.put("DONT_INHERIT_OUS", (Object)((Boolean)r.get("DONT_INHERIT_OUS")));
                    subJson.put("GROUPS", (Object)GSConfigHandler.getSubscriptionDetails(subId, domainName, "GROUPS", null));
                    JSONArray usrsJson = GSConfigHandler.getSubscriptionDetails(subId, domainName, "USERS", null);
                    subJson.put("USERS", (Object)GSConfigHandler.getSubscriptionDetails(subId, null, "OUS", usrsJson));
                    retJson.put(i + "", (Object)subJson);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retJson;
    }

    public static JSONObject getSubscriptionDetails(Long subId) {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject();
            Criteria crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"SUB_ID"), (Object)subId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, crit);
            Row r = obj.getFirstRow(GRP_SUBCRIPT_TABLE);
            String domainName = r.get("DOMAIN_NAME").toString();
            retJson.put("SUB_ID", (Object)subId);
            retJson.put("NAME", (Object)r.get("NAME").toString());
            retJson.put("DESCRIPTION", (Object)r.get("DESCRIPTION").toString());
            retJson.put("DOMAIN_NAME", (Object)domainName);
            retJson.put("STATUS", (Object)((Boolean)r.get("STATUS")));
            retJson.put("VIEW_MEMBERS", (Integer)r.get("VIEW_MEMBERS") == 1);
            retJson.put("DONT_INHERIT_OUS", (Object)((Boolean)r.get("DONT_INHERIT_OUS")));
            JSONArray usrsJson = GSConfigHandler.getSubscriptionDetails(subId, domainName, "USERS", null);
            retJson.put("GROUPS", (Object)GSConfigHandler.getSubscriptionDetails(subId, domainName, "GROUPS", null));
            retJson.put("USERS", (Object)GSConfigHandler.getSubscriptionDetails(subId, null, "OUS", usrsJson));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retJson;
    }

    public static JSONArray getSubscriptionDetails(Long subId, String domainName, String retObj, JSONArray retJson) {
        try {
            if (subId == null || subId == 0L) {
                return null;
            }
            if (retJson == null) {
                retJson = new JSONArray();
            }
            if ((domainName == null || domainName != null && domainName.equals("")) && !retObj.equalsIgnoreCase("OUS")) {
                Criteria crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"SUB_ID"), (Object)subId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, crit);
                Row r = obj.getFirstRow(GRP_SUBCRIPT_TABLE);
                domainName = r.get("DOMAIN_NAME").toString();
            }
            String baseTable = "";
            String joinTable = "";
            String attrib = "";
            String objClass = "";
            ArrayList<Column> columns = null;
            String[] selCols = null;
            String[] selAtts = null;
            Query sq = null;
            Criteria criteria = null;
            if (retObj.equalsIgnoreCase("GROUPS")) {
                String rootDomainNamingcontext = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "ROOT_DOMAIN_NAMING_CONTEXT");
                ArrayList domainList = DomainHandler.getForestDomains(rootDomainNamingcontext, AuthUtil.getUserCredential().getLoginId());
                baseTable = GS_GROUPS_TABLE;
                attrib = "DISPLAY_NAME";
                objClass = "group";
                selCols = new String[]{"OBJECT_GUID", attrib, "DOMAIN_NAME"};
                selAtts = new String[]{"OBJECT_GUID", "OBJECT_NAME", "DOMAIN_NAME"};
                criteria = new Criteria(Column.getColumn((String)baseTable, (String)"SUB_ID"), (Object)subId, 0);
                Query unionQuery = null;
                Query prevQuery = null;
                for (Properties domainProp : domainList) {
                    joinTable = CommonUtil.getDomainGroupTableName(domainProp.get("DOMAIN_NAME").toString());
                    columns = new ArrayList<Column>(Arrays.asList(Column.getColumn((String)baseTable, (String)"OBJECT_GUID"), Column.getColumn((String)joinTable, (String)attrib), Column.getColumn((String)joinTable, (String)"DOMAIN_NAME")));
                    Query curQuery = GSConfigHandler.getGStableQuery(baseTable, joinTable, columns, criteria, attrib);
                    if (unionQuery != null) {
                        unionQuery.union(curQuery, false);
                    } else if (prevQuery != null) {
                        unionQuery = new UnionQueryImpl(prevQuery, curQuery, false);
                    }
                    prevQuery = curQuery;
                }
                sq = unionQuery != null ? unionQuery : prevQuery;
            } else if (retObj.equalsIgnoreCase("USERS") || retObj.equalsIgnoreCase("OUS")) {
                if (retObj.equalsIgnoreCase("USERS")) {
                    baseTable = GS_USERS_TABLE;
                    joinTable = CommonUtil.getDomainUserTableName(domainName);
                    attrib = "SAM_ACCOUNT_NAME";
                    objClass = "user";
                } else if (retObj.equalsIgnoreCase("OUS")) {
                    baseTable = GS_OUS_TABLE;
                    joinTable = "ADSMOUDetails";
                    attrib = "NAME";
                    objClass = "ou";
                }
                selCols = new String[]{"OBJECT_GUID", attrib};
                selAtts = new String[]{"OBJECT_GUID", "OBJECT_NAME"};
                columns = new ArrayList<Column>(Arrays.asList(Column.getColumn((String)baseTable, (String)"OBJECT_GUID"), Column.getColumn((String)joinTable, (String)attrib)));
                criteria = new Criteria(Column.getColumn((String)baseTable, (String)"SUB_ID"), (Object)subId, 0);
                sq = GSConfigHandler.getGStableQuery(baseTable, joinTable, columns, criteria, attrib);
            } else {
                return retJson;
            }
            if (sq != null) {
                retJson = GSConfigHandler.getGStableData(sq, selCols, selAtts, objClass, retJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retJson;
    }

    public static Query getGStableQuery(String baseTable, String joinTable, List<Column> columns, Criteria criteria, String sortColumnName) {
        SelectQueryImpl sq = new SelectQueryImpl(new Table(baseTable));
        try {
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
            sq.addSelectColumns(columns);
            SortColumn sortColumn = new SortColumn(joinTable, sortColumnName, true);
            sq.addSortColumn(sortColumn);
            sq.setCriteria(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getGStableData(Query sq, String[] columns, String[] attribs, String objClass, JSONArray retJson) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery(sq, connection);
            while (dataSet.next()) {
                JSONObject jsonobj = new JSONObject();
                for (int i = 0; i < columns.length; ++i) {
                    jsonobj.put(attribs[i], (Object)((String)dataSet.getValue(columns[i])));
                }
                jsonobj.put("OBJECT_CLASS", (Object)objClass);
                retJson.put((Object)jsonobj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retJson;
    }

    public static String addSubscription(HttpServletRequest request) {
        Long subId = 0L;
        try {
            DataObject subDO;
            String id = request.getParameter("subId");
            String name = request.getParameter("name");
            String grps = StrUtil.htmlUnescape(request.getParameter("hidden_grps"));
            String usrs = StrUtil.htmlUnescape(request.getParameter("hidden_usrs"));
            JSONObject grpsJson = new JSONObject(grps);
            JSONObject usrsJson = new JSONObject(usrs);
            Boolean hasGroup = grpsJson.has("group");
            Boolean hasUser = usrsJson.has("user");
            Boolean hasOu = usrsJson.has("ou");
            if (!hasGroup.booleanValue() || hasGroup.booleanValue() && grpsJson.getJSONObject("group").length() == 0 || (hasUser == false || hasUser != false && usrsJson.getJSONObject("user").length() == 0) & (hasOu == false || hasOu != false && usrsJson.getJSONObject("ou").length() == 0)) {
                return "adssp.admin.general.adsearch.update_error";
            }
            if (id != null && !"".equals(id)) {
                GSConfigHandler.deleteSubscription(Long.parseLong(id));
            }
            if (!(subDO = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"NAME"), (Object)name, 0, false))).isEmpty()) {
                return "adssp.configuration.selfservice.error_subscription_name_exists";
            }
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row(GRP_SUBCRIPT_TABLE);
            r.set("NAME", (Object)name);
            r.set("DESCRIPTION", (Object)request.getParameter("desc"));
            r.set("DOMAIN_NAME", (Object)request.getParameter("domainName"));
            r.set("VIEW_MEMBERS", (Object)(request.getParameter("viewMembers") != null ? 1 : 0));
            r.set("DONT_INHERIT_OUS", (Object)(request.getParameter("dontInheritOus") != null ? 1 : 0));
            r.set("STATUS", (Object)true);
            obj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            subId = (Long)r.get("SUB_ID");
            GSConfigHandler.addSubComponents("group", grpsJson.getJSONObject("group"), subId);
            if (hasUser.booleanValue()) {
                GSConfigHandler.addSubComponents("user", usrsJson.getJSONObject("user"), subId);
            }
            if (hasOu.booleanValue()) {
                GSConfigHandler.addSubComponents("ou", usrsJson.getJSONObject("ou"), subId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (subId != 0L) {
                GSConfigHandler.deleteSubscription(subId);
            }
            return "adssp.admin.general.adsearch.update_error";
        }
        return "adssp.common.text.success";
    }

    public static void addSubComponents(String componentType, JSONObject component, Long subId) {
        try {
            String table = componentType.equalsIgnoreCase("group") ? GS_GROUPS_TABLE : (componentType.equalsIgnoreCase("user") ? GS_USERS_TABLE : GS_OUS_TABLE);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Iterator objIterator = component.keys();
            while (objIterator.hasNext()) {
                Row ouRow = new Row(table);
                ouRow.set("SUB_ID", (Object)subId);
                ouRow.set("OBJECT_GUID", (Object)((String)objIterator.next()));
                obj.addRow(ouRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteSubscription(Long subId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"SUB_ID"), (Object)subId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String changeStatus(Long subId) {
        Boolean status = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"SUB_ID"), (Object)subId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, crit);
            Row r = obj.getFirstRow(GRP_SUBCRIPT_TABLE);
            status = (Boolean)r.get("STATUS");
            r.set("STATUS", (Object)(status == false ? 1 : 0));
            obj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return status == false ? "enableIcon" : "disableIcon";
    }

    public static void deleteFromGSUsersTable(ArrayList usersList) {
        try {
            String[] users = usersList.toArray(new String[usersList.size()]);
            Criteria crit = new Criteria(Column.getColumn((String)GS_USERS_TABLE, (String)"OBJECT_GUID"), (Object)users, 8);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean isSubscriptionNameExist(Long subId, String name) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"NAME"), (Object)name, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)GRP_SUBCRIPT_TABLE, (String)"SUB_ID"), (Object)subId, 1));
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get(GRP_SUBCRIPT_TABLE, crit);
            if (!o.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

