/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mailalias;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UnionQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.IteratorUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class GSSelfServiceHandler {
    public static Boolean isGroupsAvailableForUser(Long loginId) {
        Boolean ret = false;
        try {
            if (ADMPRoleHandler.isADSSPUser(loginId)) {
                return false;
            }
            JSONObject userDetails = GSSelfServiceHandler.getUserLoginDetails(loginId);
            String domainName = userDetails.getString("DOMAINNAME");
            String samAccName = userDetails.getString("NAME");
            ret = GSSelfServiceHandler.isGroupsAvailableForUser(domainName, samAccName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Boolean isGroupsAvailableForUser(String domainName, String samAccName) {
        try {
            List subs = GSSelfServiceHandler.getSubscriptions(domainName, samAccName);
            if (!subs.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static JSONObject getGroups(int startIndex, int numOfObjects, String searchString) {
        return GSSelfServiceHandler.getGroups(startIndex, numOfObjects, searchString, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getGroups(int startIndex, int numOfObjects, String searchString, Criteria crit, String domName) {
        Connection connection = null;
        DataSet dataSet = null;
        JSONObject retJson = null;
        try {
            Credential cred = AuthUtil.getUserCredential();
            Long loginId = cred.getLoginId();
            JSONObject userLoginDetails = GSSelfServiceHandler.getUserLoginDetails(loginId);
            String domainName = userLoginDetails.getString("DOMAINNAME");
            String samAccName = userLoginDetails.getString("NAME");
            ArrayList domainList = new ArrayList();
            if (domName != null) {
                Properties domProp = new Properties();
                domProp.put("DOMAIN_NAME", domName);
                domainList.add(domProp);
            } else {
                String rootDomainNamingcontext = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "ROOT_DOMAIN_NAMING_CONTEXT");
                domainList = DomainHandler.getForestDomains(rootDomainNamingcontext, 1L);
            }
            Boolean multipleDomains = domainList.size() > 1;
            List subscriptions = GSSelfServiceHandler.getSubscriptions(domainName, samAccName, false, domainList);
            Criteria c = null;
            if (!subscriptions.isEmpty()) {
                retJson = new JSONObject();
                retJson.put("MULTIPLE_DOMAINS", (Object)multipleDomains);
                JSONArray grpJsonArr = new JSONArray();
                Properties userProps = UserUtil.getUserData(domainName, samAccName);
                String userGUID = userProps.getProperty("objectGUID");
                ArrayList<String> attrList = new ArrayList<String>();
                attrList.add("memberOf");
                attrList.add("primaryGroupID");
                Properties userDetails = GSSelfServiceHandler.getObjectDetails(userGUID, domainName, attrList, true);
                String userGrptable = CommonUtil.getDomainGroupTableName(domainName);
                DataObject primaryGroupObj = CommonUtil.getPersistence(new boolean[0]).get(userGrptable, new Criteria(Column.getColumn((String)userGrptable, (String)"SID_STRING"), (Object)("-" + (String)((List)userDetails.get("primaryGroupID")).get(0)), 11));
                Row primaryGroupRow = primaryGroupObj.getFirstRow(userGrptable);
                ArrayList memberOf = userDetails.get("memberOf") != null ? (ArrayList)userDetails.get("memberOf") : new ArrayList();
                memberOf.add((String)primaryGroupRow.get("DN_STRING"));
                retJson.put("MEMBER_OF", (Collection)memberOf);
                c = new Criteria(Column.getColumn((String)"SSPGSGroups", (String)"SUB_ID"), (Object)subscriptions.toArray(new Long[subscriptions.size()]), 8);
                if (crit != null) {
                    c = c.and(crit);
                }
                int count = 0;
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                Query countQuery = GSSelfServiceHandler.getGroupQuery(c, searchString, "count", domainList);
                dataSet = relationalAPI.executeQuery(countQuery, connection);
                while (dataSet.next()) {
                    ++count;
                }
                if (!dataSet.isClosed()) {
                    dataSet.close();
                    dataSet = null;
                }
                Query finalQuery = GSSelfServiceHandler.getGroupQuery(c, searchString, null, domainList);
                if (startIndex > 0 && numOfObjects > 0) {
                    finalQuery.setRange(new Range(startIndex, numOfObjects));
                }
                dataSet = relationalAPI.executeQuery(finalQuery, connection);
                while (dataSet.next()) {
                    JSONObject grpJson = new JSONObject();
                    grpJson.put("OBJECT_GUID", (Object)((String)dataSet.getValue("OBJECT_GUID")));
                    grpJson.put("DN_STRING", (Object)((String)dataSet.getValue("DN_STRING")));
                    grpJson.put("DISPLAY_NAME", (Object)((String)dataSet.getValue("DISPLAY_NAME")));
                    grpJson.put("VIEW_MEMBERS", (Integer)dataSet.getValue("VIEW_MEMBERS") == 1);
                    grpJson.put("MAIL", (Object)((String)dataSet.getValue("E_MAIL")));
                    grpJson.put("DESCRIPTION", (Object)((String)dataSet.getValue("DESCRIPTION")));
                    grpJson.put("SID_STRING", (Object)((String)dataSet.getValue("SID_STRING")));
                    grpJson.put("DOMAIN_NAME", (Object)((String)dataSet.getValue("DOMAIN_NAME")));
                    grpJsonArr.put((Object)grpJson);
                }
                retJson.put("GROUPS", (Object)grpJsonArr);
                retJson.put("COUNT", count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retJson;
    }

    public static List getSubscriptions(String domainName, String samAccName) {
        return GSSelfServiceHandler.getSubscriptions(domainName, samAccName, true, new ArrayList<Properties>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSubscriptions(String domainName, String samAccName, Boolean checkAvailability, List<Properties> domainList) {
        ArrayList<Long> subIds;
        block28: {
            Connection connection = null;
            DataSet dataSet = null;
            subIds = new ArrayList<Long>();
            try {
                Object gsQuery;
                if (domainList == null || domainList != null && domainList.size() == 0) {
                    String rootDomainNamingcontext = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "ROOT_DOMAIN_NAMING_CONTEXT");
                    domainList = DomainHandler.getForestDomains(rootDomainNamingcontext, 1L);
                }
                Properties userProps = UserUtil.getUserData(domainName, samAccName);
                String userGUID = userProps.getProperty("objectGUID");
                String userDN = userProps.getProperty("distinguishedName");
                userDN = userDN.toLowerCase();
                Criteria subscriptionCrit = new Criteria(Column.getColumn((String)"SSPGroupSubscriptions", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                subscriptionCrit = subscriptionCrit.and(new Criteria(Column.getColumn((String)"SSPGroupSubscriptions", (String)"STATUS"), (Object)true, 0));
                Object unionQuery = null;
                Object prevQuery = null;
                for (Properties domainProp : domainList) {
                    String joinTable = CommonUtil.getDomainGroupTableName(domainProp.get("DOMAIN_NAME").toString());
                    gsQuery = new SelectQueryImpl(new Table("SSPGroupSubscriptions"));
                    gsQuery.addJoin(new Join("SSPGroupSubscriptions", "SSPGSGroups", new String[]{"SUB_ID"}, new String[]{"SUB_ID"}, 2));
                    gsQuery.addJoin(new Join("SSPGSGroups", joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
                    gsQuery.addSelectColumn(Column.getColumn((String)"SSPGroupSubscriptions", (String)"*"));
                    gsQuery.setCriteria(subscriptionCrit);
                    gsQuery.addSortColumn(new SortColumn(Column.getColumn((String)"SSPGroupSubscriptions", (String)"SUB_ID"), true));
                    if (unionQuery != null) {
                        unionQuery.union((Query)gsQuery, false);
                    } else if (prevQuery != null) {
                        unionQuery = new UnionQueryImpl((Query)prevQuery, (Query)gsQuery, false);
                    }
                    prevQuery = gsQuery;
                }
                Object query = unionQuery != null ? unionQuery : prevQuery;
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery(query, connection);
                JSONObject gsDO = new JSONObject();
                while (dataSet.next()) {
                    if (gsDO.has(dataSet.getValue("SUB_ID").toString())) continue;
                    gsDO.put(dataSet.getValue("SUB_ID").toString(), (Object)((Boolean)dataSet.getValue("DONT_INHERIT_OUS")));
                }
                if (!dataSet.isClosed()) {
                    dataSet.close();
                    dataSet = null;
                }
                if (gsDO.length() == 0) {
                    gsQuery = subIds;
                    return gsQuery;
                }
                String baseTable = "SSPGSOUs";
                String joinTable = "ADSMOUDetails";
                SelectQueryImpl sq = new SelectQueryImpl(new Table(baseTable));
                sq.addJoin(new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
                sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"*"));
                sq.addSelectColumn(Column.getColumn((String)joinTable, (String)"DISTINGUISHED_NAME"));
                dataSet = relationalAPI.executeQuery((Query)sq, connection);
                while (dataSet.next() && (!checkAvailability.booleanValue() || subIds.isEmpty())) {
                    Long ouSubId = (Long)dataSet.getValue("SUB_ID");
                    if (subIds.contains(ouSubId) || gsDO.length() == 0 || !gsDO.has(ouSubId.toString())) continue;
                    Boolean dontInherit = gsDO.getBoolean(ouSubId.toString());
                    String ouDN = (String)dataSet.getValue("DISTINGUISHED_NAME");
                    if (!userDN.endsWith(ouDN = ouDN.toLowerCase())) continue;
                    if (dontInherit.booleanValue()) {
                        if (userDN.replace("," + ouDN, "").indexOf(",ou=") != -1) continue;
                        subIds.add(ouSubId);
                        continue;
                    }
                    subIds.add(ouSubId);
                }
                if (checkAvailability.booleanValue() && !subIds.isEmpty()) break block28;
                Criteria userCrit = new Criteria(Column.getColumn((String)"SSPGSUsers", (String)"OBJECT_GUID"), (Object)userGUID, 0);
                userCrit = userCrit.and(new Criteria(Column.getColumn((String)"SSPGSUsers", (String)"SUB_ID"), (Object)subIds.toArray(new Long[subIds.size()]), 9));
                userCrit = userCrit.and(new Criteria(Column.getColumn((String)"SSPGSUsers", (String)"SUB_ID"), (Object)((String[])IteratorUtils.toArray((Iterator)gsDO.keys(), String.class)), 8));
                DataObject gsuserDO = CommonUtil.getPersistence(new boolean[0]).get("SSPGSUsers", userCrit);
                Iterator userIterator = gsuserDO.getRows("SSPGSUsers");
                while (userIterator.hasNext()) {
                    if (checkAvailability.booleanValue() && !subIds.isEmpty()) {
                        break;
                    }
                    Row ro = (Row)userIterator.next();
                    subIds.add((Long)ro.get("SUB_ID"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return subIds;
    }

    public static Properties getObjectDetails(String objectGUID, String domainName, ArrayList attrList, boolean needDN) {
        Properties objDetails = null;
        try {
            Properties domainProps = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
            objDetails = ADHandler.getObjectFromGUID(domainProps, objectGUID.substring(objectGUID.indexOf("{") + 1, objectGUID.lastIndexOf("}")), attrList, needDN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objDetails;
    }

    public static JSONObject getUserLoginDetails(Long loginId) {
        JSONObject retObj = new JSONObject();
        try {
            String table = "AaaLogin";
            Criteria crit = new Criteria(Column.getColumn((String)table, (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(table, crit);
            Row r = obj.getFirstRow(table);
            retObj.put("DOMAINNAME", (Object)r.get("DOMAINNAME").toString());
            retObj.put("NAME", (Object)r.get("NAME").toString());
            retObj.put("LOGIN_ID", (Object)((Long)r.get("LOGIN_ID")));
            retObj.put("USER_ID", (Object)((Long)r.get("USER_ID")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retObj;
    }

    public static Query getGroupQuery(Criteria c, String searchString, String type, List<Properties> domainList) {
        SelectQueryImpl finalQuery = null;
        try {
            String baseTable = "SSPGSGroups";
            String joinTable = "";
            SelectQueryImpl unionQuery = null;
            SelectQueryImpl prevQuery = null;
            for (Properties domainProp : domainList) {
                joinTable = CommonUtil.getDomainGroupTableName(domainProp.get("DOMAIN_NAME").toString());
                SelectQueryImpl sq = new SelectQueryImpl(new Table(baseTable));
                boolean retainDuplicateRows = false;
                Criteria crit = c;
                if (searchString != null && !searchString.equals("")) {
                    crit = c.and(new Criteria(Column.getColumn((String)joinTable, (String)"DISPLAY_NAME"), (Object)searchString, 12, false));
                }
                sq.setCriteria(crit);
                ArrayList<Column> selectColumns = new ArrayList<Column>(Arrays.asList(Column.getColumn((String)"SSPGSGroups", (String)"OBJECT_GUID"), Column.getColumn((String)joinTable, (String)"DISPLAY_NAME"), Column.getColumn((String)joinTable, (String)"DESCRIPTION"), Column.getColumn((String)joinTable, (String)"DN_STRING"), Column.getColumn((String)joinTable, (String)"E_MAIL"), Column.getColumn((String)joinTable, (String)"SID_STRING"), Column.getColumn((String)joinTable, (String)"DOMAIN_NAME")));
                sq.setGroupByClause(new GroupByClause(selectColumns));
                Join join = new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                sq.addJoin(join);
                sq.addJoin(new Join(baseTable, "SSPGroupSubscriptions", new String[]{"SUB_ID"}, new String[]{"SUB_ID"}, 2));
                if (type != null && type.equalsIgnoreCase("count")) {
                    Column countColumn = new Column(null, "*");
                    sq.addSelectColumn(countColumn.count());
                    retainDuplicateRows = true;
                } else {
                    Column allowViewMembers = Column.getColumn((String)"SSPGroupSubscriptions", (String)"VIEW_MEMBERS").maximum();
                    allowViewMembers.setColumnAlias("VIEW_MEMBERS");
                    sq.addSelectColumn(allowViewMembers);
                    sq.addSelectColumns(selectColumns);
                    sq.addSortColumn(new SortColumn(Column.getColumn((String)joinTable, (String)"DISPLAY_NAME"), true));
                }
                if (unionQuery != null) {
                    unionQuery.union((Query)sq, retainDuplicateRows);
                } else if (prevQuery != null) {
                    unionQuery = new UnionQueryImpl((Query)prevQuery, (Query)sq, retainDuplicateRows);
                }
                prevQuery = sq;
            }
            finalQuery = unionQuery != null ? unionQuery : prevQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalQuery;
    }

    public static JSONObject getGroupMembers(String guid, String domainName) {
        return GSSelfServiceHandler.getGroupMembers(guid, domainName, false);
    }

    public static JSONObject getGroupMembers(String guid, String domainName, Boolean needDN) {
        JSONObject retJson = null;
        String errMsg = "";
        try {
            retJson = new JSONObject();
            JSONObject grpJson = GSSelfServiceHandler.getGroups(0, 0, null, new Criteria(Column.getColumn((String)"SSPGSGroups", (String)"OBJECT_GUID"), (Object)guid, 0, false), domainName);
            if (grpJson == null || grpJson.getInt("COUNT") == 0 || !grpJson.getJSONArray("GROUPS").getJSONObject(0).getBoolean("VIEW_MEMBERS")) {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                errMsg = rb.getString("adssp.error.native.access_deny");
                retJson.put("MEMBERS", new ArrayList());
                retJson.put("TITLE", (Object)errMsg);
                throw new Exception(errMsg);
            }
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("distinguishedName");
            Properties domainDetails = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
            Properties p = GroupUtil.getGroupPropsFromGUID(guid, domainName, new String[]{"primaryGroupToken", "DN_STRING", "DISPLAY_NAME"});
            String searchString = "(|(memberOf=" + p.get("DN_STRING") + ")(primaryGroupID=" + p.get("primaryGroupToken") + "))";
            ArrayList list = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attribList, searchString);
            ArrayList memberList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                Properties prop = (Properties)list.get(i);
                memberList.add((String)((ArrayList)prop.get("distinguishedName")).get(0));
            }
            retJson.put("TITLE", p.get("DISPLAY_NAME"));
            String[] groupMembers = memberList.toArray(new String[memberList.size()]);
            memberList = UserUtil.removeRestrictedUsersByDN(groupMembers, domainName);
            retJson.put("MEMBERS", (Collection)memberList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String subscribe(String grpGUID, String sid, String grpDomainName, String operation) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Long errVal = -1L;
        String errMsg = "adssp.common.text.success";
        String buttonText = rb.getString("adssp.domain_user.my_group_unsubscribe.text");
        String userDN = "";
        String userGUID = "";
        String domainName = "";
        try {
            Long dwControlCode = new Long(3L);
            Credential cred = AuthUtil.getUserCredential();
            Long loginId = cred.getLoginId();
            JSONObject userDetails = GSSelfServiceHandler.getUserLoginDetails(loginId);
            domainName = userDetails.getString("DOMAINNAME");
            String samAccName = userDetails.getString("NAME");
            Criteria c = new Criteria(Column.getColumn((String)"SSPGSGroups", (String)"OBJECT_GUID"), (Object)grpGUID, 0, false);
            c = c.and(new Criteria(Column.getColumn((String)CommonUtil.getDomainGroupTableName(grpDomainName), (String)"SID_STRING"), (Object)sid, 0, false));
            JSONObject grpJson = GSSelfServiceHandler.getGroups(0, 0, null, c, grpDomainName);
            if (grpJson == null || grpJson.getInt("COUNT") == 0) {
                throw new NativeException("SEVERE", "-1", "adssp.login.common.error.permission_denied", grpGUID);
            }
            Properties userProps = UserUtil.getUserData(domainName, samAccName);
            userDN = userProps.getProperty("distinguishedName");
            userGUID = userProps.getProperty("objectGUID");
            if (operation.equalsIgnoreCase("UnSubscribe")) {
                dwControlCode = 4L;
            }
            ArrayList<Properties> list = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE", userDN);
            p.put("ATTRIB_VALUE_COUNT", (Object)1L);
            p.put("DATA_HANDLER_TYPE", (Object)3L);
            p.put("ATTRIB_LDAP_NAME", "member");
            p.put("DW_CONTROL_CODE", dwControlCode);
            list.add(p);
            Long adminLoginId = 1L;
            errVal = ADHandler.modifyGroup(grpDomainName, adminLoginId, sid, list, new ArrayList());
        }
        catch (NativeException n) {
            n.printStackTrace();
            errMsg = n.getExceptionMsg();
            errVal = Long.parseLong(n.getExceptionCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (errVal == 80072035L && !userDN.equals("") && !grpDomainName.equals("")) {
                ArrayList<String> attribList = new ArrayList<String>();
                attribList.add("primaryGroupID");
                attribList.add("distinguishedName");
                Properties userDetails = GSSelfServiceHandler.getObjectDetails(userGUID, domainName, attribList, false);
                String primaryGroupID = (String)((ArrayList)userDetails.get("primaryGroupID")).get(0);
                if (sid.endsWith("-" + primaryGroupID)) {
                    errMsg = "adssp.login.common.error.permission_denied";
                    operation = "failed";
                } else {
                    attribList = new ArrayList();
                    attribList.add("member");
                    Properties grpDetails = GSSelfServiceHandler.getObjectDetails(grpGUID, grpDomainName, attribList, true);
                    userDN = (String)((ArrayList)userDetails.get("distinguishedName")).get(0);
                    ArrayList memberList = (ArrayList)grpDetails.get("member");
                    if (memberList == null || memberList != null && !memberList.contains(userDN)) {
                        if (operation.equalsIgnoreCase("Subscribe")) {
                            errMsg = "adssp.domain_user.my_group.status_common_error";
                            operation = "failed";
                            buttonText = rb.getString("adssp.domain_user.my_group_subscribe.text");
                        } else {
                            errMsg = "adssp.domain_user.my_group.status.already_unsubscribed";
                        }
                    }
                }
            } else if (errVal == 80071392L) {
                errMsg = "adssp.domain_user.my_group.status.already_subscribed";
            } else if (errVal != 0L) {
                operation = "failed";
                if (errVal == 80072030L) {
                    errMsg = "adssp.error.native.nosuch_object_on_the_server";
                } else if (errMsg.equals("adssp.common.text.success")) {
                    errMsg = "adssp.common.error.error_occured";
                }
            }
            errMsg = rb.getString(errMsg);
            errMsg = errMsg.replace("\n", "").replace("\r", "");
            if (operation.equalsIgnoreCase("UnSubscribe")) {
                buttonText = rb.getString("adssp.domain_user.my_group_subscribe.text");
            }
        }
        return "{'operation':'" + operation + "','errMsg':'" + errMsg + "','buttonText':'" + buttonText + "'}";
    }
}

