/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.metracker;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.mail.MailHandler;
import com.manageengine.ads.fw.roboupdate.RoboUpdateUtil;
import com.manageengine.ads.fw.util.BonitasUpload;
import com.me.tools.zcutil.METrack;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class METrackHandler {
    private static Logger out = Logger.getLogger("ADSLogger");
    private static METrackHandler handler = null;
    private DataObject dataObj = null;
    private int noOfClicks = 0;

    private METrackHandler() {
        this.getURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static METrackHandler getInstance() {
        if (handler != null) return handler;
        Class<METrackHandler> clazz = METrackHandler.class;
        synchronized (METrackHandler.class) {
            handler = new METrackHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public static void disableScheduler(long scheduleId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Scheduled_Task");
                r.set("ADMIN_STATUS", (Object)new Integer(4));
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
                out.log(Level.INFO, "Scheduler Disabled for " + scheduleId);
                METrack.disable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void enableScheduler(long scheduleId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Scheduled_Task", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Scheduled_Task");
                r.set("ADMIN_STATUS", (Object)new Integer(3));
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
                out.log(Level.INFO, "Scheduler Disabled for " + scheduleId);
                METrack.enable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getURLs() {
        try {
            this.dataObj = CommonUtil.getPersistence(new boolean[0]).get("METrackURL", (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateClicks(HttpServletRequest servletrequest) {
        String url = servletrequest.getRequestURI() + "?" + servletrequest.getQueryString();
        url = url.substring(1);
        try {
            Iterator rows = this.dataObj.getRows("METrackURL");
            Object matchRow = null;
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                String s = (String)r.get("URL");
                if (!url.startsWith(s)) continue;
                Long val = (Long)r.get("NO_OF_CLICKS");
                r.set("NO_OF_CLICKS", (Object)(val + 1L));
                this.dataObj.updateRow(r);
                ++this.noOfClicks;
            }
            if (this.noOfClicks == 10) {
                CommonUtil.getPersistence(new boolean[0]).update(this.dataObj);
                this.noOfClicks = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            CommonUtil.getPersistence(new boolean[0]).update(this.dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getProxySettings() {
        Properties MEProxyProp = new Properties();
        try {
            Properties proxyProp = ServerUtil.getProxySettings();
            if (proxyProp != null && !proxyProp.isEmpty()) {
                MEProxyProp.setProperty("host", (String)proxyProp.get("SERVER_NAME"));
                MEProxyProp.setProperty("username", (String)proxyProp.get("USER_NAME"));
                MEProxyProp.setProperty("port", (String)proxyProp.get("PORT"));
                MEProxyProp.setProperty("password", (String)proxyProp.get("PASSWORD"));
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return MEProxyProp;
    }

    public static int getDomainUsersCount(String domainName) {
        try {
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            return dataObject.size(tableName);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
            return 0;
        }
    }

    public static int getDomainComputersCount(String domainName) {
        try {
            String tableName = CommonUtil.getDomainComputerTableName(domainName);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            return dataObject.size(tableName);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String[] key, String[] value, String tableName) {
        int count = 0;
        RelationalAPI relationalAPI = null;
        Connection connect = null;
        Statement stmt = null;
        ResultSet rsltSet = null;
        DataSet dataSet = null;
        try {
            int i;
            relationalAPI = RelationalAPI.getInstance();
            connect = relationalAPI.getConnection();
            stmt = connect.createStatement();
            rsltSet = null;
            String lookUpTableName = null;
            Criteria crit = new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"TABLE_NAME"), (Object)tableName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPMETATABLE", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPMETATABLE");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    lookUpTableName = (String)r.get("LOOKUP_TABLENAME");
                    StringBuffer cntQuery = new StringBuffer("SELECT count(*) FROM ").append(lookUpTableName).append(" WHERE ").append(key[0]).append("= '").append(value[0]).append("' ");
                    for (i = 1; i < key.length; ++i) {
                        cntQuery.append(" AND ");
                        cntQuery.append(key[i]);
                        cntQuery.append("= '");
                        cntQuery.append(value[i]);
                        cntQuery.append("' ");
                    }
                    rsltSet = QueryUtil.executeQuery("Getting count from tables", stmt, cntQuery.toString());
                    while (rsltSet.next()) {
                        count += Integer.parseInt(rsltSet.getString(1));
                    }
                }
            }
            lookUpTableName = new String(tableName);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)lookUpTableName));
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            Criteria criteria = new Criteria(Column.getColumn((String)lookUpTableName, (String)key[0]), (Object)value[0], 0);
            for (i = 1; i < key.length; ++i) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)lookUpTableName, (String)key[i]), (Object)value[i], 0));
            }
            sq.setCriteria(criteria);
            dataSet = relationalAPI.executeQuery((Query)sq, connect);
            while (dataSet.next()) {
                count += ((Integer)dataSet.getValue(1)).intValue();
            }
            dataSet.close();
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rsltSet != null) {
                try {
                    rsltSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connect != null) {
                try {
                    connect.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    public static Long getUrlCount(String value) {
        Long count = 0L;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"METrackURL", (String)"URL"), (Object)value, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("METrackURL", criteria);
            count = (Long)obj.getFirstValue("METrackURL", "NO_OF_CLICKS");
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return count;
    }

    public static Vector<Properties> getConfiguredIAMApps() {
        Vector<Properties> record = new Vector<Properties>();
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("ADSIAMApplications");
            tableList.add("ADSIAMAppConfig");
            Long uniqueId = System.currentTimeMillis();
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get(tableList, (Criteria)null);
            Iterator it = dO.getRows("ADSIAMApplications");
            while (it.hasNext()) {
                Row appRow = (Row)it.next();
                int cAppCount = 0;
                String modules = "";
                Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_ID"), (Object)((Long)appRow.get("APP_ID")), 0);
                c = c.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"IS_ENABLED"), (Object)"true", 0));
                Iterator cApps = dO.getRows("ADSIAMAppConfig", c);
                while (cApps.hasNext()) {
                    Row configRow = (Row)cApps.next();
                    Long appConfigId = (Long)configRow.get("APP_CONFIG_ID");
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)appConfigId, 0);
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"MODULES", 0));
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", crit);
                    if (!dataObject.isEmpty()) {
                        Row ConfParamRow = dataObject.getFirstRow("ADSIAMAppConfigParams");
                        modules = modules + (String)ConfParamRow.get("PARAM_VALUE");
                    }
                    ++cAppCount;
                }
                Properties pro = new Properties();
                String appName = (String)appRow.get("APP_NAME");
                pro.put("UNIQUE_ID", uniqueId);
                pro.put("Entity", appName);
                pro.put("Countvalue", (Object)cAppCount);
                pro.put("MODULES", modules);
                record.add(pro);
            }
            out.log(Level.INFO, "IAM App Data " + record);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return record;
    }

    public static Vector<Properties> getCustomIAMApps() {
        Vector<Properties> record = new Vector<Properties>();
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("ADSIAMApplications");
            tableList.add("ADSIAMApplicationsProps");
            Long uniqueId = System.currentTimeMillis();
            Criteria crit = new Criteria(Column.getColumn((String)"ADSIAMApplicationsProps", (String)"IS_CUSTOM_SAML_APP"), (Object)"true", 0);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get(tableList, crit);
            Iterator it1 = dO.getRows("ADSIAMApplications");
            Iterator it2 = dO.getRows("ADSIAMApplicationsProps");
            while (it1.hasNext()) {
                Row appRow = (Row)it1.next();
                Row appPropsRow = (Row)it2.next();
                Properties pro = new Properties();
                String appDisplayName = (String)appRow.get("DISPLAY_NAME");
                pro.put("UNIQUE_ID", uniqueId);
                pro.put("Entity", appDisplayName);
                pro.put("IS_IDP_INITIATED_FLOW", appPropsRow.get("IS_IDP_INITIATED_FLOW"));
                pro.put("SIGNED_SAML_RESPONSE", appPropsRow.get("SIGNED_SAML_RESPONSE"));
                pro.put("SHA_METHOD", appPropsRow.get("SHA_METHOD"));
                record.add(pro);
            }
            out.log(Level.INFO, "IAM Custom App Data " + record);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return record;
    }

    public static Vector<Properties> getConfiguredLocales() {
        Vector<Properties> record = new Vector<Properties>();
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("LocaleDetails");
            tableList.add("User_Locale");
            Long uniqueId = System.currentTimeMillis();
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get(tableList, (Criteria)null);
            Iterator it = dO.getRows("LocaleDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                int localeCount = 0;
                Criteria c = new Criteria(Column.getColumn((String)"User_Locale", (String)"LOCALE_ID"), (Object)((Long)r.get("LOCALE_ID")), 0);
                Iterator uLocale = dO.getRows("User_Locale", c);
                while (uLocale.hasNext()) {
                    uLocale.next();
                    ++localeCount;
                }
                if (localeCount <= 0) continue;
                Properties pro = new Properties();
                pro.put("UNIQUE_ID", uniqueId);
                pro.put("Locale", (String)r.get("LOCALE_DISPLAY"));
                pro.put("Countvalue", (Object)localeCount);
                record.add(pro);
            }
            out.log(Level.INFO, "Language Data " + record);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return record;
    }

    public static void setMultiFactorAuthenticators(Properties pro) {
        try {
            Long moduleId = APCModuleHandler.getModuleId("ID_VERIFICATIONS");
            JSONArray flagNames = APCModuleHandler.getModuleFlagNames(moduleId);
            JSONArray bitValues = METrackHandler.getModuleBitValue(moduleId);
            for (int i = 0; i < bitValues.length(); ++i) {
                Long bitValue = bitValues.getLong(i);
                for (int j = 0; j < flagNames.length(); ++j) {
                    JSONObject flag = flagNames.getJSONObject(j);
                    String flagName = flag.getString("FLAG_NAME");
                    Long flagBitVal = flag.getLong("FLAG_BIT_VAL");
                    Long flagPos = APCModuleHandler.getFlagPos(flagBitVal);
                    String isEnabled = APCModuleHandler.getBitValue(flagPos, bitValue);
                    if (pro.containsKey(flagName) && pro.get(flagName).equals("1")) continue;
                    pro.put(flagName, isEnabled);
                }
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static JSONArray getModuleBitValue(long moduleId) {
        JSONArray bitValues = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPCPOLICYVSMODULES", (String)"PC_MODULE_ID"), (Object)moduleId, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPPCPOLICYVSMODULES", c);
            if (!dataobject.isEmpty()) {
                bitValues = new JSONArray();
                Iterator it = dataobject.getRows("SSPPCPOLICYVSMODULES");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    bitValues.put((Object)((Long)r.get("FLAG_BIT_VALS")));
                }
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return bitValues;
    }

    public static Vector rumAudit() {
        Logger logger = Logger.getLogger("ADSLogger");
        logger.log(Level.INFO, "rumAudit called");
        Vector<Properties> adsVec = new Vector<Properties>();
        try {
            JSONObject failedDetails;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            String productName = com.manageengine.ads.fw.util.CommonUtil.getProductName();
            Long lastFailedPPM = null;
            if (RoboUpdateUtil.isPreviousUpgradeFailed((String)productName) && (failedDetails = RoboUpdateUtil.getFailedUpdateDetails((String)productName)).has("BUILD_NO")) {
                lastFailedPPM = failedDetails.getLong("BUILD_NO");
            }
            Persistence per = CommonUtil.getPersistence(new boolean[0]);
            DataObject obj = per.get("ADSRUMAudit", (Criteria)null);
            DataObject obj1 = per.get("ADSProducts", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSRUMAudit");
                JSONObject license = LicenseManager.getLicenseDetails();
                JSONObject mail = MailHandler.getMailSettings();
                while (it.hasNext()) {
                    Properties pro = new Properties();
                    Row row = (Row)it.next();
                    Long rumBuildNo = (Long)row.get("BUILD_NO");
                    Row r1 = obj1.getRow("ADSProducts", new Criteria(Column.getColumn((String)"ADSProducts", (String)"PRODUCT_ID"), (Object)((Long)row.get("PRODUCT_ID")), 0));
                    String rumProuductName = (String)r1.get("PRODUCT_NAME");
                    pro.put("PRODUCT_NAME", rumProuductName);
                    pro.put("VERSION", (String)row.get("VERSION"));
                    pro.put("BUILD_NO", rumBuildNo);
                    SimpleDateFormat dateFormat = new SimpleDateFormat("d MMMMM yyyy aaa HH:mm:ss");
                    Date installedOn = new Date((Long)row.get("UPDATED_TIME"));
                    pro.put("UPDATED_TIME", dateFormat.format(installedOn));
                    pro.put("STATUS", row.get("STATUS"));
                    pro.put("STATUS_MESSAGE", (String)row.get("STATUS_MESSAGE"));
                    pro.put("CUSTOMER_EMAIL", license.has("LICENSE_MAIL_ID") ? license.getString("LICENSE_MAIL_ID") : "NA");
                    pro.put("ADMIN_EMAIL", mail.has("ADMIN_MAIL_ID") ? mail.getString("ADMIN_MAIL_ID") : "NA");
                    if (lastFailedPPM != null && rumBuildNo.compareTo(lastFailedPPM) == 0 && productName.equalsIgnoreCase(rumProuductName) && !BonitasUpload.isLogsUploaded((Long)rumBuildNo)) {
                        String fromAddress = rb.getString("adssp.tab.talkback.text.mailid");
                        String toAddress = rb.getString("adssp.tab.talkback.text.mailid");
                        if (pro.getProperty("CUSTOMER_EMAIL") != "NA") {
                            fromAddress = pro.getProperty("CUSTOMER_EMAIL");
                        } else if (pro.getProperty("ADMIN_EMAIL") != "NA") {
                            fromAddress = pro.getProperty("ADMIN_EMAIL");
                        }
                        String failedBuildNo = row.get("BUILD_NO").toString();
                        Boolean informCustomer = false;
                        String messageContent = "PPM Migration has been failed for the Customer";
                        String logURL = BonitasUpload.uploadAndGetBonitasURL((String)fromAddress, (String)toAddress, (String)messageContent, (Boolean)informCustomer, (String)failedBuildNo);
                        pro.put("LOGS_URL", logURL != null ? logURL : "NA");
                    }
                    adsVec.add(pro);
                }
                out.log(Level.INFO, "RUM App Data " + adsVec);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "error in rumAudit()");
        }
        return adsVec;
    }

    public static boolean enrollDeviceDetails(int providerId, String deviceModel, String deviceId, String osVersion) throws Exception {
        try {
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPMobileDeviceAnalytics");
            r.set("PROVIDER_ID", (Object)providerId);
            r.set("DEVICE_MODEL", (Object)deviceModel);
            r.set("DEVICE_ID", (Object)deviceId);
            r.set("OS_VERSION", (Object)osVersion);
            dataobject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataobject);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return true;
    }

    public static int getCount(String tableName, Criteria crit) {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dataObj.isEmpty()) {
                return dataObj.size(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTechnicianCount(String techPosition, boolean domainFlag) {
        DataSet dataset = null;
        Connection connection = null;
        try {
            Table table = new Table("ADMPUsersRoleMapping");
            SelectQueryImpl sq = new SelectQueryImpl(table);
            sq.addJoin(new Join(Table.getTable((String)"ADMPUsersRoleMapping"), Table.getTable((String)"ADMPRoles"), new String[]{"ADMP_ROLE_ID"}, new String[]{"ADMP_ROLE_ID"}, 2));
            sq.addJoin(new Join(Table.getTable((String)"ADMPUsersRoleMapping"), Table.getTable((String)"AaaLogin"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
            Column column = Column.getColumn(null, (String)"*");
            sq.addSelectColumn(column.count());
            Criteria crit = new Criteria(new Column("ADMPRoles", "ADMP_ROLE_NAME"), (Object)techPosition, 0);
            int critFlag = domainFlag ? 1 : 0;
            crit = crit.and(new Criteria(new Column("AaaLogin", "DOMAINNAME"), (Object)"ADSelfService Plus Authentication", critFlag));
            sq.setCriteria(crit);
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            dataset = relApi.executeQuery((Query)sq, connection);
            if (dataset.next()) {
                int count;
                int n = count = ((Integer)dataset.getValue(1)).intValue();
                DBUtil.closeQuietly(connection, dataset);
                return n;
            }
            DBUtil.closeQuietly(connection, dataset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataset);
        }
        return 0;
    }

    public static String getSecAttributes() {
        String secondaryAttributes = "";
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecondaryAttributes", (Criteria)null);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("SSPSecondaryAttributes");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    if (!secondaryAttributes.equalsIgnoreCase("")) {
                        secondaryAttributes = secondaryAttributes + ",";
                    }
                    secondaryAttributes = secondaryAttributes + (String)row.get("ATTRIBUTE_NAME");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return secondaryAttributes;
    }

    public static void setTFAMode(Properties pro) {
        String enabledTFAModes = "";
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPTFAModesVsPolicies", (String)"ENABLED"), (Object)true, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(Arrays.asList("SSPTFAModesVsPolicies", "SSPTFAProviderModes"), Arrays.asList("SSPTFAProviderModes"), (Criteria)null);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("SSPTFAModesVsPolicies", c);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long enabledModeId = (Long)row.get("MODE_ID");
                    Row providerRow = dataObj.getRow("SSPTFAProviderModes", new Criteria(Column.getColumn((String)"SSPTFAProviderModes", (String)"MODE_ID"), (Object)enabledModeId, 0));
                    String modeName = (String)providerRow.get("MODE_NAME");
                    if (enabledTFAModes.indexOf(modeName) != -1) continue;
                    if (!enabledTFAModes.equalsIgnoreCase("")) {
                        enabledTFAModes = enabledTFAModes + ",";
                    }
                    enabledTFAModes = enabledTFAModes + modeName;
                }
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        pro.put("TFA_MODE", enabledTFAModes);
    }

    public static void setGINAinstallcount(Properties pro) {
        pro.put("GINA_WINDOWS", (Object)METrackHandler.getGINAinstallcount("*windows*"));
        pro.put("GINA_MAC", (Object)METrackHandler.getGINAinstallcount("mac os x"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getGINAinstallcount(String os) {
        long installCount = 0L;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            ArrayList domainNamesList = DomainHandler.getDomainList(false);
            String baseTable = "AgentComputerDetails";
            String joinTable = "";
            Criteria c = new Criteria(Column.getColumn((String)baseTable, (String)"INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0, false);
            for (Properties p : domainNamesList) {
                String domainName = p.getProperty("DOMAIN_NAME");
                joinTable = CommonUtil.getDomainComputerTableName(domainName);
                SelectQueryImpl curQuery = new SelectQueryImpl(new Table(baseTable));
                Criteria crit = c.and(new Criteria(Column.getColumn((String)joinTable, (String)"OS"), (Object)os, 2, false));
                curQuery.setCriteria(crit);
                curQuery.addJoin(new Join(baseTable, joinTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2));
                curQuery.addSelectColumns(new ArrayList<Column>(Arrays.asList(Column.getColumn(null, (String)"*", (String)"COUNT").count())));
                dataSet = relationalAPI.executeQuery((Query)curQuery, connection);
                while (dataSet.next()) {
                    installCount += (long)((Integer)dataSet.getValue(1)).intValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return installCount;
    }

    public static void setUnrestrictSchedulerData(Properties pro) {
        String unrestrictData = "";
        try {
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("SSPStaleAccountUnrestriction", (Criteria)null);
            Long flags = 0L;
            if (!dob.isEmpty()) {
                Iterator it = dob.getRows("SSPStaleAccountUnrestriction");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    flags = (Long)r.get("UNRESTRICTION_FLAGS");
                    unrestrictData = unrestrictData + ((flags & 1L) != 0L && unrestrictData.indexOf("ACCOUNT_ENABLED") == -1 ? "ACCOUNT_ENABLED," : "");
                    unrestrictData = unrestrictData + ((flags & 2L) != 0L && unrestrictData.indexOf("SMARTCARD_DISABLED") == -1 ? "SMARTCARD_DISABLED," : "");
                    unrestrictData = unrestrictData + ((flags & 4L) != 0L && unrestrictData.indexOf("EXPIRATION_CHANGES") == -1 ? "EXPIRATION_CHANGES," : "");
                    unrestrictData = unrestrictData + ((flags & 8L) != 0L && unrestrictData.indexOf("LOGGED_IN_CHANGES") == -1 ? "LOGGED_IN_CHANGES," : "");
                }
            } else {
                unrestrictData = "- ";
            }
            pro.put("AUTO_UNRESTRICT", unrestrictData.substring(0, unrestrictData.length() - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

