/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.metracker;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.metracker.METrackHandler;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.authentication.smartcard.SmartCardHandler;
import com.manageengine.ads.fw.ha.HAHandler;
import com.manageengine.ads.fw.iamapps.handler.sso.SSOSAMLHandler;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.mobile.mobilemanager.mdm.ApplicationHandler;
import com.manageengine.ads.fw.mobile.mobilemanager.mdm.DeviceHandler;
import com.manageengine.ads.fw.mobile.pushnotification.PNEnrollmentHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import com.me.tools.zcutil.ApplicationData;
import com.me.tools.zcutil.METrack;
import com.me.tools.zcutil.ZCDataHandler;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class METrackScheduler
implements ZCDataHandler {
    private static Logger out = Logger.getLogger("ADSLogger");

    public void uploadData() {
        try {
            out.log(Level.INFO, "METrack UploadData Invoked");
            ApplicationData appData = new ApplicationData();
            appData.addRecords("inputload", METrackScheduler.getUploadedData());
            appData.addRecords("inputClientVSPushNotification", METrackScheduler.getNotificationAuditData());
            appData.addRecords("inputClientVSEntity", METrackHandler.getConfiguredIAMApps());
            appData.addRecords("inputClientVSCustomSSO", METrackHandler.getCustomIAMApps());
            appData.addRecords("inputClientVSLocale", METrackHandler.getConfiguredLocales());
            appData.addRecords("inputrumaudit", METrackHandler.rumAudit());
            appData.addRecords("inputClientVsPolicyConfig", METrackScheduler.getPolicyConfigData());
            METrack.updateMultiFormdData((ApplicationData)appData, (Properties)METrackHandler.getProxySettings());
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    public Properties getInstallationDetails() {
        return null;
    }

    private static Vector getUploadedData() {
        Vector<Properties> uploadedData = null;
        try {
            Properties pro = new Properties();
            METrackScheduler.setBuildDetails(pro);
            METrackScheduler.setAuditData(pro);
            METrackScheduler.setAccessData(pro);
            METrackScheduler.setDomainData(pro);
            METrackScheduler.setTechnicianData(pro);
            METrackScheduler.setWFData(pro);
            METrackScheduler.setGSData(pro);
            METrackScheduler.setSynAgentData(pro);
            METrackScheduler.setEnrollCountData(pro);
            METrackScheduler.setLicenseData(pro);
            METrackScheduler.setManualLinkData(pro);
            METrackScheduler.setSmartCardData(pro);
            METrackScheduler.setHAData(pro);
            METrackHandler.setGINAinstallcount(pro);
            METrackHandler.setUnrestrictSchedulerData(pro);
            uploadedData = new Vector<Properties>();
            uploadedData.add(pro);
            out.log(Level.INFO, "Uploaded Data " + uploadedData);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        return uploadedData;
    }

    private static void setVPNConfigCount(Properties pro) {
        try {
            int noOfVPNConfig = METrackHandler.getCount("ADSVPNProviderSettings", null);
            pro.put("VPN_CONFIG_COUNT", (Object)noOfVPNConfig);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setManualLinkData(Properties pro) {
        try {
            int noOfManualLinkAcc = METrackHandler.getCount("SSPPSLinkedAccounts", null);
            pro.put("MANUAL_LINKED_ACCOUNTS", (Object)noOfManualLinkAcc);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setLicenseData(Properties pro) {
        try {
            int noOfLicensedUsers = METrackHandler.getCount("AaaLogin", null);
            pro.put("AAA_COUNT", (Object)noOfLicensedUsers);
            JSONObject licenseDetails = LicenseManager.getLicenseDetails();
            String customerMail = licenseDetails.has("LICENSE_MAIL_ID") ? licenseDetails.getString("LICENSE_MAIL_ID") : "";
            pro.put("CUSTOMER_EMAIL", customerMail);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setEnrollCountData(Properties pro) {
        try {
            int noOFEnrolledUsers = METrackHandler.getCount(new String[]{"REGISTRATION_STATUS"}, new String[]{"1"}, "SSPUserPropertyMap");
            pro.put("ENROLLED_USERS", (Object)noOFEnrolledUsers);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setSynAgentData(Properties pro) {
        try {
            int noOfSynAgent = METrackHandler.getCount("ADSAgentDetails", null);
            pro.put("PS_AGENT_COUNT", (Object)noOfSynAgent);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setGSData(Properties pro) {
        try {
            int groupSubConf = METrackHandler.getCount("SSPGroupSubscriptions", null);
            pro.put("GS_CONFIGURED", (Object)groupSubConf);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setWFData(Properties prop) {
        try {
            Criteria wfSubCrit = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"SUBJECT"), (Object)"*Group*", 2);
            int noOfWFSubRequest = METrackHandler.getCount("SSPWFAllRequests", wfSubCrit);
            prop.put("WF_GROUP_SUBSCRIPTION", (Object)noOfWFSubRequest);
            Criteria wfModCrit = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"SUBJECT"), (Object)"*Modify*", 2);
            int noOfWFModRequest = METrackHandler.getCount("SSPWFAllRequests", wfModCrit);
            prop.put("WF_SELF_UPDATE", (Object)noOfWFModRequest);
            Criteria wfUnlockCrit = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"SUBJECT"), (Object)"*Unlock*", 2);
            int noOfWFUnlockRequest = METrackHandler.getCount("SSPWFAllRequests", wfUnlockCrit);
            prop.put("WF_UNLOCK_ACCOUNT", (Object)noOfWFUnlockRequest);
            Criteria wfResetCrit = new Criteria(Column.getColumn((String)"SSPWFAllRequests", (String)"SUBJECT"), (Object)"*Reset*", 2);
            int noOfWFResetRequest = METrackHandler.getCount("SSPWFAllRequests", wfResetCrit);
            prop.put("WF_RESET_PASSWORD", (Object)noOfWFResetRequest);
            String wfEnabled = METrackHandler.getCount("SSPWFConfiguration", null) > 0 ? "Enabled" : "-";
            prop.put("WF_ENABLED", wfEnabled);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setTechnicianData(Properties pro) {
        try {
            int techCount = METrackHandler.getTechnicianCount("Operator", false);
            pro.put("PRODUCT_OPERATOR", (Object)techCount);
            techCount = METrackHandler.getTechnicianCount("Super Admin", false);
            pro.put("PRODUCT_SUPER_ADMIN", (Object)techCount);
            techCount = METrackHandler.getTechnicianCount("Operator", true);
            pro.put("DOMAIN_OPERATOR", (Object)techCount);
            techCount = METrackHandler.getTechnicianCount("Super Admin", true);
            pro.put("DOMAIN_SUPER_ADMIN", (Object)techCount);
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setEnforcerData(Properties pro) {
        pro.put("ENFORCED_POLICIES", Integer.toString(PPEHandler.getEnforcedPolicyCount()));
    }

    private static void setSSOData(Properties pro) {
        pro.put("SSO_COUNT", Integer.toString(SSOSAMLHandler.getSSOCount()));
    }

    private static void setBuildDetails(Properties pro) {
        try {
            pro.put("BUILD_NO", CommonUtil.getBuildNumber());
            pro.put("IS_FREE_TOOL", System.getProperty("freeTool") != null ? "1" : "0");
            String reg_mail = ADSMPersUtil.getSyMParameter("FREE_TOOL_REG_MAIL");
            pro.put("FREE_TOOL_REG_MAIL", reg_mail != null ? reg_mail : "Not Registered");
            pro.put("PRODUCT_ARCHITECTURE", CommonUtil.getBuildArchitecture());
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setAuditData(Properties pro) {
        try {
            if (AuditReportHandler.isAuditTableExist("SSPAudit")) {
                int WRCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"WebPage", "audit.action.reset_pwd"}, "SSPAudit");
                int WUCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"WebPage", "audit.action.unlocked"}, "SSPAudit");
                int changePwd = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"WebPage", "audit.action.change_pwd"}, "SSPAudit");
                int MAppUACount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"MApp", "audit.action.unlocked"}, "SSPAudit");
                int MAppRPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"MApp", "audit.action.reset_pwd"}, "SSPAudit");
                int MAppCPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"MApp", "audit.action.change_pwd"}, "SSPAudit");
                int NAppAndroidUACount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_Android", "audit.action.unlocked"}, "SSPAudit");
                int NAppAndroidRPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_Android", "audit.action.reset_pwd"}, "SSPAudit");
                int NAppAndroidCPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_Android", "audit.action.change_pwd"}, "SSPAudit");
                int NAppIOSUACount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_IOS", "audit.action.unlocked"}, "SSPAudit");
                int NAppIOSRPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_IOS", "audit.action.reset_pwd"}, "SSPAudit");
                int NAppIOSCPCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"NApp_IOS", "audit.action.change_pwd"}, "SSPAudit");
                int GRCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"GINA", "audit.action.reset_pwd"}, "SSPAudit");
                int GUCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"GINA", "audit.action.unlocked"}, "SSPAudit");
                int MacRCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"MAC", "audit.action.reset_pwd"}, "SSPAudit");
                int MacUCount = METrackHandler.getCount(new String[]{"ACCESS_MODE", "TYPE"}, new String[]{"MAC", "audit.action.unlocked"}, "SSPAudit");
                int selfUpdate = METrackHandler.getCount(new String[]{"TYPE"}, new String[]{"audit.action.self_update"}, "SSPAudit");
                int autoResetPwd = METrackHandler.getCount(new String[]{"TYPE"}, new String[]{"audit.action.automatic_reset_pwd"}, "SSPAudit");
                int autoUnlockAccount = METrackHandler.getCount(new String[]{"TYPE"}, new String[]{"audit.action.automatic_unlock"}, "SSPAudit");
                pro.put("WebPageRESET", Integer.toString(WRCount));
                pro.put("WebPageUNLOCK", Integer.toString(WUCount));
                pro.put("Change_Password", Integer.toString(changePwd));
                pro.put("MApp_UA", Integer.toString(MAppUACount));
                pro.put("MApp_RP", Integer.toString(MAppRPCount));
                pro.put("MApp_CP", Integer.toString(MAppCPCount));
                pro.put("NApp_Android_UA", Integer.toString(NAppAndroidUACount));
                pro.put("NApp_Android_RP", Integer.toString(NAppAndroidRPCount));
                pro.put("NApp_Android_CP", Integer.toString(NAppAndroidCPCount));
                pro.put("NApp_IOS_UA", Integer.toString(NAppIOSUACount));
                pro.put("NApp_IOS_RP", Integer.toString(NAppIOSRPCount));
                pro.put("NApp_IOS_CP", Integer.toString(NAppIOSCPCount));
                pro.put("GinaRESET", Integer.toString(GRCount));
                pro.put("GinaUNLOCK", Integer.toString(GUCount));
                pro.put("Mac_RP", Integer.toString(MacRCount));
                pro.put("Mac_UA", Integer.toString(MacUCount));
                pro.put("Self_Update", Integer.toString(selfUpdate));
                pro.put("Automatic_Reset", Integer.toString(autoResetPwd));
                pro.put("Automatic_Unlock", Integer.toString(autoUnlockAccount));
            }
            if (AuditReportHandler.isAuditTableExist("SSPSTEMailAudit")) {
                int pwdExpiryNotification = METrackHandler.getCount(new String[]{"ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton"}, "SSPSTEMailAudit");
                int accExpiryNotification = METrackHandler.getCount(new String[]{"ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.account_expire_notificaiton"}, "SSPSTEMailAudit");
                pro.put("Password_Expiry_Notification", Integer.toString(pwdExpiryNotification));
                pro.put("Account_Expiry_Notification", Integer.toString(accExpiryNotification));
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setAccessData(Properties pro) {
        try {
            Long peopleFinder = METrackHandler.getUrlCount("EmployeeSearch.cc?actionId=Search");
            Long orgChart = METrackHandler.getUrlCount("OrganizationChart.cc");
            Long myGroup = METrackHandler.getUrlCount("SelfGroupSubscribe.do?selectedTab=MyGroup");
            Long mAppAccessCount = METrackHandler.getUrlCount("m/home");
            Long nAppAndroidAccessCount = METrackHandler.getUrlCount("RestAPI/AuthenticationAPI?PRODUCT_NAME=ADSSP&operation=homeProps&PROVIDER_NAME=android");
            Long nAppIOSAccessCount = METrackHandler.getUrlCount("RestAPI/AuthenticationAPI?PRODUCT_NAME=ADSSP&operation=homeProps&PROVIDER_NAME=ios");
            Long myGroupSubscription = METrackHandler.getUrlCount("SelfGroupSubscribe.do?methodToCall=subscribe&operation=Subscribe");
            Long myGroupUnSubscription = METrackHandler.getUrlCount("SelfGroupSubscribe.do?methodToCall=subscribe&operation=UnSubscribe");
            pro.put("Employee_Search", Long.toString(peopleFinder));
            pro.put("Org_Chart", Long.toString(orgChart));
            pro.put("MApp_AccessCount", Long.toString(mAppAccessCount));
            pro.put("NApp_Android_AccessCount", Long.toString(nAppAndroidAccessCount));
            pro.put("NApp_IOS_AccessCount", Long.toString(nAppIOSAccessCount));
            pro.put("GROUP_SUB", Long.toString(myGroup));
            pro.put("GS_SUBSCRIPTION", Long.toString(myGroupSubscription));
            pro.put("GS_UNSUBSCRIPTION", Long.toString(myGroupUnSubscription));
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setDomainData(Properties pro) {
        try {
            ArrayList domainList = DomainHandler.getDomainList(false);
            int noOfDomains = domainList.size();
            if (noOfDomains > 0) {
                int noOfUsers = 0;
                int noOfComp = 0;
                for (int i = 0; i < noOfDomains; ++i) {
                    String domainName = (String)((Properties)domainList.get(i)).get("DOMAIN_NAME");
                    int userCount = METrackHandler.getDomainUsersCount(domainName);
                    noOfUsers += userCount;
                    int compCount = METrackHandler.getDomainComputersCount(domainName);
                    noOfComp += compCount;
                }
                pro.put("NO_OF_USERS", Integer.toString(noOfUsers));
                pro.put("NO_OF_DOMAINS", Integer.toString(noOfDomains));
                pro.put("NO_OF_COMP", Integer.toString(noOfComp));
            }
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static Vector<Properties> getNotificationAuditData() {
        Vector<Properties> record = new Vector<Properties>();
        Properties pro = new Properties();
        try {
            if (AuditReportHandler.isAuditTableExist("SSPNotificationAudit")) {
                int androidEnrollPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.android.push_notification", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton"}, "SSPNotificationAudit");
                int iosEnrollPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.ios.push_notification", "adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton"}, "SSPNotificationAudit");
                int mail = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.mail"}, "SSPNotificationAudit");
                int sms = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.sms"}, "SSPNotificationAudit");
                int iOSPush = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.ios.push_notification"}, "SSPNotificationAudit");
                int androidPush = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.android.push_notification"}, "SSPNotificationAudit");
                int push = iOSPush + androidPush;
                pro.put("MAIL_NOTIFICATIONS", Integer.toString(mail));
                pro.put("SMS_NOTIFICATIONS", Integer.toString(sms));
                pro.put("PUSH_NOTIFICATIONS", Integer.toString(push));
                pro.put("Android_PN_For_Enrollment", Integer.toString(androidEnrollPN));
                pro.put("IOS_PN_For_Enrollment", Integer.toString(iosEnrollPN));
            }
            if (AuditReportHandler.isAuditTableExist("SSPSTEMailAudit")) {
                int androidPwdPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.android.push_notification", "adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton"}, "SSPSTEMailAudit");
                int androidAccountExpiryPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.android.push_notification", "adssp.reports.audit_report.notification_delivery_report.account_expire_notificaiton"}, "SSPSTEMailAudit");
                int iosPwdPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.ios.push_notification", "adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton"}, "SSPSTEMailAudit");
                int iosAccountExpiryPN = METrackHandler.getCount(new String[]{"NOTIFICATION_TYPE", "ACTION_NAME"}, new String[]{"adssp.reports.audit_report.notification_delivery_report.ios.push_notification", "adssp.reports.audit_report.notification_delivery_report.account_expire_notificaiton"}, "SSPSTEMailAudit");
                pro.put("Android_PN_For_PasswordExpiry", Integer.toString(androidPwdPN));
                pro.put("Android_PN_For_AccountExpiry", Integer.toString(androidAccountExpiryPN));
                pro.put("IOS_PN_For_PasswordExpiry", Integer.toString(iosPwdPN));
                pro.put("IOS_PN_For_AccountExpiry", Integer.toString(iosAccountExpiryPN));
            }
            int conAndroidDevices = PNEnrollmentHandler.getPushRegisteredDeviceCount((String)"ANDROID");
            int conIOSDevices = PNEnrollmentHandler.getPushRegisteredDeviceCount((String)"IOS");
            pro.put("Android_PN_Enabled", Integer.toString(conAndroidDevices));
            pro.put("IOS_PN_Enabled", Integer.toString(conIOSDevices));
            pro.put("MDM_CONFIGURED_DEVICES", Integer.toString(DeviceHandler.getRecordCount(null, (String)"ADSMPMEnrolledDevices")));
            pro.put("MDM_APP_INSTALLED_COUNT", Integer.toString(ApplicationHandler.getAppInstalledCount()));
            pro.put("MDM_AUDIT_COUNT", Integer.toString(ApplicationHandler.getTotalAudits()));
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
        if (pro.size() > 0) {
            record.add(pro);
        }
        out.log(Level.INFO, "Notification Data " + record);
        return record;
    }

    private static Vector<Properties> getPolicyConfigData() {
        Vector<Properties> pcrecord = new Vector<Properties>();
        Properties prop = new Properties();
        try {
            int noOfPolicies = METrackHandler.getCount("PolicyConfiguration", null);
            prop.put("NO_OF_POLICY", (Object)noOfPolicies);
            String custScriptStatus = METrackHandler.getCount(new String[]{"IS_ENABLED"}, new String[]{"1"}, "SSPCustomScript") > 0 ? "Enabled" : "-";
            prop.put("CUSTOM_SCRIPT", custScriptStatus);
            String enforcePwdHistStatus = METrackHandler.getCount(new String[]{"ENFORCE_PWD_HIS"}, new String[]{"1"}, "SSPSecurity") > 0 ? "Enabled" : "-";
            prop.put("ENFORCE_PWD_HISTORY", enforcePwdHistStatus);
            String ppeEnabled = PPEHandler.getEnforcedPolicyCount() > 0 ? "Enabled" : "-";
            prop.put("PPE_ENABLED", ppeEnabled);
            String ppeEnabledInGina = PPEHandler.getEnforcedInGinaPolicyCount() > 0 ? "Enabled" : "-";
            prop.put("PPE_GINA", ppeEnabledInGina);
            String ppeShowPolicy = PPEHandler.getShowPolicyEnabledCount() > 0 ? "Enabled" : "-";
            prop.put("PPE_WEB", ppeShowPolicy);
            String ppePwdHistory = PPEHandler.getPasswordHistoryEnabledCount() > 0 ? "Enabled" : "-";
            prop.put("PPE_PWD_HISTORY", ppePwdHistory);
            prop.put("SECONDARY_ATTRIBUTES", METrackHandler.getSecAttributes());
            METrackHandler.setMultiFactorAuthenticators(prop);
            METrackHandler.setTFAMode(prop);
            pcrecord.add(prop);
            out.log(Level.INFO, "Uploading getPolicyConfigData : " + pcrecord);
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error at getPolicyConfigData : " + e.getMessage());
        }
        return pcrecord;
    }

    private static void setSmartCardData(Properties pro) {
        try {
            pro.put("IS_SMART_CARD_ENABLED", (Object)SmartCardHandler.isSmartCardEnabled());
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }

    private static void setHAData(Properties pro) {
        try {
            pro.put("IS_HA_ENABLED", (Object)HAHandler.isHAEnabled());
        }
        catch (Exception e) {
            out.log(Level.INFO, e.getMessage());
        }
    }
}

