/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mobile;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.manageengine.ads.fw.mobile.mobilemanager.profile.ios.IOSProfileConfigHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobileUtil {
    public static final String SSP_MOBILE_APP_SETTINGS = "SSPMobileAppSettings";
    public static final String ALLOW_ROOTED_DEVICES = "ALLOW_ROOTED_DEVICES";
    public static final String HOME_VIEW_PROPERTIES = "HOME_VIEW_PROPERTIES";
    public static final String MOBILE_AUTO_LOGIN = "MOBILE_AUTO_LOGIN";
    public static final String RESTRICT_MOBILE_ACCESS = "RESTRICT_MOBILE_ACCESS";
    public static final String MOBILE_SHOW_DOMAIN_LIST = "MOBILE_SHOW_DOMAIN_LIST";
    public static final String MOBILE_LOGO = "MOBILE_LOGO";
    public static final String PUSH_CONF_ALERT_DISABL_PERIOD = "PUSH_CONF_ALERT_DISABL_PERIOD";
    public static final String MOBILE_SELECT_DOMAIN_OPTION = "MOBILE_SELECT_DOMAIN_OPTION";
    public static String[] mobFormElements = new String[]{"MOBILE_AUTO_LOGIN"};
    public static String[] mobFormElemTxt = new String[]{"adssp.admin.customize.logon_settgs.enable_mobile_auto_login", "adssp.admin.customize.logon_settings.hide_mobile_site"};
    public static final String KEY = "KEY";
    public static final String TXT_VALUE = "TXT_VALUE";
    public static final String ACTION = "ACTION";
    public static final String ENABLED_STATUS = "ENABLED_STATUS";
    public static final String TEXT = "TEXT";
    public static String[] mobCustomParams = new String[]{"KEY", "TXT_VALUE", "ACTION", "ENABLED_STATUS"};
    public static final String MOB_HOME_RESET = "MOB_HOME_RESET";
    public static final String MOB_HOME_UNLOCK = "MOB_HOME_UNLOCK";
    public static final String MOB_HOME_CHANGEPWD = "MOB_HOME_CHANGEPWD";
    public static final String MOB_HOME_SS = "MOB_HOME_SS";
    public static final String MOB_HOME_LOGIN = "MOB_HOME_LOGIN";
    public static final String MOB_HOME_FEEDBACK = "MOB_HOME_FEEDBACK";
    public static final String MOB_HOME_HELP = "MOB_HOME_HELP";
    public static List<String> sortableMobHomeElements = Arrays.asList("MOB_HOME_RESET", "MOB_HOME_UNLOCK", "MOB_HOME_CHANGEPWD");
    public static final int BROWSER_BIT_VALUE = 1;
    public static final int APP_BIT_VALUE = 2;
    public static String[] mobileSettngColumns = new String[]{"HOME_VIEW_PROPERTIES", "MOBILE_AUTO_LOGIN", "RESTRICT_MOBILE_ACCESS", "MOBILE_SHOW_DOMAIN_LIST", "MOBILE_SELECT_DOMAIN_OPTION", "MOBILE_LOGO"};
    public static final String RESET_BTN_LINK = "../m/mReset";
    public static final String UNLOCK_BTN_LINK = "../m/mUnlock";
    public static final String LOGIN_BTN_LINK = "../m/mAuthorization.do?isMobile=true";
    public static final String ACTION_BTN_ICON = "ACTION_BTN_ICON";
    public static final String ACTION_BTN_LINK = "ACTION_BTN_LINK";

    public static boolean isMobileAccess(HttpServletRequest request) {
        return MobileUtil.isNativeApp(request) || MobileUtil.isMobile(request);
    }

    public static boolean isNativeApp(HttpServletRequest request) {
        if (request == null || request.getHeader("User-Agent") == null) {
            return false;
        }
        String ua = request.getHeader("User-Agent").toLowerCase();
        return ua.contains("napp");
    }

    public static boolean isMobile(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        if (request.getHeader("User-Agent") == null) {
            return false;
        }
        String ua = request.getHeader("User-Agent").toLowerCase();
        String contextURL = request.getContextPath() + "/m/";
        return MobileUtil.isUserAgentMobile(ua) && (request.getRequestURI().startsWith("/m/") || request.getRequestURI().startsWith(contextURL));
    }

    public static boolean isUserAgentMobile(String ua) {
        return ua.indexOf("android") != -1 || ua.indexOf("blackberry") != -1 || ua.indexOf("iemobile") != -1 || ua.indexOf("mobile") != -1;
    }

    public static String getMobileProvider(HttpServletRequest request) {
        String ua = request.getHeader("User-Agent").toLowerCase();
        if (ua.equals("napp_android")) {
            return "NApp_Android";
        }
        return "NApp_IOS";
    }

    public static Long convertVersionToLong(String version) {
        version = version.trim();
        String[] subPart = version.split("\\.");
        version = "";
        for (int i = 0; i < subPart.length; ++i) {
            version = version + subPart[i];
        }
        return version.equals("") ? null : Long.valueOf(version);
    }

    public static boolean isProviderAndroid(HttpServletRequest request) {
        String provider = MobileUtil.getMobileProvider(request);
        return provider.equalsIgnoreCase("NApp_Android");
    }

    public static Boolean isMFASupportedApp(HttpServletRequest request) {
        return MobileUtil.isThisFeatureSupported(request, 126L, 128L);
    }

    public static Boolean isMultipleMobFormatSupported(HttpServletRequest request) {
        return MobileUtil.isThisFeatureSupported(request, 129L, 132L);
    }

    private static Boolean isThisFeatureSupported(HttpServletRequest request, Long minAndroidVersion, Long minIOSVersion) {
        String appVersion = request.getHeader("App-Version");
        if (appVersion == null) {
            return false;
        }
        if (MobileUtil.isNativeApp(request) && appVersion != null) {
            Long version = MobileUtil.convertVersionToLong(appVersion);
            boolean isAndroid = MobileUtil.isProviderAndroid(request);
            if (isAndroid && version >= minAndroidVersion || !isAndroid && version >= minIOSVersion) {
                return true;
            }
        }
        return false;
    }

    public static JSONObject getMobileAppSettings() {
        JSONObject appSettingProp = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                appSettingProp = new JSONObject();
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                for (int index = 0; index < mobileSettngColumns.length; ++index) {
                    String key = mobileSettngColumns[index];
                    appSettingProp.put(key, appSettingRow.get(key));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appSettingProp;
    }

    public static void updateMobileAppSettings(JSONObject appSettingProp) {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                Iterator keys = appSettingProp.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    appSettingRow.set(key, appSettingProp.get(key));
                }
                dataObj.updateRow(appSettingRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean showDomainList() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                return (Boolean)appSettingRow.get(MOBILE_SHOW_DOMAIN_LIST);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static Boolean getSelectDomainOption() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                return (Boolean)appSettingRow.get(MOBILE_SELECT_DOMAIN_OPTION);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static Boolean isAutoLoginEnabled() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                return (Boolean)appSettingRow.get(MOBILE_AUTO_LOGIN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static int getPNConfigAlertDisablePeriod() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                return ((Long)appSettingRow.get(PUSH_CONF_ALERT_DISABL_PERIOD)).intValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static Boolean isMobileSiteAccessRestricted(String requestURI) {
        boolean isMobSiteRestricted = false;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                int mobileAccessRestriction = ((Long)appSettingRow.get(RESTRICT_MOBILE_ACCESS)).intValue();
                boolean bl = isMobSiteRestricted = (1 & mobileAccessRestriction) == 1;
            }
            if (isMobSiteRestricted) {
                if (requestURI.contains("mDeviceEnrollment") && "step4".equalsIgnoreCase(IOSProfileConfigHandler.getStepfromDB())) {
                    isMobSiteRestricted = false;
                }
            } else if (requestURI.contains("mReset")) {
                isMobSiteRestricted = !MobileUtil.isResetOptEnabled();
            } else if (requestURI.contains("mUnlock")) {
                isMobSiteRestricted = !MobileUtil.isUnlockOptEnabled();
            } else if (requestURI.contains("mAuthorization")) {
                isMobSiteRestricted = !MobileUtil.isLoginOptEnabled() && !MobileUtil.isChangePwdOptEnabled();
            } else if (requestURI.contains("mDeviceEnrollment") && !"step4".equalsIgnoreCase(IOSProfileConfigHandler.getStepfromDB())) {
                isMobSiteRestricted = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isMobSiteRestricted;
    }

    public static Boolean isMobileAppAccessRestricted() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                int mobileAccessRestriction = ((Long)appSettingRow.get(RESTRICT_MOBILE_ACCESS)).intValue();
                return (2 & mobileAccessRestriction) == 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Boolean isRootedDeviceAllowed() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                return (Boolean)appSettingRow.get(ALLOW_ROOTED_DEVICES);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static JSONObject getActionBtnProp(String actionBtn) {
        JSONObject actionBtnProp = new JSONObject();
        try {
            if (actionBtn.equals(MOB_HOME_RESET)) {
                actionBtnProp.put(ACTION_BTN_LINK, (Object)RESET_BTN_LINK);
                actionBtnProp.put(ACTION_BTN_ICON, (Object)"resetBtnIcon");
            } else if (actionBtn.equals(MOB_HOME_UNLOCK)) {
                actionBtnProp.put(ACTION_BTN_LINK, (Object)UNLOCK_BTN_LINK);
                actionBtnProp.put(ACTION_BTN_ICON, (Object)"unlockBtnIcon");
            } else if (actionBtn.equals(MOB_HOME_CHANGEPWD)) {
                actionBtnProp.put(ACTION_BTN_LINK, (Object)LOGIN_BTN_LINK);
                actionBtnProp.put(ACTION_BTN_ICON, (Object)"chPwdBtnIcon");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionBtnProp;
    }

    public static String getMobLogoPath() {
        String imageDir = System.getProperty("server.home") + File.separator + "webapps" + File.separator + "adssp" + File.separator;
        try {
            Row appSettingRow;
            String mobLogoPath;
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty() && (mobLogoPath = (String)(appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS)).get(MOBILE_LOGO)) != null && !mobLogoPath.equals("") && new File(imageDir + mobLogoPath).exists()) {
                return mobLogoPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isMobDefaultLogo() {
        try {
            String mobLogoPath = MobileUtil.getMobLogoPath();
            if (mobLogoPath != null) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static boolean isResetOptEnabled() {
        return MobileUtil.getActionKeyEnabledStatus(MOB_HOME_RESET);
    }

    public static boolean isUnlockOptEnabled() {
        return MobileUtil.getActionKeyEnabledStatus(MOB_HOME_UNLOCK);
    }

    public static boolean isLoginOptEnabled() {
        return MobileUtil.getActionKeyEnabledStatus(MOB_HOME_LOGIN);
    }

    public static boolean isChangePwdOptEnabled() {
        return MobileUtil.getActionKeyEnabledStatus(MOB_HOME_CHANGEPWD);
    }

    public static boolean isServSettngOptEnabled() {
        return MobileUtil.getActionKeyEnabledStatus(MOB_HOME_SS);
    }

    public static boolean getActionKeyEnabledStatus(String actionKey) {
        try {
            Row appSettingRow;
            String viewProps;
            JSONArray homeViewProperties;
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty() && (homeViewProperties = new JSONArray(viewProps = (String)(appSettingRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS)).get(HOME_VIEW_PROPERTIES))) != null && homeViewProperties.length() > 0) {
                for (int index = 0; index < homeViewProperties.length(); ++index) {
                    JSONObject homeViewProp = homeViewProperties.getJSONObject(index);
                    if (!homeViewProp.has(ACTION) || !homeViewProp.getString(KEY).equals(actionKey)) continue;
                    return homeViewProp.getBoolean(ENABLED_STATUS);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void removeTempImage() {
        String imageDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adssp" + File.separator;
        try {
            File tempLogoImg = new File(imageDir + "/temp/tempMobPreview.jpeg");
            if (tempLogoImg.exists()) {
                tempLogoImg.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetMobileSettings() {
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            if (!dataObj.isEmpty()) {
                Row oldRow = dataObj.getFirstRow(SSP_MOBILE_APP_SETTINGS);
                dataObj.deleteRow(oldRow);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                MobileUtil.addDefaultMobileSettings();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addDefaultMobileSettings() {
        String mobileHomeSettings = "[{\"KEY\":\"MOB_HOME_RESET\",\"TXT_VALUE\":\"adssp.mobile.home.button.password_reset\",\"ACTION\":\"resetPassword\",\"ENABLED_STATUS\":\"true\"},{\"KEY\":\"MOB_HOME_UNLOCK\",\"TXT_VALUE\":\"adssp.mobile.home.button.account_unlock\",\"ACTION\":\"unlockAccount\",\"ENABLED_STATUS\":\"true\"},{\"KEY\":\"MOB_HOME_CHANGEPWD\",\"TXT_VALUE\":\"adssp.mobile.home.button.password_change\",\"ACTION\":\"changePwd\",\"ENABLED_STATUS\":\"false\"},{\"KEY\":\"MOB_HOME_SS\",\"TXT_VALUE\":\"adssp.mobile.home.button.server_settings\",\"ACTION\":\"serverSettings\",\"ENABLED_STATUS\":\"true\"},{\"KEY\":\"MOB_HOME_LOGIN\",\"TXT_VALUE\":\"adssp.mobile.login.button.login\",\"ACTION\":\"login\",\"ENABLED_STATUS\":\"true\"},{\"KEY\":\"MOB_HOME_HELP\",\"TXT_VALUE\":\"adssp.mobile.home.button.help\",\"ACTION\":\"help\",\"ENABLED_STATUS\":\"true\"},{\"KEY\":\"MOB_HOME_FEEDBACK\",\"TXT_VALUE\":\"adssp.mobile.home.button.feedback\",\"ACTION\":\"feedback\",\"ENABLED_STATUS\":\"true\"}]";
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_MOBILE_APP_SETTINGS, (Criteria)null);
            Row newRow = new Row(SSP_MOBILE_APP_SETTINGS);
            newRow.set(HOME_VIEW_PROPERTIES, (Object)mobileHomeSettings);
            dataObj.addRow(newRow);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isActionPermitted(HttpServletRequest request) {
        String pssoperation = request.getParameter("PSS_OPERATION");
        String operation = request.getParameter("operation");
        String selfServiceOperation = request.getParameter("SELF_SERVICE_OPERATION");
        return !("unlock".equals(pssoperation) && !MobileUtil.isUnlockOptEnabled() || "reset".equals(pssoperation) && !MobileUtil.isResetOptEnabled() || "login".equals(selfServiceOperation) && !MobileUtil.isLoginOptEnabled()) && (!"changePwd".equals(selfServiceOperation) || MobileUtil.isChangePwdOptEnabled());
    }

    public static List<String> getNonSupportedList(HttpServletRequest request) {
        ArrayList<String> nonSupMandList = new ArrayList<String>();
        boolean isMobileSite = MobileUtil.isMobile(request);
        boolean isNativeApp = MobileUtil.isNativeApp(request);
        if (isMobileSite || isNativeApp) {
            nonSupMandList.add(String.valueOf(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID));
            nonSupMandList.add(String.valueOf(IdentityVerifyHandler.TOTP_VERIFICATION_ID));
            if (isMobileSite) {
                nonSupMandList.add(String.valueOf(IdentityVerifyHandler.PN_VERIFICATION_ID));
                nonSupMandList.add(String.valueOf(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID));
            }
        }
        return nonSupMandList;
    }

    public static List<String> getNonSupportedList(HttpServletRequest request, String supportCategory) {
        try {
            if (request == null || !MobileUtil.isNativeApp(request)) {
                return null;
            }
            String[] baseNonSupportAppArr = new String[]{};
            return new ArrayList<String>(Arrays.asList(baseNonSupportAppArr));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isAppBannerDisabled() {
        try {
            Criteria crit = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"HIDE_APP_SUGGESTION", 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("SystemParams");
                return Boolean.valueOf((String)r.get("PARAM_VALUE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Boolean isEmpSearchHidden() {
        try {
            Criteria crit = new Criteria(new Column("SystemParams", "PARAM_NAME"), (Object)"HIDE_MOB_EMP_SEARCH", 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SystemParams", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("SystemParams");
                return Boolean.valueOf((String)r.get("PARAM_VALUE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

