/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mobile.mobilemanager.enrollment;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.iam.security.SecurityRequestWrapper;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AgentSchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.mobile.mobilemanager.enrollment.DeviceEnrollHandler;
import com.manageengine.ads.fw.mobile.mobilemanager.enrollment.MailDataSource;
import com.manageengine.ads.fw.mobile.mobilemanager.mdm.DeviceHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileUpload;
import org.apache.struts.upload.MultipartRequestWrapper;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailDataSourceImpl
implements MailDataSource {
    private static Logger logger = Logger.getLogger(MailDataSourceImpl.class.getName());
    public static String[] minutes = new String[]{"00", "05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    public static Long[] minValues = new Long[]{0L, 5L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L};
    public static String[] hourMins = new String[]{"05", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
    public static Long[] hourMinVals = new Long[]{5L, 10L, 15L, 20L, 25L, 30L, 35L, 40L, 45L, 50L, 55L};
    public static String[] hours = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static Long[] hourValues = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L};
    public static String[] time = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
    public static Long[] timeValues = new Long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L};
    public static String[] days = new String[]{"adssp.admin.common.text.sunday", "adssp.admin.common.text.monday", "adssp.admin.common.text.tuesday", "adssp.admin.common.text.wednesday", "adssp.admin.common.text.thursday", "adssp.admin.common.text.friday", "adssp.admin.common.text.saturday"};
    public static Integer[] dayValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
    public static String[] date = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    public static String[] scheduleTypeArray = new String[]{"daily", "weekly", "monthly", "hourly"};
    public static String[] scheduleText = new String[]{"adssp.admin.common.text.daily", "adssp.admin.common.text.weekly", "adssp.admin.common.text.monthly", "adssp.admin.common.text.hourly"};

    public static JSONObject getScheduleTimePeriods() {
        JSONObject timePeriodValues = new JSONObject();
        try {
            timePeriodValues.put("hours", (Object)hours);
            timePeriodValues.put("hourValues", (Object)hourValues);
            timePeriodValues.put("minutes", (Object)minutes);
            timePeriodValues.put("minValues", (Object)minValues);
            timePeriodValues.put("hourMins", (Object)hourMins);
            timePeriodValues.put("hourMinVals", (Object)hourMinVals);
            timePeriodValues.put("days", (Object)days);
            timePeriodValues.put("dayValues", (Object)dayValues);
            timePeriodValues.put("date", (Object)date);
            timePeriodValues.put("dateValues", (Object)dateValues);
            timePeriodValues.put("time", (Object)time);
            timePeriodValues.put("timeValues", (Object)timeValues);
            timePeriodValues.put("scheduleTypes", (Object)scheduleTypeArray);
            timePeriodValues.put("scheduleTypeValues", (Object)scheduleText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return timePeriodValues;
    }

    public String getTimeinCustomFormat(Long time, HttpServletRequest request) {
        return TimeZoneUtil.getTimeInCustomFormat(time, request);
    }

    public JSONArray getDomainList(Long loginId) {
        JSONArray domainDetails = new JSONArray();
        try {
            Hashtable domains = DomainHandler.getDomainsAndOUs(loginId);
            ArrayList domainList = (ArrayList)domains.get("domainList");
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                String domainName = domainProp.getProperty("DOMAIN_NAME");
                String domainFlatName = domainProp.getProperty("DOMAIN_FLAT_NAME");
                String defaultDomain = domainProp.getProperty("IS_DEFAULT_DOMAIN");
                String domainDisplayName = domainProp.getProperty("DOMAIN_DISPLAY_NAME");
                JSONObject tempJson = new JSONObject();
                tempJson.put("DOMAIN_NAME", (Object)domainName);
                tempJson.put("DOMAIN_FLAT_NAME", (Object)domainFlatName);
                tempJson.put("DOMAIN_DISPLAY_NAME", (Object)domainDisplayName);
                tempJson.put("IS_DEFAULT_DOMAIN", Boolean.parseBoolean(defaultDomain));
                domainDetails.put((Object)tempJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainDetails;
    }

    public void viewScheduler(HttpServletRequest request, DynaValidatorForm bean) {
        try {
            HttpSession session = request.getSession();
            String action = request.getParameter("action");
            if (action == null) {
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                JSONObject timePeriodValues = MailDataSourceImpl.getScheduleTimePeriods();
                String[] daysKey = (String[])timePeriodValues.get("days");
                String[] days = new String[daysKey.length];
                for (int i = 0; i < daysKey.length; ++i) {
                    days[i] = rb.getString(daysKey[i]);
                }
                bean.set("minutes", timePeriodValues.get("minutes"));
                bean.set("minValues", timePeriodValues.get("minValues"));
                bean.set("hourMins", timePeriodValues.get("hourMins"));
                bean.set("hourMinVals", timePeriodValues.get("hourMinVals"));
                bean.set("time", timePeriodValues.get("time"));
                bean.set("timeValues", timePeriodValues.get("timeValues"));
                bean.set("days", (Object)days);
                bean.set("dayValues", timePeriodValues.get("dayValues"));
                bean.set("date", timePeriodValues.get("date"));
                bean.set("dateValues", timePeriodValues.get("dateValues"));
                AgentSchedulerUtil.setDefaultProps(bean, loginId);
            } else {
                request.setAttribute("isEdit", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveSchedulers(Hashtable schedulerProps, DynaValidatorForm bean, HttpServletRequest request) {
        try {
            SchedulerHandler sHandler = SchedulerHandler.getInstance();
            Object scheduleId = sHandler.updateMobileScheduler(schedulerProps, request);
            MailDataSourceImpl.updateMASConfiguration(scheduleId, bean, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installAppsTask(Long scheduleId) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String configTableName = new String("SSPMASConfiguration");
            Table configTable = new Table(configTableName);
            SelectQueryImpl query = new SelectQueryImpl(configTable);
            Criteria crit = new Criteria(Column.getColumn((String)configTableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            Join configFilterJoin = new Join(configTableName, "SSPMASDomainOUs", new String[]{"AGENT_ID"}, new String[]{"AGENT_ID"}, 2);
            query.addJoin(configFilterJoin);
            query.addSelectColumn(Column.getColumn((String)"SSPMASDomainOUs", (String)"DOMAIN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"SSPMASDomainOUs", (String)"OU_DN"));
            query.addSelectColumn(Column.getColumn((String)configTableName, (String)"AGENT_ID"));
            RelationalAPI rApi = RelationalAPI.getInstance();
            connection = rApi.getConnection();
            dataSet = rApi.executeQuery((Query)query, connection);
            Hashtable ouTable = new Hashtable();
            Long agentId = new Long(-1L);
            while (dataSet.next()) {
                String ouDN;
                String domainDN;
                agentId = (Long)dataSet.getValue("AGENT_ID");
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                ArrayList<String> ouList = (ArrayList<String>)ouTable.get(domainName);
                if (ouList == null) {
                    ouList = new ArrayList<String>();
                }
                if (!(domainDN = DomainHandler.getDomainDetails(domainName).getString("DEFAULT_NAMING_CONTEXT")).equalsIgnoreCase(ouDN = (String)dataSet.getValue("OU_DN"))) {
                    ouList.add(ouDN);
                }
                ouTable.put(domainName, ouList);
            }
            Enumeration e = ouTable.keys();
            while (e.hasMoreElements()) {
                String keyName = (String)e.nextElement();
                Hashtable<String, Object> queryData = new Hashtable<String, Object>();
                queryData.put("DOMAIN_NAME", keyName);
                queryData.put("OU_LIST", (ArrayList)ouTable.get(keyName));
                queryData.put("START_INDEX", -1);
                queryData.put("NUM_OF_OBJECTS", -1);
                ArrayList userList = UserUtil.getUsersList(queryData);
                String[] userNames = new String[userList.size()];
                int i = 0;
                for (Properties p : userList) {
                    String samName = p.getProperty("SAM_ACCOUNT_NAME");
                    userNames[i++] = samName;
                }
                DeviceHandler.pushAppsToDomain((String[])userNames, (String)keyName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMailTask(Long scheduleId) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String configTableName = new String("SSPMASConfiguration");
            Table configTable = new Table(configTableName);
            SelectQueryImpl query = new SelectQueryImpl(configTable);
            Criteria crit = new Criteria(Column.getColumn((String)configTableName, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            Join configFilterJoin = new Join(configTableName, "SSPMASDomainOUs", new String[]{"AGENT_ID"}, new String[]{"AGENT_ID"}, 2);
            query.addJoin(configFilterJoin);
            query.addSelectColumn(Column.getColumn((String)"SSPMASDomainOUs", (String)"DOMAIN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"SSPMASDomainOUs", (String)"OU_DN"));
            query.addSelectColumn(Column.getColumn((String)configTableName, (String)"AGENT_ID"));
            RelationalAPI rApi = RelationalAPI.getInstance();
            connection = rApi.getConnection();
            dataSet = rApi.executeQuery((Query)query, connection);
            Hashtable<String, ArrayList<String>> ouTable = new Hashtable<String, ArrayList<String>>();
            Long agentId = new Long(-1L);
            while (dataSet.next()) {
                agentId = (Long)dataSet.getValue("AGENT_ID");
                String domainName = (String)dataSet.getValue("DOMAIN_NAME");
                ArrayList<String> ouList = (ArrayList<String>)ouTable.get(domainName);
                if (ouList == null) {
                    ouList = new ArrayList<String>();
                }
                ouList.add((String)dataSet.getValue("OU_DN"));
                ouTable.put(domainName, ouList);
            }
            Enumeration e = ouTable.keys();
            while (e.hasMoreElements()) {
                JSONArray usrArr;
                JSONArray notifiedArr;
                String keyName = (String)e.nextElement();
                Hashtable results = this.retrieveMailList(keyName, (ArrayList)ouTable.get(keyName));
                if (results == null || (notifiedArr = DeviceEnrollHandler.sendMailUsers((JSONArray)(usrArr = (JSONArray)results.get("USER_DETAILS")), (String)keyName)) == null || notifiedArr.length() == 0) continue;
                DeviceHandler.addNotifiedUsers((JSONArray)notifiedArr, (String)keyName, (String[])((String[])results.get("USER_GUIDS")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Hashtable retrieveMailList(String domainName, ArrayList<String> ouList) {
        Hashtable<String, Object> results = new Hashtable<String, Object>();
        try {
            Boolean notifyAll = "true".equals(ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY"));
            String domainUserTable = CommonUtil.getDomainUserTableName(domainName);
            Table domainTable = Table.getTable((String)domainUserTable);
            SelectQueryImpl selQuery = new SelectQueryImpl(domainTable);
            selQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
            DeviceHandler.removeConfiguredDevices((String)domainName, (SelectQuery)selQuery);
            ouList = OUUtil.getParentOUs(ouList);
            Criteria filterCrit = null;
            for (int x = 0; x < ouList.size(); ++x) {
                filterCrit = filterCrit == null ? new Criteria(Column.getColumn((String)domainUserTable, (String)"DN_STRING"), (Object)("*" + (String)ouList.get(x)), 2, false) : filterCrit.or(new Criteria(Column.getColumn((String)domainUserTable, (String)"DN_STRING"), (Object)("*" + (String)ouList.get(x)), 2, false));
            }
            selQuery.setCriteria(selQuery.getCriteria() != null ? selQuery.getCriteria().and(filterCrit) : filterCrit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            ArrayList<String> mailIDs = new ArrayList<String>();
            ArrayList<String> usrGuids = new ArrayList<String>();
            JSONArray usrArr = new JSONArray();
            Iterator iter = dataObject.getRows(domainUserTable);
            while (iter.hasNext()) {
                Hashtable secondaryMailHash;
                String allSecMails;
                Long loginId;
                Row row = (Row)iter.next();
                String samAccountName = (String)row.get("SAM_ACCOUNT_NAME");
                String email = row.get("E_MAIL").toString();
                if (notifyAll.booleanValue() && (loginId = ADMPUserHandler.getLoginId(samAccountName, domainName)) != null && (allSecMails = (String)(secondaryMailHash = UserUtil.getUserPersonal(loginId, new String[]{"EMAIL_ADDRESSES"})).get("EMAIL_ADDRESSES")) != null && !allSecMails.equals("")) {
                    email = email + "," + allSecMails;
                }
                if (email == null || email.equals("")) continue;
                JSONObject usrObj = new JSONObject();
                mailIDs.add(row.get("E_MAIL").toString());
                usrGuids.add((String)row.get("OBJECT_GUID"));
                usrObj.put("USER_NAME", (Object)samAccountName);
                usrObj.put("OBJECT_GUID", (Object)((String)row.get("OBJECT_GUID")));
                usrObj.put("DOMAIN_NAME", (Object)domainName);
                usrObj.put("E_MAIL", (Object)email);
                usrArr.put((Object)usrObj);
            }
            String[] usrGuid = new String[usrArr.length()];
            usrGuids.toArray(usrGuid);
            results.put("USER_GUIDS", usrGuid);
            results.put("MAILING_LIST", mailIDs);
            results.put("USER_DETAILS", usrArr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    public static void updateMASConfiguration(Object scheduleId, DynaValidatorForm bean, HttpServletRequest request) {
        try {
            Long agentId = (Long)bean.get("AGENT_ID");
            ArrayList domainList = (ArrayList)bean.get("domainList");
            for (int i = 0; i < domainList.size(); ++i) {
                Properties props = (Properties)domainList.get(i);
                String domainName = (String)props.get("DOMAIN_NAME");
                logger.log(Level.INFO, "Deleting OUs configured for the domain: " + domainName + " for the agentID :" + agentId);
                AgentSchedulerHandler.deleteMobileScheduler(agentId, domainName);
            }
            Criteria crit = new Criteria(Column.getColumn((String)"SSPMASConfiguration", (String)"AGENT_ID"), (Object)agentId, 0);
            DataObject asConfobj = CommonUtil.getPersistence(new boolean[0]).get("SSPMASConfiguration", crit);
            Row asConfig = asConfobj.getFirstRow("SSPMASConfiguration");
            asConfig.set("SCHEDULE_ID", scheduleId);
            asConfobj.updateRow(asConfig);
            CommonUtil.getPersistence(new boolean[0]).update(asConfobj);
            asConfobj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            ArrayList<Object> selectedDomainList = new ArrayList();
            String[] ar = request.getParameterValues("domains");
            if (ar != null) {
                selectedDomainList = new ArrayList<String>(Arrays.asList(ar));
            }
            Properties ouGuidsProp = new Properties();
            Hashtable selDomainAndOUs = new Hashtable();
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            for (int j = 0; j < domainList.size(); ++j) {
                Properties props = (Properties)domainList.get(j);
                String dn = (String)props.get("DEFAULT_NAMING_CONTEXT");
                if (!selectedDomainList.contains(dn)) continue;
                String domainName = (String)props.get("DOMAIN_NAME");
                AgentSchedulerHandler.getOUGuids((ArrayList)props.get("ouList"), ouGuidsProp);
                ouGuidsProp.put(dn, (String)props.get("OBJECT_GUID"));
                ArrayList<String> list = (ArrayList<String>)domainOUList.get(dn);
                logger.log(Level.INFO, "List : " + list + " : For DN : " + dn);
                if (list == null || list.isEmpty()) {
                    list = new ArrayList<String>();
                    list.add(dn);
                } else if (list.contains(dn) && list.size() != 1) {
                    list.remove(dn);
                }
                ArrayList<String> ouList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    String ouName = (String)list.get(i);
                    Row r = new Row("SSPMASDomainOUs");
                    r.set("AGENT_ID", (Object)agentId);
                    r.set("OBJECT_GUID", (Object)ouGuidsProp.getProperty(ouName));
                    r.set("DOMAIN_NAME", (Object)domainName);
                    if (!ouList.contains(ouName)) {
                        ouList.add(ouName);
                    }
                    r.set("OU_DN", (Object)ouName);
                    asConfobj.addRow(r);
                }
                selDomainAndOUs.put((String)props.get("DOMAIN_NAME"), ouList);
            }
            CommonUtil.getPersistenceLite().add(asConfobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getAgentSchedulerDetails(HttpServletRequest request, DynaValidatorForm bean) {
        AgentSchedulerHandler.getAgentSchedulerDetails(request, bean, "SSPMASDomainOUs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTaskSchedulers() {
        ArrayList<Properties> scheduleConfigList = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String configTableName = new String("SSPMASConfiguration");
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("Schedule"));
            Join scheduleJoin = new Join("Schedule", configTableName, new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Join taskInputJoin = new Join("Schedule", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join schTaskJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join taskJoin = new Join("Scheduled_Task", "TaskEngine_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 1);
            selQuery.addSortColumn(new SortColumn(Column.getColumn((String)"SSPMASConfiguration", (String)"AGENT_ID"), true));
            selQuery.addJoin(scheduleJoin);
            selQuery.addJoin(taskInputJoin);
            selQuery.addJoin(calendarJoin);
            selQuery.addJoin(periodicJoin);
            selQuery.addJoin(schTaskJoin);
            selQuery.addJoin(taskJoin);
            selQuery.addSelectColumn(Column.getColumn((String)"SSPMASConfiguration", (String)"AGENT_ID"));
            selQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"));
            selQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"Schedule", (String)"DESCRIPTION"));
            selQuery.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_TIME"));
            selQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"TIME_OF_DAY"));
            selQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"UNIT_OF_TIME"));
            selQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DAY_OF_WEEK"));
            selQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"DATE_OF_MONTH"));
            selQuery.addSelectColumn(Column.getColumn((String)"Calendar", (String)"REPEAT_FREQUENCY"));
            selQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"TIME_PERIOD"));
            selQuery.addSelectColumn(Column.getColumn((String)"Periodic", (String)"UNIT_OF_TIME"));
            selQuery.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"ADMIN_STATUS"));
            selQuery.addSelectColumn(Column.getColumn((String)"Scheduled_Task", (String)"TASK_ID"));
            selQuery.addSelectColumn(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                Properties taskProps = new Properties();
                Long agentId = (Long)dataSet.getValue("AGENT_ID");
                taskProps.put("AGENT_ID", agentId);
                taskProps.put("SCHEDULE_ID", (Long)dataSet.getValue("SCHEDULE_ID"));
                taskProps.put("SCHEDULE_NAME", (String)dataSet.getValue("SCHEDULE_NAME"));
                taskProps.put("DESCRIPTION", (String)dataSet.getValue("DESCRIPTION"));
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put("TIME_OF_DAY", (Long)dataSet.getValue("TIME_OF_DAY"));
                prop.put("C_UNIT_OF_TIME", (String)dataSet.getValue(7));
                prop.put("DAY_OF_WEEK", (Integer)dataSet.getValue("DAY_OF_WEEK"));
                prop.put("DATE_OF_MONTH", (Integer)dataSet.getValue("DATE_OF_MONTH"));
                Long timePeriod = (Long)dataSet.getValue("TIME_PERIOD");
                prop.put("TIME_PERIOD", timePeriod);
                if (timePeriod != null && timePeriod != -1L) {
                    prop.put("SCHEDULE_TYPE", "Hourly");
                } else {
                    prop.put("SCHEDULE_TYPE", (String)dataSet.getValue("REPEAT_FREQUENCY"));
                }
                prop.put("P_UNIT_OF_TIME", (String)dataSet.getValue(12));
                taskProps.put("SCHEDULED_AT", prop);
                taskProps.put("SCHEDULE_STATUS", (Integer)dataSet.getValue("ADMIN_STATUS"));
                String taskName = (String)dataSet.getValue("TASK_NAME");
                String domainOrPolicies = new String();
                domainOrPolicies = MailDataSourceImpl.getTaskDomains(agentId);
                taskProps.put("DOMAINS", domainOrPolicies);
                scheduleConfigList.add(taskProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleConfigList;
    }

    public static String getTaskDomains(Long agentId) {
        String domains = new String("...");
        try {
            Table domainOU = new Table("SSPMASDomainOUs");
            SelectQueryImpl sq = new SelectQueryImpl(domainOU);
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
            Join join = new Join(domainOU, Table.getTable((String)"ADSMDomainConfiguration"), new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 1);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPMASDomainOUs", (String)"AGENT_ID"), (Object)agentId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DISPLAY_NAME"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows("ADSMDomainConfiguration");
                while (iter.hasNext()) {
                    Row filterRow = (Row)iter.next();
                    String domainName = (String)filterRow.get("DOMAIN_DISPLAY_NAME");
                    if (domains.equals("...")) {
                        domains = domainName;
                        continue;
                    }
                    if (domains.indexOf(domainName) == 0 || domains.indexOf(new String("," + domainName)) != -1) continue;
                    domains = domains + "," + domainName;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    public String getDefaultDomainName(Long loginId) {
        return DomainHandler.getDefaultDomain(loginId);
    }

    public String changeAdminStatus(String scheduleId) {
        return SchedulerConfiguration.changeAdminStatus(scheduleId);
    }

    public String getOuDN(String guid, String domainName) {
        try {
            String ouDN = DomainHandler.getDomainDetails(domainName).getString("DEFAULT_NAMING_CONTEXT");
            String ouProp = OUUtil.getOUProp("OBJECT_GUID", guid, "DISTINGUISHED_NAME", domainName, 1L);
            if (!ouDN.equalsIgnoreCase(ouProp)) {
                return ouProp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void addTaskSchedulers() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPMASConfiguration", (String)"AGENT_ID"), null, 1);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPMASConfiguration", crit);
            if (!dObj.isEmpty()) {
                return;
            }
            logger.log(Level.INFO, "Populating the values for MobileTaskScheduler");
            String[] schedulerNames = new String[]{"ads.configuration.mdm.schedulers.notification_scheduler", "ads.configuration.mdm.schedulers.installation_scheduler"};
            Long[] agentIds = new Long[]{1L, 2L};
            int i = 0;
            for (String schedulerName : schedulerNames) {
                Criteria criter = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schedulerName, 0);
                DataObject schObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", criter);
                if (schObj.isEmpty()) continue;
                Row sr = schObj.getFirstRow("Schedule");
                Row cR = null;
                cR = new Row("SSPMASConfiguration");
                cR.set("AGENT_ID", (Object)agentIds[i++]);
                cR.set("SCHEDULE_ID", (Object)((Long)sr.get("SCHEDULE_ID")));
                dObj.addRow(cR);
            }
            CommonUtil.getPersistenceLite().add(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SelectQuery getSQForUsers(Hashtable props) {
        return UserUtil.getSQForUsersList(props);
    }

    public ArrayList getParentOUs(ArrayList ouList) {
        return OUUtil.getParentOUs(ouList);
    }

    public int getUsersCount(Hashtable props) {
        return UserUtil.getUsersCount(props);
    }

    public boolean uploadFile(String fileName, HttpServletRequest request, String requestFileName) {
        try {
            String folderName = "..\\MPM\\Certificates";
            File certDir = new File("..\\MPM");
            if (certDir.exists()) {
                certDir = new File(folderName);
                if (!certDir.exists()) {
                    certDir.mkdir();
                }
            } else {
                certDir.mkdir();
                certDir = new File(folderName);
                certDir.mkdir();
            }
            if (FileUpload.isMultipartContent((HttpServletRequest)request)) {
                SecurityRequestWrapper secrequest = (SecurityRequestWrapper)((MultipartRequestWrapper)request).getRequest();
                UploadedFileItem item1 = secrequest.getMultipartParameter(requestFileName);
                File formFile = null;
                if (item1 != null) {
                    formFile = item1.getUploadedFile();
                    MailDataSourceImpl.storeFile(fileName, formFile);
                }
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getEncryptedKeyStorePassword() {
        return ADSMPersUtil.getEncryptedKeyStorePassword();
    }

    public static String storeFile(String fileName, File formFile) throws Exception {
        FileOutputStream fout = null;
        File saveFile = null;
        try {
            FileInputStream fileInput = new FileInputStream(formFile);
            byte[] file = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read(file);
            File saveDir = new File("..\\MPM\\Certificates");
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File("..\\MPM\\Certificates" + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write(file);
            fout.close();
            String string = saveFile.getAbsolutePath();
            return string;
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

