/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.model;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Hashtable;
import java.util.Iterator;

public class DirectoryObjectAPI {
    private static DirectoryObjectAPI api = null;
    private Hashtable objectClasses = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DirectoryObjectAPI getInstance() {
        if (api != null) return api;
        Class<DirectoryObjectAPI> clazz = DirectoryObjectAPI.class;
        synchronized (DirectoryObjectAPI.class) {
            if (api != null) return api;
            api = new DirectoryObjectAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return api;
        }
    }

    private DirectoryObjectAPI() {
        try {
            this.objectClasses = new Hashtable();
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPObjects", new Criteria(new Column("ADMPObjects", "OBJECT_CLASS"), (Object)"", 1));
            Iterator iterator = obj.getRows("ADMPObjects");
            while (iterator.hasNext()) {
                Row r1 = (Row)iterator.next();
                String objectClass = (String)r1.get("OBJECT_CLASS");
                this.objectClasses.put(objectClass.toLowerCase(), new ObjectClass(objectClass, obj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectClass getObjectClass(String objClass) {
        return (ObjectClass)this.objectClasses.get(objClass.toLowerCase());
    }
}

