/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.model;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import java.util.ArrayList;
import java.util.Hashtable;

public class ObjectClass {
    private ArrayList tables = null;
    private String objectClass = null;
    private Integer startRange = null;
    private Integer endRange = null;
    private String baseTable = null;
    private String resultTable = null;
    private String ldapCriteria = null;

    public ObjectClass(String objClass, DataObject obj) {
        try {
            this.objectClass = objClass;
            this.tables = new ArrayList();
            Row r = obj.getRow("ADMPObjects", new Criteria(new Column("ADMPObjects", "OBJECT_CLASS"), (Object)objClass, 0));
            this.baseTable = (String)r.get("BASE_TABLE_NAME");
            this.resultTable = (String)r.get("RESULT_TABLE_NAME");
            this.startRange = (Integer)r.get("START_ATTRIB_ID");
            this.endRange = (Integer)r.get("END_ATTRIB_ID");
            this.ldapCriteria = (String)r.get("LDAP_CRITERIA");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getTables() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.tables.size(); ++i) {
            Hashtable props = (Hashtable)this.tables.get(i);
            list.add(props.get("TABLE_NAME"));
        }
        return list;
    }

    public ArrayList getTableDetails() {
        return this.tables;
    }

    public Integer getStartRange() {
        return this.startRange;
    }

    public Integer getEndRange() {
        return this.endRange;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getResultTable() {
        return this.resultTable;
    }

    public String getLdapCriteia() {
        return this.ldapCriteria;
    }
}

