/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql;

import com.adventnet.mfw.Starter;
import com.adventnet.sym.adsm.common.server.mysql.ChangeDBServerGUI;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChangeDBServer {
    public static void main(String[] args) throws Exception {
        Starter.LoadJars();
        if (args.length == 1) {
            if (!"--console".equals(args[0].trim())) {
                ChangeDBServerGUI.main(args);
            }
        } else if (args.length == 0) {
            ChangeDBServerGUI.main(args);
        }
    }

    public static String createDB(String stype, String server, String port, String dbName, boolean isWinAuthType, String domain, String user, String pword) throws Exception {
        String conUrl = ChangeDBServer.getConnectionURL(stype, server, port, isWinAuthType, domain);
        if (stype.equalsIgnoreCase("mysql")) {
            return ChangeDBServer.executeQuery(conUrl, user, pword, "create database " + dbName + " DEFAULT CHARACTER SET utf8 DEFAULT COLLATE utf8_general_ci");
        }
        return ChangeDBServer.executeQuery(conUrl, user, pword, "create database " + dbName);
    }

    public static String getActiveDB() throws Exception {
        String stype = "mssql";
        String driverName = ChangeDBServer.getPropertyValue("drivername");
        if (driverName.equals("org.gjt.mm.mysql.Driver")) {
            stype = "mysql";
        } else if (driverName.equals("org.postgresql.Driver")) {
            stype = "postgres";
        }
        return stype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyValue(String key) throws Exception {
        FileInputStream fis = null;
        String dbfile = System.getProperty("SERVER_HOME") + File.separator + "conf" + File.separator + "database_params.conf";
        if (!new File(dbfile).isFile()) {
            throw new Exception("datasource file not found [" + dbfile + "]");
        }
        Properties pro = new Properties();
        try {
            fis = new FileInputStream(new File(dbfile));
            pro.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return pro.getProperty(key);
    }

    public static boolean isSameDBConfiguration(String serverType, String host, String port, String dbName, String username, String password, boolean isWinAuthType, String domain) {
        try {
            String oldUserName = ChangeDBServer.getPropertyValue("username");
            if (oldUserName != null && oldUserName.equalsIgnoreCase(username)) {
                String oldpassword = ChangeDBServer.getPropertyValue("password");
                if (oldpassword == null) {
                    oldpassword = "";
                }
                if (!oldpassword.equals("")) {
                    EnDecryptImpl deCryptor = new EnDecryptImpl();
                    oldpassword = deCryptor.decrypt(oldpassword);
                }
                if (password.equalsIgnoreCase(oldpassword)) {
                    String oldConnectURL;
                    String newConnectURL = ChangeDBServer.constructConnectionURL(serverType, host, port, dbName, isWinAuthType, domain);
                    if (newConnectURL.equals(oldConnectURL = ChangeDBServer.getPropertyValue("url"))) {
                        return true;
                    }
                    if (serverType.equals("postgres") && oldConnectURL.equals(newConnectURL + "?useUnicode=true&characterEncoding=UTF-8")) {
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isWinAuthType() throws Exception {
        String connectionURL = ChangeDBServer.getPropertyValue("url");
        return connectionURL.indexOf("Domain=") != -1;
    }

    public static HashMap<String, String> getDBDetails(String selectedServer) throws Exception {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        String activeDB = ChangeDBServer.getActiveDB();
        String connectionURL = ChangeDBServer.getPropertyValue("url");
        String userName = ChangeDBServer.getPropertyValue("username");
        String dbName = "";
        String dbServer = "localhost";
        String port = "";
        if ("mysql".equals(activeDB) && selectedServer.equals("mysql")) {
            dbServer = connectionURL.substring(connectionURL.indexOf("://") + 3, connectionURL.lastIndexOf(":"));
            port = connectionURL.substring(connectionURL.indexOf(dbServer) + dbServer.length() + 1, connectionURL.lastIndexOf("/"));
            dbName = connectionURL.substring(connectionURL.indexOf(port) + port.length() + 1, connectionURL.indexOf("?"));
        } else if ("mssql".equals(activeDB) && selectedServer.equals("mssql")) {
            dbServer = connectionURL.substring(connectionURL.indexOf("://") + 3, connectionURL.lastIndexOf(":"));
            port = connectionURL.substring(connectionURL.indexOf(dbServer) + dbServer.length() + 1, connectionURL.indexOf(";"));
            if (connectionURL.indexOf("Domain=") != -1) {
                dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + 13, connectionURL.indexOf(";Domain="));
                String domainName = connectionURL.substring(connectionURL.indexOf("Domain") + 7, connectionURL.indexOf(";useNTLMv2="));
                hash.put("DOMAINNAME", domainName);
            } else {
                dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + 13, connectionURL.length());
            }
            hash.put("DATABASE", dbName);
        } else if ("postgres".equals(activeDB) && selectedServer.equals("postgres")) {
            dbServer = connectionURL.substring(connectionURL.indexOf("://") + 3, connectionURL.lastIndexOf(":"));
            port = connectionURL.substring(connectionURL.indexOf(dbServer) + dbServer.length() + 1, connectionURL.lastIndexOf("/"));
            dbName = connectionURL.substring(connectionURL.indexOf(port) + port.length() + 1, connectionURL.length());
        }
        hash.put("HOST", dbServer);
        hash.put("PORT", port);
        hash.put("DATABASE", dbName);
        hash.put("USERNAME", userName);
        return hash;
    }

    public static String getConnectionURL(String stype, String server, String port, boolean isWinAuthType, String domain) throws Exception {
        String dbUrl = "";
        if ("mssql".equals(stype)) {
            dbUrl = isWinAuthType ? "jdbc:jtds:sqlserver://" + server + ":" + port + ";Domain=" + domain + ";useNTLMv2=true" : "jdbc:jtds:sqlserver://" + server + ":" + port + ";";
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        } else if ("mysql".equals(stype)) {
            dbUrl = "jdbc:mysql://" + server + ":" + port + "/";
            Class.forName("org.gjt.mm.mysql.Driver");
        } else if ("postgres".equals(stype)) {
            dbUrl = "jdbc:postgresql://" + server + ":" + port + "/";
            Class.forName("org.postgresql.Driver");
        }
        return dbUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeQuery(String conUrl, String user, String pword, String query) throws Exception {
        String message = "Successfully Executed !!!";
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(conUrl, user, pword);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isDBServerRunning(String stype, String server, String port, boolean isWinAuthType, String domain, String user, String pword) throws Exception {
        String isRunning = "yes";
        String dbUrl = null;
        if ("mssql".equals(stype)) {
            dbUrl = isWinAuthType ? "jdbc:jtds:sqlserver://" + server + ":" + port + ";Domain=" + domain + ";useNTLMv2=true" : "jdbc:jtds:sqlserver://" + server + ":" + port + ";";
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        } else if ("mysql".equals(stype)) {
            dbUrl = "jdbc:mysql://" + server + ":" + port + "/";
            Class.forName("org.gjt.mm.mysql.Driver");
        } else if ("postgres".equals(stype)) {
            dbUrl = "jdbc:postgresql://" + server + ":" + port + "/";
            Class.forName("org.postgresql.Driver");
        }
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(dbUrl, user, pword);
        }
        catch (Exception e) {
            isRunning = e.getMessage().indexOf("refused") > 0 ? ("mssql".equals(stype) ? "Unable to connect to the MSSQL server. Please verify the following:\n\n1)  Check whether the MSSQL server is running.\n2)  Check for correct Server Name and Port number.\n3)  Check if a firewall blocks the port " + port + ", on the server. \n4)  MSSQL Server is not configured to use TCP/IP. Enable TCP/IP for Remote Connections. \nNote: To check whether TCP/IP is enabled or the port is blocked, use \"telnet <server_host> <portnumber>\"\n" : ("mysql".equals(stype) ? "Unable to connect to the MySQL server. Please verify the following:\n\n1)  Check whether the MySQL server is running.\n2)  Check for correct Server Name and Port number.\n3)  If the MySQL server is running on remote machine, check if a firewall blocks the port " + port + ", on the server." : "Unable to connect to the PgSQL server. Please verify the following:\n\n1)  Check whether the PgSQL server is running.\n2)  Check for correct Server Name and Port number.\n3)  If the PgSQL server is running on remote machine, check if a firewall blocks the port " + port + ", on the server.")) : (e.getMessage().toLowerCase().indexOf("access denied") > 0 ? "Access denied :-( please check the User name and password" : (e.getMessage().toLowerCase().indexOf("port out of range") > 0 ? "Out of range :-( Invalid port number" : (e.getMessage().toLowerCase().indexOf("unknownhost") > 0 ? "Unknown Host " + server + " : Please check the server name you have entered" : e.getMessage())));
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        return isRunning;
    }

    public void updateDBConfigFile(String server, String host, String port, String dbName, boolean isWinAuthType, String domain, String user, String pwd, String serverdir) throws Exception {
        Properties updatedDBConfig = new Properties();
        String connectionUrl = null;
        String driverName = null;
        String userName = user;
        String passWord = null;
        String dbAdapter = null;
        String sqlGenerator = null;
        String portNumber = port;
        String exceptionSorter = null;
        String dbParmasFile = System.getProperty("SERVER_HOME") + File.separator + "conf" + File.separator + "database_params.conf";
        String dbPersistenceConfFile = System.getProperty("SERVER_HOME") + File.separator + "conf" + File.separator + "Persistence" + File.separator + "persistence-configurations.xml";
        if (pwd != null && !pwd.equals("")) {
            EnDecryptImpl enCryptor = new EnDecryptImpl();
            passWord = enCryptor.encrypt(pwd);
        }
        if ("mysql".equals(server)) {
            connectionUrl = "jdbc:mysql://" + host + ":" + portNumber + "/" + dbName + "?useUnicode=true&characterEncoding=UTF-8&jdbcCompliantTruncation=false";
            driverName = "org.gjt.mm.mysql.Driver";
            dbAdapter = "com.adventnet.db.adapter.mysql.MysqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mysql.MysqlSQLGenerator";
            exceptionSorter = "com.adventnet.db.adapter.mysql.MysqlExceptionSorter";
            if (passWord != null) {
                updatedDBConfig.setProperty("password", passWord);
            }
        } else if ("mssql".equals(server)) {
            connectionUrl = "jdbc:jtds:sqlserver://" + host + ":" + portNumber;
            connectionUrl = connectionUrl + ";DatabaseName=" + dbName;
            if (isWinAuthType) {
                connectionUrl = connectionUrl + ";Domain=" + domain + ";useNTLMv2=true";
            }
            driverName = "net.sourceforge.jtds.jdbc.Driver";
            dbAdapter = "com.adventnet.db.adapter.mssql.MssqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mssql.MssqlSQLGenerator";
            exceptionSorter = "com.adventnet.db.adapter.mssql.MssqlExceptionSorter";
            if (passWord != null) {
                updatedDBConfig.setProperty("password", passWord);
            }
        } else if ("postgres".equals(server)) {
            connectionUrl = "jdbc:postgresql://" + host + ":" + portNumber + "/" + dbName;
            driverName = "org.postgresql.Driver";
            dbAdapter = "com.adventnet.db.adapter.postgres.PostgresDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.postgres.PostgresSQLGenerator";
            exceptionSorter = "com.adventnet.db.adapter.postgres.PostgresExceptionSorter";
            if (passWord != null) {
                updatedDBConfig.setProperty("password", passWord);
            }
        }
        this.updateXMLFile(server, dbPersistenceConfFile);
        updatedDBConfig.setProperty("minsize", "1");
        updatedDBConfig.setProperty("maxsize", "20");
        updatedDBConfig.setProperty("transaction_isolation", "TRANSACTION_READ_COMMITTED");
        updatedDBConfig.setProperty("url", connectionUrl);
        updatedDBConfig.setProperty("drivername", driverName);
        updatedDBConfig.setProperty("username", userName);
        updatedDBConfig.setProperty("dbadapter", dbAdapter);
        updatedDBConfig.setProperty("sqlgenerator", sqlGenerator);
        updatedDBConfig.setProperty("exceptionsorterclassname", exceptionSorter);
        FileOutputStream out = new FileOutputStream(dbParmasFile);
        Enumeration<Object> e = updatedDBConfig.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String configLine = key + " = " + updatedDBConfig.getProperty(key) + "\n";
            byte[] buf = configLine.getBytes();
            ((OutputStream)out).write(buf);
        }
        ((OutputStream)out).close();
    }

    private void updateXMLFile(String newDBServer, String serverdir) throws Exception {
        String dbCrachHandler;
        String value = "false";
        String string = dbCrachHandler = "postgres".equals(newDBServer) ? "com.adventnet.db.adapter.postgres.PostgresExceptionSorter" : "com.adventnet.db.adapter.mysql.MysqlExceptionSorter";
        if ("mssql".equals(newDBServer)) {
            dbCrachHandler = "com.adventnet.db.adapter.mssql.MssqlExceptionSorter";
        }
        String xml_path = serverdir;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new FileInputStream(xml_path));
        NodeList attributes = doc.getElementsByTagName("configuration");
        for (int i = 0; i < attributes.getLength(); ++i) {
            Element ele = (Element)attributes.item(i);
            String attributeName = ele.getAttribute("name");
            if ("DBName".equals(attributeName)) {
                ele.setAttribute("value", newDBServer);
            }
            if ("StartDBServer".equals(attributeName)) {
                ele.setAttribute("value", value);
            }
            if ("DSAdapter".equals(attributeName)) {
                ele.setAttribute("value", newDBServer);
            }
            if (!"DBCrashHandler".equals(attributeName)) continue;
            ele.setAttribute("value", dbCrachHandler);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new File(xml_path));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkBCPFiles() {
        String bcpError = "BCP OK";
        String mysqlDir = System.getProperty("SERVER_HOME") + File.separator + "bin" + File.separator;
        File bcpexe = new File(mysqlDir + "bcp.exe");
        File bcprll = new File(mysqlDir + "bcp.rll");
        if (!bcpexe.exists() || !bcprll.exists()) {
            bcpError = "adssp.system.dbconfig.copy_paste_bcp_files";
        } else {
            BufferedReader in = null;
            try {
                Process p = new ProcessBuilder("cmd", "/c", "..\\bin\\bcp.exe", "-?").start();
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String bcpOut = in.readLine();
                if (bcpOut == null) {
                    bcpError = "SQL Native Client";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
        return bcpError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeBCPQuery(String serverName, boolean isWinAuthType, String userName, String pwd, String query) {
        String output = "";
        ArrayList<String> commandToExecute = new ArrayList<String>(Arrays.asList("cmd", "/c", "..\\bin\\bcp.exe", query, "queryout", "query.out", "-S", serverName, "-c"));
        if (isWinAuthType) {
            commandToExecute.add("-T");
        } else {
            commandToExecute.add("-U");
            commandToExecute.add(userName);
            commandToExecute.add("-P");
            commandToExecute.add(pwd);
        }
        BufferedReader in = null;
        try {
            Process p = new ProcessBuilder(commandToExecute).start();
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = in.readLine()) != null) {
                output = output + line;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        return output;
    }

    public static String checkBCPQuery(String serverName, boolean isWinAuthType, String userName, String pwd) {
        String queryOut = ChangeDBServer.executeBCPQuery(serverName, isWinAuthType, userName, pwd, "select * from INFORMATION_SCHEMA.Tables");
        return queryOut.indexOf("Named Pipes") != -1 ? "Please enable the option Using both TCP/IP and named pipes in Remote Connections.\n For more information click on OK" : "BCP OK";
    }

    public static String getLicenseType() {
        String licenseType = new String();
        try {
            String separator = File.separator;
            String license_path = System.getProperty("SERVER_HOME") + separator + "lib" + separator + "AdventNetLicense.xml";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(license_path));
            licenseType = ((Element)doc.getElementsByTagName("UserInfo").item(0)).getAttribute("LicenseType");
            if (licenseType.equals("Registered")) {
                licenseType = licenseType + "-" + ((Element)doc.getElementsByTagName("Product").item(0)).getAttribute("Type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseType;
    }

    private static String constructConnectionURL(String serverType, String host, String port, String dbName, boolean isWinAuthType, String domain) {
        String connectionUrl = null;
        if ("mysql".equals(serverType)) {
            connectionUrl = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?useUnicode=true&characterEncoding=UTF-8";
        } else if ("mssql".equals(serverType)) {
            connectionUrl = "jdbc:jtds:sqlserver://" + host;
            if (port != null && !port.equalsIgnoreCase("")) {
                connectionUrl = connectionUrl + ":" + port;
            }
            connectionUrl = isWinAuthType && domain != null ? connectionUrl + ";DatabaseName=" + dbName + ";Domain=" + domain + ";useNTLMv2=true" : connectionUrl + "/" + dbName;
        } else if ("postgres".equals(serverType)) {
            connectionUrl = "jdbc:postgresql://" + host + ":" + port + "/" + dbName;
        }
        return connectionUrl;
    }

    public static Properties getUpdatedDBParams(Hashtable destDBProps) throws Exception {
        Properties updatedDBConfig = new Properties();
        String connectionUrl = null;
        String driverName = null;
        String userName = (String)destDBProps.get("USERNAME");
        String passWord = (String)destDBProps.get("PASSWORD");
        String dbAdapter = null;
        String sqlGenerator = null;
        String host = (String)destDBProps.get("HOST");
        String port = (String)destDBProps.get("PORT");
        String destDB = (String)destDBProps.get("DESTINATION_DB");
        String dbName = (String)destDBProps.get("DB_NAME");
        Boolean isWinAuthType = (Boolean)destDBProps.get("IS_WIN_AUTH");
        if ("mysql".equals(destDB)) {
            updatedDBConfig.setProperty("username", userName);
            connectionUrl = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?useUnicode=true&characterEncoding=UTF-8";
            driverName = "org.gjt.mm.mysql.Driver";
            dbAdapter = "com.adventnet.db.adapter.mysql.MysqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mysql.MysqlSQLGenerator";
            if (passWord != null && !"".equals(passWord)) {
                updatedDBConfig.setProperty("password", passWord);
            }
        } else if ("mssql".equals(destDB)) {
            connectionUrl = "jdbc:jtds:sqlserver://" + host;
            if (port != null && !port.equalsIgnoreCase("")) {
                connectionUrl = connectionUrl + ":" + port;
            }
            connectionUrl = connectionUrl + "/" + dbName;
            if (!isWinAuthType.booleanValue()) {
                updatedDBConfig.setProperty("username", userName);
                if (passWord != null && !"".equals(passWord)) {
                    EnDecryptImpl enDecrypt = new EnDecryptImpl();
                    updatedDBConfig.setProperty("password", enDecrypt.encrypt(passWord));
                }
            }
            driverName = "net.sourceforge.jtds.jdbc.Driver";
            dbAdapter = "com.adventnet.db.adapter.mssql.MssqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mssql.MssqlSQLGenerator";
            updatedDBConfig.setProperty("exceptionsorterclassname", "com.adventnet.db.adapter.mssql.MssqlExceptionSorter");
        } else if ("postgres".equals(destDB)) {
            updatedDBConfig.setProperty("username", userName);
            connectionUrl = "jdbc:postgresql://" + host + ":" + port + "/" + dbName + "?useUnicode=true&characterEncoding=UTF-8";
            driverName = "org.postgresql.Driver";
            dbAdapter = "com.adventnet.db.adapter.postgres.PostgresDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.postgres.PostgresSQLGenerator";
            if (passWord != null && !"".equals(passWord)) {
                updatedDBConfig.setProperty("password", passWord);
            }
            updatedDBConfig.setProperty("exceptionsorterclassname", "com.adventnet.db.adapter.postgres.PostgresExceptionSorter");
        }
        updatedDBConfig.setProperty("minsize", "1");
        updatedDBConfig.setProperty("maxsize", "20");
        updatedDBConfig.setProperty("transaction_isolation", "TRANSACTION_READ_COMMITTED");
        updatedDBConfig.setProperty("url", connectionUrl);
        updatedDBConfig.setProperty("drivername", driverName);
        updatedDBConfig.setProperty("dbadapter", dbAdapter);
        updatedDBConfig.setProperty("sqlgenerator", sqlGenerator);
        return updatedDBConfig;
    }
}

