/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql;

import com.adventnet.db.migration.util.DBMigrationUtil;
import com.adventnet.sym.adsm.common.server.i18n.SystemResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.SystemResourceBundleHandler;
import com.adventnet.sym.adsm.common.server.mysql.ChangeDBServer;
import com.manageengine.ads.fw.ha.HAHandler;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ChangeDBServerGUI
extends JFrame {
    private PrintWriter log = null;
    private String alertTitle = "ADSelfService Plus - Change DataBase";
    SystemResourceBundle rb = null;
    private static boolean migrateData = false;
    private JComboBox serverType;
    private JComboBox sqlinstance;
    private JLabel sqlinstancelabel;
    private JLabel serverTypeLabel;
    private JLabel addressLabel;
    private JLabel authtypelabel;
    private JLabel dblabel;
    private JLabel domainlabel;
    private JLabel portlabel;
    private JLabel userLabel;
    private JLabel pwdlabel;
    private JPasswordField password;
    private JTextField serverAddress;
    private JTextField database;
    private JRadioButton winauthtype;
    private JRadioButton sqlauthtype;
    private JTextField domainName;
    private JTextField userName;
    private JTextField port;
    private JButton cancelButton;
    private JButton testButton;
    private JButton saveButton;
    private JPanel jPanel1 = new JPanel();

    public ChangeDBServerGUI() throws Exception {
        this.log = new PrintWriter(new FileOutputStream("changedbserver.log"), true);
        this.rb = new SystemResourceBundleHandler().getBundle();
        this.initComponents();
    }

    private void initComponents() {
        this.serverTypeLabel = new JLabel();
        this.serverType = new JComboBox();
        this.sqlinstance = new JComboBox();
        this.sqlinstancelabel = new JLabel();
        this.addressLabel = new JLabel();
        this.serverAddress = new JTextField();
        this.port = new JTextField();
        this.authtypelabel = new JLabel();
        this.dblabel = new JLabel();
        this.domainlabel = new JLabel();
        this.portlabel = new JLabel();
        this.winauthtype = new JRadioButton();
        this.sqlauthtype = new JRadioButton();
        this.database = new JTextField();
        this.domainName = new JTextField();
        this.userLabel = new JLabel();
        this.userName = new JTextField();
        this.pwdlabel = new JLabel();
        this.password = new JPasswordField();
        this.cancelButton = new JButton();
        this.testButton = new JButton();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.rb.getString("adssp.system.dbconfig.db_setup_wizard")));
        this.serverTypeLabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_server_type"));
        this.add(this.serverTypeLabel);
        this.serverTypeLabel.setBounds(40, 70, 100, 20);
        String[] serverTypeArr = new String[]{"Mysql Server", "MSSQL Server", "Pgsql Server"};
        this.serverType.setModel(new DefaultComboBoxModel<String>(serverTypeArr));
        this.add(this.serverType);
        this.serverType.setBounds(180, 70, 180, 24);
        this.serverType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String stype = ChangeDBServerGUI.this.serverType.getSelectedItem().toString();
                try {
                    ChangeDBServerGUI.this.serverAddress.setText("");
                    ChangeDBServerGUI.this.port.setText("");
                    ChangeDBServerGUI.this.database.setText("");
                    ChangeDBServerGUI.this.userName.setText("");
                    ChangeDBServerGUI.this.password.setText("");
                    if ("MSSQL Server".equals(stype)) {
                        String alertMsg = ChangeDBServer.checkBCPFiles();
                        ChangeDBServerGUI.this.log.println("alertMsg : after checkBCPFiles..: " + alertMsg);
                        if (!"BCP OK".equals(alertMsg)) {
                            if (alertMsg.equals("adssp.system.dbconfig.copy_paste_bcp_files")) {
                                JOptionPane.showMessageDialog(null, ChangeDBServerGUI.this.rb.getString(alertMsg), ChangeDBServerGUI.this.alertTitle, 2);
                            } else {
                                JOptionPane.showMessageDialog(null, ChangeDBServerGUI.this.rb.getString("adssp.system.dbconfig.msg_sqlserver_2005_download_sqlnative_client"), ChangeDBServerGUI.this.alertTitle, 2);
                            }
                            if (alertMsg.indexOf("SQL Native Client") != -1) {
                                String serverHome = System.getProperty("SERVER_HOME") + File.separator + "help" + File.separator + "mssql" + File.separator + "config-mssql-database.html";
                                String getAbsPath = new File(serverHome).getAbsolutePath();
                                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", getAbsPath).start();
                            }
                            ChangeDBServerGUI.this.callMYSQLUI();
                        } else {
                            ChangeDBServerGUI.this.callMSSQLUI();
                        }
                    } else if ("Mysql Server".equals(stype)) {
                        ChangeDBServerGUI.this.callMYSQLUI();
                    } else if ("Pgsql Server".equals(stype)) {
                        ChangeDBServerGUI.this.callPGSQLUI();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        String stype = "mssql";
        try {
            stype = ChangeDBServer.getActiveDB();
            if ("mysql".equals(stype)) {
                stype = "Mysql Server";
                this.sqlinstance.setVisible(false);
                this.sqlinstancelabel.setVisible(false);
            } else if ("mssql".equals(stype)) {
                stype = "MSSQL Server";
                this.sqlinstance.setVisible(true);
                this.sqlinstancelabel.setVisible(true);
            } else if ("postgres".equals(stype)) {
                stype = "Pgsql Server";
                this.sqlinstance.setVisible(false);
                this.sqlinstancelabel.setVisible(false);
            }
            this.serverType.setSelectedItem(stype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addressLabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_host_name"));
        this.add(this.addressLabel);
        this.addressLabel.setBounds(40, 120, 110, 15);
        this.serverAddress.setText("localhost");
        this.add(this.serverAddress);
        this.serverAddress.setBounds(180, 120, 180, 19);
        this.serverAddress.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String stype = ChangeDBServerGUI.this.serverType.getSelectedItem().toString();
                if ("MSSQL Server".equals(stype)) {
                    ChangeDBServerGUI.this.sqlinstance.setModel(new DefaultComboBoxModel<Object>(ChangeDBServerGUI.this.getNamedInstance(ChangeDBServerGUI.this.serverAddress.getText())));
                    if (ChangeDBServerGUI.this.sqlinstance.getSelectedItem() != null) {
                        String instance_details = ChangeDBServerGUI.this.sqlinstance.getSelectedItem().toString();
                        String[] values = instance_details.split(";");
                        ChangeDBServerGUI.this.serverAddress.setText(ChangeDBServerGUI.this.serverAddress.getText());
                        ChangeDBServerGUI.this.port.setText(values[2]);
                    }
                }
            }
        });
        this.add(this.portlabel);
        this.portlabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_port_number"));
        this.portlabel.setBounds(40, 150, 110, 15);
        this.add(this.port);
        this.port.setBounds(180, 150, 180, 19);
        this.port.setText("33308");
        this.port.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String stype = ChangeDBServerGUI.this.serverType.getSelectedItem().toString();
                if ("MSSQL Server".equals(stype)) {
                    ChangeDBServerGUI.this.sqlinstance.setModel(new DefaultComboBoxModel<Object>(ChangeDBServerGUI.this.getNamedInstance(ChangeDBServerGUI.this.serverAddress.getText())));
                    if (ChangeDBServerGUI.this.sqlinstance.getSelectedItem() != null) {
                        String instance_details = ChangeDBServerGUI.this.sqlinstance.getSelectedItem().toString();
                        String[] values = instance_details.split(";");
                        ChangeDBServerGUI.this.serverAddress.setText(ChangeDBServerGUI.this.serverAddress.getText());
                        ChangeDBServerGUI.this.port.setText(values[2]);
                    }
                }
            }
        });
        this.add(this.sqlinstancelabel);
        this.sqlinstancelabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_available_mssql_server_instances"));
        this.sqlinstancelabel.setBounds(40, 180, 420, 24);
        this.add(this.sqlinstance);
        this.sqlinstance.setBounds(40, 210, 320, 24);
        this.sqlinstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String instance_details = ChangeDBServerGUI.this.sqlinstance.getSelectedItem().toString();
                String[] values = instance_details.split(";");
                ChangeDBServerGUI.this.serverAddress.setText(values[0]);
                ChangeDBServerGUI.this.port.setText(values[2]);
            }
        });
        int inc = 0;
        if ("MSSQL Server".equals(stype)) {
            inc = 60;
        }
        this.dblabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_database_name"));
        this.add(this.dblabel);
        this.dblabel.setBounds(40, 180 + inc, 110, 15);
        this.database.setEditable(true);
        this.database.setText("");
        this.add(this.database);
        this.database.setBounds(180, 180 + inc, 180, 19);
        this.authtypelabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_connect_using"));
        this.add(this.authtypelabel);
        this.authtypelabel.setBounds(40, 210 + inc, 110, 15);
        this.winauthtype.setText(this.rb.getString("adssp.system.dbconfig.lbl_winnt_authentication"));
        this.add(this.winauthtype);
        this.winauthtype.setBounds(30, 240 + inc, 180, 25);
        this.sqlauthtype.setText(this.rb.getString("adssp.system.dbconfig.lbl_mssql_authentication"));
        this.add(this.sqlauthtype);
        this.sqlauthtype.setBounds(200, 240 + inc, 200, 25);
        this.domainlabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_domain_name"));
        this.domainlabel.setBounds(40, 270 + inc, 110, 15);
        this.add(this.domainlabel);
        this.domainName.setText("");
        this.domainName.setBounds(180, 270 + inc, 180, 19);
        this.add(this.domainName);
        if ("MSSQL Server".equals(stype)) {
            inc = 150;
        }
        this.winauthtype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeDBServerGUI.this.sqlauthtype.setSelected(false);
                ChangeDBServerGUI.this.domainlabel.setVisible(true);
                ChangeDBServerGUI.this.domainName.setVisible(true);
            }
        });
        this.sqlauthtype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeDBServerGUI.this.winauthtype.setSelected(false);
                ChangeDBServerGUI.this.domainlabel.setVisible(false);
                ChangeDBServerGUI.this.domainName.setVisible(false);
            }
        });
        this.userLabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_user_name"));
        this.add(this.userLabel);
        this.userLabel.setBounds(40, 210 + inc, 110, 15);
        this.add(this.userName);
        this.userName.setText("");
        this.userName.setBounds(180, 210 + inc, 180, 19);
        this.pwdlabel.setText(this.rb.getString("adssp.system.dbconfig.lbl_password"));
        this.add(this.pwdlabel);
        this.pwdlabel.setBounds(40, 240 + inc, 110, 15);
        this.add(this.password);
        this.password.setText("");
        this.password.setBounds(180, 240 + inc, 180, 19);
        this.cancelButton.setText(this.rb.getString("adssp.system.dbconfig.btn_cancel"));
        this.add(this.cancelButton);
        this.cancelButton.setBounds(190, 270 + inc, 80, 25);
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                System.exit(0);
            }
        });
        this.testButton.setText(this.rb.getString("adssp.system.dbconfig.btn_test_connection"));
        this.add(this.testButton);
        this.testButton.setBounds(280, 270 + inc, 80, 25);
        this.testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChangeDBServerGUI.this.doCheckDBOperation();
            }
        });
        this.saveButton.setText(this.rb.getString("adssp.system.dbconfig.btn_save"));
        this.add(this.saveButton);
        this.saveButton.setBounds(100, 270 + inc, 80, 25);
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChangeDBServerGUI.this.doSaveDBOperation();
            }
        });
        this.jPanel1.setBounds(0, 0, 360, 300);
        this.add(this.jPanel1);
        this.setTitle(this.rb.getString("adssp.system.dbconfig.window_title"));
        String meImg = System.getProperty("SERVER_HOME") + File.separator + "images" + File.separator + "adsspFavicon.jpg";
        Image im = Toolkit.getDefaultToolkit().getImage(meImg);
        this.setIconImage(im);
        try {
            if (stype.equals("MSSQL Server")) {
                this.callMSSQLUI();
            } else if (stype.equals("Mysql Server")) {
                this.callMYSQLUI();
            } else if (stype.equals("Pgsql Server")) {
                this.callPGSQLUI();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveDBOperation() {
        block35: {
            boolean validation = true;
            String stype = this.serverType.getSelectedItem().toString();
            String sname = this.serverAddress.getText();
            String sport = this.port.getText();
            String db = this.database.getText();
            String domain = this.domainName.getText();
            String uname = this.userName.getText();
            String pwd = this.password.getText();
            String serverType = "MSSQL Server".equals(stype) ? "mssql" : ("Pgsql Server".equals(stype) ? "postgres" : "mysql");
            boolean isWinAuthType = this.isWindowsAuthentication(stype);
            String err = null;
            if (sname.trim().equals("")) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_server_address");
                validation = false;
            } else if (sport.trim().equals("")) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_server_port");
                validation = false;
            } else if (db.trim().equals("")) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_database");
                validation = false;
            } else if (domain.trim().equals("") && isWinAuthType) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_domain_name");
                validation = false;
            } else if (uname.trim().equals("")) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_user_name");
                validation = false;
            } else {
                try {
                    Integer.parseInt(sport);
                }
                catch (Exception e) {
                    err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_server_port");
                    validation = false;
                }
            }
            if (validation && !db.trim().equals("") && !this.isValidDBName(db)) {
                err = this.rb.getString("adssp.system.dbconfig.invalid_db_name");
                validation = false;
            }
            ChangeDBServer cdb = new ChangeDBServer();
            if (ChangeDBServer.isSameDBConfiguration(serverType, sname, sport, db, uname, pwd, isWinAuthType, domain)) {
                err = this.rb.getString("adssp.system.dbconfig.same_db_config");
                validation = false;
            }
            if (!validation) {
                JOptionPane.showMessageDialog(null, err, this.alertTitle, 0);
            } else {
                try {
                    String running = ChangeDBServer.isDBServerRunning(serverType, sname, sport, isWinAuthType, domain, uname, pwd);
                    if ("yes".equals(running)) {
                        Hashtable<String, Object> destDBProps = new Hashtable<String, Object>();
                        destDBProps.put("HOST", sname);
                        destDBProps.put("PORT", sport);
                        destDBProps.put("DB_NAME", db);
                        destDBProps.put("IS_WIN_AUTH", isWinAuthType);
                        destDBProps.put("USERNAME", uname);
                        destDBProps.put("DOMAIN_NAME", domain);
                        if (pwd == null) {
                            pwd = "";
                        }
                        destDBProps.put("PASSWORD", pwd);
                        if ("MSSQL Server".equals(stype)) {
                            destDBProps.put("DESTINATION_DB", "mssql");
                            String licenseType = ChangeDBServer.getLicenseType();
                            this.alertTitle = ChangeDBServer.createDB("mssql", sname, sport, db, isWinAuthType, domain, uname, pwd);
                            if (migrateData) {
                                Properties destDBParams = ChangeDBServer.getUpdatedDBParams(destDBProps);
                                try {
                                    DBMigrationUtil.migrateTables((String)"mssql", (Properties)destDBParams);
                                }
                                catch (PatternSyntaxException pse) {
                                    pse.printStackTrace();
                                    JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.invalid_db_name"), this.alertTitle, 2);
                                    System.exit(0);
                                }
                            }
                            cdb.updateDBConfigFile("mssql", sname, sport, db, isWinAuthType, domain, uname, pwd, null);
                            JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.msg_mssql_server_config_success"), this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
                            System.exit(0);
                            break block35;
                        }
                        if ("Mysql Server".equals(stype)) {
                            this.alertTitle = ChangeDBServer.createDB("mysql", sname, sport, db, false, "", uname, pwd);
                            if (migrateData) {
                                JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.db_mig_mysql_not_support"), this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
                                System.exit(0);
                            }
                            cdb.updateDBConfigFile("mysql", sname, sport, db, false, "", uname, pwd, null);
                            JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.msg_mysql_server_config_success"), this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
                            System.exit(0);
                        } else if ("Pgsql Server".equals(stype)) {
                            db = db.toLowerCase();
                            destDBProps.put("DB_NAME", db);
                            this.alertTitle = ChangeDBServer.createDB("postgres", sname, sport, db, false, "", uname, pwd);
                            if (migrateData) {
                                destDBProps.put("DESTINATION_DB", "postgres");
                                Properties destDBParams = ChangeDBServer.getUpdatedDBParams(destDBProps);
                                DBMigrationUtil.migrateTables((String)"postgres", (Properties)destDBParams);
                            }
                            cdb.updateDBConfigFile("postgres", sname, sport, db, false, "", uname, pwd, null);
                            JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.msg_pgsql_server_config_success"), this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
                            System.exit(0);
                        }
                        break block35;
                    }
                    JOptionPane.showMessageDialog(null, running, this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.log.println(ex.getMessage());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.log.println(t.getMessage());
                }
                finally {
                    if (this.log != null) {
                        this.log.close();
                    }
                }
            }
        }
    }

    private void doCheckDBOperation() {
        String stype = this.serverType.getSelectedItem().toString();
        String sname = this.serverAddress.getText();
        String sport = this.port.getText();
        String db = this.database.getText();
        String domain = this.domainName.getText();
        String uname = this.userName.getText();
        String pwd = this.password.getText();
        String serverType = "MSSQL Server".equals(stype) ? "mssql" : ("Pgsql Server".equals(stype) ? "postgres" : "mysql");
        boolean isWinAuthType = this.isWindowsAuthentication(stype);
        boolean validation = true;
        String err = null;
        if (sname.trim().equals("")) {
            err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_server_address");
            validation = false;
        } else if (sport.trim().equals("")) {
            err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_server_port");
            validation = false;
        } else if (db.trim().equals("")) {
            err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_database");
            validation = false;
        } else if (domain.trim().equals("") && isWinAuthType) {
            err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_domain_name");
            validation = false;
        } else if (uname.trim().equals("")) {
            err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_user_name");
            validation = false;
        } else {
            try {
                Integer.parseInt(sport);
            }
            catch (Exception e) {
                err = this.rb.getString("adssp.system.dbconfig.msg_please_enter_valid_server_port");
                validation = false;
            }
        }
        if (validation && !db.trim().equals("") && !this.isValidDBName(db)) {
            err = this.rb.getString("adssp.system.dbconfig.invalid_db_name");
            validation = false;
        }
        if (!validation) {
            JOptionPane.showMessageDialog(null, err, this.alertTitle, 0);
        } else {
            String running = "no";
            try {
                running = ChangeDBServer.isDBServerRunning(serverType, sname, sport, isWinAuthType, domain, uname, pwd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("yes".equals(running)) {
                if ("MSSQL Server".equals(stype)) {
                    this.sqlServerValidation(sname, uname, pwd, isWinAuthType);
                }
                JOptionPane.showMessageDialog(null, this.rb.getString("adssp.system.dbconfig.msg_conn_establish_success"), this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
            } else {
                JOptionPane.showMessageDialog(null, running, this.rb.getString("adssp.system.dbconfig.msg_alert"), -1);
            }
        }
    }

    private boolean isValidDBName(String dbName) {
        return dbName.length() > 0 && dbName.matches("[a-zA-Z0-9_]+");
    }

    private void sqlServerValidation(String sname, String uname, String pwd, boolean isWinAuthType) {
        String bcpMsg = ChangeDBServer.checkBCPQuery(sname, isWinAuthType, uname, pwd);
        if (!"BCP OK".equals(bcpMsg)) {
            JOptionPane.showMessageDialog(null, bcpMsg, this.alertTitle, 2);
            try {
                String serverHome = System.getProperty("SERVER_HOME") + File.separator + "help" + File.separator + "mssql" + File.separator + "mssql-remote-connections-config.html";
                String getAbsPath = new File(serverHome).getAbsolutePath();
                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", getAbsPath).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object[] getNamedInstance(String hostName) {
        byte[] bytBuffer = new byte[1024];
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.setSoTimeout(6000);
            InetAddress iadd = InetAddress.getByName(hostName);
            ds.connect(iadd, 1434);
            byte[] msg = new byte[]{2};
            DatagramPacket dp = new DatagramPacket(msg, msg.length);
            ds.send(dp);
            DatagramPacket dpr = new DatagramPacket(bytBuffer, bytBuffer.length);
            ds.receive(dpr);
        }
        catch (PortUnreachableException ure) {
            String msg = "Unable to fetch the SQL server instances\n\nRoot Causes:\n";
            msg = msg + "1) SQL server is not installed in " + hostName + "\n";
            msg = msg + "2) There is a firewall blocking port 1434 on the server\n";
            msg = msg + "3) If you are using MSSQL Server 2005/2012, Please start the 'SQL Server Browser' from the Services\n";
            JOptionPane.showMessageDialog(null, msg, this.alertTitle, -1);
        }
        catch (UnknownHostException uhe) {
            JOptionPane.showMessageDialog(null, "Unknown host : " + hostName, this.alertTitle, -1);
        }
        catch (SocketTimeoutException ste) {
            JOptionPane.showMessageDialog(null, "Socket Time out while fetching the database instances from host : " + hostName, this.alertTitle, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String instances = new String(bytBuffer);
        String[] instance = instances.split(";;");
        int len = instance.length;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < len; ++i) {
            if (instance[i].trim().equals("")) continue;
            String[] temp = instance[i].split(";");
            int l = temp.length;
            String val = "";
            for (int j = 0; j < l; j += 2) {
                if (temp[j].indexOf("ServerName") >= 0) {
                    val = val + temp[j + 1].trim();
                    continue;
                }
                if (temp[j].indexOf("InstanceName") >= 0) {
                    val = val + ";" + temp[j + 1].trim();
                    continue;
                }
                if (temp[j].indexOf("tcp") < 0) continue;
                val = val + ";" + temp[j + 1].trim();
            }
            v.add(val);
        }
        return v.toArray();
    }

    private boolean isWindowsAuthentication(String stype) {
        Object[] authType;
        boolean isWinAuthType = false;
        if ("MSSQL Server".equals(stype) && (authType = this.winauthtype.getSelectedObjects()) != null) {
            isWinAuthType = true;
        }
        return isWinAuthType;
    }

    public static void main(String[] args) throws Exception {
        HAHandler.setProductHome((String)System.getProperty("server.home"));
        if (HAHandler.isHAEnabled()) {
            JOptionPane.showMessageDialog(null, "High availability setup must be disabled before you can change the database.", "ADSelfService Plus - Change DataBase", 0);
            System.exit(0);
        }
        ChangeDBServerGUI obj = new ChangeDBServerGUI();
        obj.setLocation(300, 200);
        obj.setSize(420, 500);
        obj.setVisible(true);
        if (args.length > 0 && "true".equalsIgnoreCase(args[0])) {
            migrateData = true;
        }
    }

    public void callMYSQLUI() throws Exception {
        HashMap<String, String> hash = null;
        this.sqlinstance.setVisible(false);
        this.sqlinstancelabel.setVisible(false);
        this.authtypelabel.setVisible(false);
        this.winauthtype.setVisible(false);
        this.sqlauthtype.setVisible(false);
        this.domainlabel.setVisible(false);
        this.domainName.setVisible(false);
        this.database.setLocation((int)this.database.getLocation().getX(), (int)this.database.getLocation().getY() - 60);
        this.dblabel.setLocation((int)this.dblabel.getLocation().getX(), (int)this.dblabel.getLocation().getY() - 60);
        this.userLabel.setLocation((int)this.userLabel.getLocation().getX(), (int)this.userLabel.getLocation().getY() - 60);
        this.userName.setLocation((int)this.userName.getLocation().getX(), (int)this.userName.getLocation().getY() - 60);
        this.pwdlabel.setLocation((int)this.pwdlabel.getLocation().getX(), (int)this.pwdlabel.getLocation().getY() - 60);
        this.password.setLocation((int)this.password.getLocation().getX(), (int)this.password.getLocation().getY() - 60);
        this.saveButton.setLocation((int)this.saveButton.getLocation().getX(), (int)this.saveButton.getLocation().getY() - 60);
        this.cancelButton.setLocation((int)this.cancelButton.getLocation().getX(), (int)this.cancelButton.getLocation().getY() - 60);
        this.testButton.setLocation((int)this.testButton.getLocation().getX(), (int)this.testButton.getLocation().getY() - 60);
        this.serverType.setSelectedItem("Mysql Server");
        this.dblabel.setBounds(40, 180, 110, 15);
        this.database.setBounds(180, 180, 180, 19);
        this.userLabel.setBounds(40, 210, 110, 15);
        this.userName.setBounds(180, 210, 180, 19);
        this.pwdlabel.setBounds(40, 240, 110, 15);
        this.password.setBounds(180, 240, 180, 19);
        this.cancelButton.setBounds(190, 270, 80, 25);
        this.testButton.setBounds(280, 270, 80, 25);
        this.saveButton.setBounds(100, 270, 80, 25);
        hash = ChangeDBServer.getDBDetails("mysql");
        this.serverAddress.setText(hash.get("HOST"));
        String portNo = hash.get("PORT");
        if (portNo != null) {
            this.port.setText(portNo);
        } else {
            this.port.setText("33308");
        }
        this.database.setText(hash.get("DATABASE"));
        this.userName.setText(hash.get("USERNAME"));
        this.password.setText("");
        String stype = ChangeDBServer.getActiveDB();
        if (stype.equals("mssql") || stype.equals("postgres")) {
            this.database.setText("");
            this.userName.setText("");
            this.password.setText("");
        }
    }

    public void callPGSQLUI() throws Exception {
        HashMap<String, String> hash = null;
        this.sqlinstance.setVisible(false);
        this.sqlinstancelabel.setVisible(false);
        this.authtypelabel.setVisible(false);
        this.winauthtype.setVisible(false);
        this.sqlauthtype.setVisible(false);
        this.domainlabel.setVisible(false);
        this.domainName.setVisible(false);
        this.database.setLocation((int)this.database.getLocation().getX(), (int)this.database.getLocation().getY() - 60);
        this.dblabel.setLocation((int)this.dblabel.getLocation().getX(), (int)this.dblabel.getLocation().getY() - 60);
        this.userLabel.setLocation((int)this.userLabel.getLocation().getX(), (int)this.userLabel.getLocation().getY() - 60);
        this.userName.setLocation((int)this.userName.getLocation().getX(), (int)this.userName.getLocation().getY() - 60);
        this.pwdlabel.setLocation((int)this.pwdlabel.getLocation().getX(), (int)this.pwdlabel.getLocation().getY() - 60);
        this.password.setLocation((int)this.password.getLocation().getX(), (int)this.password.getLocation().getY() - 60);
        this.saveButton.setLocation((int)this.saveButton.getLocation().getX(), (int)this.saveButton.getLocation().getY() - 60);
        this.cancelButton.setLocation((int)this.cancelButton.getLocation().getX(), (int)this.cancelButton.getLocation().getY() - 60);
        this.testButton.setLocation((int)this.testButton.getLocation().getX(), (int)this.testButton.getLocation().getY() - 60);
        this.serverType.setSelectedItem("Pgsql Server");
        this.dblabel.setBounds(40, 180, 110, 15);
        this.database.setBounds(180, 180, 180, 19);
        this.userLabel.setBounds(40, 210, 110, 15);
        this.userName.setBounds(180, 210, 180, 19);
        this.pwdlabel.setBounds(40, 240, 110, 15);
        this.password.setBounds(180, 240, 180, 19);
        this.cancelButton.setBounds(190, 270, 80, 25);
        this.testButton.setBounds(280, 270, 80, 25);
        this.saveButton.setBounds(100, 270, 80, 25);
        hash = ChangeDBServer.getDBDetails("postgres");
        this.serverAddress.setText(hash.get("HOST"));
        String portNo = hash.get("PORT");
        if (portNo != null) {
            this.port.setText(portNo);
        } else {
            this.port.setText("33308");
        }
        this.database.setText(hash.get("DATABASE"));
        this.userName.setText(hash.get("USERNAME"));
        this.password.setText("");
        String stype = ChangeDBServer.getActiveDB();
        if (stype.equals("mssql") || stype.equals("mysql")) {
            this.database.setText("");
            this.userName.setText("");
            this.password.setText("");
        }
    }

    public void callMSSQLUI() throws Exception {
        HashMap<String, String> hash = null;
        this.sqlinstance.setVisible(true);
        this.sqlinstancelabel.setVisible(true);
        this.authtypelabel.setVisible(true);
        this.winauthtype.setVisible(true);
        this.sqlauthtype.setVisible(true);
        this.authtypelabel.setLocation((int)this.authtypelabel.getLocation().getX(), (int)this.authtypelabel.getLocation().getY() + 60);
        this.winauthtype.setLocation((int)this.winauthtype.getLocation().getX(), (int)this.winauthtype.getLocation().getY() + 60);
        this.sqlauthtype.setLocation((int)this.sqlauthtype.getLocation().getX(), (int)this.sqlauthtype.getLocation().getY() + 60);
        this.dblabel.setLocation((int)this.dblabel.getLocation().getX(), (int)this.dblabel.getLocation().getY() + 60);
        this.database.setLocation((int)this.database.getLocation().getX(), (int)this.database.getLocation().getY() + 60);
        this.domainlabel.setLocation((int)this.domainlabel.getLocation().getX(), (int)this.domainlabel.getLocation().getY() + 60);
        this.domainName.setLocation((int)this.domainName.getLocation().getX(), (int)this.domainName.getLocation().getY() + 60);
        this.userLabel.setLocation((int)this.userLabel.getLocation().getX(), (int)this.userLabel.getLocation().getY() + 60);
        this.userName.setLocation((int)this.userName.getLocation().getX(), (int)this.userName.getLocation().getY() + 60);
        this.pwdlabel.setLocation((int)this.pwdlabel.getLocation().getX(), (int)this.pwdlabel.getLocation().getY() + 60);
        this.password.setLocation((int)this.password.getLocation().getX(), (int)this.password.getLocation().getY() + 60);
        this.saveButton.setLocation((int)this.saveButton.getLocation().getX(), (int)this.saveButton.getLocation().getY() + 60);
        this.cancelButton.setLocation((int)this.cancelButton.getLocation().getX(), (int)this.cancelButton.getLocation().getY() + 60);
        this.testButton.setLocation((int)this.testButton.getLocation().getX(), (int)this.testButton.getLocation().getY() + 60);
        this.dblabel.setBounds(40, 240, 110, 15);
        this.database.setBounds(180, 240, 180, 19);
        this.authtypelabel.setBounds(40, 270, 110, 15);
        this.winauthtype.setBounds(35, 300, 170, 15);
        this.sqlauthtype.setBounds(200, 300, 190, 15);
        this.domainlabel.setBounds(40, 330, 110, 15);
        this.domainName.setBounds(180, 330, 180, 19);
        this.userLabel.setBounds(40, 360, 110, 15);
        this.userName.setBounds(180, 360, 180, 19);
        this.pwdlabel.setBounds(40, 390, 110, 15);
        this.password.setBounds(180, 390, 180, 19);
        this.cancelButton.setBounds(190, 420, 80, 25);
        this.testButton.setBounds(280, 420, 80, 25);
        this.saveButton.setBounds(100, 420, 80, 25);
        hash = ChangeDBServer.getDBDetails("mssql");
        if (!ChangeDBServer.isWinAuthType()) {
            this.sqlauthtype.setSelected(true);
            this.domainlabel.setVisible(false);
            this.domainName.setVisible(false);
        } else {
            this.winauthtype.setSelected(true);
            this.domainlabel.setVisible(true);
            this.domainName.setVisible(true);
            this.domainName.setText(hash.get("DOMAINNAME"));
        }
        this.serverAddress.setText(hash.get("HOST"));
        this.port.setText(hash.get("PORT"));
        this.database.setText(hash.get("DATABASE"));
        this.userName.setText("");
        this.password.setText("");
    }
}

