/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.ds.DataSourceManager;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.mysql.DBManagerObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.DataSource;
import org.json.JSONObject;

public class DBManager {
    public static String servers = "{ MYSQL : { URL : \"jdbc:mysql://localhost:port/dbName\", ADAPTER : \"com.adventnet.db.adapter.mysql.MysqlDBAdapter\", GENERATOR : \"com.adventnet.db.adapter.mysql.MysqlSQLGenerator\", DRIVER :\"org.gjt.mm.mysql.Driver\"}, MSSQL : { URL : \"jdbc:jtds:sqlserver://localhost:port;DatabaseName=dbName\", ADAPTER : \"com.adventnet.db.adapter.mssql.MssqlDBAdapter\", GENERATOR : \"com.adventnet.db.adapter.mssql.MssqlSQLGenerator\", DRIVER : \"net.sourceforge.jtds.jdbc.Driver\"}, ORACLE : { URL : \"jdbc:oracle:thin:@localhost:port:dbName\", ADAPTER : \"com.manageengine.ads.fw.db.adapter.oracle.ADSOracleDBAdapter\", GENERATOR : \"com.manageengine.ads.fw.db.adapter.oracle.ADSOracleSQLGenerator\", DRIVER :\"oracle.jdbc.driver.OracleDriver\"}, PGSQL : { URL : \"jdbc:postgresql://localhost:port/dbName\", ADAPTER : \"com.adventnet.db.adapter.postgres.PostgresDBAdapter\", GENERATOR : \"com.adventnet.db.adapter.postgres.PostgresSQLGenerator\", DRIVER :\"org.postgresql.Driver\"}}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable addDataSource(Hashtable dbConProps) throws Exception {
        Long dsId;
        String dsName;
        Hashtable<String, Object> hash;
        block5: {
            hash = new Hashtable<String, Object>();
            dsName = (String)dbConProps.get("DSNAME");
            String id = DBManager.getDSProp(dsName, "DSNAME", "DSID");
            Long l = dsId = id != null ? new Long(id) : null;
            if (dsId != null) throw new Exception("adssp.configuration.admin_tools.ext_dat_source.dbsource_already_con_exist");
            boolean result = false;
            try {
                DataObject dsDo = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row dsRow = new Row("DataSource");
                Row adapRow = new Row("DBAdapter");
                Row conRow = new Row("DBConnector");
                DBManager.setRows(dbConProps, dsRow, adapRow, conRow);
                dsDo.addRow(adapRow);
                dsDo.addRow(dsRow);
                dsDo.addRow(conRow);
                DataObject dob = CommonUtil.getPersistence(new boolean[0]).add(dsDo);
                dsId = new Long(DBManager.getDSProp(dsName, "DSNAME", "DSID"));
                Properties props = PersistenceInitializer.getDBProps((DataObject)dob);
                result = DataSourceManager.addDataSource((Properties)props);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (result) break block5;
                DBManager.deleteDataSource(dsId.toString());
                throw new Exception("adssp.configuration.admin_tools.ext_dat_source.dbsource_con_refused");
            }
        }
        hash.put("DSID", dsId);
        hash.put("DSNAME", dsName);
        return hash;
    }

    public static Hashtable updateDataSource(Hashtable dbConProps) throws Exception {
        return DBManager.updateDataSource(dbConProps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable updateDataSource(Hashtable dbConProps, DataObject dsDo) throws Exception {
        Hashtable hash;
        block9: {
            hash = new Hashtable();
            Hashtable prevDbConnProps = new Hashtable();
            DataObject cloneObj = null;
            String dsName = (String)dbConProps.get("DSNAME");
            Long dsId = new Long((String)dbConProps.get("DSID"));
            boolean result = false;
            try {
                if (dsDo == null) {
                    SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"DataSource"));
                    sq.setCriteria(new Criteria(Column.getColumn((String)"DataSource", (String)"DSID"), (Object)dsId, 0));
                    sq.addJoin(new Join(Table.getTable((String)"DataSource"), Table.getTable((String)"DBAdapter"), new String[]{"DSID"}, new String[]{"DSID"}, 1));
                    sq.addJoin(new Join(Table.getTable((String)"DataSource"), Table.getTable((String)"DBConnector"), new String[]{"DSID"}, new String[]{"DSID"}, 1));
                    sq.addSelectColumn(Column.getColumn((String)"DataSource", (String)"*"));
                    sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"*"));
                    sq.addSelectColumn(Column.getColumn((String)"DBAdapter", (String)"*"));
                    dsDo = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                    if (dsDo != null && !dsDo.isEmpty()) {
                        cloneObj = (DataObject)dsDo.clone();
                    }
                }
                if (!dsDo.isEmpty()) {
                    Row dsRow = dsDo.getRow("DataSource");
                    Row adapRow = dsDo.getRow("DBAdapter");
                    Row conRow = dsDo.getRow("DBConnector");
                    DBManager.setRows(dbConProps, dsRow, adapRow, conRow);
                    dsDo.updateRow(dsRow);
                    dsDo.updateRow(adapRow);
                    dsDo.updateRow(conRow);
                    DataObject dob = CommonUtil.getPersistence(new boolean[0]).update(dsDo);
                    Properties props = PersistenceInitializer.getDBProps((DataObject)dob);
                    DataSourceManager.removeDataSource((String)dsName);
                    result = DataSourceManager.addDataSource((Properties)props);
                }
                dsId = new Long(DBManager.getDSProp(dsName, "DSNAME", "DSID"));
                hash.put("DSID", dsId);
                hash.put("DSNAME", dsName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (result) break block9;
                if (cloneObj != null) {
                    prevDbConnProps = DBManager.getCurrentDBProviderValues(cloneObj);
                    hash = DBManager.updateDataSource(prevDbConnProps, dsDo);
                }
                throw new Exception("adssp.configuration.admin_tools.ext_dat_source.dbsource_con_refused");
            }
        }
        return hash;
    }

    public static void setRows(Hashtable dbConProps, Row dsRow, Row adapRow, Row conRow) throws Exception {
        String dsName = (String)dbConProps.get("DSNAME");
        String hostName = (String)dbConProps.get("HOSTNAME");
        String dbName = (String)dbConProps.get("DBNAME");
        String port = (String)dbConProps.get("PORT");
        String dbServer = (String)dbConProps.get("DBSERVER");
        String userName = (String)dbConProps.get("USERNAME");
        String password = (String)dbConProps.get("PASSWORD");
        String domain = (String)dbConProps.get("DOMAINNAME");
        JSONObject serverProps = new JSONObject(new JSONObject(servers).getString(dbServer));
        String url = serverProps.getString("URL");
        String adapter = serverProps.getString("ADAPTER");
        String generator = serverProps.getString("GENERATOR");
        String driver = serverProps.getString("DRIVER");
        url = DBManager.getURL(url, dbName, dbConProps);
        dsRow.set(2, (Object)dsName);
        dsRow.set("ADAPTERCLASS", (Object)adapter);
        adapRow.set(1, dsRow.get("DSID"));
        adapRow.set(2, (Object)generator);
        adapRow.set(3, (Object)driver);
        adapRow.set(4, (Object)url);
        adapRow.set(5, (Object)userName);
        adapRow.set(6, (Object)password);
        conRow.set("DSID", dsRow.get("DSID"));
        conRow.set("HOSTNAME", (Object)hostName);
        conRow.set("PORT", (Object)port);
        conRow.set("DBSERVER", (Object)dbServer);
        conRow.set("DBNAME", (Object)dbName);
        conRow.set("DOMAINNAME", (Object)domain);
    }

    public static void deleteDataSource(String dsId) {
        try {
            DataSourceManager.removeDataSource((String)dsId);
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"DataSource", (String)"DSID"), (Object)dsId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DBManagerObject getConnectionObject(String dsName) {
        DataSource ds = DataSourceManager.getDataSource((String)dsName);
        DBAdapter dbadapter = (DBAdapter)DataSourceManager.getDSAdapter((String)dsName);
        return new DBManagerObject(dbadapter, ds);
    }

    private static String getURL(String url, String dbName, Hashtable dbConProps) {
        String hostName = (String)dbConProps.get("HOSTNAME");
        String port = (String)dbConProps.get("PORT");
        String dbServer = (String)dbConProps.get("DBSERVER");
        String domain = (String)dbConProps.get("DOMAINNAME");
        String auType = (String)dbConProps.get("AUTHEN_TYPE");
        if (auType.equals("SERVICE")) {
            url = "jdbc:oracle:thin:@//localhost:port/dbName";
        }
        url = url.replace("localhost", hostName).replace("port", port).replace("dbName", dbName);
        url = url + (dbServer.equals("MSSQL") && "WIN".equals(auType) && domain != null ? ";Domain=" + domain : "");
        return url;
    }

    public static String getDSProp(String val, String key, String retCN) {
        String ret = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"DataSource", (String)key), (Object)val, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("DataSource", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("DataSource");
                ret = r.get(retCN).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Hashtable getCurrentDBProviderValues(DataObject dObj) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            Row dsRow = dObj.getRow("DataSource");
            Row adapRow = dObj.getRow("DBAdapter");
            Row conRow = dObj.getRow("DBConnector");
            hash.put("DSNAME", dsRow.get("DSNAME"));
            hash.put("DSID", Long.toString((Long)dsRow.get("DSID")));
            hash.put("USERNAME", adapRow.get("USERNAME"));
            hash.put("PASSWORD", adapRow.get("PASSWORD"));
            hash.put("HOSTNAME", conRow.get("HOSTNAME"));
            hash.put("DBSERVER", conRow.get("DBSERVER"));
            hash.put("PORT", conRow.get("PORT"));
            hash.put("DBNAME", conRow.get("DBNAME"));
            hash.put("DOMAINNAME", conRow.get("DOMAINNAME"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }
}

