/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.notifications;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.configuration.EnrollmentNotifyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import com.manageengine.ads.fw.mobile.pushnotification.PNEnrollmentHandler;
import com.manageengine.ads.fw.mobile.pushnotification.SendPushNotification;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolicyNotifications {
    public static final Long RESET_PASSWORD_MAIL = 1L;
    public static final Long UNLOCK_ACCOUNT_MAIL = 2L;
    public static final Long CHANGE_PASSWORD_MAIL = 3L;
    public static final Long VERIFICATION_CODE_MAIL = 4L;
    public static final Long VERIFICATION_CODE_MOBILE = 5L;
    public static final Long RESET_PASSWORD_SMS = 6L;
    public static final Long UNLOCK_ACCOUNT_SMS = 7L;
    public static final Long CHANGE_PASSWORD_SMS = 8L;
    public static final Long ADMIN_NOTIFICATION_ID = 9L;
    public static final Long TICKET_GENERATION_ID = 21L;
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());

    public static String sendNotification(String domainName, String samAccountName, Long policyId, ArrayList nIds, Hashtable keyPairValue) {
        String returnStr = "failed";
        try {
            ArrayList forceNotificationIds = keyPairValue.containsKey("forceNotificationIds") ? (ArrayList)keyPairValue.get("forceNotificationIds") : null;
            Criteria c = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0);
            Criteria nC = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), nIds.get(0), 0);
            for (int i = 1; i < nIds.size(); ++i) {
                nC = nC.or(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), nIds.get(i), 0));
            }
            c = c.and(nC);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyNotifications", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyNotifications");
                while (it.hasNext()) {
                    String exemptedDeviceId;
                    Row row = (Row)it.next();
                    String nId = row.get("NOTIFICATION_ID").toString();
                    Long enabled = forceNotificationIds != null && forceNotificationIds.contains((Long)row.get("NOTIFICATION_ID")) ? 1L : (Long)row.get("ENABLED");
                    if (enabled != 1L) continue;
                    String action = (String)keyPairValue.get("action");
                    if (nId.equals(ADMIN_NOTIFICATION_ID.toString())) {
                        keyPairValue.put("emailAddress", (String)row.get("MAIL_ID"));
                    }
                    String subject = (String)row.get("SUBJECT");
                    String mailText = (String)row.get("MAIL_CONTENT");
                    String sendVia = (String)row.get("SEND_VIA");
                    Properties p = null;
                    if (nId.equalsIgnoreCase(TICKET_GENERATION_ID.toString())) {
                        JSONObject object = new JSONObject(mailText);
                        JSONObject info = object.getJSONObject("operation");
                        PolicyNotifications.parse(info, samAccountName, domainName, mailText, subject, keyPairValue);
                        p = APCUtil.getPCNotifyProps(samAccountName, domainName, mailText, subject, keyPairValue);
                        p.setProperty("mailText", object.toString());
                    } else {
                        p = APCUtil.getPCNotifyProps(samAccountName, domainName, mailText, subject, keyPairValue);
                    }
                    subject = (String)p.get("subject");
                    ArrayList contactAtt = (ArrayList)p.get("contactAtt");
                    mailText = p.getProperty("mailText");
                    Properties prop = (Properties)contactAtt.get(0);
                    prop.put("sendVia", sendVia);
                    prop.put("subject", subject);
                    prop.put("mailText", mailText);
                    prop.put("policyId", policyId);
                    prop.put("domainName", domainName);
                    prop.put("samAccountName", samAccountName);
                    prop.put("nId", nId);
                    keyPairValue.put("userName", (String)prop.get("name"));
                    String string = exemptedDeviceId = keyPairValue.containsKey("EXEMPTED_DEVICE") ? (String)keyPairValue.get("EXEMPTED_DEVICE") : null;
                    if (exemptedDeviceId != null) {
                        prop.put("EXEMPTED_DEVICE", exemptedDeviceId);
                    }
                    if (sendVia.equalsIgnoreCase("MAIL")) {
                        if (nId.equals(ADMIN_NOTIFICATION_ID.toString())) {
                            prop.put("isAdmin", (Object)true);
                            PolicyNotifications.sendMailNotification(prop);
                            continue;
                        }
                        if (nId.equals(TICKET_GENERATION_ID.toString())) {
                            PolicyNotifications.raiseTicket(prop);
                            continue;
                        }
                        Boolean notifySecondary = "true".equals(ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY")) && !keyPairValue.containsKey("confirmCode") && !keyPairValue.containsKey("secureLink");
                        prop.put("notifySecondary", notifySecondary);
                        returnStr = PolicyNotifications.sendMailNotification(prop);
                        continue;
                    }
                    if (sendVia.equalsIgnoreCase("SMS")) {
                        prop.put("IS_OTP", (Object)(VERIFICATION_CODE_MOBILE.equals((Long)row.get("NOTIFICATION_ID")) ? 1 : 0));
                        returnStr = PolicyNotifications.sendSMSNotification(prop);
                        continue;
                    }
                    if (!sendVia.equals("PushNotification")) continue;
                    returnStr = PolicyNotifications.sendPushNotification(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnStr = e.getMessage();
        }
        return returnStr;
    }

    public static void parse(JSONObject json, String samAccountName, String domainName, String mailText, String subject, Hashtable keyPairValue) throws JSONException {
        Iterator keys = json.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String val = null;
            try {
                JSONObject value = json.getJSONObject(key);
                PolicyNotifications.parse(value, samAccountName, domainName, mailText, subject, keyPairValue);
            }
            catch (Exception e) {
                val = json.getString(key);
                val = StrUtil.jsonEscape(APCUtil.getPCNotifyProps(samAccountName, domainName, val, subject, keyPairValue).getProperty("mailText"));
            }
            if (val == null) continue;
            json.put(key, (Object)val);
            if (!key.equalsIgnoreCase("requester") || !val.equalsIgnoreCase("")) continue;
            json.put(key, (Object)samAccountName);
        }
    }

    public static void raiseTicket(Properties prop) {
        try {
            prop.put("actionName", new JSONObject(AdvancedPolicyHandler.policyMailNotify).getString((String)prop.get("nId")));
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            String objectGuID = (String)prop.get("objectGUID");
            Properties auditProps = new Properties();
            map.put("DOMAIN_NAME", (String)prop.get("domainName"));
            map.put("OBJECT_GUID", (String)prop.get("objectGUID"));
            map.put("NAME", (String)prop.get("samAccountName"));
            map.put("MAIL_SENT_TIME", System.currentTimeMillis());
            map.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
            map.put("ACTION_NAME", (String)prop.get("actionName"));
            map.put("DELIEVERED_TIME", System.currentTimeMillis());
            prop.setProperty("OPERATION_NAME", "ADD_REQUEST");
            Properties resultProp = PolicyNotifications.callSDPAPI(prop);
            if (!resultProp.getProperty("MESSAGE").equalsIgnoreCase("failed") || !resultProp.getProperty("MESSAGE").equals("")) {
                String status = resultProp.getProperty("STATUS");
                if (status.equalsIgnoreCase("success")) {
                    String result = resultProp.getProperty("MESSAGE");
                    JSONObject jsonResult = new JSONObject(result);
                    if ((jsonResult = jsonResult.getJSONObject("operation").getJSONObject("result")).getString("status").equalsIgnoreCase("success")) {
                        map.put("STATUS", "adssp.common.text.success");
                    } else {
                        map.put("STATUS", jsonResult.getString("message"));
                    }
                } else {
                    map.put("STATUS", resultProp.getProperty("MESSAGE"));
                }
            } else {
                map.put("STATUS", "adssp.common.text.failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties callSDPAPI(Properties prop) {
        Properties resultProp = new Properties();
        try {
            String line;
            HttpURLConnection conn = null;
            BufferedReader rd = null;
            OutputStreamWriter wr = null;
            Long productId = com.manageengine.ads.fw.util.CommonUtil.getProductId((String)"ManageEngine ServiceDesk Plus");
            JSONObject productJSON = JumpToHandler.getProductSettings((String)"ManageEngine ServiceDesk Plus");
            Iterator keys = productJSON.keys();
            String prorityId = "";
            while (keys.hasNext()) {
                prorityId = (String)keys.next();
            }
            String technicianKey = com.manageengine.ads.fw.util.CommonUtil.getProductParamValue((Long)productId, (String)"TECHNICIAN_KEY");
            if (prop.get("TECHNICIAN_KEY") != null) {
                technicianKey = prop.getProperty("TECHNICIAN_KEY");
            }
            if (productJSON.length() == 0 && prop.get("URLSTRING") == null || technicianKey == null) {
                logger.log(Level.INFO, "Service Desk Plus not configured");
                resultProp.setProperty("STATUS", "failed");
                resultProp.setProperty("MESSAGE", "adssp.reports.sdp_not_configured");
                return resultProp;
            }
            String sdpUrl = prop.getProperty("URL");
            if (sdpUrl == null) {
                sdpUrl = "/sdpapi/request";
            }
            String urlString = "";
            if (prop.get("URLSTRING") != null) {
                urlString = prop.getProperty("URLSTRING") + "/sdpapi/request";
            } else {
                JSONObject productSettings = productJSON.getJSONObject(prorityId);
                urlString = productSettings.get("PROTOCOL") + "://" + productSettings.get("HOST") + ":" + productSettings.get("PORT") + sdpUrl;
            }
            URL url = new URL(urlString);
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write("OPERATION_NAME=" + prop.getProperty("OPERATION_NAME") + "&TECHNICIAN_KEY=" + technicianKey + "&format=json&INPUT_DATA=" + URLEncoder.encode(prop.getProperty("mailText"), "UTF-8"));
                wr.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                resultProp.setProperty("STATUS", "failed");
                resultProp.setProperty("MESSAGE", "adssp.reports.unable_to_connect_sdp");
                return resultProp;
            }
            int responseCode = conn.getResponseCode();
            logger.log(Level.INFO, "response code:" + responseCode);
            InputStream isr = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            rd = new BufferedReader(new InputStreamReader(isr));
            StringBuilder result = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            String response = result.toString();
            logger.log(Level.INFO, "response:" + response);
            if (responseCode == 200) {
                resultProp.setProperty("STATUS", "success");
                resultProp.setProperty("MESSAGE", result.toString());
                return resultProp;
            }
            resultProp.setProperty("STATUS", "failed");
            resultProp.setProperty("MESSAGE", result.toString());
            return resultProp;
        }
        catch (Exception e) {
            e.printStackTrace();
            resultProp.setProperty("STATUS", "failed");
            resultProp.setProperty("MESSAGE", "");
            return resultProp;
        }
    }

    public static JSONObject sendPassword(String domainName, String samAccountName, Long policyId, Hashtable keyPairValue) {
        JSONObject returnObj = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            String smsStatus = PolicyNotifications.sendNotification(domainName, samAccountName, policyId, new ArrayList<Long>(Arrays.asList(RESET_PASSWORD_SMS)), keyPairValue);
            String mailStatus = PolicyNotifications.sendNotification(domainName, samAccountName, policyId, new ArrayList<Long>(Arrays.asList(RESET_PASSWORD_MAIL)), keyPairValue);
            String pushStatus = PolicyNotifications.sendNotification(domainName, samAccountName, policyId, new ArrayList<Long>(Arrays.asList(10L)), keyPairValue);
            returnObj.put("SMS", (Object)smsStatus);
            returnObj.put("MAIL", (Object)mailStatus);
            returnObj.put("PushNotification", (Object)pushStatus);
            keyPairValue.put("actionPhrase", rb.getString("adssp.notification.actio.reset_pwd_admin"));
            keyPairValue.put("action", rb.getString("adssp.common.text.reset_pwd"));
            String adminDateTime = (String)keyPairValue.get("adminDateTime");
            if (adminDateTime != null && !"".equals(adminDateTime)) {
                keyPairValue.put("dateTime", adminDateTime);
            }
            ArrayList<String> colNames = new ArrayList<String>();
            colNames.add("SEND_AUTO_GEN_PWD");
            Hashtable colValues = APCUtil.getRequiredPCValues(policyId, colNames, "SSPSecurity");
            String sendAutoGenPwd = (String)colValues.get("SEND_AUTO_GEN_PWD");
            if (!sendAutoGenPwd.equals("1") || mailStatus.equalsIgnoreCase("adssp.common.text.mail_sent_success") || smsStatus.equalsIgnoreCase("adssp.common.text.smssent") || pushStatus.equalsIgnoreCase("success")) {
                PolicyNotifications.sendMailToAdmin(domainName, samAccountName, policyId, keyPairValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnObj;
    }

    public static void sendMailToAdmin(String domainName, String samAccountName, Long policyId, Hashtable keyPairValue) {
        try {
            if (keyPairValue.get("updatedAttributes") == null) {
                keyPairValue.put("updatedAttributes", new JSONArray());
            }
            PolicyNotifications.sendNotification(domainName, samAccountName, policyId, new ArrayList<Long>(Arrays.asList(ADMIN_NOTIFICATION_ID, TICKET_GENERATION_ID)), keyPairValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String sendMailNotification(Properties prop) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Hashtable<String, Object> auditProps = new Hashtable<String, Object>();
        String returnStr = null;
        try {
            int i;
            Hashtable<String, Hashtable<String, Object>> allAuditProps = new Hashtable<String, Hashtable<String, Object>>();
            String domainName = (String)prop.get("domainName");
            String objectGUID = (String)prop.get("objectGUID");
            Long mailSentTIme = System.currentTimeMillis();
            ArrayList mailIds = prop.get("mail") != null ? (ArrayList)prop.get("mail") : new ArrayList();
            ArrayList primMailIds = prop.get("primMailIds") != null ? (ArrayList)prop.get("primMailIds") : new ArrayList();
            ArrayList secMailIds = prop.get("secMailIds") != null ? (ArrayList)prop.get("secMailIds") : new ArrayList();
            ArrayList sentMailList = new ArrayList();
            Boolean notifyAll = prop.get("notifySecondary") != null ? (Boolean)prop.get("notifySecondary") : false;
            Boolean isAdmin = (Boolean)prop.get("isAdmin");
            String actionName = new JSONObject(AdvancedPolicyHandler.policyMailNotify).getString((String)prop.get("nId"));
            prop.put("actionName", actionName);
            Properties mailConfig = ADSMPersUtil.getMailServerSettings();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("MAIL_SERVER", (String)mailConfig.get("MAIL_SERVER"));
            map.put("FROM_ADDRESS", (String)mailConfig.get("FROM_ADDRESS"));
            map.put("MAIL_SUBJECT", (String)prop.get("subject"));
            map.put("MAIL_CONTENT", (String)prop.get("mailText"));
            map.put("SMTP_PORT", (String)mailConfig.get("SMTP_PORT"));
            map.put("MAIL_SERVER_USER", (String)mailConfig.get("MAIL_SERVER_USER"));
            map.put("MAIL_SERVER_PWD", (String)mailConfig.get("MAIL_SERVER_PWD"));
            map.put("DOMAIN_NAME", domainName);
            map.put("OBJECT_GUID", objectGUID);
            map.put("NAME", (String)prop.get("samAccountName"));
            map.put("MAIL_SENT_TIME", mailSentTIme);
            map.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
            map.put("ACTION_NAME", (String)prop.get("actionName"));
            String tempStatus = "";
            Properties mailServerProp = ADSMPersUtil.getMailServerSettings();
            Boolean isInvalidMailId = true;
            for (i = 0; i < mailIds.size(); ++i) {
                sentMailList.add(mailIds.get(i));
                isInvalidMailId = false;
                map.put("MAIL_IDS", new String[]{(String)mailIds.get(i)});
                returnStr = SendMailAPI.getInstance().sendMail(map, auditProps, mailServerProp);
                if (returnStr.equals("adssp.common.text.mail_sent_success") && (isAdmin == null || !isAdmin.booleanValue()) && (notifyAll == null || !notifyAll.booleanValue())) break;
                tempStatus = "adssp.common.text.success".equals(String.valueOf(((Hashtable)auditProps.get(objectGUID)).get("STATUS"))) ? "adssp.common.text.success" : tempStatus;
            }
            for (i = 0; i < primMailIds.size() && notifyAll != null && notifyAll.booleanValue(); ++i) {
                if ("".equals((String)primMailIds.get(i)) || sentMailList.contains((String)primMailIds.get(i))) continue;
                sentMailList.add(primMailIds.get(i));
                isInvalidMailId = false;
                map.put("MAIL_IDS", new String[]{(String)primMailIds.get(i)});
                returnStr = SendMailAPI.getInstance().sendMail(map, auditProps, mailServerProp);
                tempStatus = "adssp.common.text.success".equals(String.valueOf(((Hashtable)auditProps.get(objectGUID)).get("STATUS"))) ? "adssp.common.text.success" : tempStatus;
            }
            for (i = 0; i < secMailIds.size() && notifyAll != null && notifyAll.booleanValue(); ++i) {
                if ("".equals((String)secMailIds.get(i)) || sentMailList.contains((String)secMailIds.get(i))) continue;
                sentMailList.add(secMailIds.get(i));
                isInvalidMailId = false;
                map.put("MAIL_IDS", new String[]{(String)secMailIds.get(i)});
                returnStr = SendMailAPI.getInstance().sendMail(map, auditProps, mailServerProp);
                tempStatus = "adssp.common.text.success".equals(String.valueOf(((Hashtable)auditProps.get(objectGUID)).get("STATUS"))) ? "adssp.common.text.success" : tempStatus;
            }
            if (isInvalidMailId.booleanValue()) {
                logger.log(Level.INFO, "Unable to send email as the mailID is not valid ");
                if (domainName != null) {
                    auditProps.put("DOMAIN_NAME", domainName);
                    auditProps.put("MAIL_SENT_TIME", mailSentTIme);
                    auditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                    auditProps.put("ACTION_NAME", actionName);
                    auditProps.put("NAME", (String)prop.get("samAccountName"));
                    auditProps.put("STATUS", rb.getString("adssp.reports.delivery_rep_invalid_email_id"));
                    allAuditProps.put(objectGUID, auditProps);
                    AuditAPI.getInstance();
                    AuditAPI.addAuditLogs(allAuditProps);
                }
                return "adssp.common.text.unable_send_notification";
            }
            if (tempStatus != "") {
                Hashtable mailAuditProps = (Hashtable)auditProps.get(objectGUID);
                mailAuditProps.put("STATUS", tempStatus);
                auditProps.put(objectGUID, mailAuditProps);
            }
            AuditAPI.getInstance();
            AuditAPI.addAuditLogs(auditProps);
        }
        catch (Exception e) {
            e.printStackTrace();
            returnStr = e.getMessage();
        }
        return returnStr;
    }

    public static String sendSMSNotification(Properties prop) {
        String returnStr;
        String errorMsg = returnStr = null;
        try {
            Hashtable<String, Properties> auditLogs = new Hashtable<String, Properties>();
            Properties auditProps = new Properties();
            String objectGuID = (String)prop.get("objectGUID");
            prop.put("actionName", new JSONObject(AdvancedPolicyHandler.policySMSNotify).getString((String)prop.get("nId")));
            prop.put("domainName", (String)prop.get("domainName"));
            ArrayList mobNumber = (ArrayList)prop.get("mobNumber");
            Boolean isInvalidMobNo = true;
            if (mobNumber != null && mobNumber.size() != 0) {
                for (int i = 0; i < mobNumber.size(); ++i) {
                    if (mobNumber.get(i).equals("")) continue;
                    isInvalidMobNo = false;
                    errorMsg = returnStr = SMSAction.sendSMS((String)mobNumber.get(i), (String)prop.get("mailText"), (Boolean)prop.get("IS_OTP"));
                    if (!returnStr.equals("adssp.common.text.smssent")) continue;
                    errorMsg = "adssp.common.text.success";
                    break;
                }
            }
            if (isInvalidMobNo.booleanValue()) {
                logger.log(Level.INFO, "Unable to send SMS as the mobile number is not valid ");
                errorMsg = "adssp.reports.ste_delivery_rep_invalid_mobile_number";
                returnStr = "adssp.common.text.unable_send_notification";
            }
            auditProps.put("ACTION_NAME", (String)prop.get("actionName"));
            auditProps.put("DOMAIN_NAME", (String)prop.get("domainName"));
            auditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.sms");
            auditProps.put("MAIL_SENT_TIME", (Object)System.currentTimeMillis());
            auditProps.put("STATUS", errorMsg);
            auditProps.put("NAME", prop.get("samAccountName"));
            auditLogs.put(objectGuID, auditProps);
            AuditAPI.getInstance();
            AuditAPI.addAuditLogs(auditLogs);
        }
        catch (Exception e) {
            e.printStackTrace();
            returnStr = e.getMessage();
        }
        return returnStr;
    }

    public static String sendPushNotification(Properties userProperty) {
        try {
            String pushSubject = (String)userProperty.get("subject");
            String pushMsg = (String)userProperty.get("mailText");
            JSONObject customAttribs = new JSONObject();
            customAttribs.put("NA", 4);
            JSONObject pnMessageContainer = PNEnrollmentHandler.getMessageBody((String)pushSubject, (String)pushMsg, (JSONObject)customAttribs);
            String deviceId = (String)userProperty.get("EXEMPTED_DEVICE");
            if (deviceId != null) {
                pnMessageContainer.put("EXEMPTED_DEVICE_TOKEN", (Object)PNEnrollmentHandler.getDeviceTokensFromDeviceIds((String[])new String[]{deviceId}));
            }
            String domainName = (String)userProperty.get("domainName");
            String samAccountName = (String)userProperty.get("samAccountName");
            if (domainName != null && samAccountName != null) {
                JSONObject accountDetails = UserUtil.getUserAccountDetails(samAccountName, domainName);
                Long loginId = (Long)accountDetails.get("LOGIN_ID");
                JSONObject returnValueJSON = SendPushNotification.getInstance().sendNotification(new Long[]{loginId}, new JSONObject().put(String.valueOf(loginId), (Object)pnMessageContainer), null, "");
                Hashtable<String, String> notificationProps = new Hashtable<String, String>();
                notificationProps.put("ACTION_NAME", new JSONObject(AdvancedPolicyHandler.policyPNNotify).getString((String)userProperty.get("nId")));
                notificationProps.put("NOTIFICATION_FROM", "QUICK_ENROLLMENT");
                String status = returnValueJSON.getString("STATUS");
                if (status != null && status.equals("success")) {
                    JSONArray notifiedUserList = returnValueJSON.getJSONArray("DELIVERY_DETAILS");
                    EnrollmentNotifyHandler.auditProcess(notifiedUserList, notificationProps);
                    return "success";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Failed";
    }

    public static JSONObject getNotificationDetails(Long policyId, Long notifyId, String columnName) {
        JSONObject json = new JSONObject();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"POLICY_ID"), (Object)policyId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)notifyId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyNotifications", criteria);
            if (!obj.isEmpty()) {
                Row row = obj.getFirstRow("PolicyNotifications");
                json.put(columnName, row.get(columnName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static JSONObject sendEnrolledAcknowledgement(HttpServletRequest request, Long policyId, String domainName, String logonName) throws Exception {
        JSONObject adMsg = new JSONObject();
        JSONObject adStatus = new JSONObject();
        try {
            Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
            keyPairValue.put("dateTime", TimeZoneUtil.getPresentDateTime(request, null));
            String ipAddress = CommonUtil.getIPAddress(request);
            HashMap result = (HashMap)CommonUtil.getHostDetails(ipAddress);
            keyPairValue.put("hostName", (String)result.get("host"));
            keyPairValue.put("ipAddress", (String)result.get("ip"));
            ArrayList<Long> nIds = new ArrayList<Long>();
            nIds.add(new Long(13L));
            nIds.add(new Long(14L));
            nIds.add(new Long(19L));
            if (MobileUtil.isNativeApp(request) && request.getParameterMap().containsKey("DEVICE_ID")) {
                keyPairValue.put("EXEMPTED_DEVICE", request.getParameter("DEVICE_ID"));
            }
            PolicyNotifications.sendNotification(domainName, logonName, policyId, nIds, keyPairValue);
            AdventNetResourceBundle adminRb = ResourceBundleMgr.getInstance().getBundle();
            keyPairValue.put("actionPhrase", adminRb.getString("adssp.notification.actio.enrollment_admin"));
            keyPairValue.put("action", adminRb.getString("adssp.admin.policies.policy_config.apc_enrollment"));
            keyPairValue.put("dateTime", TimeZoneUtil.getPresentDateTime(request, 1L));
            JSONObject jsonLog = AuditAPI.getInstance().setAuditProps(logonName, domainName, System.currentTimeMillis(), "adssp.admin.policies.policy_config.apc_enrollment", (String)result.get("ip"), (String)result.get("host"), "", "adssp.common.text.success");
            jsonLog.put("ENROLLMENT_SOURCE", request.getAttribute("SOURCE"));
            logger.log(Level.INFO, "calling logForwarder : " + jsonLog.toString());
            LogForwarderAPI.getInstance().sendMessage(jsonLog);
            PolicyNotifications.sendMailToAdmin(domainName, logonName, policyId, keyPairValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        adMsg.put("sSTATUS", (Object)"success");
        adMsg.put("DISPLAY_MESSAGE", request.getAttribute("statusMsg"));
        return adStatus;
    }
}

