/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.popup.PopupDataModel;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvancedFilterObject {
    private Long advancedFilterId = 0L;
    private Integer objectTypeId = 1;
    private String advancedFilterName = "";
    private Integer priority = 1;
    private boolean isDefaultSelected = false;
    private String advancedFilterDesc = "";
    private ArrayList popupDataModelList = new ArrayList();
    private String filterButtonName = null;

    public void init(Row r, PopupSelection popupSelection) {
        this.advancedFilterId = (Long)r.get("ADVANCED_FILTER_ID");
        this.advancedFilterName = (String)r.get("ADVANCED_FILTER_NAME");
        this.priority = (Integer)r.get("PRIORITY");
        this.isDefaultSelected = (Boolean)r.get("IS_DEFAULT_SELECTED");
        this.objectTypeId = (Integer)r.get("OBJECT_TYPE_ID");
        this.filterButtonName = (String)r.get("FILTER_BUTTON_NAME");
        this.setPopupDataModelList(popupSelection);
    }

    private void setPopupDataModelList(PopupSelection popupSelection) {
        try {
            DataObject popupDO = popupSelection.getPopupDO();
            Iterator itr = popupDO.getRows("ADSMFilterToViewModel", new Criteria(Column.getColumn((String)"ADSMFilterToViewModel", (String)"ADVANCED_FILTER_ID"), (Object)this.advancedFilterId, 0));
            this.popupDataModelList = new ArrayList();
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                PopupDataModel pdm = new PopupDataModel();
                pdm.init(r, popupSelection);
                this.popupDataModelList.add(pdm);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public PopupDataModel getPDM(Long pdmId) {
        PopupDataModel pdmObject = null;
        for (PopupDataModel pdm : this.popupDataModelList) {
            if (pdm.getPopupDataModelId().intValue() != pdmId.intValue()) continue;
            pdmObject = pdm;
            break;
        }
        return pdmObject;
    }

    public Object toJSONObject() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("objectTypeId", (Object)this.objectTypeId);
            jsonObj.put("isDefaultSelected", this.isDefaultSelected);
            jsonObj.put("advancedFilterId", (Object)this.advancedFilterId);
            jsonObj.put("filterButtonName", (Object)this.filterButtonName);
            JSONArray jsonAFArray = new JSONArray();
            for (PopupDataModel popupDataModel : this.popupDataModelList) {
                jsonAFArray.put(popupDataModel.toJSONObject());
            }
            jsonObj.put("popupDataModelList", (Object)jsonAFArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public String getAfoName() {
        return this.advancedFilterName;
    }

    public Long getAfoId() {
        return this.advancedFilterId;
    }

    public Integer getObjectTypeId() {
        return this.objectTypeId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean getIsDefaultSelected() {
        return this.isDefaultSelected;
    }

    public String getAfoDesc() {
        return this.advancedFilterDesc;
    }

    public ArrayList getPopupDataModelList() {
        return this.popupDataModelList;
    }
}

