/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupDataModel {
    private Long advancedFilterId = 1L;
    private Long popupDataModelId = 1L;
    private Integer viewModelId = 1;
    private Integer priority = 1;
    private boolean isDefaultSelected = false;
    private Integer isSingleOrMultiple = 1;
    private ArrayList menuItemList = new ArrayList();
    private String viewModelName = null;
    private String viewModelImage = null;
    private String moduleName = "";

    public void init(Row r, PopupSelection popupSelection) {
        try {
            this.advancedFilterId = (Long)r.get("ADVANCED_FILTER_ID");
            this.popupDataModelId = (Long)r.get("POPUP_DATA_MODEL_ID");
            this.viewModelId = (Integer)r.get("VIEW_MODEL_ID");
            this.viewModelName = (String)r.get("VIEW_MODEL_NAME");
            this.priority = (Integer)r.get("PRIORITY");
            this.isDefaultSelected = (Boolean)r.get("IS_DEFAULT_SELECTED");
            this.isSingleOrMultiple = (Integer)r.get("IS_SINGLE_OR_MULTIPLE");
            this.setMenuList(popupSelection);
            this.moduleName = (String)r.get("MODULE_NAME");
            this.viewModelImage = (String)r.get("VIEW_MODEL_IMAGE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setMenuList(PopupSelection popupSelection) {
        try {
            DataObject popupDO = popupSelection.getPopupDO();
            Iterator itr = popupDO.getRows("ADSMPopupMenuMapping", new Criteria(Column.getColumn((String)"ADSMPopupMenuMapping", (String)"POPUP_DATA_MODEL_ID"), (Object)this.popupDataModelId, 0));
            this.menuItemList = new ArrayList();
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                this.menuItemList.add((Integer)r.get("POPUP_MENU_ID"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private JSONObject setRangeNavigationConfig() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("start", 1);
            jsonObj.put("end", 10);
            jsonObj.put("rangeList", (Object)new JSONArray("[10,25,50,100]"));
            jsonObj.put("url", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public Object toJSONObject() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("advancedFilterId", (Object)this.getAfoId());
            jsonObj.put("popupDataModelId", (Object)this.popupDataModelId);
            jsonObj.put("viewModelId", (Object)this.viewModelId);
            jsonObj.put("priority", (Object)this.priority);
            jsonObj.put("isDefaultSelected", this.isDefaultSelected);
            jsonObj.put("isSingleOrMultiple", (Object)this.isSingleOrMultiple);
            jsonObj.put("viewModelName", (Object)this.viewModelName);
            JSONArray jsonAFArray = new JSONArray();
            for (Integer menuItem : this.menuItemList) {
                jsonAFArray.put((Object)menuItem);
            }
            jsonObj.put("menuItemList", (Object)jsonAFArray);
            jsonObj.put("rangeNavigationConfig", (Object)this.setRangeNavigationConfig());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public Long getAfoId() {
        return this.advancedFilterId;
    }

    public Long getPopupDataModelId() {
        return this.popupDataModelId;
    }

    public Integer getViewModelId() {
        return this.viewModelId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean isDefaultSelected() {
        return this.isDefaultSelected;
    }

    public Integer getIsSingleOrMultiple() {
        return this.isSingleOrMultiple;
    }

    public ArrayList getMenuItemList() {
        return this.menuItemList;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getViewModelName() {
        return this.viewModelName;
    }

    public String getViewModelImage() {
        return this.viewModelImage;
    }
}

