/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.sym.adsm.common.server.popup.PopupDataModel;
import com.adventnet.sym.adsm.common.server.popup.PopupSingleton;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupReqParams {
    private JSONObject json = null;
    private Integer start = 1;
    private Integer end = 3;
    private Integer range = 3;
    private String searchTxt = "";
    private Long popupId = 1L;
    private Long loginId = 1L;
    private Integer objectTypeId = 1;
    private Integer viewModelId = 1;
    private Long popupDataModelId = 1L;
    private Long boardId = 1L;
    private JSONObject inputParamsMap = new JSONObject();
    private String domainName;
    private String nodeClicked;
    private PopupDataModel pdmObject = null;
    private String refresh;
    private JSONObject filtersList;
    private Boolean allDomains;
    private JSONObject colFilterJson;
    private JSONArray prevSelItems;

    public PopupReqParams(JSONObject json) {
        this.json = json;
        this.domainName = "";
        this.allDomains = false;
        this.colFilterJson = new JSONObject();
        this.prevSelItems = new JSONArray();
        this.nodeClicked = null;
        this.refresh = "false";
        this.filtersList = new JSONObject();
        this.setCommonProperties();
        this.initFilterSpecificInputProps();
        this.initMenuItemSpecificInput();
    }

    public Long getLoginId() {
        return this.loginId;
    }

    public void setLoginId(Long loginId) {
        this.loginId = loginId;
    }

    public void setBoardId(Long boardId) {
        this.boardId = boardId;
    }

    public JSONObject getInputParamsMap() {
        return this.inputParamsMap;
    }

    private void setCommonProperties() {
        try {
            this.popupId = this.json.getLong("popupId");
            this.objectTypeId = this.json.getInt("objectTypeId");
            this.viewModelId = this.json.getInt("viewModelId");
            this.popupDataModelId = this.json.getLong("popupDataModelId");
            this.pdmObject = PopupSingleton.getInstance().getPopupSelection(this.getPopupId()).getPDM(this.popupDataModelId);
            this.domainName = (String)this.json.get("domainName");
            this.allDomains = (Boolean)this.json.get("allDomains");
            this.colFilterJson = this.json.getJSONObject("colFilter");
            if (this.json.has("prevSelItems")) {
                this.prevSelItems = this.json.getJSONArray("prevSelItems");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initMenuItemSpecificInput() {
        try {
            if (this.json.has("searchText")) {
                this.searchTxt = this.json.getString("searchText");
            }
            if (this.json.has("boardid")) {
                this.boardId = this.json.getLong("boardid");
            }
            if (this.json.has("start") || this.json.has("end") || this.json.has("range")) {
                this.setRangeNavigationProperties();
            }
            if (this.json.has("refresh")) {
                this.refresh = this.json.getString("refresh");
            }
            if (this.json.has("inputParams")) {
                this.inputParamsMap = this.json.getJSONObject("inputParams");
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
    }

    private void initFilterSpecificInputProps() {
        try {
            if (this.json.has("nodeClicked")) {
                this.nodeClicked = this.json.getString("nodeClicked");
            }
            if (this.json.has("selectedList")) {
                this.filtersList = this.json.getJSONObject("selectedList");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setRangeNavigationProperties() {
        try {
            this.start = this.json.getInt("start");
            this.end = this.json.getInt("end");
            this.range = this.json.getInt("range");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public Long getPopupId() {
        return this.popupId;
    }

    public Integer getObjectTypeId() {
        return this.objectTypeId;
    }

    public Integer getViewModelId() {
        return this.viewModelId;
    }

    public Long getPDMId() {
        return this.popupDataModelId;
    }

    public String getSearchTxt() {
        return this.searchTxt;
    }

    public Long getBoardId() {
        return this.boardId;
    }

    public Integer getStartingIndex() {
        return this.start;
    }

    public Integer getRange() {
        return this.range;
    }

    public Integer getToIndex() {
        return this.end;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Boolean getAllDomains() {
        return this.allDomains;
    }

    public JSONObject getColFilterJson() {
        return this.colFilterJson;
    }

    public JSONArray getPrevSelItems() {
        return this.prevSelItems;
    }

    public String getNodeClicked() {
        return this.nodeClicked;
    }

    public String getRefreshFlag() {
        return this.refresh;
    }

    public JSONObject getFiltersList() {
        return this.filtersList;
    }
}

