/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.popup.AdvancedFilterObject;
import com.adventnet.sym.adsm.common.server.popup.PopupDataModel;
import com.adventnet.sym.adsm.common.server.popup.PopupTabObject;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupSelection {
    private Long popupId = 1L;
    private Long popupTypeId = 1L;
    private Long popupScriptConfigId = 1L;
    private DataObject popupDO = null;
    private ArrayList popupTabs = new ArrayList();
    private String buttonName = null;
    private boolean needsSummmary = false;
    private boolean needsDomainSel = false;

    public void init(Long popupId) {
        try {
            this.popupId = popupId;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMObjectPopup"));
            query.addSelectColumn(new Column(null, "*"));
            query.addJoin(new Join("ADSMObjectPopup", "ADSMPopupTabMappping", new String[]{"POPUP_TYPE_ID"}, new String[]{"POPUP_TYPE_ID"}, 1));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMPopupTabMappping", (String)"PRIORITY"), true));
            query.addJoin(new Join("ADSMObjectPopup", "ADSMPopupSelection", new String[]{"POPUP_TYPE_ID"}, new String[]{"POPUP_TYPE_ID"}, 1));
            query.addJoin(new Join("ADSMPopupTabMappping", "ADSMPopupAdvancedFilter", new String[]{"POPUP_TAB_ID"}, new String[]{"POPUP_TAB_ID"}, 1));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMPopupAdvancedFilter", (String)"PRIORITY"), true));
            query.addJoin(new Join("ADSMPopupAdvancedFilter", "ADSMFilterToViewModel", new String[]{"ADVANCED_FILTER_ID"}, new String[]{"ADVANCED_FILTER_ID"}, 1));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMFilterToViewModel", (String)"PRIORITY"), true));
            query.addJoin(new Join("ADSMFilterToViewModel", "ADSMPopupMenuMapping", new String[]{"POPUP_DATA_MODEL_ID"}, new String[]{"POPUP_DATA_MODEL_ID"}, 1));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMObjectPopup", (String)"POPUP_ID"), (Object)this.popupId, 0);
            query.setCriteria(criteria);
            this.popupDO = DataAccess.get((SelectQuery)query);
            this.setPopupSelection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPopupButtonName(String buttonName) {
        this.buttonName = buttonName;
    }

    private void setPopupSelection() {
        try {
            Row r = this.popupDO.getRow("ADSMObjectPopup");
            this.setPopupTypeId((Long)r.get("POPUP_TYPE_ID"));
            this.setPopupScriptConfigId((Long)r.get("POPUP_SCRIPT_CONFIG_ID"));
            r = this.popupDO.getRow("ADSMPopupSelection");
            this.setPopupButtonName((String)r.get("BUTTON_NAME"));
            this.needsSummmary = (Boolean)r.get("NEEDS_SUMMARY");
            this.needsDomainSel = (Boolean)r.get("NEEDS_DOMAIN_SEL");
            this.setPopupTabs();
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private void setPopupTabs() {
        try {
            Iterator itr = this.popupDO.getRows("ADSMPopupTabMappping");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                PopupTabObject popupTabObj = new PopupTabObject();
                this.popupTabs.add(popupTabObj);
                popupTabObj.init(r, this);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public PopupTabObject getPopupTab(Long tabId) {
        PopupTabObject popupTab = null;
        for (PopupTabObject tab : this.popupTabs) {
            if (popupTab.getTabId().intValue() != tabId.intValue()) continue;
            popupTab = tab;
            break;
        }
        return popupTab;
    }

    public AdvancedFilterObject getAFO(Long afoId) {
        AdvancedFilterObject afO = null;
        block0: for (PopupTabObject tab : this.popupTabs) {
            for (AdvancedFilterObject afo : tab.getAfoList()) {
                if (afo.getAfoId().intValue() != afoId.intValue()) continue;
                afO = afo;
                continue block0;
            }
        }
        return afO;
    }

    public PopupDataModel getPDM(Long pdmId) {
        PopupDataModel pdmObject = null;
        for (PopupTabObject tab : this.popupTabs) {
            for (AdvancedFilterObject afo : tab.getAfoList()) {
                for (PopupDataModel pdm : afo.getPopupDataModelList()) {
                    if (pdm.getPopupDataModelId().intValue() != pdmId.intValue()) continue;
                    pdmObject = pdm;
                    return pdmObject;
                }
            }
        }
        return pdmObject;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("popupId", (Object)this.popupId);
            jsonObj.put("popupTypeId", (Object)this.popupTypeId);
            jsonObj.put("popupScriptConfigId", (Object)this.popupScriptConfigId);
            jsonObj.put("buttonName", (Object)this.buttonName);
            jsonObj.put("needsSummmary", this.needsSummmary);
            jsonObj.put("needsDomainSel", this.needsDomainSel);
            JSONArray popObjArray = new JSONArray();
            for (PopupTabObject popupTabObj : this.popupTabs) {
                popObjArray.put(popupTabObj.toJSONObject());
            }
            jsonObj.put("popupTabs", (Object)popObjArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    private void setPopupScriptConfigId(Long long1) {
        this.popupScriptConfigId = long1;
    }

    private void setPopupTypeId(Long long1) {
        this.popupTypeId = long1;
    }

    public DataObject getPopupDO() {
        return this.popupDO;
    }

    public ArrayList getPopupTabs() {
        return this.popupTabs;
    }

    public boolean isNeedSummary() {
        return this.needsSummmary;
    }

    public boolean isDomainSelNeeded() {
        return this.needsDomainSel;
    }
}

