/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import java.util.Hashtable;
import java.util.Iterator;

public class PopupSingleton {
    private static PopupSingleton popup = null;
    private Hashtable popupConfigData = new Hashtable();
    private Hashtable objectViewModelInfo = new Hashtable();
    private Hashtable objectTypeInfo = new Hashtable();

    private PopupSingleton() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PopupSingleton getInstance() {
        if (popup != null) return popup;
        Class<PopupSingleton> clazz = PopupSingleton.class;
        synchronized (PopupSingleton.class) {
            popup = new PopupSingleton();
            // ** MonitorExit[var0] (shouldn't be in output)
            return popup;
        }
    }

    public PopupSelection getPopupSelection(Long popupId) {
        PopupSelection pop = (PopupSelection)this.popupConfigData.get(popupId);
        if (pop == null) {
            pop = new PopupSelection();
            pop.init(popupId);
            this.popupConfigData.put(popupId, pop);
        }
        return pop;
    }

    public String getObjectTypeInfo(Integer objectTypeId) {
        String clsName = (String)this.objectTypeInfo.get(objectTypeId);
        if (clsName == null) {
            this.initObjectTypeInfo();
            clsName = (String)this.objectTypeInfo.get(objectTypeId);
        }
        return clsName;
    }

    public void initObjectTypeInfo() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMObjectType"));
            query.addSelectColumn(new Column(null, "*"));
            DataObject dataObj = DataAccess.get((SelectQuery)query);
            Iterator itr = dataObj.getRows("ADSMObjectType");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String s = (String)r.get("CLASS_NAME");
                this.objectTypeInfo.put(r.get("OBJECT_TYPE_ID"), s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable getObjectViewModelInfo(Integer objectViewId) {
        Hashtable viewModelInfo = (Hashtable)this.objectViewModelInfo.get(objectViewId);
        if (viewModelInfo == null) {
            this.initViewModelInfo();
            viewModelInfo = (Hashtable)this.objectViewModelInfo.get(objectViewId);
        }
        return viewModelInfo;
    }

    public void initViewModelInfo() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMObjectViewModel"));
            query.addSelectColumn(new Column(null, "*"));
            DataObject popupDO = DataAccess.get((SelectQuery)query);
            Iterator itr = popupDO.getRows("ADSMObjectViewModel");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                Integer viewModelId = (Integer)r.get("VIEW_MODEL_ID");
                hash.put("VIEW_MODEL_ID", viewModelId);
                hash.put("VIEW_NAME", (String)r.get("VIEW_NAME"));
                hash.put("CLASS_NAME", (String)r.get("CLASS_NAME"));
                hash.put("TILE_NAME", (String)r.get("TILE_NAME"));
                this.objectViewModelInfo.put(viewModelId, hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

