/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.popup.AdvancedFilterObject;
import com.adventnet.sym.adsm.common.server.popup.PopupSelection;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PopupTabObject {
    private Long tabId = 0L;
    private Integer objectTypeId = 1;
    private String popupTabName = "";
    private Integer priority = 1;
    private boolean isDefaultSelected = false;
    private String popupTabDesc = "";
    private ArrayList advancedFilterObjectList = new ArrayList();

    public void init(Row r, PopupSelection popupSelection) {
        this.tabId = (Long)r.get("POPUP_TAB_ID");
        this.popupTabName = (String)r.get("POPUP_TAB_NAME");
        this.priority = (Integer)r.get("PRIORITY");
        this.objectTypeId = (Integer)r.get("OBJECT_TYPE_ID");
        this.isDefaultSelected = (Boolean)r.get("IS_DEFAULT_SELECTED");
        this.setAdvancedFilterList(popupSelection);
    }

    private void setAdvancedFilterList(PopupSelection popupSelection) {
        try {
            DataObject popupDO = popupSelection.getPopupDO();
            Iterator itr = popupDO.getRows("ADSMPopupAdvancedFilter", new Criteria(Column.getColumn((String)"ADSMPopupAdvancedFilter", (String)"POPUP_TAB_ID"), (Object)this.tabId, 0));
            this.advancedFilterObjectList = new ArrayList();
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                AdvancedFilterObject afo = new AdvancedFilterObject();
                afo.init(r, popupSelection);
                this.advancedFilterObjectList.add(afo);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public AdvancedFilterObject getAFO(Long afoId) {
        AdvancedFilterObject afO = null;
        for (AdvancedFilterObject afo : this.advancedFilterObjectList) {
            if (afo.getAfoId().intValue() != afoId.intValue()) continue;
            afO = afo;
            break;
        }
        return afO;
    }

    public Object toJSONObject() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("objectTypeId", (Object)this.objectTypeId);
            jsonObj.put("isDefaultSelected", this.isDefaultSelected);
            jsonObj.put("tabId", (Object)this.tabId);
            JSONArray jsonAFArray = new JSONArray();
            for (AdvancedFilterObject advancedFO : this.advancedFilterObjectList) {
                jsonAFArray.put(advancedFO.toJSONObject());
            }
            jsonObj.put("advancedFilterObjectList", (Object)jsonAFArray);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public String getTabName() {
        return this.popupTabName;
    }

    public Long getTabId() {
        return this.tabId;
    }

    public Integer getObjectTypeId() {
        return this.objectTypeId;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public boolean getIsDefaultSelected() {
        return this.isDefaultSelected;
    }

    public String getTabDesc() {
        return this.popupTabDesc;
    }

    public ArrayList getAfoList() {
        return this.advancedFilterObjectList;
    }
}

