/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup.datasource;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UnionQueryImpl;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.popup.FillDataModel;
import com.manageengine.ads.fw.popup.PopupDataModel;
import com.manageengine.ads.fw.popup.PopupReqParams;
import com.manageengine.ads.fw.popup.PopupSelectionConstants;
import com.manageengine.ads.fw.popup.PopupSingleton;
import com.manageengine.ads.fw.popup.datamodel.DataModel;
import com.manageengine.ads.fw.popup.datamodel.PopupTableDataModel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.json.JSONObject;

public class GroupDataSource
implements FillDataModel {
    protected Long pdmId = 1L;
    protected PopupDataModel pdmObject = null;
    protected PopupReqParams popupReqParams = null;

    public void init(PopupReqParams popupReqParams) {
        this.popupReqParams = popupReqParams;
        this.pdmId = popupReqParams.getPDMId();
        this.pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId()).getPDM(this.pdmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillTableDataModel(PopupReqParams popupReqParams, DataModel iDataModel) {
        PopupTableDataModel popupTableModel = (PopupTableDataModel)iDataModel;
        this.init(popupReqParams);
        DataSet dataSet = null;
        Connection connection = null;
        try {
            ArrayList tableData = new ArrayList();
            int startIndex = popupReqParams.getStartingIndex();
            int numOfObjects = popupReqParams.getRange();
            String domainName = popupReqParams.getDomainName();
            popupTableModel.setIsSingleOrMultiple(this.pdmObject.getIsSingleOrMultiple());
            String grpFilterData = "{ 'DB_COL_NAME':'GROUP_TYPE', 'FILTER_DETAILS':[{'displayValue':'adssp.common.text.all','uniqueValue':'-'}, {'displayValue':'adssp.common.text.security','uniqueValue':'-2147483648'}, {'displayValue':'adssp.reports.adreport.status.distribution','uniqueValue':'0'}] }";
            ArrayList<HashMap> columns = new ArrayList<HashMap>();
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "DISPLAY_NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "GROUP_TYPE");
                    this.put("DISPLAY_NAME", "adssp.xml.attributedetails.group_type");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                    this.put("FILTER", "{ 'DB_COL_NAME':'GROUP_TYPE', 'FILTER_DETAILS':[{'displayValue':'adssp.common.text.all','uniqueValue':'-'}, {'displayValue':'adssp.common.text.security','uniqueValue':'-2147483648'}, {'displayValue':'adssp.reports.adreport.status.distribution','uniqueValue':'0'}] }");
                }
            });
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "OU_NAME");
                    this.put("DISPLAY_NAME", "adssp.common.text.location");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setColumnList(columns);
            popupTableModel.setUniqueColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "OBJECT_GUID");
                    this.put("DISPLAY_NAME", "adssp.common.text.guid");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "1");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setUniqueDisplayColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "DISPLAY_NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            ArrayList domainList = new ArrayList();
            Properties domProp = new Properties();
            domProp.put("DOMAIN_NAME", domainName);
            domainList.add(domProp);
            if (popupReqParams.isForestDomainsOnly().booleanValue() && popupReqParams.getAllDomains().booleanValue()) {
                String rootDomainNamingcontext = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "ROOT_DOMAIN_NAMING_CONTEXT");
                domainList = DomainHandler.getForestDomains(rootDomainNamingcontext, AuthUtil.getUserCredential().getLoginId());
            }
            if (ADMPRoleHandler.isAdminUser(AuthUtil.getUserCredential().getLoginId())) {
                Query finalQuery = this.getGroupQuery(domainList, columns, popupReqParams, false);
                finalQuery.setRange(new Range(startIndex, numOfObjects));
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery(finalQuery, connection);
                while (dataSet.next()) {
                    ArrayList<String> tableRow = new ArrayList<String>();
                    String columnName = (String)popupTableModel.getUniqueColumnMap().get("COLUMN_NAME");
                    tableRow.add((String)dataSet.getValue(columnName));
                    columnName = (String)popupTableModel.getUniqueDisplayColumnMap().get("COLUMN_NAME");
                    String uniqueDisplayColumnValue = (String)dataSet.getValue(columnName);
                    tableRow.add(uniqueDisplayColumnValue);
                    for (int index = 0; index < columns.size(); ++index) {
                        HashMap mapDetails = (HashMap)columns.get(index);
                        columnName = (String)mapDetails.get("COLUMN_NAME");
                        String columnValue = (String)dataSet.getValue(columnName);
                        if (columnName.equalsIgnoreCase("GROUP_TYPE")) {
                            int bitopt = Integer.parseInt(columnValue);
                            columnValue = "adssp.reports.adreport.status.distribution";
                            if ((bitopt & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                                columnValue = "adssp.common.text.security";
                            }
                        }
                        if (columnName.equalsIgnoreCase("DISTINGUISHED_NAME") || columnName.equalsIgnoreCase("DN_STRING")) {
                            columnValue = StrUtil.getCanonicalName(columnValue);
                        }
                        tableRow.add(columnValue);
                    }
                    tableRow.add("{'DOMAIN_NAME':'" + (String)dataSet.getValue("DOMAIN_NAME") + "'}");
                    tableData.add(tableRow);
                }
                if (!dataSet.isClosed()) {
                    dataSet.close();
                    dataSet = null;
                }
                popupTableModel.setTableData(tableData);
                int size = 0;
                Query countQuery = this.getGroupQuery(domainList, columns, popupReqParams, true);
                dataSet = relationalAPI.executeQuery(countQuery, connection);
                while (dataSet.next()) {
                    size += ((Integer)dataSet.getValue(1)).intValue();
                }
                popupTableModel.setTotalResultCount(size);
            } else {
                popupTableModel.setTableData(new ArrayList());
                popupTableModel.setTotalResultCount(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void fillTreeDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }

    public void fillAddRemoveDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }

    protected Criteria getCriteria(ArrayList columns, String tableName, PopupReqParams popupReqParams) {
        Criteria crit = null;
        try {
            JSONObject colFilterJson;
            if (this.pdmObject.getMenuItemList().contains(PopupSelectionConstants.SEARCH)) {
                Criteria columnSearchCriteria = null;
                String searchText = popupReqParams.getSearchTxt();
                if (searchText != null && !searchText.equals("")) {
                    searchText = QueryUtil.mickeyCriteriaEscape(searchText);
                    for (int index = 0; index < columns.size(); ++index) {
                        HashMap mapDetails = (HashMap)columns.get(index);
                        columnSearchCriteria = columnSearchCriteria == null ? new Criteria(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))), (Object)searchText, 12, false) : columnSearchCriteria.or(new Criteria(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))), (Object)searchText, 12, false));
                    }
                    crit = crit == null ? columnSearchCriteria : crit.and(columnSearchCriteria);
                }
            }
            if (popupReqParams != null && (colFilterJson = popupReqParams.getColFilterJson()).length() != 0) {
                Criteria colCrit = null;
                Iterator colFilterItr = colFilterJson.keys();
                while (colFilterItr.hasNext()) {
                    String colName = (String)colFilterItr.next();
                    String colVal = colFilterJson.getString(colName);
                    if (colName == null || colName.equals("") || colVal == null) continue;
                    Criteria c = null;
                    if (colVal.equals("-")) continue;
                    c = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)new String[]{"1", "2", "4", "8", "16", "32"}, 8);
                    if (!colVal.equals("0") && !colVal.equals("-")) {
                        c = c.negate();
                    }
                    if (colCrit == null) {
                        colCrit = c;
                        continue;
                    }
                    colCrit = colCrit.or(c);
                }
                crit = crit == null ? colCrit : crit.and(colCrit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public Query getGroupQuery(List<Properties> domainList, ArrayList columns, PopupReqParams popupReqParams, Boolean isCountQuery) {
        SelectQueryImpl finalQuery = null;
        try {
            Object c = null;
            SelectQueryImpl unionQuery = null;
            SelectQueryImpl prevQuery = null;
            for (Properties domainProp : domainList) {
                String domainName = domainProp.get("DOMAIN_NAME").toString();
                String table = CommonUtil.getDomainGroupTableName(domainName);
                Criteria colFilterCrit = this.getCriteria(columns, table, popupReqParams);
                SelectQueryImpl sq = new SelectQueryImpl(new Table(table));
                sq.setCriteria(colFilterCrit);
                if (isCountQuery.booleanValue()) {
                    Column countColumn = new Column(null, "*");
                    sq.addSelectColumn(countColumn.count());
                } else {
                    sq.addSelectColumns(new ArrayList<Column>(Arrays.asList(Column.getColumn((String)table, (String)"OBJECT_GUID"), Column.getColumn((String)table, (String)"DOMAIN_NAME"))));
                    for (int index = 0; index < columns.size(); ++index) {
                        HashMap mapDetails = (HashMap)columns.get(index);
                        if (sq.getSelectColumns().contains(Column.getColumn((String)table, (String)((String)mapDetails.get("COLUMN_NAME"))))) continue;
                        sq.addSelectColumn(Column.getColumn((String)table, (String)((String)mapDetails.get("COLUMN_NAME"))));
                        if (!mapDetails.containsKey("IS_SORT") || !"1".equals((String)mapDetails.get("IS_SORT"))) continue;
                        sq.addSortColumn(new SortColumn(table, (String)mapDetails.get("COLUMN_NAME"), true));
                    }
                }
                if (unionQuery != null) {
                    unionQuery.union((Query)sq, false);
                } else if (prevQuery != null) {
                    unionQuery = new UnionQueryImpl((Query)prevQuery, (Query)sq, false);
                }
                prevQuery = sq;
            }
            finalQuery = unionQuery != null ? unionQuery : prevQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalQuery;
    }

    public void fillCustomDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }
}

