/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup.datasource;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.popup.FillDataModel;
import com.manageengine.ads.fw.popup.PopupDataModel;
import com.manageengine.ads.fw.popup.PopupReqParams;
import com.manageengine.ads.fw.popup.PopupSelectionConstants;
import com.manageengine.ads.fw.popup.PopupSingleton;
import com.manageengine.ads.fw.popup.datamodel.DataModel;
import com.manageengine.ads.fw.popup.datamodel.PopupTableDataModel;
import com.manageengine.ads.fw.popup.datamodel.PopupTreeDataModel;
import com.manageengine.ads.fw.tree.TreeObject;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.json.JSONArray;

public class OUDataSource
implements FillDataModel {
    private Long pdmId = 1L;
    private PopupDataModel pdmObject = null;
    private PopupReqParams popupReqParams = null;

    public void init(PopupReqParams popupReqParams) {
        this.popupReqParams = popupReqParams;
        this.pdmId = popupReqParams.getPDMId();
        this.pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId()).getPDM(this.pdmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillTableDataModel(PopupReqParams popupReqParams, DataModel iDataModel) {
        Connection connection = null;
        DataSet dataSet = null;
        PopupTableDataModel popupTableModel = (PopupTableDataModel)iDataModel;
        this.init(popupReqParams);
        try {
            ArrayList<HashMap> columns = new ArrayList<HashMap>();
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "CANONICAL_NAME");
                    this.put("DISPLAY_NAME", "adssp.xml.attributedetails.canonical_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setColumnList(columns);
            popupTableModel.setUniqueColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "OBJECT_GUID");
                    this.put("DISPLAY_NAME", "adssp.common.text.guid");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "1");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setUniqueDisplayColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            ArrayList tableData = new ArrayList();
            ArrayList column = popupTableModel.getColumnList();
            SelectQuery finalQuery = this.getOUQuery(columns, false);
            int startIndex = popupReqParams.getStartingIndex();
            int numOfObjects = popupReqParams.getRange();
            if (startIndex != -1) {
                finalQuery.setRange(new Range(startIndex, numOfObjects));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(finalQuery);
            Iterator ouIterator = dataObj.getRows("ADSMOUDetails");
            while (ouIterator.hasNext()) {
                Row r = (Row)ouIterator.next();
                if (r == null) continue;
                ArrayList<String> tableRow = new ArrayList<String>();
                String columnName = (String)popupTableModel.getUniqueColumnMap().get("COLUMN_NAME");
                tableRow.add((String)r.get(columnName));
                columnName = (String)popupTableModel.getUniqueDisplayColumnMap().get("COLUMN_NAME");
                String uniqueDisplayColumnValue = (String)r.get(columnName);
                tableRow.add(uniqueDisplayColumnValue);
                for (int index = 0; index < columns.size(); ++index) {
                    HashMap mapDetails = (HashMap)columns.get(index);
                    columnName = (String)mapDetails.get("COLUMN_NAME");
                    String columnValue = (String)r.get(columnName);
                    if (columnName.equalsIgnoreCase("DISTINGUISHED_NAME") || columnName.equalsIgnoreCase("DN_STRING")) {
                        columnValue = StrUtil.getCanonicalName(columnValue);
                    }
                    tableRow.add(columnValue);
                }
                tableData.add(tableRow);
            }
            popupTableModel.setTableData(tableData);
            int totalCount = 0;
            SelectQuery countQuery = this.getOUQuery(columns, true);
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)countQuery, connection);
            while (dataSet.next()) {
                totalCount += ((Integer)dataSet.getValue(1)).intValue();
            }
            popupTableModel.setTotalResultCount(totalCount);
            popupTableModel.setIsSingleOrMultiple(this.pdmObject.getIsSingleOrMultiple());
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
    }

    public void fillTreeDataModel(PopupReqParams popupReqParams, DataModel idataModel) {
        this.init(popupReqParams);
        try {
            String domainName = popupReqParams.getDomainName();
            Hashtable domainGenDetails = DomainUtil.getDomainGenDetails("NAME", domainName, new String[]{"OBJECT_GUID"});
            Long loginId = popupReqParams.getLoginId();
            String nodeClicked = popupReqParams.getNodeClicked();
            PopupTreeDataModel treeModel = (PopupTreeDataModel)idataModel;
            DirectoryObject directoryObject = null;
            if (nodeClicked == null || nodeClicked.length() == 0) {
                ArrayList ouList = OUUtil.getOUList(domainName, null);
                directoryObject = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, (String)domainGenDetails.get("OBJECT_GUID"), ouList, "true");
                treeModel.setShowRootNode();
            } else if (nodeClicked != null) {
                directoryObject = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, nodeClicked, null, "true");
            }
            JSONArray ouGUIDs = popupReqParams.getPrevSelItems();
            ArrayList<String> openNodeGUIDs = new ArrayList<String>();
            if (ouGUIDs != null && ouGUIDs.length() != 0) {
                Criteria crit = null;
                for (int i = 0; i < ouGUIDs.length(); ++i) {
                    Criteria c = new Criteria(new Column("ADSMOUDetails", "OBJECT_GUID"), (Object)ouGUIDs.getString(i), 0, false);
                    crit = crit != null ? crit.or(c) : c;
                }
                ArrayList selOUs = OUUtil.getOUList(domainName, crit);
                ArrayList openNode = DirectoryObjectUtil.getOpenNodes(selOUs);
                crit = null;
                for (int i = 0; i < openNode.size(); ++i) {
                    openNodeGUIDs.add(OUUtil.getOUProp("DISTINGUISHED_NAME", (String)openNode.get(i), "OBJECT_GUID", domainName, loginId));
                }
                if (!openNodeGUIDs.isEmpty()) {
                    Properties selectedDomain = DomainHandler.getConfiguredValues(domainName, loginId);
                    for (int i = 0; i < openNodeGUIDs.size(); ++i) {
                        DirectoryObjectUtil.getDirectoryObject(directoryObject, (String)openNodeGUIDs.get(i), selectedDomain, loginId, "true");
                    }
                }
            }
            treeModel.setOpenNodes(openNodeGUIDs);
            treeModel.setData((TreeObject)directoryObject);
            treeModel.setIsSingleOrMultiple(this.pdmObject.getIsSingleOrMultiple());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillAddRemoveDataModel(PopupReqParams popupReqParams, DataModel idataModel) {
    }

    protected Criteria getSearchCriteria(ArrayList columns) {
        String searchText;
        Criteria columnSearchCriteria = null;
        String tableName = "ADSMOUDetails";
        if (this.pdmObject.getMenuItemList().contains(PopupSelectionConstants.SEARCH) && (searchText = this.popupReqParams.getSearchTxt()) != null && !searchText.equals("")) {
            searchText = QueryUtil.mickeyCriteriaEscape(searchText);
            for (int index = 0; index < columns.size(); ++index) {
                HashMap mapDetails = (HashMap)columns.get(index);
                columnSearchCriteria = columnSearchCriteria == null ? new Criteria(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))), (Object)searchText, 12, false) : columnSearchCriteria.or(new Criteria(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))), (Object)searchText, 12, false));
            }
        }
        return columnSearchCriteria;
    }

    private SelectQuery getOUQuery(ArrayList columns, boolean isCountQuery) {
        String tableName = "ADSMOUDetails";
        SelectQueryImpl sq = new SelectQueryImpl(new Table(tableName));
        try {
            String domainName = this.popupReqParams.getDomainName();
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            Criteria searchCriteria = this.getSearchCriteria(columns);
            if (searchCriteria != null) {
                criteria = criteria.and(searchCriteria);
            }
            sq.setCriteria(criteria);
            if (isCountQuery) {
                Column countColumn = Column.getColumn(null, (String)"*");
                sq.addSelectColumn(countColumn.count());
            } else {
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"OBJECT_GUID"));
                for (int index = 0; index < columns.size(); ++index) {
                    HashMap mapDetails = (HashMap)columns.get(index);
                    if (sq.getSelectColumns().contains(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))))) continue;
                    sq.addSelectColumn(Column.getColumn((String)tableName, (String)((String)mapDetails.get("COLUMN_NAME"))));
                    if (!mapDetails.containsKey("IS_SORT") || !"1".equals((String)mapDetails.get("IS_SORT"))) continue;
                    sq.addSortColumn(new SortColumn(tableName, (String)mapDetails.get("COLUMN_NAME"), true));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public void fillCustomDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }
}

