/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.popup.datasource;

import com.adventnet.ds.query.SelectQuery;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.manageengine.ads.fw.popup.FillDataModel;
import com.manageengine.ads.fw.popup.PopupDataModel;
import com.manageengine.ads.fw.popup.PopupReqParams;
import com.manageengine.ads.fw.popup.PopupSingleton;
import com.manageengine.ads.fw.popup.datamodel.DataModel;
import com.manageengine.ads.fw.popup.datamodel.PopupTableDataModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;

public class UserDataSource
implements FillDataModel {
    protected Long pdmId = 1L;
    protected PopupDataModel pdmObject = null;
    protected PopupReqParams popupReqParams = null;

    public void init(PopupReqParams popupReqParams) {
        this.popupReqParams = popupReqParams;
        this.pdmId = popupReqParams.getPDMId();
        this.pdmObject = PopupSingleton.getInstance().getPopupSelection(popupReqParams.getPopupId()).getPDM(this.pdmId);
    }

    public void fillTableDataModel(PopupReqParams popupReqParams, DataModel iDataModel) {
        PopupTableDataModel popupTableModel = (PopupTableDataModel)iDataModel;
        this.init(popupReqParams);
        try {
            ArrayList tableData = new ArrayList();
            Hashtable<String, Object> queryData = new Hashtable<String, Object>();
            String domainName = popupReqParams.getDomainName();
            popupTableModel.setIsSingleOrMultiple(this.pdmObject.getIsSingleOrMultiple());
            ArrayList<HashMap> columns = new ArrayList<HashMap>();
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "SAM_ACCOUNT_NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            columns.add(new HashMap(){
                {
                    this.put("COLUMN_NAME", "OU_NAME");
                    this.put("DISPLAY_NAME", "adssp.common.text.location");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setColumnList(columns);
            popupTableModel.setUniqueColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "OBJECT_GUID");
                    this.put("DISPLAY_NAME", "adssp.common.text.guid");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "1");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "0");
                    this.put("IS_SORT", "0");
                }
            });
            popupTableModel.setUniqueDisplayColumnMap(new HashMap(){
                {
                    this.put("COLUMN_NAME", "SAM_ACCOUNT_NAME");
                    this.put("DISPLAY_NAME", "adssp.admin.configuration.tech_name");
                    this.put("IS_UNIQUE_VALUE_COLUMN", "0");
                    this.put("IS_UNIQUE_DISPLAY_COLUMN", "1");
                    this.put("IS_SORT", "1");
                }
            });
            String domainUserTable = CommonUtil.getDomainUserTableName(domainName);
            String searchTxt = popupReqParams.getSearchTxt();
            if (searchTxt != null && !searchTxt.equals("")) {
                queryData.put("SEARCH_STRING", searchTxt);
                String[] searchColumns = new String[columns.size()];
                for (int index = 0; index < columns.size(); ++index) {
                    HashMap mapDetails = (HashMap)columns.get(index);
                    searchColumns[index] = (String)mapDetails.get("COLUMN_NAME");
                }
                queryData.put("SEARCH_COLUMNS", searchColumns);
            }
            queryData.put("DOMAIN_NAME", domainName);
            queryData.put("START_INDEX", popupReqParams.getStartingIndex());
            queryData.put("NUM_OF_OBJECTS", popupReqParams.getRange());
            SelectQuery sq = UserUtil.getSQForUsersList(queryData);
            DataObject usersDO = CommonUtil.getPersistence(new boolean[0]).get(sq);
            Iterator usrIterator = usersDO.getRows(domainUserTable);
            while (usrIterator.hasNext()) {
                Row usrRow = (Row)usrIterator.next();
                if (usrRow == null) continue;
                ArrayList<String> tableRow = new ArrayList<String>();
                String columnName = (String)popupTableModel.getUniqueColumnMap().get("COLUMN_NAME");
                tableRow.add((String)usrRow.get(columnName));
                columnName = (String)popupTableModel.getUniqueDisplayColumnMap().get("COLUMN_NAME");
                String uniqueDisplayColumnValue = (String)usrRow.get(columnName);
                tableRow.add(uniqueDisplayColumnValue);
                for (int index = 0; index < columns.size(); ++index) {
                    HashMap mapDetails = (HashMap)columns.get(index);
                    columnName = (String)mapDetails.get("COLUMN_NAME");
                    String columnValue = (String)usrRow.get(columnName);
                    if (columnName.equalsIgnoreCase("DISTINGUISHED_NAME") || columnName.equalsIgnoreCase("DN_STRING")) {
                        columnValue = StrUtil.getCanonicalName(columnValue);
                    }
                    tableRow.add(columnValue);
                }
                tableData.add(tableRow);
            }
            popupTableModel.setTableData(tableData);
            popupTableModel.setTotalResultCount(UserUtil.getUsersCount(queryData).intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillTreeDataModel(PopupReqParams popupReqParams, DataModel idataModel) {
    }

    public void fillAddRemoveDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }

    public void fillCustomDataModel(PopupReqParams popupreqparams, DataModel idataModel) {
    }
}

