/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.postgres;

import com.adventnet.db.adapter.BackupRestoreConfigurations;
import com.adventnet.db.adapter.BackupRestoreException;
import com.adventnet.db.adapter.postgres.PostgresDBAdapter;
import com.adventnet.db.persistence.metadata.MetaDataException;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.db.persistence.metadata.util.TemplateMetaHandler;
import com.adventnet.mfw.BackupDB;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.VersionHandler;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.util.OSCheckUtil;
import com.adventnet.sym.adsm.common.server.i18n.SystemResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.SystemResourceBundleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.zoho.framework.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class ADSMPostgresDBAdapter
extends PostgresDBAdapter {
    private static boolean backupDBInProgress = false;
    protected VersionHandler backupRestoreHandler = null;
    Logger logger = CommonUtil.getDefaultLogger();

    protected List<String> getTableNamesForBackUp() {
        ArrayList<String> tableList = new ArrayList<String>();
        ArrayList<String> excludedTableList = DBUtil.getExcludedTableList();
        this.logger.log(Level.INFO, "ADSMPostgresDBAdapter :: getTableNamefor backup");
        try {
            for (Object tdObj : MetaDataUtil.getTableDefinitions()) {
                TableDefinition tDef = (TableDefinition)tdObj;
                if (!tDef.isTemplate()) {
                    String tableName = tDef.getTableName();
                    if (!tableList.contains(tableName)) {
                        tableList.add(tDef.getTableName());
                        continue;
                    }
                    this.logger.log(Level.INFO, " Excluded Table List " + tableName);
                    continue;
                }
                TemplateMetaHandler templateHandler = MetaDataUtil.getTemplateHandler((String)tDef.getModuleName());
                List templateInstances = templateHandler.getTemplateInstancesForBackUp(tDef.getTableName());
                if (templateInstances == null) continue;
                for (int k = 0; k < templateInstances.size(); ++k) {
                    if (tableList.contains(templateInstances.get(k))) continue;
                    tableList.add((String)templateInstances.get(k));
                }
            }
        }
        catch (MetaDataException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "Total table list going to backup " + tableList.size());
        return tableList;
    }

    public void setUpDB(String connectionURL, String userName, String password) throws IOException {
        String dbHome = System.getProperty("db.home", System.getProperty("server.home") + File.separator + "pgsql");
        String pgctlPath = dbHome + File.separator + "bin" + File.separator + "pg_ctl.exe";
        try {
            super.setUpDB(connectionURL, userName, password);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                String clientURL = "http://www.manageengine.com/products/self-service-password/adselfservice-plus-startup-failed.html";
                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", clientURL).start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (System.getProperty("SERVER_HOME") == null) {
                System.setProperty("SERVER_HOME", "../");
            }
            SystemResourceBundle rb = new SystemResourceBundleHandler().getLocalizedBuildBundle();
            String errorMessage = MessageFormat.format(rb.getString("adssp.startup.stat_msg.check_antivirus_quarantined_this_file"), pgctlPath);
            JOptionPane.showMessageDialog(null, errorMessage, "Information", 1);
            throw new IOException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int backupDB(String backupDir, String backupFile) throws Exception {
        if (backupDBInProgress) {
            this.logger.log(Level.WARNING, "Already a backup DB process is running.");
            return BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_IN_PROGRESS.getValue();
        }
        backupDBInProgress = true;
        try {
            String path;
            File file;
            boolean isWindows;
            String pgDumpPath;
            block26: {
                block27: {
                    block25: {
                        pgDumpPath = System.getProperty("db.home") + "/bin/pg_dump";
                        isWindows = OSCheckUtil.isWindows((int)OSCheckUtil.getOS());
                        if (isWindows) {
                            pgDumpPath = pgDumpPath + ".exe";
                        }
                        if (!(file = new File(pgDumpPath)).exists()) {
                            this.logger.log(Level.SEVERE, "{0} is not bundled with the database. Remote machine backup invoked.", pgDumpPath);
                            int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_FAILED.getValue();
                            return n;
                        }
                        backupFile = this.getBackUpFileName(backupFile);
                        path = backupDir + "/" + backupFile;
                        file = new File(path);
                        File zipFile = new File(path + ".zip");
                        if (zipFile.exists() || file.exists() || file.isDirectory()) break block25;
                        file.mkdirs();
                        this.initVersionHandler(PersistenceInitializer.getConfigurationValue((String)"VersionHandler"));
                        if (this.backupRestoreHandler == null) break block26;
                        break block27;
                    }
                    this.logger.log(Level.INFO, "Already a file/directory with this name [{0}.zip] is found. Take the backup after a minute.", path);
                    int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_FAILED.getValue();
                    return n;
                }
                String version = this.backupRestoreHandler.getCurrentVersion();
                if (version == null) {
                    this.logger.log(Level.SEVERE, "Current version cannot be null. Provide proper version.");
                    int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_TERMINATED.getValue();
                    return n;
                }
                Properties versionProp = new Properties();
                versionProp.put("handler", this.backupRestoreHandler.getClass().getName());
                versionProp.put("version", version);
                FileUtils.writeToFile((File)new File(path + File.separator + "version.conf"), (Properties)versionProp, (String)"version properties");
            }
            if (BackupDB.SHOW_STATUS) {
                this.logger.log(Level.INFO, "Backup DB started...");
            }
            try {
                List<String> tableList = this.getTableNamesForBackUp();
                String[] tableNames = tableList.toArray(new String[0]);
                Properties properties = this.getDBProps();
                String username = properties.getProperty("username");
                String password = properties.getProperty("password", "");
                String sock = System.getProperty("db.home") + "/tmp/";
                String url = properties.getProperty("url");
                if (url.contains("?")) {
                    url = url.substring(0, url.indexOf("?"));
                }
                String hostName = (String)properties.get("Server");
                Integer port = (Integer)properties.get("Port");
                String database = url.substring(url.lastIndexOf("/") + 1, url.length());
                Properties props = new Properties();
                int index = 0;
                Properties envProp = new Properties();
                envProp.setProperty("PGPASSWORD", password);
                String[] arr$ = tableNames;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++index, ++i$) {
                    String tableName = arr$[i$];
                    if (!backupDBInProgress) {
                        this.logger.log(Level.INFO, "backupDB is aborted" + path);
                        this.deleteFiles(path);
                        int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_TERMINATED.getValue();
                        return n;
                    }
                    ArrayList<String> dumpcmd = new ArrayList<String>();
                    props.put("table" + index, tableName);
                    dumpcmd.add(pgDumpPath);
                    dumpcmd.add("-U" + username);
                    if (!hostName.equals("localhost")) {
                        dumpcmd.add("-h");
                        dumpcmd.add(hostName);
                    } else {
                        String hostAddress = InetAddress.getByName(hostName).getHostAddress();
                        this.logger.log(Level.INFO, "hostAddress of localhost is {0}", hostAddress);
                        dumpcmd.add("-h");
                        dumpcmd.add(hostAddress);
                    }
                    dumpcmd.add("--port=" + port);
                    dumpcmd.add("-w");
                    dumpcmd.add("-t");
                    String dbSpecificTableName = this.sqlGen.getDBSpecificTableName(tableName);
                    dumpcmd.add(!isWindows || isWindows && !isAutoQuoteEnabled && dbSpecificTableName.equals(tableName) ? dbSpecificTableName : "\\\"" + dbSpecificTableName + "\\\"");
                    if (DBUtil.getExcludedTableList().contains(tableName)) {
                        dumpcmd.add("--schema-only");
                    }
                    dumpcmd.add("-f");
                    dumpcmd.add(file.getCanonicalPath() + File.separator + tableName + ".sql");
                    dumpcmd.add(database);
                    ConsoleOut.println((String)("Backing up: " + tableName));
                    Process process = this.executeCommand(dumpcmd, envProp);
                    String errorStreamString = null;
                    BufferedReader errStreamBuff = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    while ((errorStreamString = errStreamBuff.readLine()) != null) {
                        this.logger.log(Level.WARNING, errorStreamString);
                        if ((errorStreamString = errorStreamString.toLowerCase(Locale.ENGLISH)) == null || errorStreamString.contains(" ignored.")) continue;
                        throw new Exception("Error occured while backup " + tableName + " table :: ErrorStream message ::: " + errorStreamString);
                    }
                    errStreamBuff.close();
                    if (!BackupDB.SHOW_STATUS) continue;
                    this.logger.log(Level.INFO, "Backup table name :: " + tableName);
                }
                this.addSpecXMLEntryToProps(props);
                FileUtils.writeToFile((File)new File(path + File.separator + "backuprestore.conf"), (Properties)props, (String)"Backup Tables");
            }
            catch (Exception ex) {
                this.deleteFiles(path);
                this.logger.log(Level.INFO, "Unable to retrieve tables from DB");
                throw ex;
            }
            this.zip(path);
            this.deleteFiles(path);
            this.logger.log(Level.INFO, "Backup File {0}.zip", path);
            if (BackupDB.SHOW_STATUS) {
                this.logger.log(Level.INFO, "\nBackup File " + path + ".zip");
            }
            ConsoleOut.println((String)"Postgres DB backup successfully");
            int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_SUCCESSFULLY_COMPLETED.getValue();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = BackupRestoreConfigurations.BACKUP_STATUS.BACKUP_PROCESS_FAILED.getValue();
            return n;
        }
        finally {
            backupDBInProgress = false;
        }
    }

    Process executeCommand(List<String> commandList, Properties envVariables) throws IOException {
        this.logger.log(Level.INFO, "Command to be executed {0} ", commandList);
        ProcessBuilder processBuilder = new ProcessBuilder(commandList);
        Map<String, String> environment = processBuilder.environment();
        if (envVariables != null) {
            Enumeration<Object> keys = envVariables.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                environment.put(key, envVariables.getProperty(key));
            }
        }
        return processBuilder.start();
    }

    public int restoreDB(String src) throws Exception {
        try {
            if (this.isFileExistsInZip(src, "version.conf")) {
                return super.restoreDB(src);
            }
            ConsoleOut.println((String)"version.conf missing. Please check version of backup file");
            return BackupRestoreConfigurations.RESTORE_STATUS.RESTORE_PROCESS_FAILED.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return BackupRestoreConfigurations.RESTORE_STATUS.RESTORE_PROCESS_FAILED.getValue();
        }
    }

    private String getBackUpFileName(String backupFile) {
        if (backupFile == null) {
            Date today = Calendar.getInstance().getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd-HHmm");
            backupFile = formatter.format(today);
        }
        return backupFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSpecXMLEntryToProps(Properties props) throws Exception {
        try (FileInputStream fis = null;){
            File specsFile = new File(System.getProperty("server.home") + "/Patch/specs.xml");
            if (specsFile.exists()) {
                props.setProperty("AllVersions", this.getAllVersions(specsFile));
            }
        }
    }

    protected void deleteFiles(String path) {
        try {
            File direc = new File(path);
            File[] files = direc.listFiles();
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                if (!files[i].isFile() || (deleted = files[i].delete())) continue;
                this.logger.log(Level.FINE, "Error occurred while deleting the file :: {0}", files[i].getName());
            }
            direc.delete();
        }
        catch (Exception e) {
            ConsoleOut.println((String)("error occurred while deleting :: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getAllVersions(File specsFile) throws Exception {
        try (FileInputStream fis = null;){
            String versionString;
            fis = new FileInputStream(specsFile);
            byte[] b = new byte[4096];
            fis.read(b);
            String strFromSpecsFile = new String(b);
            String string = versionString = strFromSpecsFile.substring(strFromSpecsFile.indexOf(" AllVersions=") + 14, strFromSpecsFile.indexOf(" Versions=") - 1);
            return string;
        }
    }

    protected void initVersionHandler(String versionHandler) throws BackupRestoreException {
        this.logger.log(Level.INFO, "BackUp/Restore Version handler :::: {0}", versionHandler);
        if (versionHandler != null) {
            try {
                this.backupRestoreHandler = (VersionHandler)Thread.currentThread().getContextClassLoader().loadClass(versionHandler).newInstance();
            }
            catch (Exception e) {
                throw new BackupRestoreException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

