/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.reports.CreateAuditTable;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AuditLog {
    private static Logger logger = Logger.getLogger(AuditLog.class.getName());

    public static void addUserAttemptsAuditLog(String loginName, String domainName, String auditType, String errMsg, int status, String ip, String accessMode) {
        class Action
        extends Thread {
            String loginName;
            String domainName;
            String auditType;
            String errMsg;
            int status;
            String ip;
            String accessMode;

            Action(String loginName, String domainName, String auditType, String errMsg, int status, String ip, String accessMode) {
                this.loginName = loginName;
                this.domainName = domainName;
                this.auditType = auditType;
                this.errMsg = errMsg;
                this.status = status;
                this.ip = ip;
                this.accessMode = accessMode;
            }

            @Override
            public void run() {
                try {
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    String tableName = "SSPUserAttemptsAudit";
                    if (!AuditReportHandler.isAuditTableExist(tableName) && !CreateAuditTable.create(tableName)) {
                        return;
                    }
                    if (this.errMsg != null && !this.errMsg.equals("")) {
                        if (this.status == -1) {
                            this.status = 0;
                        }
                        this.errMsg = AuditLog.getErrMsg(this.errMsg);
                    } else {
                        if (this.status == -1) {
                            this.status = 1;
                        }
                        this.errMsg = "adssp.common.text.success";
                    }
                    this.domainName = this.domainName == null || this.domainName != null && this.domainName.equals("") ? "-" : this.domainName;
                    HashMap result = (HashMap)CommonUtil.getHostDetails(this.ip);
                    Row r = new Row(tableName);
                    r.set("LOGIN_NAME", (Object)this.loginName);
                    r.set("DOMAIN_NAME", (Object)this.domainName);
                    r.set("HOST", (Object)((String)result.get("host")));
                    r.set("IP", (Object)((String)result.get("ip")));
                    r.set("TIME", (Object)System.currentTimeMillis());
                    r.set("TYPE", (Object)this.auditType);
                    r.set("STATUS", (Object)this.status);
                    r.set("ERROR_MESSAGE", (Object)this.errMsg);
                    r.set("ACCESS_MODE", (Object)this.accessMode);
                    obj.addRow(r);
                    AdventNetResourceBundle adminRb = ResourceBundleMgr.getInstance().getBundle();
                    if (!(this.auditType + "_attempt").equalsIgnoreCase(adminRb.getString(this.auditType + "_attempt"))) {
                        this.auditType = this.auditType + "_attempt";
                    }
                    JSONObject jsonLog = AuditAPI.getInstance().setAuditProps(this.loginName, this.domainName, System.currentTimeMillis(), this.auditType, (String)result.get("ip"), (String)result.get("host"), this.accessMode, this.errMsg);
                    logger.log(Level.INFO, "calling LogForwarderAPI : " + jsonLog.toString());
                    LogForwarderAPI.getInstance().sendMessage(jsonLog);
                    CommonUtil.getPersistence(new boolean[0]).update(obj);
                    AuditReportHandler.checkForBackUp(tableName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Action acn = new Action(loginName, domainName, auditType, errMsg, status, ip, accessMode);
        acn.start();
    }

    private static String getErrMsg(String errMsg) {
        if (errMsg.equals("adssp.login.common.error.invalid_login")) {
            return "adssp.reports.audit_report.user_attempts.error.invalid_login";
        }
        if (errMsg.equals("adssp.login.common.error.acc_has_locked")) {
            return "adssp.reports.audit_report.user_attempts.error.acc_locked";
        }
        if (errMsg.equals("adssp.login.common.error.acc_has_expired")) {
            return "adssp.reports.audit_report.user_attempts.error.acc_expired";
        }
        if (errMsg.equals("adssp.login.common.error.acc_has_disabled")) {
            return "adssp.reports.audit_report.user_attempts.error.acc_disabled";
        }
        if (errMsg.equals("adssp.login.common.error.acc_has_restricted")) {
            return "adssp.reports.audit_report.user_attempts.error.user_restricted";
        }
        if (errMsg.equals("adssp.login.common.error.pwd_expired")) {
            return "adssp.reports.audit_report.user_attempts.error.pwd_expired";
        }
        if (errMsg.equals("adssp.security.que.rp.ua.page.account.blocked")) {
            return "adssp.reports.audit_report.user_attempts.error.user_blocked";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.rp_ua.permission_denied_contact_admin")) {
            return "adssp.reports.audit_report.user_attempts.error.permission_denied";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.username.error_invalid_not_enrolled")) {
            return "adssp.reports.audit_report.user_attempts.error.invalid_not_enrolled";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg_verification_code")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_ver_code";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg_security_qa")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_sec_qa";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg_auth_app")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_auth_app";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg_duo_app")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_duo_security";
        }
        if (errMsg.equals("adssp.login.tfa.invalid_verification_code")) {
            return "adssp.login.tfa.audit_invalid_verification_code";
        }
        if (errMsg.equals("adssp.login.tfa.rsa_new_pin_accepted")) {
            return "adssp.login.tfa.rsa_audit_new_pin_accepted";
        }
        if (errMsg.equals("adssp.login.tfa.rsa_new_pin_not_accepted")) {
            return "adssp.login.tfa.rsa_audit_new_pin_not_accepted";
        }
        if (errMsg.equals("adssp.login.tfa.rsa_system_pin_not_accepted")) {
            return "adssp.login.tfa.rsa_audit_system_pin_not_accepted";
        }
        if (errMsg.equals("adssp.login.tfa.rsa_new_oda_pin_accepted")) {
            return "adssp.login.tfa.rsa_audit_new_oda_pin_accepted";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg.mobile_app_auth.push")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_push_notification";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg.mobile_app_auth.finger_print")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_finger_print";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg.mobile_app_auth.qr_code")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_qr_code";
        }
        if (errMsg.equals("adssp.reset_unlock.accounts.not_reg.mobile_app_auth.totp")) {
            return "adssp.reports.audit_report.user_attempts.error.not_enrolled_totp";
        }
        return errMsg;
    }
}

